/*
 * Decompiled with CFR 0.152.
 */
package csplugins.vectormath;

import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import csplugins.vectormath.VectorDataProvider;

public class MathVector
extends ReadOnlyMathVector
implements VectorDataProvider {
    VectorDataProvider p;

    MathVector(VectorDataProvider vectorDataProvider) {
        super(vectorDataProvider);
        this.p = vectorDataProvider;
    }

    public void set(int n, double d2) throws IndexOutOfBoundsException {
        if (n <= -1 || n >= this.p.size()) {
            String string = "Element requested: " + n + ",  vector size: " + this.p.size();
            throw new IndexOutOfBoundsException(string);
        }
        this.p.setQuick(n, d2);
    }

    public void setQuick(int n, double d2) {
        this.p.setQuick(n, d2);
    }

    public MathVector normalize() {
        double d2 = this.mag();
        if (d2 == 0.0) {
            return this;
        }
        for (int i = 0; i < this.p.size(); ++i) {
            this.p.setQuick(i, this.p.getQuick(i) / d2);
        }
        return this;
    }

    public MathVector add(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i = 0; i < n; ++i) {
            this.p.setQuick(i, this.p.getQuick(i) + readOnlyMathVector.p.getQuick(i));
        }
        return this;
    }

    public static MathVector sum(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = readOnlyMathVector.getQuick(i) + readOnlyMathVector2.getQuick(i);
        }
        return MathVectorFactory.makeVector(dArray);
    }

    public MathVector subtract(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i = 0; i < n; ++i) {
            this.p.setQuick(i, this.p.getQuick(i) - readOnlyMathVector.p.getQuick(i));
        }
        return this;
    }

    public static MathVector difference(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = readOnlyMathVector.getQuick(i) - readOnlyMathVector2.getQuick(i);
        }
        return MathVectorFactory.makeVector(dArray);
    }

    public MathVector add(double d2) {
        for (int i = 0; i < this.p.size(); ++i) {
            this.p.setQuick(i, this.p.getQuick(i) + d2);
        }
        return this;
    }

    public MathVector subtract(double d2) {
        for (int i = 0; i < this.p.size(); ++i) {
            this.p.setQuick(i, this.p.getQuick(i) - d2);
        }
        return this;
    }

    public MathVector times(double d2) {
        for (int i = 0; i < this.p.size(); ++i) {
            this.p.setQuick(i, d2 * this.p.getQuick(i));
        }
        return this;
    }

    public MathVector pow(double d2) {
        for (int i = 0; i < this.p.size(); ++i) {
            double d3 = this.p.getQuick(i);
            this.p.setQuick(i, Math.pow(d3, d2));
        }
        return this;
    }

    public static double magSum(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        return Math.sqrt(MathVector.magSumSquared(readOnlyMathVector, readOnlyMathVector2));
    }

    public static double magSumSquared(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) {
        int n = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = readOnlyMathVector.getQuick(i) + readOnlyMathVector2.getQuick(i);
            d2 += d3 * d3;
        }
        return d2;
    }

    public static double magDiff(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        return Math.sqrt(MathVector.magDiffSquared(readOnlyMathVector, readOnlyMathVector2));
    }

    public static double magDiffSquared(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) {
        int n = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = readOnlyMathVector.getQuick(i) - readOnlyMathVector2.getQuick(i);
            d2 += d3 * d3;
        }
        return d2;
    }
}

