/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.AttributeBadValueException;
import dods.dap.AttributeTable;
import java.util.Enumeration;
import java.util.Vector;

public class Attribute
implements Cloneable {
    public static final int UNKNOWN = 1;
    public static final int CONTAINER = 2;
    public static final int BYTE = 3;
    public static final int INT16 = 4;
    public static final int UINT16 = 5;
    public static final int INT32 = 6;
    public static final int UINT32 = 7;
    public static final int FLOAT32 = 8;
    public static final int FLOAT64 = 9;
    public static final int STRING = 10;
    public static final int URL = 11;
    private int type;
    private String name;
    private boolean is_alias;
    private String aliased_to;
    private Object attr;

    public Attribute(AttributeTable container) {
        this.type = 2;
        this.is_alias = false;
        this.attr = container;
    }

    public Attribute(int type, String name, String value, boolean check) throws AttributeBadValueException {
        if (check) {
            Attribute.dispatchCheckValue(type, value);
        }
        this.type = type;
        this.name = name;
        this.is_alias = false;
        this.attr = new Vector();
        ((Vector)this.attr).addElement(value);
    }

    public Attribute(int type, String name, String value) throws AttributeBadValueException {
        Attribute.dispatchCheckValue(type, value);
        this.type = type;
        this.name = name;
        this.is_alias = false;
        this.attr = new Vector();
        ((Vector)this.attr).addElement(value);
    }

    public Attribute(String name, AttributeTable container) {
        this.type = 2;
        this.name = name;
        this.is_alias = false;
        this.attr = container;
    }

    public Attribute(String aliasedTo, Attribute attr) {
        this.type = attr.type;
        this.is_alias = true;
        this.aliased_to = aliasedTo;
        this.attr = attr.attr;
    }

    public Attribute(String name, int type) throws IllegalArgumentException {
        this.type = type;
        this.name = name;
        if (type == 2) {
            throw new IllegalArgumentException("can't construct Attribute(CONTAINER)");
        }
        this.attr = new Vector();
    }

    public Object clone() {
        try {
            Attribute a2 = (Attribute)super.clone();
            a2.attr = this.type == 2 ? ((AttributeTable)this.attr).clone() : ((Vector)this.attr).clone();
            return a2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public final String getTypeString() {
        switch (this.type) {
            case 2: {
                return "Container";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Int16";
            }
            case 5: {
                return "UInt16";
            }
            case 6: {
                return "Int32";
            }
            case 7: {
                return "UInt32";
            }
            case 8: {
                return "Float32";
            }
            case 9: {
                return "Float64";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "Url";
            }
        }
        return "";
    }

    public final int getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isContainer() {
        return this.type == 2;
    }

    public final boolean isAlias() {
        return this.is_alias;
    }

    public final String getAliasedTo() {
        return this.aliased_to;
    }

    public final AttributeTable getContainer() {
        return (AttributeTable)this.attr;
    }

    public final Enumeration getValues() {
        return ((Vector)this.attr).elements();
    }

    public final String getValueAt(int index) {
        return (String)((Vector)this.attr).elementAt(index);
    }

    public final void appendValue(String value) throws AttributeBadValueException {
        this.appendValue(value, true);
    }

    public final void appendValue(String value, boolean check) throws AttributeBadValueException {
        if (check) {
            Attribute.dispatchCheckValue(this.type, value);
        }
        ((Vector)this.attr).addElement(value);
    }

    public final void deleteValueAt(int index) {
        ((Vector)this.attr).removeElementAt(index);
    }

    private static void dispatchCheckValue(int type, String value) throws AttributeBadValueException {
        switch (type) {
            case 3: {
                if (Attribute.checkByte(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Byte value.");
            }
            case 4: {
                if (Attribute.checkShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int16 value.");
            }
            case 5: {
                if (Attribute.checkUShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt16 value.");
            }
            case 6: {
                if (Attribute.checkInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int32 value.");
            }
            case 7: {
                if (Attribute.checkUInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt32 value.");
            }
            case 8: {
                if (Attribute.checkFloat(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float32 value.");
            }
            case 9: {
                if (Attribute.checkDouble(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float64 value.");
            }
        }
    }

    private static final boolean checkByte(String s) throws AttributeBadValueException {
        try {
            short val = Short.parseShort(s);
            return val <= 255;
        }
        catch (NumberFormatException e2) {
            throw new AttributeBadValueException("`" + s + "' is not a Byte value.");
        }
    }

    private static final boolean checkShort(String s) {
        try {
            Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static final boolean checkUShort(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 65535L;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static final boolean checkInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static final boolean checkUInt(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 0xFFFFFFFFL;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static final boolean checkFloat(String s) {
        try {
            Float.valueOf(s);
            return true;
        }
        catch (NumberFormatException e2) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }

    private static final boolean checkDouble(String s) {
        try {
            Double.valueOf(s);
            return true;
        }
        catch (NumberFormatException e2) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }
}

