/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.AttributeTable;
import dods.dap.DASException;
import dods.dap.parser.DASParser;
import dods.dap.parser.ParseException;
import dods.util.SortedTable;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class DAS
implements Cloneable {
    private SortedTable attr = new SortedTable();

    public Object clone() {
        try {
            DAS d2 = (DAS)super.clone();
            d2.attr = new SortedTable();
            int i = 0;
            while (i < this.attr.size()) {
                String key = (String)this.attr.getKey(i);
                AttributeTable element = (AttributeTable)this.attr.elementAt(i);
                d2.attr.put(key, element.clone());
                ++i;
            }
            return d2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public final Enumeration getNames() {
        return this.attr.keys();
    }

    public final AttributeTable getAttributeTable(String name) {
        return (AttributeTable)this.attr.get(name);
    }

    public void addAttributeTable(String name, AttributeTable a2) {
        this.attr.put(name, a2);
    }

    public void parse(InputStream is) throws ParseException, DASException {
        DASParser dp = new DASParser(is);
        dp.Attributes(this);
    }

    public void print(PrintWriter os) {
        os.println("Attributes {");
        Enumeration e2 = this.getNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            os.println("    " + name + " {");
            this.getAttributeTable(name).print(os, "        ");
            os.println("    }");
        }
        os.println("}");
        os.flush();
    }

    public final void print(OutputStream os) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))));
    }
}

