/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.DArrayDimension;
import dods.dap.DVector;
import dods.dap.Server.InvalidParameterException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DArray
extends DVector
implements Cloneable {
    private Vector dimVector = new Vector();

    public DArray() {
        this(null);
    }

    public DArray(String n) {
        super(n);
    }

    public Object clone() {
        DArray a2 = (DArray)super.clone();
        a2.dimVector = new Vector();
        int i = 0;
        while (i < this.dimVector.size()) {
            DArrayDimension d2 = (DArrayDimension)this.dimVector.elementAt(i);
            a2.dimVector.addElement(d2.clone());
            ++i;
        }
        return a2;
    }

    public String getTypeName() {
        return "Array";
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        if (this.dimVector.isEmpty()) {
            throw new BadSemanticsException("An array variable must have dimensions");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        this.getPrimitiveVector().printDecl(os, space, false, constrained);
        Enumeration e2 = this.dimVector.elements();
        while (e2.hasMoreElements()) {
            DArrayDimension d2 = (DArrayDimension)e2.nextElement();
            os.print("[");
            if (d2.getName() != null) {
                os.print(d2.getName() + " = ");
            }
            os.print(d2.getSize() + "]");
        }
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration e2 = this.dimVector.elements();
        while (e2.hasMoreElements()) {
            DArrayDimension d2 = (DArrayDimension)e2.nextElement();
            shape[i++] = d2.getSize();
        }
        this.printArray(os, 0, dims, shape, 0);
        if (print_decl_p) {
            os.println(";");
        }
    }

    private int printArray(PrintWriter os, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            os.print("{");
            int i = 0;
            while (i < shape[offset] - 1) {
                this.getPrimitiveVector().printSingleVal(os, index++);
                os.print(", ");
                ++i;
            }
            this.getPrimitiveVector().printSingleVal(os, index++);
            os.print("}");
            return index;
        }
        os.print("{");
        int i = 0;
        while (i < shape[offset] - 1) {
            index = this.printArray(os, index, dims - 1, shape, offset + 1);
            os.print(",");
            ++i;
        }
        index = this.printArray(os, index, dims - 1, shape, offset + 1);
        os.print("}");
        return index;
    }

    public void appendDim(int size, String name) {
        DArrayDimension newDim = new DArrayDimension(size, name);
        this.dimVector.addElement(newDim);
    }

    public void appendDim(int size) {
        this.appendDim(size, null);
    }

    public final Enumeration getDimensions() {
        return this.dimVector.elements();
    }

    public final int numDimensions() {
        return this.dimVector.size();
    }

    public DArrayDimension getDimension(int dimension) throws InvalidParameterException {
        if (dimension < this.dimVector.size()) {
            return (DArrayDimension)this.dimVector.get(dimension);
        }
        throw new InvalidParameterException("DArray.getDimension(): Bad dimension request: dimension > # of dimensions");
    }

    public DArrayDimension getFirstDimension() {
        return (DArrayDimension)this.dimVector.get(0);
    }
}

