/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.ClientIO;
import dods.dap.DDS;
import dods.dap.DODSException;
import dods.dap.DataReadException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;

public class DataDDS
extends DDS {
    private ServerVersion ver;

    public DataDDS(ServerVersion ver) {
        this.ver = ver;
    }

    public DataDDS(ServerVersion ver, BaseTypeFactory btf) {
        super(btf);
        this.ver = ver;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public void readData(InputStream is, StatusUI statusUI) throws IOException, EOFException, DODSException {
        BufferedInputStream bufferedIS = new BufferedInputStream(is);
        DataInputStream dataIS = new DataInputStream(bufferedIS);
        Enumeration e2 = this.getVariables();
        while (e2.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO bt = (ClientIO)e2.nextElement();
            bt.deserialize(dataIS, this.ver, statusUI);
        }
        if (statusUI != null) {
            statusUI.finished();
        }
    }

    public void printVal(PrintWriter os) {
        Enumeration e2 = this.getVariables();
        while (e2.hasMoreElements()) {
            BaseType bt = (BaseType)e2.nextElement();
            bt.printVal(os, "", true);
        }
        os.println();
    }

    public final void printVal(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw);
        pw.flush();
    }

    public final void externalize(OutputStream os, boolean compress, boolean headers) throws IOException {
        if (headers) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            pw.println("HTTP/1.0 200 OK");
            pw.println("Server: " + ServerVersion.getCurrentVersion());
            pw.println("Content-type: application/octet-stream");
            pw.println("Content-Description: dods_data");
            if (compress) {
                pw.println("Content-Encoding: deflate");
            }
            pw.println();
            pw.flush();
        }
        FilterOutputStream bufferedOS = compress ? new DeflaterOutputStream(os) : new BufferedOutputStream(os);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(bufferedOS));
        this.print(pw);
        pw.flush();
        ((OutputStream)bufferedOS).write("\nData:\n".getBytes());
        ((OutputStream)bufferedOS).flush();
        DataOutputStream dataOS = new DataOutputStream(bufferedOS);
        Enumeration e2 = this.getVariables();
        while (e2.hasMoreElements()) {
            ClientIO bt = (ClientIO)e2.nextElement();
            bt.externalize(dataOS);
        }
        dataOS.close();
    }
}

