/*
 * Decompiled with CFR 0.152.
 */
package dods.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class iniFile {
    private boolean Debug = false;
    private String iniFile;
    private Vector sectionNames;
    private Vector sectionProperties;
    private int currentSection;
    private String errMsg;

    protected iniFile() {
    }

    public iniFile(String fname) {
        this(null, fname, false);
    }

    public iniFile(String path, String fname) {
        this(path, fname, false);
    }

    public iniFile(String path, String fname, boolean dbg) {
        this.Debug = dbg;
        if (path == null) {
            path = System.getProperty("user.home");
        }
        String fileSeperator = System.getProperty("file.separator");
        this.iniFile = path + fileSeperator + fname;
        this.errMsg = "The file: \"" + this.iniFile + "\" did not contain recognizable init information.";
        this.currentSection = -1;
        this.sectionNames = null;
        this.sectionProperties = null;
        this.parseFile();
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
        }
    }

    public String getFileName() {
        return this.iniFile;
    }

    private void parseFile() {
        try {
            BufferedReader fp = new BufferedReader(new InputStreamReader(new FileInputStream(this.iniFile)));
            boolean done = false;
            while (!done) {
                String thisLine = fp.readLine();
                if (thisLine != null) {
                    int eqidx;
                    if (this.Debug) {
                        System.out.println("Read: \"" + thisLine + "\"");
                    }
                    thisLine.trim();
                    if (thisLine.startsWith(";") || thisLine.equalsIgnoreCase("")) {
                        if (!this.Debug) continue;
                        System.out.println("Ignoring comment or blank line...");
                        continue;
                    }
                    int cindx = thisLine.indexOf(";");
                    if (cindx > 0) {
                        thisLine = thisLine.substring(0, cindx);
                    }
                    if (this.Debug) {
                        System.out.println("Comments removed: \"" + thisLine + "\"");
                    }
                    thisLine.trim();
                    if (thisLine.startsWith("[") && thisLine.endsWith("]")) {
                        String sname = thisLine.substring(1, thisLine.length() - 1).trim();
                        if (this.Debug) {
                            System.out.println("Found Section Name: " + sname);
                        }
                        if (this.sectionNames == null) {
                            this.sectionNames = new Vector();
                        }
                        this.sectionNames.add(sname);
                        if (this.sectionProperties == null) {
                            this.sectionProperties = new Vector();
                        }
                        this.sectionProperties.add(new Vector());
                        continue;
                    }
                    if (this.sectionNames == null || this.sectionProperties == null || (eqidx = thisLine.indexOf("=")) == -1) continue;
                    String[] pair = new String[]{thisLine.substring(0, eqidx).trim(), thisLine.substring(eqidx + 1, thisLine.length()).trim()};
                    if (this.Debug) {
                        System.out.println("pair[0]: \"" + pair[0] + "\"   pair[1]: \"" + pair[1] + "\"");
                    }
                    ((Vector)this.sectionProperties.lastElement()).add(pair);
                    continue;
                }
                done = true;
            }
            fp.close();
        }
        catch (FileNotFoundException e2) {
            System.err.println("Could Not Find ini File: \"" + this.iniFile + "\"");
        }
        catch (IOException e3) {
            System.err.println("Could Not Read ini File: \"" + this.iniFile + "\"");
        }
    }

    public Enumeration getPropList(String sectionName) {
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
            return null;
        }
        int sectionIndex = 0;
        Enumeration e2 = this.sectionNames.elements();
        boolean done = false;
        while (!done && e2.hasMoreElements()) {
            String thisName = (String)e2.nextElement();
            if (sectionName.equalsIgnoreCase(thisName)) {
                done = true;
                continue;
            }
            ++sectionIndex;
        }
        if (!done) {
            return null;
        }
        return ((Vector)this.sectionProperties.elementAt(sectionIndex)).elements();
    }

    public String getProperty(String propertyName) {
        if (this.currentSection < 0) {
            String msg = "You must use the setSection() method before you can use getProperty().";
            System.err.println(msg);
            return msg;
        }
        String[] pair = null;
        Enumeration e2 = ((Vector)this.sectionProperties.elementAt(this.currentSection)).elements();
        boolean done = false;
        while (!done && e2.hasMoreElements()) {
            pair = (String[])e2.nextElement();
            if (!pair[0].equalsIgnoreCase(propertyName)) continue;
            done = true;
        }
        if (done) {
            return pair[1];
        }
        return null;
    }

    public Enumeration getSectionList() {
        if (this.sectionNames == null) {
            return null;
        }
        return this.sectionNames.elements();
    }

    /*
     * Unable to fully structure code
     */
    public void printProps(PrintStream ps) {
        block2: {
            se = this.getSectionList();
            if (se != null) ** GOTO lbl16
            ps.println(this.errMsg);
            break block2;
lbl-1000:
            // 1 sources

            {
                sname = (String)se.nextElement();
                this.setSection(sname);
                ps.println("[" + sname + "]");
                pe = this.getPropList(sname);
                while (pe.hasMoreElements()) {
                    pair = (String[])pe.nextElement();
                    prop = pair[0];
                    valu = this.getProperty(prop);
                    ps.println("    \"" + prop + "\" = \"" + valu + "\"");
                }
lbl16:
                // 2 sources

                ** while (se.hasMoreElements())
            }
        }
    }

    public boolean setSection(String sectionName) {
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
            return false;
        }
        int sectionIndex = 0;
        Enumeration e2 = this.sectionNames.elements();
        boolean done = false;
        while (!done && e2.hasMoreElements()) {
            String thisName = (String)e2.nextElement();
            if (sectionName.equalsIgnoreCase(thisName)) {
                done = true;
                continue;
            }
            ++sectionIndex;
        }
        if (!done) {
            return false;
        }
        this.currentSection = sectionIndex;
        return true;
    }
}

