/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.McIDASException;
import java.io.Serializable;

public class GRIDnav
implements Serializable {
    final int PSEUDO_MERCATOR = 1;
    final int PS_OR_LAMBERT_CONIC = 2;
    final int EQUIDISTANT = 3;
    final int PSEUDO_MERCATOR_GENERAL = 4;
    final int NO_NAV = 5;
    final int LAMBERT_CONFORMAL_TANGENT = 6;
    final double EARTH_RADIUS = 6371.23;
    final double xrad = Math.PI / 180;
    public final int indexRow = 1;
    public final int indexCol = 0;
    public final int indexLat = 0;
    public final int indexLon = 1;
    private int startRow = 1;
    private int startColumn = 1;
    private boolean isRowFlipped = false;
    private double rowOffset = 0.0;
    private int navType;
    private double xnr;
    private double xnc;
    private double xnrow;
    private double xncol;
    private boolean wierd = false;
    private double glamx;
    private double glomx;
    private double ginct;
    private double gincn;
    private double xrowi;
    private double xcoli;
    private double xqlon;
    private double xspace;
    private double xh;
    private double xfac;
    private double xblat;
    private double xrot;
    private double yspace;
    private double xblon;

    public GRIDnav(int[] gridDirBlock) throws McIDASException {
        if (gridDirBlock.length != 64) {
            throw new McIDASException("Directory is not the right size");
        }
        int gridType = gridDirBlock[33];
        this.navType = gridType % 10;
        this.wierd = gridType / 10 == 1;
        this.xnr = gridDirBlock[1];
        this.xnc = gridDirBlock[2];
        this.xnrow = this.xnr;
        this.xncol = this.xnc;
        switch (this.navType) {
            case 1: 
            case 4: {
                this.glamx = (double)gridDirBlock[34] / 10000.0;
                this.glomx = (double)gridDirBlock[35] / 10000.0;
                this.ginct = (double)gridDirBlock[38] / 10000.0;
                double d2 = this.gincn = this.navType == 4 ? (double)gridDirBlock[39] / 10000.0 : this.ginct;
                if (!this.wierd) break;
                double x = this.xnr;
                this.xnr = this.xnc;
                this.xnc = x;
                break;
            }
            case 2: {
                this.xrowi = (double)gridDirBlock[34] / 10000.0;
                this.xcoli = (double)gridDirBlock[35] / 10000.0;
                this.xspace = (double)gridDirBlock[36] / 1000.0;
                this.xqlon = (double)gridDirBlock[37] / 10000.0;
                double xt1 = (double)gridDirBlock[38] / 10000.0;
                double xt2 = (double)gridDirBlock[39] / 10000.0;
                this.xh = xt1 >= 0.0 ? 1.0 : -1.0;
                xt1 = (90.0 - this.xh * xt1) * (Math.PI / 180);
                xt2 = (90.0 - this.xh * xt2) * (Math.PI / 180);
                this.xfac = 1.0;
                if (xt1 != xt2) {
                    this.xfac = (Math.log(Math.sin(xt1)) - Math.log(Math.sin(xt2))) / (Math.log(Math.tan(0.5 * xt1)) - Math.log(Math.tan(0.5 * xt2)));
                }
                this.xfac = 1.0 / this.xfac;
                this.xblat = 6370.0 * Math.sin(xt1) / (this.xspace * this.xfac * Math.pow(Math.tan(xt1 * 0.5), this.xfac));
                if (!this.wierd) break;
                double x = this.xnr;
                this.xnr = this.xnc;
                this.xnc = x;
                x = this.xcoli;
                this.xcoli = this.xrowi;
                this.xrowi = this.xnr - x + 1.0;
                this.xqlon += 90.0;
                break;
            }
            case 3: {
                this.xrowi = 1.0;
                this.xcoli = 1.0;
                this.glamx = (double)gridDirBlock[34] / 10000.0;
                this.glomx = (double)gridDirBlock[35] / 10000.0;
                this.xrot = -Math.PI / 180 * (double)gridDirBlock[36] / 10000.0;
                this.xspace = (double)gridDirBlock[37] / 1000.0;
                this.yspace = (double)gridDirBlock[38] / 1000.0;
                this.xblat = 111.19894090183831 / this.yspace;
                this.xblon = 111.19894090183831 / this.xspace;
                if (!this.wierd) break;
                double x = this.xnr;
                this.xnr = this.xnc;
                this.xnc = x;
                break;
            }
            case 6: {
                this.xrowi = (double)gridDirBlock[34] / 10000.0;
                this.xcoli = (double)gridDirBlock[35] / 10000.0;
                this.xspace = (double)gridDirBlock[36] / 1000.0;
                this.xqlon = (double)gridDirBlock[37] / 10000.0;
                double xtl = (double)gridDirBlock[38] / 10000.0;
                this.xh = xtl >= 0.0 ? 1.0 : -1.0;
                xtl = (90.0 - this.xh * xtl) * (Math.PI / 180);
                this.xfac = Math.cos(xtl);
                this.xblat = 6371.23 * Math.tan(xtl) / (this.xspace * Math.pow(Math.tan(xtl * 0.5), this.xfac));
                break;
            }
        }
    }

    public double[][] toLatLon(double[][] rowcol) {
        double[][] latlon = new double[2][rowcol[0].length];
        double xlat = Double.NaN;
        double xlon = Double.NaN;
        double xrlon = 0.0;
        int i = 0;
        while (i < rowcol[0].length) {
            double xrow = this.isRowFlipped ? this.rowOffset - rowcol[1][i] + 1.0 : rowcol[1][i];
            double xcol = rowcol[0][i] - (double)(this.startColumn - 1);
            if ((xrow += (double)(this.startRow - 1)) > this.xnrow || xrow < 1.0 || xcol > this.xncol || xcol < 1.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                switch (this.navType) {
                    case 1: 
                    case 4: {
                        if (this.wierd) {
                            double x = xrow;
                            xcol = xrow;
                            xrow = this.xnr - x + 1.0;
                        }
                        xlat = this.glamx - (xrow - 1.0) * this.ginct;
                        xlon = this.glomx - (xcol - 1.0) * this.gincn;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: 
                    case 6: {
                        double radius;
                        double xldif = this.xh * (xrow - this.xrowi) / this.xblat;
                        double xedif = (this.xcoli - xcol) / this.xblat;
                        xrlon = 0.0;
                        if (xldif != 0.0 || xedif != 0.0) {
                            xrlon = Math.atan2(xedif, xldif);
                        }
                        if ((xlon = xrlon / this.xfac / (Math.PI / 180) + this.xqlon) > 180.0) {
                            xlon -= 360.0;
                        }
                        if ((radius = Math.sqrt(xldif * xldif + xedif * xedif)) < 1.0E-5) {
                            xlat = this.xh * 90.0;
                            break;
                        }
                        xlat = this.xh * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(radius) / this.xfac)) / (Math.PI / 180));
                        break;
                    }
                    default: {
                        xlat = 1.0 - (xrow - 1.0) / (this.xnr - 1.0);
                        xlon = 1.0 - (xcol - 1.0) / (this.xnc - 1.0);
                    }
                }
            }
            latlon[0][i] = xlat;
            latlon[1][i] = -xlon;
            ++i;
        }
        return latlon;
    }

    public double[][] toRowCol(double[][] latlon) {
        double[][] rowcol = new double[2][latlon[0].length];
        int i = 0;
        while (i < latlon[0].length) {
            double xrow = Double.NaN;
            double xcol = Double.NaN;
            double xlat = latlon[0][i];
            double xlon = -latlon[1][i];
            switch (this.navType) {
                case 1: 
                case 4: {
                    double glomx1 = this.glomx;
                    if (this.glomx < 0.0 && this.glomx * xlon < 0.0) {
                        glomx1 = this.glomx + 360.0;
                    }
                    xrow = (this.glamx - xlat) / this.ginct + 1.0;
                    xcol = (glomx1 - xlon) / this.gincn + 1.0;
                    break;
                }
                case 3: {
                    double xrlon = xlon - this.glomx;
                    double xrlat = xlat - this.glamx;
                    double xldif = this.xblat * xrlat;
                    double xedif = xrlon * this.xblon * Math.cos(xlat * (Math.PI / 180));
                    double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
                    if (xdis > 0.001) {
                        double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                        double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                        xldif = xdis * Math.cos(-this.xrot + xangl);
                        xedif = xdis * Math.sin(-this.xrot + xange);
                    }
                    xrow = this.xrowi - xldif;
                    xcol = this.xcoli - xedif;
                    break;
                }
                case 2: 
                case 6: {
                    double xrlon = xlon - this.xqlon;
                    if (xrlon > 180.0) {
                        xrlon -= 360.0;
                    }
                    xrlon = xrlon * this.xfac * (Math.PI / 180);
                    double xclat = (90.0 - this.xh * xlat) * (Math.PI / 180) * 0.5;
                    double xrlat = this.xblat * Math.pow(Math.tan(xclat), this.xfac);
                    xrow = this.xh * xrlat * Math.cos(xrlon) + this.xrowi;
                    xcol = -xrlat * Math.sin(xrlon) + this.xcoli;
                    break;
                }
                default: {
                    xrow = (1.0 - xlat) * (this.xnr - 1.0) + 1.0;
                    xcol = (1.0 - xlon) * (this.xnc - 1.0) + 1.0;
                }
            }
            if (xrow > this.xnrow || xrow < 1.0 || xcol > this.xncol || xcol < 1.0) {
                xrow = Double.NaN;
                xcol = Double.NaN;
            } else {
                xrow -= (double)(this.startRow - 1);
                xcol += (double)(this.startColumn - 1);
                if (this.isRowFlipped) {
                    xrow = this.rowOffset - xrow + 1.0;
                }
            }
            rowcol[1][i] = xrow;
            rowcol[0][i] = xcol;
            ++i;
        }
        return rowcol;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GRIDnav)) {
            return false;
        }
        GRIDnav that = (GRIDnav)obj;
        return Double.doubleToLongBits(this.xnr) == Double.doubleToLongBits(that.xnr) && Double.doubleToLongBits(this.xnc) == Double.doubleToLongBits(that.xnc) && this.navType == that.navType;
    }

    public void setStart(int startRow, int startColumn) {
        this.startRow = startRow;
        this.startColumn = startColumn;
    }

    public void setFlipRowCoordinates(int row) {
        this.isRowFlipped = true;
        this.rowOffset = row;
    }

    public boolean isFlippedRowCoordinates() {
        return this.isRowFlipped;
    }

    public double getRowOffset() {
        return this.rowOffset;
    }

    public int getRowIndex() {
        return 1;
    }

    public int getColumnIndex() {
        return 0;
    }
}

