/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class GridDirectoryList {
    private boolean flipwords = false;
    private DataInputStream inputStream;
    private int status = -1;
    private AddeURLConnection urlc;
    private ArrayList dirs;
    private ArrayList fileHeaders;
    private int numDirs = 0;
    private final int HEARTBEAT = 11223344;

    public GridDirectoryList(String gridSource) throws McIDASException {
        try {
            URL url = new URL(gridSource);
            this.urlc = (AddeURLConnection)url.openConnection();
            this.inputStream = new DataInputStream(new BufferedInputStream(this.urlc.getInputStream()));
        }
        catch (IOException e2) {
            throw new McIDASException("Error opening URL for grids:" + e2);
        }
        this.readDirectory();
    }

    public GridDirectoryList(URL url) throws McIDASException {
        try {
            this.urlc = (AddeURLConnection)url.openConnection();
            this.inputStream = new DataInputStream(new BufferedInputStream(this.urlc.getInputStream()));
        }
        catch (IOException e2) {
            throw new McIDASException("Error opening URL for grids:" + e2);
        }
        this.readDirectory();
    }

    private void readDirectory() throws McIDASException {
        if (this.urlc.getRequestType() != 3) {
            throw new McIDASException("Request must be of GDIR type");
        }
        this.dirs = new ArrayList();
        this.fileHeaders = new ArrayList();
        int numBytes = this.urlc.getInitialRecordSize();
        if (numBytes == 0) {
            throw new McIDASException("No datasets found");
        }
        byte[] header = new byte[256];
        try {
            int check;
            while (numBytes == 4) {
                check = this.inputStream.readInt();
                if (check != 11223344) {
                    System.out.println("problem...not heartbeat = " + check);
                }
                numBytes = this.inputStream.readInt();
            }
            while ((check = this.inputStream.readInt()) == 0) {
                int check2;
                this.inputStream.readFully(header, 0, 256);
                String head = new String(header, 0, 32);
                this.fileHeaders.add(head);
                while ((check2 = this.inputStream.readInt()) == 0) {
                    int[] dir = new int[64];
                    int i = 0;
                    while (i < 64) {
                        dir[i] = this.inputStream.readInt();
                        ++i;
                    }
                    GridDirectory gridDir = new GridDirectory(dir);
                    System.out.println(gridDir);
                    this.dirs.add(gridDir);
                }
            }
        }
        catch (IOException e2) {
            this.status = -1;
            throw new McIDASException("Error reading grid directory:" + e2);
        }
        this.status = 1;
        ++this.numDirs;
    }

    public ArrayList getDirs() throws McIDASException {
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new McIDASException("Error reading directory information");
        }
        return this.dirs;
    }

    public String toString() {
        if (this.status <= 0 || this.numDirs <= 0) {
            return new String("No directory information available");
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.dirs.size()) {
            sb.append(((GridDirectory)this.dirs.get(i)).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a ADDE request to grids");
            System.exit(1);
        }
        GridDirectoryList gridDirectoryList = new GridDirectoryList(args[0]);
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e2) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

