/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class RECTnav
extends AREAnav {
    private boolean isEastPositive = true;
    int itype;
    int iwest;
    double xrow;
    double xcol;
    double zslat;
    double zslon;
    double zdlat;
    double zdlon;
    double xlin;
    double xele;
    double xldif;
    double xedif;
    double xlat;
    double xlon;

    public RECTnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1380270932) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        int ipowlat = iparms[11];
        if (ipowlat == 0) {
            ipowlat = 4;
        }
        this.zslat = (double)iparms[2] / Math.pow(10.0, ipowlat);
        this.xcol = iparms[3];
        int ipowlon = iparms[12];
        if (ipowlon == 0) {
            ipowlon = 4;
        }
        this.zslon = (double)iparms[4] / Math.pow(10.0, ipowlon);
        int ipowdlin = iparms[13];
        if (ipowdlin == 0) {
            ipowdlin = 4;
        }
        this.zdlat = (double)iparms[5] / Math.pow(10.0, ipowdlin);
        int ipowdele = iparms[14];
        if (ipowdele == 0) {
            ipowdele = 4;
        }
        this.zdlon = (double)iparms[6] / Math.pow(10.0, ipowdele);
        int ipowrad = iparms[15];
        if (ipowrad == 0) {
            ipowrad = 3;
        }
        double drad = (double)iparms[7] / Math.pow(10.0, ipowrad);
        int ipowecc = iparms[16];
        if (ipowecc == 0) {
            ipowecc = 6;
        }
        double decc = (double)iparms[8] / Math.pow(10.0, ipowecc);
        int n = this.iwest = iparms[10] >= 0 ? 1 : -1;
        if (this.iwest == 1) {
            this.isEastPositive = false;
        }
        this.xlin = 1.0;
        this.xele = 1.0;
        this.xldif = this.xrow - this.xlin;
        this.xedif = (double)this.iwest * (this.xcol - this.xele);
        this.xlon = this.zslon + this.xedif * this.zdlon;
        this.zslat = this.xlat = this.zslat + this.xldif * this.zdlat;
        this.zslon = this.xlon;
        this.xrow = 1.0;
        this.xcol = 1.0;
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        int point = 0;
        while (point < number) {
            double xldif = this.xrow - imglinele[1][point];
            double xedif = (double)this.iwest * (this.xcol - imglinele[0][point]);
            double xlon = this.zslon + xedif * this.zdlon;
            double xlat = this.zslat + xldif * this.zdlat;
            if (xlat > 90.0 || xlat < -90.0) {
                xlat = Double.NaN;
            }
            if (xlon < -180.0 && (xlon += 360.0) < -180.0) {
                xlon = Double.NaN;
            }
            if (xlon > 180.0 && xlon != Double.NaN && (xlon -= 360.0) > 180.0) {
                xlon = Double.NaN;
            }
            if (xlat == Double.NaN || xlon == Double.NaN) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
            } else {
                latlon[0][point] = xlat;
                latlon[1][point] = this.iwest == 1 ? -xlon : xlon;
            }
            ++point;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        int point = 0;
        while (point < number) {
            double xlon;
            double xlat = latlon[0][point];
            double d2 = xlon = this.iwest == 1 ? -latlon[1][point] : latlon[1][point];
            if (this.iwest == -1 && xlon < this.zslon) {
                xlon += 360.0;
            }
            linele[1][point] = this.xrow - (xlat - this.zslat) / this.zdlat;
            linele[0][point] = this.xcol - (xlon - this.zslon) / (this.zdlon * (double)this.iwest);
            ++point;
        }
        return this.imageCoordToAreaCoord(linele);
    }
}

