/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    private static String name = "Untitled";
    private static int width = 400;
    private static int height = 400;
    private static int slices = 1;
    private static int type = 0;
    private static int fillWith = 0;
    private static String[] types = new String[]{"8-bit Unsigned", "16-bit Unsigned", "32-bit Real", "32-bit RGB"};
    private static String[] fill = new String[]{"White", "Black", "Ramp", "Clipboard"};

    public NewImage() {
        this.openImage();
    }

    static void createStack(ImagePlus imp, ImageProcessor ip, int nSlices, int type) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack = imp.createEmptyStack();
        try {
            stack.addSlice(null, ip);
            int i = 2;
            while (i <= nSlices) {
                Object[] pixels2 = null;
                switch (type) {
                    case 0: {
                        pixels2 = new byte[width * height];
                        break;
                    }
                    case 1: {
                        pixels2 = new short[width * height];
                        break;
                    }
                    case 2: {
                        pixels2 = new float[width * height];
                        break;
                    }
                    case 3: {
                        pixels2 = new int[width * height];
                    }
                }
                System.arraycopy(ip.getPixels(), 0, pixels2, 0, width * height);
                stack.addSlice(null, pixels2);
                ++i;
            }
        }
        catch (OutOfMemoryError e2) {
            IJ.outOfMemory(imp.getTitle());
            stack.trim();
        }
        if (stack.getSize() > 1) {
            imp.setStack(null, stack);
        }
    }

    static ImagePlus createImagePlus() {
        return new ImagePlus();
    }

    public static ImagePlus createByteImage(String title, int width, int height, int slices, int fill) {
        byte[] pixels = new byte[width * height];
        switch (fill) {
            case 0: {
                int i = 0;
                while (i < width * height) {
                    pixels[i] = -1;
                    ++i;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                byte[] ramp = new byte[width];
                int i = 0;
                while (i < width) {
                    ramp[i] = (byte)((double)i * 256.0 / (double)width + 0.5);
                    ++i;
                }
                int y = 0;
                while (y < height) {
                    int offset = y * width;
                    int x = 0;
                    while (x < width) {
                        pixels[offset++] = ramp[x];
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        ByteProcessor ip = new ByteProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 0);
        }
        return imp;
    }

    public static ImagePlus createRGBImage(String title, int width, int height, int slices, int fill) {
        int[] pixels = new int[width * height];
        switch (fill) {
            case 0: {
                int i = 0;
                while (i < width * height) {
                    pixels[i] = -1;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < width * height) {
                    pixels[i] = -16777216;
                    ++i;
                }
                break;
            }
            case 2: {
                int[] ramp = new int[width];
                int i = 0;
                while (i < width) {
                    byte b2;
                    byte g = b2 = (byte)((double)i * 256.0 / (double)width + 0.5);
                    byte r = b2;
                    ramp[i] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b2 & 0xFF;
                    ++i;
                }
                int y = 0;
                while (y < height) {
                    int offset = y * width;
                    int x = 0;
                    while (x < width) {
                        pixels[offset++] = ramp[x];
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        ColorProcessor ip = new ColorProcessor(width, height, pixels);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 3);
        }
        return imp;
    }

    public static ImagePlus createShortImage(String title, int width, int height, int slices, int fill) {
        short[] pixels = new short[width * height];
        switch (fill) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                short[] ramp = new short[width];
                int i = 0;
                while (i < width) {
                    ramp[i] = (short)((double)i * 65536.0 / (double)width + 0.5);
                    ++i;
                }
                int y = 0;
                while (y < height) {
                    int offset = y * width;
                    int x = 0;
                    while (x < width) {
                        pixels[offset++] = ramp[x];
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        ShortProcessor ip = new ShortProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 1);
        }
        return imp;
    }

    public static ImagePlus createUnsignedShortImage(String title, int width, int height, int slices, int fill) {
        return NewImage.createShortImage(title, width, height, slices, fill);
    }

    public static ImagePlus createFloatImage(String title, int width, int height, int slices, int fill) {
        float[] pixels = new float[width * height];
        switch (fill) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                float[] ramp = new float[width];
                int i = 0;
                while (i < width) {
                    ramp[i] = (float)((double)i * 1.0 / (double)width);
                    ++i;
                }
                int y = 0;
                while (y < height) {
                    int offset = y * width;
                    int x = 0;
                    while (x < width) {
                        pixels[offset++] = ramp[x];
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        FloatProcessor ip = new FloatProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1) {
            NewImage.createStack(imp, ip, slices, 2);
        }
        return imp;
    }

    public static void open(String title, int width, int height, int nSlices, int type, int fill) {
        ImagePlus imp = null;
        switch (type) {
            case 0: {
                imp = NewImage.createByteImage(title, width, height, nSlices, fill);
                break;
            }
            case 1: {
                imp = NewImage.createShortImage(title, width, height, nSlices, fill);
                break;
            }
            case 2: {
                imp = NewImage.createFloatImage(title, width, height, nSlices, fill);
                break;
            }
            case 3: {
                imp = NewImage.createRGBImage(title, width, height, nSlices, fill);
            }
        }
        if (imp != null) {
            imp.show();
        }
    }

    void showClipboard() {
        ImagePlus clipboard = ImageWindow.getClipboard();
        if (clipboard != null) {
            clipboard.show();
        } else {
            IJ.error("The clipboard is empty.");
        }
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("New...", IJ.getInstance());
        gd.addStringField("Name:", name, 12);
        gd.addChoice("Type:", types, types[type]);
        gd.addChoice("Fill With:", fill, fill[fillWith]);
        gd.addNumericField("Width (pixels):", width, 0);
        gd.addNumericField("Height (pixels):", height, 0);
        gd.addNumericField("Slices:", slices, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        type = gd.getNextChoiceIndex();
        fillWith = gd.getNextChoiceIndex();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        slices = (int)gd.getNextNumber();
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        if (fillWith > 2) {
            this.showClipboard();
            return;
        }
        try {
            NewImage.open(name, width, height, slices, type, fillWith);
        }
        catch (OutOfMemoryError e2) {
            IJ.outOfMemory("New...");
        }
    }
}

