/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class OvalRoi
extends Roi {
    public OvalRoi(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.type = 1;
    }

    public OvalRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = 1;
    }

    public OvalRoi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    public void draw(Graphics g) {
        g.setColor(Roi.ROIColor);
        double mag = this.ic.getMagnification();
        g.drawOval(this.ic.screenX(this.x), this.ic.screenY(this.y), (int)((double)this.width * mag), (int)((double)this.height * mag));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        this.showStatus();
    }

    public void drawPixels() {
        double yy;
        ImageProcessor ip = this.imp.getProcessor();
        int a2 = this.width / 2;
        int b2 = this.height / 2;
        double a22 = a2 * a2;
        double b22 = b2 * b2;
        int xbase = this.x + a2;
        int ybase = this.y + b2;
        ip.moveTo(this.x, this.y + b2);
        int i = -a2 + 1;
        while (i <= a2) {
            yy = Math.sqrt(b22 * (1.0 - (double)(i * i) / a22));
            ip.lineTo(xbase + i, ybase + (int)(yy + 0.5));
            ++i;
        }
        ip.moveTo(this.x, this.y + b2);
        int i2 = -a2 + 1;
        while (i2 <= a2) {
            yy = Math.sqrt(b22 * (1.0 - (double)(i2 * i2) / a22));
            ip.lineTo(xbase + i2, ybase - (int)(yy + 0.5));
            ++i2;
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        double b2;
        double a2;
        if (!super.contains(x, y)) {
            return false;
        }
        return (double)((x = Math.abs(x - (this.x + this.width / 2))) * x) / ((a2 = (double)(this.width / 2)) * a2) + (double)((y = Math.abs(y - (this.y + this.height / 2))) * y) / ((b2 = (double)(this.height / 2)) * b2) <= 1.0;
    }

    public int[] getMask() {
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        g.fillOval(0, 0, this.width, this.height);
        g.dispose();
        ColorProcessor cp = new ColorProcessor(img);
        return (int[])cp.getPixels();
    }

    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        return Math.PI * ((double)this.width * pw + (double)this.height * ph) / 2.0;
    }
}

