/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.ProfilePlot;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int LINE = 2;
    private static final int LEFT_MARGIN = 50;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 30;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private float[] errorBars;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private ImageProcessor ip;
    private static int options;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    static /* synthetic */ Class class$ij$gui$PlotWindow;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(NewImage.createByteImage(title, plotWidth + 50 + 20, plotHeight + 20 + 30, 1, 0));
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xValues = xValues;
        this.yValues = yValues;
        double[] a2 = Tools.getMinMax(xValues);
        this.xMin = a2[0];
        this.xMax = a2[1];
        a2 = Tools.getMinMax(yValues);
        this.yMin = a2[0];
        this.yMax = a2[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.fixedYScale = true;
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.setup();
        switch (shape) {
            case 0: 
            case 1: {
                int i = 0;
                while (i < x.length) {
                    int xt = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    int yt = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                    this.drawShape(shape, xt, yt, 5);
                    ++i;
                }
                break;
            }
            case 2: {
                int[] xts = new int[x.length];
                int[] yts = new int[y.length];
                int i = 0;
                while (i < x.length) {
                    xts[i] = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    yts[i] = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                    ++i;
                }
                this.drawPolyline(this.ip, xts, yts, x.length);
            }
        }
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - size / 2;
        int ybase = y - size / 2;
        if (shape == 1) {
            this.ip.drawLine(xbase, ybase, xbase + size, ybase + size);
            this.ip.drawLine(xbase + size, ybase, xbase, ybase + size);
        } else {
            this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
            this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
            this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
            this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
        }
    }

    public void addErrorBars(float[] errorBars) {
        if (errorBars.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = errorBars;
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 50 + (int)(x * (double)this.frameWidth);
        int yt = 20 + (int)(y * (double)this.frameHeight);
        this.ip.drawString(label, xt, yt);
    }

    public void setColor(Color c2) {
        this.setup();
        this.ip = this.ip.convertToRGB();
        this.ip.setColor(c2);
    }

    public void draw() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.coordinates = new Label("                     ");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.coordinates);
        this.add(buttons);
        this.drawPlot();
        this.pack();
        if (this.ip instanceof ColorProcessor) {
            this.imp.setProcessor(null, this.ip);
        } else {
            this.imp.updateAndDraw();
        }
    }

    void setup() {
        if (this.ip != null) {
            return;
        }
        this.ip = this.imp.getProcessor();
        this.ip.setColor(Color.black);
        if (Line.getWidth() > 3) {
            this.ip.setLineWidth(1);
        }
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = plotWidth;
            this.frameHeight = plotHeight;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    String d2s(double n) {
        if ((double)Math.round(n) == n) {
            return IJ.d2s(n, 0);
        }
        return IJ.d2s(n);
    }

    public void mouseMoved(int x, int y) {
        if (this.frame == null || this.coordinates == null) {
            return;
        }
        if (this.frame.contains(x, y)) {
            this.coordinates.setText("X=" + this.d2s((double)(x -= this.frame.x) / this.xScale + this.xMin) + ", Y=" + this.d2s((double)(this.frameHeight - (y -= this.frame.y)) / this.yScale + this.yMin));
        } else {
            this.coordinates.setText("");
        }
    }

    void drawPlot() {
        this.setup();
        int[] xpoints = new int[this.nPoints];
        int[] ypoints = new int[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            double value = this.yValues[i];
            if (value < this.yMin) {
                value = this.yMin;
            }
            if (value > this.yMax) {
                value = this.yMax;
            }
            xpoints[i] = 50 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
            ypoints[i] = 20 + this.frame.height - (int)((value - this.yMin) * this.yScale);
            ++i;
        }
        this.drawPolyline(this.ip, xpoints, ypoints, this.nPoints);
        if (this.errorBars != null) {
            xpoints = new int[2];
            ypoints = new int[2];
            int i2 = 0;
            while (i2 < this.nPoints) {
                xpoints[0] = xpoints[1] = 50 + (int)(((double)this.xValues[i2] - this.xMin) * this.xScale);
                ypoints[0] = 20 + this.frame.height - (int)(((double)this.yValues[i2] - this.yMin - (double)this.errorBars[i2]) * this.yScale);
                ypoints[1] = 20 + this.frame.height - (int)(((double)this.yValues[i2] - this.yMin + (double)this.errorBars[i2]) * this.yScale);
                this.drawPolyline(this.ip, xpoints, ypoints, 2);
                ++i2;
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        String s = this.d2s(this.yMax);
        int sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 16);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 30);
        }
        s = this.d2s(this.yMin);
        sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 20 + this.frame.height);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 20 + this.frame.height);
        }
        int x = 50;
        int y = 20 + this.frame.height + 15;
        this.ip.drawString(this.d2s(this.xMin), x, y);
        s = this.d2s(this.xMax);
        this.ip.drawString(s, x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        this.ip.drawString(this.xLabel, 50 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
        this.drawYLabel(this.yLabel, 50, 20, this.frame.height);
    }

    void drawPolyline(ImageProcessor ip, int[] x, int[] y, int n) {
        ip.moveTo(x[0], y[0]);
        int i = 0;
        while (i < n) {
            ip.lineTo(x[i], y[i]);
            ++i;
        }
    }

    void drawYLabel(String yLabel, int x, int y, int height) {
        if (yLabel.equals("")) {
            return;
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ImageProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        label = label.rotateLeft();
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = x - h - 2;
        this.ip.insert(label, x2, y2);
    }

    void showList() {
        String headings;
        StringBuffer sb = new StringBuffer();
        if (this.errorBars != null) {
            headings = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            int i = 0;
            while (i < this.nPoints) {
                if (saveXValues) {
                    sb.append(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]) + "\t" + this.d2s(this.errorBars[i]) + "\n");
                } else {
                    sb.append(this.d2s(this.yValues[i]) + "\t" + this.d2s(this.errorBars[i]) + "\n");
                }
                ++i;
            }
        } else {
            headings = saveXValues ? "X\tY" : "Y";
            int i = 0;
            while (i < this.nPoints) {
                if (saveXValues) {
                    sb.append(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]) + "\n");
                } else {
                    sb.append(this.d2s(this.yValues[i]) + "\n");
                }
                ++i;
            }
        }
        TextWindow tw = new TextWindow("Plot Values", headings, sb.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e2) {
            IJ.error("" + e2);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        int i = 0;
        while (i < this.nPoints) {
            if (saveXValues) {
                pw.println(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]));
            } else {
                pw.println(this.d2s(this.yValues[i]));
            }
            ++i;
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e2) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter aw = new CharArrayWriter(this.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        int i = 0;
        while (i < this.nPoints) {
            if (saveXValues) {
                pw.print(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]) + "\n");
            } else {
                pw.print(this.d2s(this.yValues[i]) + "\n");
            }
            ++i;
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e2) {
        Object b2 = e2.getSource();
        if (b2 == this.list) {
            this.showList();
        } else if (b2 == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            prefs.put(MIN, Double.toString(min));
            prefs.put(MAX, Double.toString(max));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose) {
            options |= 2;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        IJ.register(class$ij$gui$PlotWindow == null ? (class$ij$gui$PlotWindow = PlotWindow.class$("ij.gui.PlotWindow")) : class$ij$gui$PlotWindow);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
    }
}

