/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Toolbar
extends Canvas
implements MouseListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int SPARE1 = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    private static final int NUM_TOOLS = 20;
    private static final int SIZE = 22;
    private static final int OFFSET = 3;
    private Dimension ps = new Dimension(440, 22);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String spareTip;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private Color gray = Color.lightGray;
    private Color brighter = this.gray.brighter();
    private Color darker = this.gray.darker();
    private Color evenDarker = this.darker.darker();

    public Toolbar() {
        this.down = new boolean[20];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(foregroundColor);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        instance = this;
    }

    public static int getToolId() {
        return current;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        int i = 0;
        while (i < 20) {
            this.drawButton(g, i);
            ++i;
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void drawButton(Graphics g, int tool) {
        this.fill3DRect(g, tool * 22 + 1, 1, 22, 21, !this.down[tool]);
        g.setColor(Color.black);
        int x = tool * 22 + 3;
        int y = 3;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        switch (tool) {
            case 0: {
                g.drawRect(x + 1, y + 2, 14, 11);
                return;
            }
            case 1: {
                g.drawOval(x + 1, y + 3, 14, 11);
                return;
            }
            case 2: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(4, 0);
                this.d(14, 0);
                this.d(14, 1);
                this.d(10, 5);
                this.d(10, 6);
                this.d(13, 9);
                this.d(13, 10);
                this.d(0, 10);
                this.d(0, 4);
                this.d(4, 0);
                return;
            }
            case 3: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(3, 0);
                this.d(5, 0);
                this.d(7, 2);
                this.d(9, 2);
                this.d(11, 0);
                this.d(13, 0);
                this.d(14, 1);
                this.d(15, 2);
                this.d(15, 4);
                this.d(14, 5);
                this.d(14, 6);
                this.d(12, 8);
                this.d(11, 8);
                this.d(10, 9);
                this.d(9, 9);
                this.d(8, 10);
                this.d(5, 10);
                this.d(3, 8);
                this.d(2, 8);
                this.d(1, 7);
                this.d(1, 6);
                this.d(0, 5);
                this.d(0, 2);
                this.d(1, 1);
                this.d(2, 1);
                return;
            }
            case 4: {
                this.xOffset = x;
                this.yOffset = y + 4;
                this.m(0, 0);
                this.d(16, 6);
                return;
            }
            case 5: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(0, 3);
                this.d(3, 0);
                this.d(13, 0);
                this.d(13, 1);
                this.d(8, 6);
                this.d(12, 10);
                return;
            }
            case 6: {
                this.xOffset = x + 1;
                this.yOffset = y + 4;
                this.m(0, 1);
                this.d(2, 3);
                this.d(4, 3);
                this.d(7, 0);
                this.d(8, 0);
                this.d(10, 4);
                this.d(14, 8);
                this.d(15, 8);
                return;
            }
            case 7: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 8);
                this.d(6, 8);
                this.d(6, 6);
                this.d(10, 6);
                this.d(10, 10);
                this.d(6, 10);
                this.d(6, 9);
                this.m(8, 1);
                this.d(8, 5);
                this.m(11, 8);
                this.d(15, 8);
                this.m(8, 11);
                this.d(8, 15);
                this.m(8, 8);
                this.d(8, 8);
                return;
            }
            case 8: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(4, 0);
                this.d(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.m(0, 4);
                this.d(0, 4);
                this.m(3, 3);
                this.d(12, 12);
                return;
            }
            case 9: {
                this.xOffset = x + 2;
                this.yOffset = y + 1;
                this.m(0, 13);
                this.d(3, 13);
                this.m(1, 12);
                this.d(7, 0);
                this.d(12, 13);
                this.m(11, 13);
                this.d(14, 13);
                this.m(3, 8);
                this.d(10, 8);
                return;
            }
            case 11: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                return;
            }
            case 12: {
                this.xOffset = x + 1;
                this.yOffset = y + 1;
                this.m(5, 14);
                this.d(2, 11);
                this.d(2, 10);
                this.d(0, 8);
                this.d(0, 7);
                this.d(1, 6);
                this.d(2, 6);
                this.d(4, 8);
                this.d(4, 6);
                this.d(3, 5);
                this.d(3, 4);
                this.d(2, 3);
                this.d(2, 2);
                this.d(3, 1);
                this.d(4, 1);
                this.d(5, 2);
                this.d(5, 3);
                this.m(6, 5);
                this.d(6, 1);
                this.d(7, 0);
                this.d(8, 0);
                this.d(9, 1);
                this.d(9, 5);
                this.m(9, 1);
                this.d(11, 1);
                this.d(12, 2);
                this.d(12, 6);
                this.m(13, 4);
                this.d(14, 3);
                this.d(15, 4);
                this.d(15, 7);
                this.d(14, 8);
                this.d(14, 10);
                this.d(13, 11);
                this.d(13, 12);
                this.d(12, 13);
                this.d(12, 14);
                return;
            }
            case 13: {
                this.xOffset = x;
                this.yOffset = y;
                g.setColor(foregroundColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.m(10, 7);
                this.d(12, 7);
                this.d(12, 9);
                this.m(8, 7);
                this.d(2, 13);
                this.d(2, 15);
                this.d(4, 15);
                this.d(11, 8);
                g.setColor(backgroundColor);
                this.m(0, 0);
                this.d(16, 0);
                this.d(16, 16);
                this.d(0, 16);
                this.d(0, 0);
                g.setColor(Color.black);
                return;
            }
        }
    }

    private void showMessage(int tool) {
        switch (tool) {
            case 0: {
                IJ.showStatus("Rectangular selections");
                return;
            }
            case 1: {
                IJ.showStatus("Oval selections");
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                IJ.showStatus("Straight line selections");
                return;
            }
            case 5: {
                IJ.showStatus("Segmented line selections");
                return;
            }
            case 6: {
                IJ.showStatus("Freehand line selections");
                return;
            }
            case 7: {
                IJ.showStatus("Crosshair (mark and count) tool");
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool");
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool");
                return;
            }
            case 13: {
                IJ.showStatus("Color picker (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")");
                return;
            }
            case 10: {
                if (this.spareTip != null) {
                    IJ.showStatus(this.spareTip);
                }
                return;
            }
        }
        IJ.showStatus("");
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void d(int x, int y) {
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void resetButtons() {
        int i = 0;
        while (i < 20) {
            this.down[i] = false;
            ++i;
        }
    }

    public void paint(Graphics g) {
        this.drawButtons(g);
    }

    public void setTool(int tool) {
        if (tool == current || tool < 0 || tool > 13 || tool == 10 && this.spareTip == null) {
            return;
        }
        current = tool;
        this.down[Toolbar.current] = true;
        this.down[this.previous] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, this.previous);
        this.drawButton(g, current);
        g.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record) {
            Recorder.record("setTool", current);
        }
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color c2) {
        foregroundColor = c2;
        this.drawButton(this.getGraphics(), 13);
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color c2) {
        foregroundColor = c2;
        Toolbar.updateColors();
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color c2) {
        backgroundColor = c2;
        Toolbar.updateColors();
    }

    static void updateColors() {
        Toolbar tb = Toolbar.getInstance();
        Graphics g = tb.getGraphics();
        tb.drawButton(g, 13);
        tb.drawButton(g, 7);
        g.dispose();
    }

    public void mousePressed(MouseEvent e2) {
        int x = e2.getX();
        int newTool = 0;
        int i = 0;
        while (i < 20) {
            if (x > i * 22 && x < i * 22 + 22) {
                newTool = i;
            }
            ++i;
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 500L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            this.mpPrevious = current;
            this.setTool(newTool);
        } else {
            ImagePlus imp = WindowManager.getCurrentImage();
            switch (current) {
                case 3: {
                    IJ.doCommand("Set Measurements...");
                    this.setTool(this.mpPrevious);
                    break;
                }
                case 11: {
                    if (imp == null) break;
                    imp.getWindow().getCanvas().unzoom();
                    break;
                }
                case 2: {
                    if (imp != null) {
                        IJ.doCommand("Calibrate...");
                    }
                    this.setTool(this.mpPrevious);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    IJ.doCommand("Line Width...");
                    break;
                }
                case 7: {
                    IJ.doCommand("Crosshair...");
                    break;
                }
                case 9: {
                    IJ.doCommand("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Colors...");
                    this.setTool(this.mpPrevious);
                    break;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void selectTool(int key) {
        switch (key) {
            case 112: {
                this.setTool(0);
                break;
            }
            case 113: {
                this.setTool(1);
                break;
            }
            case 114: {
                this.setTool(2);
                break;
            }
            case 115: {
                this.setTool(3);
                break;
            }
            case 116: {
                this.setTool(4);
                break;
            }
            case 117: {
                this.setTool(5);
                break;
            }
            case 118: {
                this.setTool(6);
                break;
            }
            case 119: {
                this.setTool(7);
                break;
            }
            case 120: {
                this.setTool(8);
                break;
            }
            case 121: {
                this.setTool(9);
                break;
            }
            case 122: {
                this.setTool(11);
                break;
            }
            case 123: {
                this.setTool(12);
                break;
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    public int addTool(String toolTip) {
        this.spareTip = toolTip;
        return 10;
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
    }
}

