/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.gui.GUI;
import ij.plugin.frame.Recorder;
import java.awt.FileDialog;
import java.awt.Frame;

public class OpenDialog {
    private String dir;
    private String name;
    private static String defaultDirectory;
    static /* synthetic */ Class class$ij$io$OpenDialog;

    public OpenDialog(String title, String path) {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            path = Macro.getValue(macroOptions, "path", path);
        }
        if (path == null || path.equals("")) {
            ImageJ ij = IJ.getInstance();
            Frame parent = ij != null ? ij : new Frame();
            FileDialog fd = new FileDialog(parent, title);
            defaultDirectory = OpenDialog.getDefaultDirectory();
            if (defaultDirectory != null) {
                fd.setDirectory(defaultDirectory);
            }
            GUI.center(fd);
            fd.show();
            this.name = fd.getFile();
            if (this.name == null) {
                Macro.abort();
            } else {
                defaultDirectory = this.dir = fd.getDirectory();
            }
            fd.dispose();
            if (ij == null) {
                parent.dispose();
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                this.dir = path.substring(0, i + 1);
                this.name = path.substring(i + 1);
            } else {
                this.dir = "";
                this.name = path;
            }
        }
        IJ.register(class$ij$io$OpenDialog == null ? (class$ij$io$OpenDialog = OpenDialog.class$("ij.io.OpenDialog")) : class$ij$io$OpenDialog);
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.dir + this.name);
        }
        return this.name;
    }

    public static String getDefaultDirectory() {
        if (defaultDirectory == null) {
            defaultDirectory = Prefs.getString("dir.image");
        }
        return defaultDirectory;
    }

    static void setDefaultDirectory(String defaultDir) {
        defaultDirectory = defaultDir;
        IJ.register(class$ij$io$OpenDialog == null ? (class$ij$io$OpenDialog = OpenDialog.class$("ij.io.OpenDialog")) : class$ij$io$OpenDialog);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

