/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class GelAnalyzer
implements PlugIn {
    static int saveID;
    static int nLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] x;
    static PlotsCanvas plotsCanvas;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    static boolean outlineLanes;
    static ImageProcessor ipCopy;
    boolean invertedLut;
    ImagePlus imp;
    Font f;
    FontMetrics fm;
    static boolean isVertical;
    static /* synthetic */ Class class$ij$plugin$GelAnalyzer;

    public void run(String arg) {
        Roi roi;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("reset")) {
            nLanes = 0;
            saveID = this.imp.getID();
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            if (ipCopy != null && this.imp.getID() == saveID) {
                this.imp.setProcessor(null, ipCopy);
            }
            ipCopy = null;
            return;
        }
        if (arg.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (arg.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (arg.equals("options")) {
            GenericDialog gd = new GenericDialog("Gel Analyzer Options...");
            gd.addCheckbox("Uncalibrated OD", uncalibratedOD);
            gd.addCheckbox("Label with Percentages", labelWithPercentages);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            uncalibratedOD = gd.getNextBoolean();
            labelWithPercentages = gd.getNextBoolean();
            return;
        }
        if (this.imp.getID() != saveID) {
            nLanes = 0;
            ipCopy = null;
            saveID = this.imp.getID();
        }
        if ((roi = this.imp.getRoi()) != null && arg.equals("perimeter")) {
            IJ.write("Perimeter: " + roi.getLength());
            return;
        }
        if (this.imp.getType() != 0 && uncalibratedOD) {
            this.show("The \"Uncalibrated OD\" option requires an 8-bit grayscale image.");
            return;
        }
        if (roi == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        this.invertedLut = this.imp.isInvertedLut();
        Rectangle rect = roi.getBoundingRect();
        if (nLanes == 0) {
            IJ.register(class$ij$plugin$GelAnalyzer == null ? (class$ij$plugin$GelAnalyzer = GelAnalyzer.class$("ij.plugin.GelAnalyzer")) : class$ij$plugin$GelAnalyzer);
        }
        if (arg.equals("first")) {
            this.selectFirstLane(rect);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (arg.equals("next")) {
            this.selectNextLane(rect);
            return;
        }
        if (arg.equals("plot")) {
            if (isVertical && rect.x != x[nLanes] || !isVertical && rect.y != x[nLanes]) {
                this.selectNextLane(rect);
            }
            this.plotLanes(this.imp);
            return;
        }
    }

    void selectFirstLane(Rectangle rect) {
        isVertical = rect.height > rect.width;
        if (isVertical && rect.height / rect.width < 2 || !isVertical && rect.width / rect.height < 2) {
            GenericDialog gd = new GenericDialog("Lane Orientation");
            String[] orientations = new String[]{"Vertical", "Horizontal"};
            int defaultOrientation = isVertical ? 0 : 1;
            gd.addChoice("Lane Orientation:", orientations, orientations[defaultOrientation]);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            String orientation = gd.getNextChoice();
            isVertical = orientation.equals(orientations[0]);
        }
        IJ.showStatus("Lane 1 selected");
        if (nLanes != 0 && ipCopy != null) {
            this.imp.setProcessor(null, ipCopy);
        }
        firstRect = rect;
        nLanes = 1;
        GelAnalyzer.x[1] = isVertical ? rect.x : rect.y;
        this.outlineLane(x[1]);
    }

    void selectNextLane(Rectangle rect) {
        if (rect.width != GelAnalyzer.firstRect.width || rect.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.x[GelAnalyzer.nLanes] = isVertical ? rect.x : rect.y;
        this.outlineLane(x[nLanes]);
    }

    void outlineLane(int x) {
        if (!outlineLanes) {
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        int lineWidth = (int)(1.0 / this.imp.getWindow().getCanvas().getMagnification());
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        ip.setLineWidth(lineWidth);
        if (nLanes == 1) {
            this.f = new Font("Helvetica", 0, 12 * lineWidth);
            ipCopy = ip.duplicate();
            ip.setColor(Toolbar.getForegroundColor());
            ip.setFont(this.f);
        }
        if (isVertical) {
            ip.drawRect(x, GelAnalyzer.firstRect.y, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        } else {
            ip.drawRect(GelAnalyzer.firstRect.x, x, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        }
        String s = "" + nLanes;
        if (isVertical) {
            ip.drawString(s, x + GelAnalyzer.firstRect.width / 2 - ip.getStringWidth(s) / 2, GelAnalyzer.firstRect.y);
        } else {
            ip.drawString(s, GelAnalyzer.firstRect.x - ip.getStringWidth(s) - 2, x + GelAnalyzer.firstRect.height / 2 + 6);
        }
        this.imp.updateAndDraw();
    }

    double od(double v) {
        if (this.invertedLut) {
            if (v == 255.0) {
                v = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - v));
        }
        if (v == 0.0) {
            v = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / v);
    }

    void plotLanes(ImagePlus imp) {
        int plotHeight;
        if (ipCopy != null) {
            ImageProcessor outlinedLanes = imp.getProcessor();
            imp.setProcessor(null, ipCopy);
            ipCopy = null;
            ImagePlus lanes = new ImagePlus("Lanes of " + imp.getShortTitle(), outlinedLanes);
            lanes.changes = true;
            lanes.show();
        }
        Calibration cal = imp.getCalibration();
        if (uncalibratedOD) {
            cal.setFunction(21, null, "Uncalibrated OD");
        } else if (cal.getFunction() == 21) {
            cal.setFunction(20, null, "Gray Value");
        }
        int topMargin = 16;
        int bottomMargin = 2;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[][] profiles = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        ImageProcessor ipRotated = imp.getProcessor();
        if (isVertical) {
            ipRotated = ipRotated.rotateLeft();
        }
        ImagePlus imp2 = new ImagePlus("", ipRotated);
        int i = 1;
        while (i <= nLanes) {
            if (isVertical) {
                imp2.setRoi(GelAnalyzer.firstRect.y, ipRotated.getHeight() - x[i] - GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height, GelAnalyzer.firstRect.width);
            } else {
                imp2.setRoi(GelAnalyzer.firstRect.x, x[i], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            }
            ProfilePlot pp = new ProfilePlot(imp2);
            profiles[i] = pp.getProfile();
            if (pp.getMin() < min) {
                min = pp.getMin();
            }
            if (pp.getMax() > max) {
                max = pp.getMax();
            }
            ++i;
        }
        int plotWidth = isVertical ? GelAnalyzer.firstRect.height : GelAnalyzer.firstRect.width;
        if (plotWidth < 500) {
            plotWidth = 500;
        }
        if (isVertical) {
            if (plotWidth > 2 * GelAnalyzer.firstRect.height) {
                plotWidth = 2 * GelAnalyzer.firstRect.height;
            }
        } else if (plotWidth > 2 * GelAnalyzer.firstRect.width) {
            plotWidth = 2 * GelAnalyzer.firstRect.width;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (plotWidth > screen.width - 40) {
            plotWidth = screen.width - 40;
        }
        if ((plotHeight = plotWidth / 2) < 200) {
            plotHeight = 200;
        }
        if (plotHeight > 400) {
            plotHeight = 400;
        }
        ByteProcessor ip = new ByteProcessor(plotWidth, topMargin + nLanes * plotHeight + bottomMargin);
        ((ImageProcessor)ip).setColor(Color.white);
        ip.fill();
        ((ImageProcessor)ip).setColor(Color.black);
        int h = ip.getHeight();
        ip.moveTo(0, 0);
        ip.lineTo(plotWidth - 1, 0);
        ip.lineTo(plotWidth - 1, h - 1);
        ip.lineTo(0, h - 1);
        ip.lineTo(0, 0);
        ip.moveTo(0, h - 2);
        ip.lineTo(plotWidth - 1, h - 2);
        String s = imp.getTitle() + "; ";
        s = cal.calibrated() ? s + cal.getValueUnit() : s + "**Uncalibrated**";
        ip.moveTo(5, topMargin);
        ip.drawString(s);
        double xScale = (double)plotWidth / (double)profiles[1].length;
        double yScale = max - min == 0.0 ? 1.0 : (double)plotHeight / (max - min);
        int i2 = 1;
        while (i2 <= nLanes) {
            double[] profile = profiles[i2];
            int top = (i2 - 1) * plotHeight + topMargin;
            int base = top + plotHeight;
            ip.moveTo(0, base);
            ip.lineTo((int)((double)profile.length * xScale), base);
            ip.moveTo(0, base - (int)((profile[0] - min) * yScale));
            int j = 1;
            while (j < profile.length) {
                ip.lineTo((int)((double)j * xScale + 0.5), base - (int)((profile[j] - min) * yScale + 0.5));
                ++j;
            }
            ++i2;
        }
        Plots plots = new Plots();
        plots.setProcessor("Plots of " + imp.getShortTitle(), ip);
        plots.changes = true;
        ip.setThreshold(0.0, 0.0, 2);
        ((ImagePlus)plots).show();
        nLanes = 0;
        saveID = 0;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow win = WindowManager.getCurrentWindow();
        ImageCanvas canvas = win.getCanvas();
        plotsCanvas = canvas instanceof PlotsCanvas ? (PlotsCanvas)canvas : null;
    }

    void show(String msg) {
        IJ.showMessage("Gel Analyzer", msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nLanes = 0;
        x = new int[101];
        uncalibratedOD = true;
        labelWithPercentages = true;
        outlineLanes = true;
    }
}

