/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.io.JpegEncoder;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;

public class Options
implements PlugIn {
    static /* synthetic */ Class class$ij$plugin$Options;

    public void run(String arg) {
        IJ.register(class$ij$plugin$Options == null ? (class$ij$plugin$Options = Options.class$("ij.plugin.Options")) : class$ij$plugin$Options);
        if (arg.equals("misc")) {
            Float f;
            GenericDialog gd = new GenericDialog("Miscellaneous Options", IJ.getInstance());
            gd.addNumericField("Real Histogram Bins:", HistogramWindow.nBins, 0);
            gd.addStringField("Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue, 10);
            gd.addCheckbox("Use Pointer Cursor", ImageCanvas.usePointer);
            gd.addCheckbox("Scale When Converting", ImageConverter.getDoScaling());
            gd.addCheckbox("Hide \"Process Stack?\" Dialog", IJ.hideProcessStackDialog);
            gd.addCheckbox("Antialiased Text", Prefs.antialiasedText);
            gd.addCheckbox("Interpolate Images <100%", Prefs.interpolateScaledImages);
            gd.addCheckbox("Debug Mode", IJ.debugMode);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int nBins = (int)gd.getNextNumber();
            if (nBins >= 2 && nBins <= 1000) {
                HistogramWindow.nBins = nBins;
            }
            String divValue = gd.getNextString();
            try {
                f = new Float(divValue);
            }
            catch (NumberFormatException e2) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            ImageCanvas.usePointer = gd.getNextBoolean();
            ImageConverter.setDoScaling(gd.getNextBoolean());
            IJ.hideProcessStackDialog = gd.getNextBoolean();
            Prefs.antialiasedText = gd.getNextBoolean();
            boolean interpolate = gd.getNextBoolean();
            IJ.debugMode = gd.getNextBoolean();
            if (interpolate != Prefs.interpolateScaledImages) {
                Prefs.interpolateScaledImages = interpolate;
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    imp.draw();
                }
            }
            return;
        }
        if (arg.equals("width")) {
            int width = (int)IJ.getNumber("Line Width:", Line.getWidth());
            if (width == Integer.MIN_VALUE) {
                return;
            }
            Line.setWidth(width);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && imp.isProcessor()) {
                ImageProcessor ip = imp.getProcessor();
                ip.setLineWidth(Line.getWidth());
            }
            return;
        }
        if (arg.equals("quality")) {
            int quality = (int)IJ.getNumber("JPEG quality (0-100):", JpegEncoder.getQuality());
            if (quality == Integer.MIN_VALUE) {
                return;
            }
            JpegEncoder.setQuality(quality);
            return;
        }
        if (arg.equals("calc")) {
            Float f;
            String value = IJ.getString("Real Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue);
            if (value.equals("")) {
                return;
            }
            try {
                f = new Float(value);
            }
            catch (NumberFormatException e3) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            return;
        }
        if (arg.equals("cross")) {
            int width = (int)IJ.getNumber("Mark Width:", Analyzer.markWidth);
            if (width == Integer.MIN_VALUE) {
                return;
            }
            Analyzer.markWidth = width;
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

