/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.SaveChangesDialog;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 512, 2048, 256, 1024, 4096};
    private static final int UNDEFINED = 0;
    private static final int AREAS = 1;
    private static final int LENGTHS = 2;
    private static final int ANGLES = 3;
    private static final int MARK_AND_COUNT = 4;
    private static int mode = 0;
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    static /* synthetic */ Class class$ij$plugin$filter$Analyzer;

    public Analyzer() {
        this.rt = systemRT;
        this.rt.setPrecision(precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imp) {
        this();
        this.imp = imp;
    }

    public Analyzer(ImagePlus imp, int measurements, ResultsTable rt) {
        this.imp = imp;
        this.measurements = measurements;
        this.rt = rt;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Analyzer == null ? (class$ij$plugin$filter$Analyzer = Analyzer.class$("ij.plugin.filter.Analyzer")) : class$ij$plugin$filter$Analyzer);
        if (arg.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (arg.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (arg.equals("clear")) {
            this.clearWorksheet();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.measure();
    }

    void doSetDialog() {
        GenericDialog gd = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] labels = new String[10];
        boolean[] states = new boolean[10];
        labels[0] = "Area";
        states[0] = (systemMeasurements & 1) != 0;
        labels[1] = "Mean Gray Value";
        states[1] = (systemMeasurements & 2) != 0;
        labels[2] = "Standard Deviation";
        states[2] = (systemMeasurements & 4) != 0;
        labels[3] = "Modal Gray Value";
        states[3] = (systemMeasurements & 8) != 0;
        labels[4] = "Min & Max Gray Value";
        states[4] = (systemMeasurements & 0x10) != 0;
        labels[5] = "Centroid";
        states[5] = (systemMeasurements & 0x20) != 0;
        labels[6] = "Center of Mass";
        states[6] = (systemMeasurements & 0x40) != 0;
        labels[7] = "Perimeter";
        states[7] = (systemMeasurements & 0x80) != 0;
        labels[8] = "Bounding Rectangle";
        states[8] = (systemMeasurements & 0x200) != 0;
        labels[9] = "Fit Ellipse";
        states[9] = (systemMeasurements & 0x800) != 0;
        gd.addCheckboxGroup(5, 2, labels, states);
        labels = new String[3];
        states = new boolean[3];
        labels[0] = "Limit to Threshold";
        states[0] = (systemMeasurements & 0x100) != 0;
        labels[1] = "Display Image Name";
        states[1] = (systemMeasurements & 0x400) != 0;
        labels[2] = "Invert Y Coordinates";
        states[2] = (systemMeasurements & 0x1000) != 0;
        gd.addCheckboxGroup(2, 2, labels, states);
        gd.addMessage("");
        gd.addNumericField("Decimal Places:", precision, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.setOptions(gd);
        int prec = (int)gd.getNextNumber();
        if (prec >= 0 && prec <= 8 && prec != precision) {
            precision = prec;
            this.rt.setPrecision(precision);
            if (mode == 1) {
                IJ.setColumnHeadings("");
                this.updateHeadings();
            }
        }
    }

    void clearWorksheet() {
        Analyzer.resetCounter();
    }

    void setOptions(GenericDialog gd) {
        int oldMeasurements = systemMeasurements;
        int previous = 0;
        boolean b2 = false;
        int i = 0;
        while (i < list.length) {
            b2 = gd.getNextBoolean();
            previous = list[i];
            systemMeasurements = b2 ? (systemMeasurements |= list[i]) : (systemMeasurements &= ~list[i]);
            ++i;
        }
        if ((oldMeasurements & 0xFFFFFEFF) != (systemMeasurements & 0xFFFFFEFF)) {
            mode = 0;
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    void measure() {
        if (Toolbar.getToolId() == 7) {
            this.markAndCount();
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() >= 5) {
            this.measureLength(roi);
            return;
        }
        if (mode != 1) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 1;
        }
        ImageStatistics stats = this.imp.getStatistics(this.measurements);
        this.saveResults(stats, this.imp.getRoi());
        this.displayResults();
    }

    void markAndCount() {
        if (this.imp.getTitle().equals("Colors")) {
            return;
        }
        int x = -1;
        int y = -1;
        ImageWindow win = this.imp.getWindow();
        if (win != null) {
            Point p = win.getCanvas().getCursorLoc();
            x = p.x;
            y = p.y;
        }
        if (x < 0) {
            return;
        }
        this.imp.killRoi();
        if (mode != 4) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 4;
        }
        this.incrementCounter();
        ImageProcessor ip = this.imp.getProcessor();
        Calibration cal = this.imp.getCalibration();
        ip.setCalibrationTable(cal.getCTable());
        double value = ip.getPixelValue(x, y);
        if (markWidth > 0) {
            ip.setColor(Toolbar.getForegroundColor());
            ip.setLineWidth(markWidth);
            ip.moveTo(x, y);
            ip.lineTo(x, y);
            this.imp.updateAndDraw();
            ip.setLineWidth(Line.getWidth());
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Name", this.getFileName());
        }
        this.rt.addValue("X", cal.getX(x));
        this.rt.addValue("Y", cal.getY(Analyzer.updateY(y, this.imp.getHeight())));
        this.rt.addValue("Value", value);
        this.displayResults();
    }

    void measureAngle(Roi roi) {
        if (mode != 3) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setColumnHeadings(" \tangle");
            mode = 3;
        }
        this.incrementCounter();
        IJ.write(this.rt.getCounter() + "\t" + this.n(((PolygonRoi)roi).getAngle()));
    }

    void measureLength(Roi roi) {
        if (mode != 2) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            if ((this.measurements & 0x400) != 0) {
                IJ.setColumnHeadings(" \tName\tlength");
            } else {
                IJ.setColumnHeadings(" \tlength");
            }
            mode = 2;
        }
        this.incrementCounter();
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Name", this.getFileName());
        }
        this.rt.addValue("Length", roi.getLength());
        this.displayResults();
    }

    public void saveResults(ImageStatistics stats, Roi roi) {
        this.incrementCounter();
        int counter = this.rt.getCounter();
        if (counter <= 20) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[counter - 1] = (float)stats.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Name", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, stats.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, stats.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, stats.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, stats.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            this.rt.addValue(4, stats.min);
            this.rt.addValue(5, stats.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, stats.xCentroid);
            this.rt.addValue(7, this.updateY(stats.yCentroid));
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, stats.xCenterOfMass);
            this.rt.addValue(9, this.updateY(stats.yCenterOfMass));
        }
        if ((this.measurements & 0x80) != 0) {
            double perimeter = roi != null ? roi.getLength() : 0.0;
            this.rt.addValue(10, perimeter);
        }
        if ((this.measurements & 0x200) != 0) {
            this.rt.addValue(11, stats.roiX);
            this.rt.addValue(12, this.updateY2(stats.roiY));
            this.rt.addValue(13, stats.roiWidth);
            this.rt.addValue(14, stats.roiHeight);
        }
        if ((this.measurements & 0x800) != 0) {
            this.rt.addValue(15, stats.major);
            this.rt.addValue(16, stats.minor);
            this.rt.addValue(17, stats.angle);
        }
    }

    double updateY(double y) {
        if (this.imp == null) {
            return y;
        }
        if ((systemMeasurements & 0x1000) != 0) {
            Calibration cal = this.imp.getCalibration();
            y = (double)this.imp.getHeight() * cal.pixelHeight - y;
        }
        return y;
    }

    double updateY2(double y) {
        if (this.imp == null) {
            return y;
        }
        if ((systemMeasurements & 0x1000) != 0) {
            Calibration cal = this.imp.getCalibration();
            y = (double)this.imp.getHeight() * cal.pixelHeight - y - cal.pixelHeight;
        }
        return y;
    }

    String getFileName() {
        String s = "";
        if (this.imp != null) {
            s = this.imp.getTitle();
            if (this.imp.getStackSize() > 1) {
                ImageStack stack = this.imp.getStack();
                int currentSlice = this.imp.getCurrentSlice();
                String label = stack.getSliceLabel(currentSlice);
                String colon = s.equals("") ? "" : ":";
                s = label != null && !label.equals("") ? s + colon + label : s + colon + currentSlice;
            }
        }
        return s;
    }

    public void displayResults() {
        int counter = this.rt.getCounter();
        if (counter == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write(this.rt.getRowAsString(counter - 1));
    }

    public void updateHeadings() {
        String tableHeadings;
        TextPanel tp = IJ.getTextPanel();
        if (tp == null) {
            return;
        }
        String worksheetHeadings = tp.getColumnHeadings();
        if (worksheetHeadings.equals(tableHeadings = this.rt.getColumnHeadings())) {
            return;
        }
        IJ.setColumnHeadings(tableHeadings);
        int n = this.rt.getCounter();
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            int i = 0;
            while (i < n) {
                sb.append(this.rt.getRowAsString(i) + "\n");
                ++i;
            }
            tp.append(new String(sb));
        }
    }

    public String n(double n) {
        String s = (double)Math.round(n) == n ? IJ.d2s(n, 0) : IJ.d2s(n, precision);
        return s + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        String worksheetHeadings;
        this.rt = systemRT;
        if (this.rt.getCounter() == 0) {
            return;
        }
        this.measurements = systemMeasurements;
        this.min = new StringBuffer(100);
        this.max = new StringBuffer(100);
        this.mean = new StringBuffer(100);
        this.sd = new StringBuffer(100);
        this.min.append("Min\t");
        this.max.append("Max\t");
        this.mean.append("Mean\t");
        this.sd.append("SD\t");
        if ((this.measurements & 0x400) != 0) {
            this.min.append("\t");
            this.max.append("\t");
            this.mean.append("\t");
            this.sd.append("\t");
        }
        if (mode == 4) {
            this.summarizePoints(this.rt);
        } else if (mode == 2) {
            this.add2(this.rt.getColumnIndex("Length"));
        } else {
            this.summarizeAreas();
        }
        TextPanel tp = IJ.getTextPanel();
        if (tp != null && (worksheetHeadings = tp.getColumnHeadings()).equals("")) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write("");
        IJ.write(new String(this.mean));
        IJ.write(new String(this.sd));
        IJ.write(new String(this.min));
        IJ.write(new String(this.max));
        IJ.write("");
        this.mean = null;
        this.sd = null;
        this.min = null;
        this.max = null;
    }

    void summarizePoints(ResultsTable rt) {
        this.add2(rt.getColumnIndex("X"));
        this.add2(rt.getColumnIndex("Y"));
        this.add2(rt.getColumnIndex("Value"));
    }

    void summarizeAreas() {
        if ((this.measurements & 1) != 0) {
            this.add2(0);
        }
        if ((this.measurements & 2) != 0) {
            this.add2(1);
        }
        if ((this.measurements & 4) != 0) {
            this.add2(2);
        }
        if ((this.measurements & 8) != 0) {
            this.add2(3);
        }
        if ((this.measurements & 0x10) != 0) {
            this.add2(4);
            this.add2(5);
        }
        if ((this.measurements & 0x20) != 0) {
            this.add2(6);
            this.add2(7);
        }
        if ((this.measurements & 0x40) != 0) {
            this.add2(8);
            this.add2(9);
        }
        if ((this.measurements & 0x80) != 0) {
            this.add2(10);
        }
        if ((this.measurements & 0x200) != 0) {
            this.add2(11);
            this.add2(12);
            this.add2(13);
            this.add2(14);
        }
        if ((this.measurements & 0x800) != 0) {
            this.add2(15);
            this.add2(16);
            this.add2(17);
        }
    }

    private void add2(int column) {
        float[] c2;
        float[] fArray = c2 = column >= 0 ? this.rt.getColumn(column) : null;
        if (c2 != null) {
            FloatProcessor ip = new FloatProcessor(c2.length, 1, c2, null);
            if (ip == null) {
                return;
            }
            FloatStatistics stats = new FloatStatistics(ip);
            if (stats == null) {
                return;
            }
            this.mean.append(this.n(stats.mean));
            this.min.append(this.n(stats.min));
            this.max.append(this.n(stats.max));
            this.sd.append(this.n(stats.stdDev));
        } else {
            this.mean.append("-\t");
            this.min.append("-\t");
            this.max.append("-\t");
            this.sd.append("-\t");
        }
    }

    public static int getCounter() {
        return systemRT.getCounter();
    }

    public static synchronized boolean resetCounter() {
        int lineCount;
        TextPanel tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int counter = systemRT.getCounter();
        int n = lineCount = tp != null ? IJ.getTextPanel().getLineCount() : 0;
        if (counter > 0 && lineCount > 0 && unsavedMeasurements && !IJ.macroRunning()) {
            SaveChangesDialog d2 = new SaveChangesDialog((Frame)IJ.getInstance(), "Save " + counter + " measurements?");
            if (d2.cancelPressed()) {
                return false;
            }
            if (d2.savePressed()) {
                new MeasurementsWriter().run("");
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        if (tp != null) {
            tp.selectAll();
            tp.clearSelection();
        }
        return true;
    }

    public static void setSaved() {
        unsavedMeasurements = false;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int measurements) {
        systemMeasurements = measurements;
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(MEASUREMENTS, Integer.toString(systemMeasurements));
        prefs.put(MARK_WIDTH, Integer.toString(markWidth));
        prefs.put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    public static int updateY(int y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = imageHeight - y - 1;
        }
        return y;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        markWidth = Prefs.getInt(MARK_WIDTH, 3);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
    }
}

