/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Equalizer
implements PlugInFilter {
    ImagePlus imp;
    int[] histogram;
    int max;
    int range;
    boolean classicEqualization = IJ.altKeyDown();

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            return 4096;
        }
        this.imp = imp;
        ImageProcessor ip = imp.getProcessor();
        this.histogram = ip.getHistogram();
        imp.killRoi();
        if (arg.equals("classic")) {
            this.classicEqualization = true;
        }
        return IJ.setupDialog(imp, 21);
    }

    private double getWeightedValue(int i) {
        int h = this.histogram[i];
        if (h < 2 || this.classicEqualization) {
            return h;
        }
        return Math.sqrt(h);
    }

    public void run(ImageProcessor ip) {
        if (this.histogram == null) {
            return;
        }
        if (ip instanceof ShortProcessor) {
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double sum = this.getWeightedValue(0);
        int i = 1;
        while (i < this.max) {
            sum += 2.0 * this.getWeightedValue(i);
            ++i;
        }
        double scale = (double)this.range / (sum += this.getWeightedValue(this.max));
        int[] lut = new int[this.range + 1];
        lut[0] = 0;
        sum = this.getWeightedValue(0);
        int i2 = 1;
        while (i2 < this.max) {
            double delta = this.getWeightedValue(i2);
            lut[i2] = (int)Math.round((sum += delta) * scale);
            sum += delta;
            ++i2;
        }
        lut[this.max] = this.max;
        ip.applyTable(lut);
    }
}

