/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Filler
implements PlugInFilter {
    String arg;
    Roi roi;
    ImagePlus imp;
    int sliceCount;
    int[] mask;
    boolean isTextRoi;
    static /* synthetic */ Class class$ij$plugin$filter$Filler;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (imp != null) {
            this.roi = imp.getRoi();
        }
        this.isTextRoi = this.roi != null && this.roi instanceof TextRoi;
        IJ.register(class$ij$plugin$filter$Filler == null ? (class$ij$plugin$filter$Filler = Filler.class$("ij.plugin.filter.Filler")) : class$ij$plugin$filter$Filler);
        int baseCapabilities = 1055;
        if (arg.equals("clear")) {
            if (this.isTextRoi || this.isLineSelection()) {
                return baseCapabilities;
            }
            return IJ.setupDialog(imp, baseCapabilities + 64);
        }
        if (arg.equals("draw")) {
            return baseCapabilities;
        }
        if (arg.equals("outside")) {
            return IJ.setupDialog(imp, baseCapabilities);
        }
        return IJ.setupDialog(imp, baseCapabilities + 64);
    }

    public void run(ImageProcessor ip) {
        if (this.arg.equals("clear")) {
            this.clear(ip);
        } else if (this.isTextRoi && (this.arg.equals("draw") || this.arg.equals("fill"))) {
            this.draw(ip);
        } else if (this.arg.equals("fill")) {
            this.fill(ip);
        } else if (this.arg.equals("draw")) {
            this.draw(ip);
        } else if (this.arg.equals("outside")) {
            this.clearOutside(ip);
        }
    }

    boolean isLineSelection() {
        return this.roi != null && this.roi.getType() >= 5 && this.roi.getType() <= 7;
    }

    public void clear(ImageProcessor ip) {
        ip.setColor(Toolbar.getBackgroundColor());
        if (this.isLineSelection()) {
            this.roi.drawPixels();
        } else {
            ip.fill();
        }
        ip.setColor(Toolbar.getForegroundColor());
    }

    public void fill(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        if (this.isLineSelection()) {
            this.roi.drawPixels();
        } else {
            ip.fill();
        }
    }

    public void draw(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        this.roi.drawPixels();
    }

    public synchronized void clearOutside(ImageProcessor ip) {
        if (this.isLineSelection()) {
            IJ.error("\"Clear Outside\" does not work with line selections.");
            return;
        }
        ++this.sliceCount;
        Rectangle r = ip.getRoi();
        if (this.mask == null) {
            this.makeMask(ip, r);
        }
        ip.setColor(Toolbar.getBackgroundColor());
        int stackSize = this.imp.getStackSize();
        if (stackSize > 1) {
            ip.snapshot();
        }
        ip.fill();
        ip.reset(this.mask);
        int width = ip.getWidth();
        int height = ip.getHeight();
        ip.setRoi(0, 0, r.x, height);
        ip.fill();
        ip.setRoi(r.x, 0, r.width, r.y);
        ip.fill();
        ip.setRoi(r.x, r.y + r.height, r.width, height - (r.y + r.height));
        ip.fill();
        ip.setRoi(r.x + r.width, 0, width - (r.x + r.width), height);
        ip.fill();
        ip.setRoi(null);
        if (this.sliceCount == stackSize) {
            ip.setColor(Toolbar.getForegroundColor());
            Roi roi = this.imp.getRoi();
            this.imp.killRoi();
            this.imp.updateAndDraw();
            this.imp.setRoi(roi);
        }
    }

    public void makeMask(ImageProcessor ip, Rectangle r) {
        this.mask = this.imp.getMask();
        if (this.mask == null) {
            this.mask = new int[r.width * r.height];
            int i = 0;
            while (i < this.mask.length) {
                this.mask[i] = -16777216;
                ++i;
            }
        } else {
            int[] mask2 = new int[this.mask.length];
            int i = 0;
            while (i < this.mask.length) {
                mask2[i] = this.mask[i];
                ++i;
            }
            this.mask = mask2;
        }
        int i = 0;
        while (i < this.mask.length) {
            this.mask[i] = this.mask[i] == -16777216 ? -1 : -16777216;
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

