/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;

public class Resizer
implements PlugInFilter {
    ImagePlus imp;
    private boolean crop;
    private static int newWidth = 100;
    private static int newHeight = 100;
    private static boolean constrain = true;
    private static boolean interpolate = true;
    static /* synthetic */ Class class$ij$plugin$filter$Resizer;

    public int setup(String arg, ImagePlus imp) {
        this.crop = arg.equals("crop");
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Resizer == null ? (class$ij$plugin$filter$Resizer = Resizer.class$("ij.plugin.filter.Resizer")) : class$ij$plugin$filter$Resizer);
        if (this.crop) {
            return 1183;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() >= 5 && roi.getType() <= 7) {
            IJ.error("The Crop and Adjust->Size commands\ndo not work with line selections.");
            return;
        }
        boolean sizeToHeight = false;
        if (this.crop) {
            Rectangle bounds = roi.getBoundingRect();
            newWidth = bounds.width;
            newHeight = bounds.height;
        } else {
            GenericDialog gd = new GenericDialog("Resize", IJ.getInstance());
            gd.addNumericField("New width (pixels):", newWidth, 0);
            gd.addNumericField("New Height (pixels):", newHeight, 0);
            gd.addCheckbox("Constrain Aspect Ratio", constrain);
            gd.addCheckbox("Interpolate", interpolate);
            gd.addMessage("NOTE: Undo is not available");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            newWidth = (int)gd.getNextNumber();
            newHeight = (int)gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error("Width or height are invalid.");
                return;
            }
            constrain = gd.getNextBoolean();
            interpolate = gd.getNextBoolean();
            boolean bl = sizeToHeight = constrain && newWidth == 0;
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        Rectangle r = ip.getRoi();
        double oldWidth = r.width;
        double oldHeight = r.height;
        if (!this.crop && constrain) {
            if (sizeToHeight) {
                newWidth = (int)((double)newHeight * (oldWidth / oldHeight));
            } else {
                newHeight = (int)((double)newWidth * (oldHeight / oldWidth));
            }
        }
        ip.setInterpolate(interpolate);
        int nSlices = this.imp.getStackSize();
        try {
            StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
            ImageStack s2 = sp.resize(newWidth, newHeight);
            int newSize = s2.getSize();
            if (s2.getWidth() > 0 && newSize > 0) {
                boolean restoreRoi;
                boolean bl = restoreRoi = this.crop && roi != null && roi.getType() != 0;
                if (restoreRoi) {
                    this.imp.killRoi();
                }
                this.imp.hide();
                Calibration cal = this.imp.getCalibration();
                if (cal.scaled()) {
                    cal.pixelWidth *= oldWidth / (double)newWidth;
                    cal.pixelHeight *= oldHeight / (double)newHeight;
                    this.imp.setCalibration(cal);
                }
                this.imp.setStack(null, s2);
                this.imp.show();
                if (restoreRoi) {
                    this.imp.restoreRoi();
                }
            }
            if (nSlices > 1 && newSize < nSlices) {
                IJ.error("ImageJ ran out of memory causing \nthe last " + (nSlices - newSize) + " slices to be lost.");
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Resize");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

