/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ColorSelector
extends PlugInFrame
implements ItemListener {
    private static final int ROI = 0;
    private static final int FOREGROUND = 1;
    private static final int BACKGROUND = 2;
    private Choice color;
    private String[] colors = new String[]{"red", "green", "blue", "magenta     ", "cyan", "yellow", "orange", "black", "white"};
    private int mode = 0;

    public ColorSelector() {
        super("ROI Color");
    }

    public void run(String arg) {
        String name;
        Color c2;
        if (arg.equals("roi")) {
            this.setTitle("ROI Color");
            this.mode = 0;
        } else if (arg.equals("back")) {
            this.setTitle("Background Color");
            this.mode = 2;
        } else {
            this.setTitle("Foreground Color");
            this.mode = 1;
        }
        this.setLayout(new FlowLayout(1, 35, 5));
        this.color = new Choice();
        int i = 0;
        while (i < this.colors.length) {
            this.color.addItem(this.colors[i]);
            ++i;
        }
        switch (this.mode) {
            case 0: {
                c2 = Roi.getColor();
                name = "yellow";
                break;
            }
            case 2: {
                c2 = Toolbar.getBackgroundColor();
                name = "white";
                break;
            }
            default: {
                c2 = Toolbar.getForegroundColor();
                name = "black";
            }
        }
        if (c2.equals(Color.red)) {
            name = this.colors[0];
        } else if (c2.equals(Color.green)) {
            name = this.colors[1];
        } else if (c2.equals(Color.blue)) {
            name = this.colors[2];
        } else if (c2.equals(Color.magenta)) {
            name = this.colors[3];
        } else if (c2.equals(Color.cyan)) {
            name = this.colors[4];
        } else if (c2.equals(Color.yellow)) {
            name = this.colors[5];
        } else if (c2.equals(Color.orange)) {
            name = this.colors[6];
        } else if (c2.equals(Color.black)) {
            name = this.colors[7];
        } else if (c2.equals(Color.white)) {
            name = this.colors[8];
        }
        this.color.select(name);
        this.color.addItemListener(this);
        this.add(this.color);
        this.pack();
        Dimension size = this.getSize();
        if (size.width < 180) {
            this.setSize(180, size.height);
        }
        GUI.center(this);
        this.show();
    }

    public void itemStateChanged(ItemEvent e2) {
        String name = this.color.getSelectedItem();
        Color c2 = Color.yellow;
        if (name.equals(this.colors[0])) {
            c2 = Color.red;
        } else if (name.equals(this.colors[1])) {
            c2 = Color.green;
        } else if (name.equals(this.colors[2])) {
            c2 = Color.blue;
        } else if (name.equals(this.colors[3])) {
            c2 = Color.magenta;
        } else if (name.equals(this.colors[4])) {
            c2 = Color.cyan;
        } else if (name.equals(this.colors[5])) {
            c2 = Color.yellow;
        } else if (name.equals(this.colors[6])) {
            c2 = Color.orange;
        } else if (name.equals(this.colors[7])) {
            c2 = Color.black;
        } else if (name.equals(this.colors[8])) {
            c2 = Color.white;
        }
        switch (this.mode) {
            case 0: {
                Roi.setColor(c2);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp == null) break;
                imp.draw();
                break;
            }
            case 1: {
                Toolbar.setForegroundColor(c2);
                if (!Recorder.record) break;
                Recorder.record("setForegroundColor", c2.getRed(), c2.getGreen(), c2.getBlue());
                break;
            }
            case 2: {
                Toolbar.setBackgroundColor(c2);
                if (!Recorder.record) break;
                Recorder.record("setBackgroundColor", c2.getRed(), c2.getGreen(), c2.getBlue());
            }
        }
    }
}

