/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener {
    static final int AUTO_THRESHOLD = 5000;
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label brightnessLabel;
    Label contrastLabel;
    boolean done;
    int autoThreshold;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int BRIGHTNESS = 5;
    static final int CONTRAST = 6;
    static final int UPDATE = 7;
    static /* synthetic */ Class class$ij$plugin$frame$ContrastAdjuster;

    public ContrastAdjuster() {
        super("B&C");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(class$ij$plugin$frame$ContrastAdjuster == null ? (class$ij$plugin$frame$ContrastAdjuster = ContrastAdjuster.class$("ij.plugin.frame.ContrastAdjuster")) : class$ij$plugin$frame$ContrastAdjuster);
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        Font monoFont = new Font("Monospaced", 0, 12);
        Font sanFont = new Font("SansSerif", 0, 12);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        this.setLayout(gridbag);
        c2.gridx = 0;
        int y = 0;
        c2.gridy = y++;
        c2.fill = 1;
        c2.anchor = 10;
        c2.insets = new Insets(10, 10, 0, 10);
        gridbag.setConstraints(this.plot, c2);
        this.add(this.plot);
        this.panel = new Panel();
        c2.gridy = y++;
        c2.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c2);
        this.panel.setLayout(new BorderLayout());
        this.minLabel = new Label("      ", 0);
        this.minLabel.setFont(monoFont);
        this.panel.add("West", this.minLabel);
        this.maxLabel = new Label("      ", 2);
        this.maxLabel.setFont(monoFont);
        this.panel.add("East", this.maxLabel);
        this.add(this.panel);
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        c2.gridy = y++;
        c2.insets = new Insets(5, 10, 0, 10);
        gridbag.setConstraints(this.brightnessSlider, c2);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        this.panel = new Panel();
        c2.gridy = y++;
        c2.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c2);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        Label label = new Label("Brightness");
        label.setFont(sanFont);
        this.panel.add(label);
        this.brightnessLabel = new Label("", 0);
        this.brightnessLabel.setFont(monoFont);
        this.panel.add(this.brightnessLabel);
        this.add(this.panel);
        this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        c2.gridy = y++;
        c2.insets = new Insets(5, 10, 0, 10);
        gridbag.setConstraints(this.contrastSlider, c2);
        this.add(this.contrastSlider);
        this.contrastSlider.addAdjustmentListener(this);
        this.contrastSlider.setUnitIncrement(1);
        this.panel = new Panel();
        c2.gridy = y++;
        c2.insets = new Insets(0, 10, 0, 10);
        gridbag.setConstraints(this.panel, c2);
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        label = new Label("Contrast");
        label.setFont(sanFont);
        this.panel.add(label);
        this.contrastLabel = new Label("", 0);
        this.contrastLabel.setFont(monoFont);
        this.panel.add(this.contrastLabel);
        this.add(this.panel);
        int trim = IJ.isMacOSX() ? 20 : 0;
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(3, 2, 0, 0));
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton("Reset", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new TrimmedButton("Apply", trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.threshB = new TrimmedButton("Thresh", trim);
        this.threshB.addActionListener(this);
        this.threshB.addKeyListener(this.ij);
        this.panel.add(this.threshB);
        this.updateB = new TrimmedButton("Update", trim);
        this.updateB.addActionListener(this);
        this.updateB.addKeyListener(this.ij);
        this.panel.add(this.updateB);
        c2.gridy = y++;
        c2.insets = new Insets(10, 5, 10, 5);
        gridbag.setConstraints(this.panel, c2);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.show();
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void setup() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageProcessor ip = imp.getProcessor();
            this.setup(imp);
            this.updatePlot();
            this.updateLabels(imp, ip);
            imp.updateAndDraw();
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e2) {
        if (e2.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e2) {
        Button b2 = (Button)e2.getSource();
        if (b2 == null) {
            return;
        }
        if (b2 == this.resetB) {
            this.doReset = true;
        } else if (b2 == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b2 == this.setB) {
            this.doSet = true;
        } else if (b2 == this.applyB) {
            this.doApplyLut = true;
        } else if (b2 == this.threshB) {
            this.doThreshold = true;
        } else if (b2 == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean newIP;
        ImageProcessor ip = imp.getProcessor();
        int type = imp.getType();
        this.RGBImage = type == 4;
        boolean bl = newIP = !imp.isProcessor();
        if (imp.getID() != this.previousImageID || this.RGBImage && newIP || type != this.previousType) {
            this.setupNewImage(imp, ip);
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        return ip;
    }

    void setupNewImage(ImagePlus imp, ImageProcessor ip) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            ip.snapshot();
        }
        double min2 = ip.getMin();
        double max2 = ip.getMax();
        if (imp.getType() == 4) {
            min2 = 0.0;
            max2 = 255.0;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        ip.setMinAndMax(min2, max2);
        this.min = ip.getMin();
        this.max = ip.getMax();
        if (IJ.debugMode) {
            IJ.log("min: " + this.min);
            IJ.log("max: " + this.max);
            IJ.log("defaultMin: " + this.defaultMin);
            IJ.log("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        this.updateScrollBars();
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
        this.autoThreshold = 0;
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        boolean realValue;
        double min = ip.getMin();
        double max = ip.getMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            if (type != 1) {
                realValue = true;
            }
        }
        if (realValue) {
            this.minLabel.setText("" + IJ.d2s(min));
            this.maxLabel.setText("" + IJ.d2s(max));
        } else {
            this.minLabel.setText(IJ.d2s(min, 0));
            this.maxLabel.setText(IJ.d2s(max, 0));
        }
    }

    void updateScrollBars() {
        double mid = this.sliderRange / 2;
        double c2 = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
        if (c2 > mid) {
            c2 = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
        }
        this.contrast = (int)c2;
        this.contrastSlider.setValue(this.contrast);
        double level = this.min + (this.max - this.min) / 2.0;
        double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
        this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
        this.brightnessSlider.setValue(this.brightness);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        int[] mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        ip.setMinAndMax(this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        ip.setMinAndMax(this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        ip.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
        this.plotHistogram(imp);
        this.autoThreshold = 0;
        if (Recorder.record) {
            Recorder.record("resetMinAndMax");
        }
    }

    void update(ImagePlus imp, ImageProcessor ip) {
        if (this.previousMin == 0.0 && this.previousMax == 0.0 || imp.getType() != this.previousType) {
            IJ.beep();
        } else {
            this.min = this.previousMin;
            this.max = this.previousMax;
            ip.setMinAndMax(this.min, this.max);
            this.updateScrollBars();
            this.plotHistogram(imp);
        }
    }

    void plotHistogram(ImagePlus imp) {
        this.plot.setHistogram(imp.getStatistics());
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            imp.unlock();
        }
        if (!imp.lock()) {
            return;
        }
        if (imp.getType() == 4 && imp.getStackSize() > 1) {
            this.applyRGBStack(imp);
            imp.unlock();
            return;
        }
        if (imp.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            imp.unlock();
            return;
        }
        int[] table = new int[256];
        int min = (int)ip.getMin();
        int max = (int)ip.getMax();
        int i = 0;
        while (i < 256) {
            table[i] = i <= min ? 0 : (i >= max ? 255 : (int)((double)(i - min) / (double)(max - min) * 255.0));
            ++i;
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d2 = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + stack.getSize() + " slices in the stack?");
            if (d2.cancelPressed()) {
                imp.unlock();
                return;
            }
            if (d2.yesPressed()) {
                new StackProcessor(stack, ip).applyTable(table);
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
        this.reset(imp, ip);
        imp.changes = true;
        imp.unlock();
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        int i = 1;
        while (i <= n) {
            if (i != current) {
                imp.setSlice(i);
                ImageProcessor ip = imp.getProcessor();
                ip.setMinAndMax(this.min, this.max);
                IJ.showProgress((double)i / (double)n);
            }
            ++i;
        }
        imp.setSlice(current);
        imp.changes = true;
    }

    void threshold(ImagePlus imp, ImageProcessor ip) {
        int threshold = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = threshold;
        this.max = threshold;
        ip.setMinAndMax(this.min, this.max);
        this.setThreshold(ip);
        this.updateScrollBars();
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        int[] mask;
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i] > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = found = histogram[--i] > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax >= hmin) {
            imp.killRoi();
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        ip.setMinAndMax(this.min, this.max);
        this.updateScrollBars();
        Roi roi = imp.getRoi();
        if (roi != null && (mask = roi.getMask()) != null) {
            ip.reset(mask);
        }
    }

    void setMinAndMax(ImagePlus imp, ImageProcessor ip) {
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        GenericDialog gd = new GenericDialog("Set Min and Max");
        gd.addNumericField("Minimum Displayed Value: ", minValue, digits);
        gd.addNumericField("Maximum Displayed Value: ", maxValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        minValue = gd.getNextNumber();
        maxValue = gd.getNextNumber();
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            ip.setMinAndMax(this.min, this.max);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)this.min, (int)this.max);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doSet) {
            action = 2;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doThreshold) {
            action = 4;
        } else if (this.doUpdate) {
            action = 7;
        } else if (this.brightnessValue >= 0) {
            action = 5;
        } else if (this.contrastValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.brightnessValue = -1;
        this.contrastValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doSet = false;
        this.doApplyLut = false;
        this.doThreshold = false;
        this.doUpdate = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor ip = action != 7 ? this.setup(imp) : imp.getProcessor();
        if (this.RGBImage && !imp.lock()) {
            imp = null;
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                break;
            }
            case 1: {
                this.autoAdjust(imp, ip);
                break;
            }
            case 2: {
                this.setMinAndMax(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp, ip);
                break;
            }
            case 4: {
                this.threshold(imp, ip);
                break;
            }
            case 7: {
                this.update(imp, ip);
                break;
            }
            case 5: {
                this.adjustBrightness(imp, ip, bvalue);
                break;
            }
            case 6: {
                this.adjustContrast(imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        imp.updateAndDraw();
        if (this.RGBImage) {
            imp.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosing(WindowEvent e2) {
        super.windowClosing(e2);
        instance = null;
        this.done = true;
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e2) {
        this.setup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

