/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.SaveChangesDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Properties;

public class Editor
extends PlugInFrame
implements ActionListener,
TextListener,
ClipboardOwner {
    public static final int MAX_SIZE = 28000;
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static int lineNumber = 1;
    Properties p = new Properties();

    public Editor() {
        super("Editor");
        WindowManager.addWindow(this);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add(new MenuItem("Save", new MenuShortcut(83)));
        m.add(new MenuItem("Save As..."));
        m.add(new MenuItem("Print...", new MenuShortcut(80)));
        m.addSeparator();
        m.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        m.addActionListener(this);
        mb.add(m);
        m = new Menu("Edit");
        String key = IJ.isMacintosh() ? " = Cmd " : " = Ctrl+";
        MenuItem item = new MenuItem("Undo" + key + "Z");
        item.setEnabled(false);
        m.add(item);
        m.addSeparator();
        boolean shortcutsBroken = IJ.isWindows() && System.getProperty("java.version").indexOf("1.1.8") >= 0;
        item = shortcutsBroken ? new MenuItem("Cut") : new MenuItem("Cut", new MenuShortcut(88));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Copy") : new MenuItem("Copy", new MenuShortcut(67));
        m.add(item);
        item = shortcutsBroken ? new MenuItem("Paste") : new MenuItem("Paste", new MenuShortcut(86));
        m.add(item);
        m.addSeparator();
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
        this.ta = new TextArea(16, 60);
        this.ta.addTextListener(this);
        if (IJ.isMacOSX()) {
            this.ta.setFont(new Font("SansSerif", 0, 12));
        }
        this.add(this.ta);
        this.pack();
        GUI.center(this);
        this.display("Test.java", "");
    }

    void setWindowTitle(String title) {
        Menus.updateWindowMenuItem(this.getTitle(), title);
        this.setTitle(title);
    }

    public void create(String name, String text) {
        this.ta.append(text);
        this.ta.setCaretPosition(0);
        this.setWindowTitle(name);
        this.changes = true;
        this.show();
    }

    public void open(String dir, String name) {
        this.path = dir + name;
        File file = new File(this.path);
        int size = (int)file.length();
        if (size > 28000 && !IJ.isMacintosh()) {
            IJ.error("This file is too large for ImageJ to open.\n \n    File size: " + size + " bytes\n" + "    Max. size: " + 28000 + " bytes");
            this.dispose();
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            this.create(name, new String(sb));
            this.changes = false;
        }
        catch (Exception e2) {
            IJ.error(e2.getMessage());
            return;
        }
    }

    public void display(String title, String text) {
        this.ta.selectAll();
        this.ta.replaceRange(text, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(title);
        this.changes = false;
        this.show();
    }

    void save() {
        if (this.path == null) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        try {
            String s;
            BufferedReader br = new BufferedReader(new CharArrayReader(chars));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            while ((s = br.readLine()) != null) {
                bw.write(s, 0, s.length());
                bw.newLine();
            }
            bw.close();
            this.changes = false;
        }
        catch (IOException e2) {}
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    void print() {
        PrintJob pjob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (pjob != null) {
            Graphics pg = pjob.getGraphics();
            if (pg != null) {
                String s = this.ta.getText();
                this.printString(pjob, pg, s);
                pg.dispose();
            }
            pjob.end();
        }
    }

    void printString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        int topMargin = 30;
        int leftMargin = 30;
        int bottomMargin = 30;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - bottomMargin;
        Font helv = new Font("Helvetica", 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = topMargin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                nextLine = this.detabLine(nextLine);
                if (curHeight + fontHeight > pageHeight) {
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = topMargin;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, leftMargin, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eof) {
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    String detabLine(String s) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        int tabSize = 4;
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.25));
        int i = 0;
        while (i < s.length()) {
            char c2 = s.charAt(i);
            if (c2 == '\t') {
                int j = 0;
                while (j < tabSize) {
                    sb.append(' ');
                    ++j;
                }
            } else {
                sb.append(c2);
            }
            ++i;
        }
        return sb.toString();
    }

    boolean copy() {
        String s = this.ta.getSelectedText();
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip != null) {
            StringSelection cont = new StringSelection(s);
            clip.setContents(cont, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int start = this.ta.getSelectionStart();
            int end = this.ta.getSelectionEnd();
            this.ta.replaceRange("", start, end);
        }
    }

    void paste() {
        String s = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(s);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e2) {
            s = e2.toString();
        }
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        this.ta.replaceRange(s, start, end);
    }

    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if ("Save".equals(what)) {
            this.save();
        } else if ("Compile and Run".equals(what)) {
            this.compileAndRun();
        } else if ("Print...".equals(what)) {
            this.print();
        } else if ("Paste".equals(what)) {
            this.paste();
        } else if ("Copy".equals(what)) {
            this.copy();
        } else if ("Cut".equals(what)) {
            this.cut();
        } else if ("Save As...".equals(what)) {
            this.saveAs();
        } else if ("Find...".equals(what)) {
            this.find(null);
        } else if ("Find Next".equals(what)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(what)) {
            this.gotoLine();
        }
    }

    public void textValueChanged(TextEvent evt) {
        this.changes = true;
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        if (this.getTitle().equals("Errors") || this.close()) {
            this.setVisible(false);
            this.dispose();
            WindowManager.removeWindow(this);
        }
    }

    boolean close() {
        boolean okay = true;
        if (this.changes) {
            SaveChangesDialog d2 = new SaveChangesDialog((Frame)this, this.getTitle());
            if (d2.cancelPressed()) {
                okay = false;
            } else if (d2.savePressed()) {
                this.save();
            }
        }
        return okay;
    }

    void saveAs() {
        FileDialog fd = new FileDialog((Frame)this, "Save Plugin As...", 1);
        String name1 = this.getTitle();
        fd.setFile(name1);
        String pluginsDir = Menus.getPlugInsPath();
        if (this.path != null) {
            fd.setDirectory(pluginsDir);
        }
        fd.show();
        String name2 = fd.getFile();
        String dir = fd.getDirectory();
        fd.dispose();
        if (name2 != null) {
            this.updateClassName(name1, name2);
            this.path = dir + name2;
            this.save();
            this.changes = false;
            this.setWindowTitle(name2);
        }
    }

    void updateClassName(String oldName, String newName) {
        if (newName.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (oldName.equals(newName) || !oldName.endsWith(".java") || !newName.endsWith(".java")) {
            return;
        }
        oldName = oldName.substring(0, oldName.length() - 5);
        newName = newName.substring(0, newName.length() - 5);
        String text1 = this.ta.getText();
        int index = text1.indexOf("public class " + oldName);
        if (index < 0) {
            return;
        }
        String text2 = text1.substring(0, index + 13) + newName + text1.substring(index + 13 + oldName.length(), text1.length());
        this.ta.setText(text2);
    }

    void find(String s) {
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find", this);
            gd.addStringField("Find: ", searchString, 20);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
        }
        if (s.equals("")) {
            return;
        }
        String text = this.ta.getText();
        int index = text.indexOf(s, this.ta.getCaretPosition() + 1);
        if (index < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(index);
        this.ta.setSelectionEnd(index + s.length());
        searchString = s;
    }

    void gotoLine() {
        GenericDialog gd = new GenericDialog("Go to Line", this);
        gd.addNumericField("Go to line number: ", lineNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        if (n < 1) {
            return;
        }
        String text = this.ta.getText();
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 1;
        int loc = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\n') {
                ++count;
            }
            if (count == n) {
                loc = i + 1;
                break;
            }
            ++i;
        }
        this.ta.setCaretPosition(loc);
        lineNumber = n;
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }
}

