/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ShortStatistics
extends ImageStatistics {
    public ShortStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    /*
     * Unable to fully structure code
     */
    public ShortStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        super();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        this.nBins = 256;
        minT = ip.getMinThreshold();
        if ((mOptions & 256) == 0) ** GOTO lbl-1000
        if (minT == -808080.0) lbl-1000:
        // 2 sources

        {
            minThreshold = 0;
            maxThreshold = 65535;
        } else {
            minThreshold = (int)minT;
            maxThreshold = (int)ip.getMaxThreshold();
        }
        hist = ip.getHistogram();
        cTable = cal != null ? cal.getCTable() : null;
        this.getRawMinAndMax(hist, minThreshold, maxThreshold);
        this.histMin = this.min;
        this.histMax = this.max;
        this.getStatistics(hist, (int)this.min, (int)this.max, cTable);
        if ((mOptions & 8) != 0) {
            this.getMode(cTable);
        }
        if ((mOptions & 2048) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 32) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 64) != 0) {
            this.getCenterOfMass(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 16) != 0 && cTable != null) {
            this.getCalibratedMinAndMax(hist, (int)this.min, (int)this.max, cTable);
        }
    }

    void getRawMinAndMax(int[] hist, int minThreshold, int maxThreshold) {
        int min = minThreshold;
        while (hist[min] == 0 && min < 65535) {
            ++min;
        }
        this.min = min;
        int max = maxThreshold;
        while (hist[max] == 0 && max > 0) {
            --max;
        }
        this.max = max;
    }

    void getStatistics(int[] hist, int min, int max, float[] cTable) {
        double sum = 0.0;
        double sum2 = 0.0;
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        int hMin = (int)this.histMin;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        this.histogram = new int[this.nBins];
        int i = min;
        while (i <= max) {
            int count = hist[i];
            this.pixelCount += count;
            double value = cTable == null ? (double)i : (double)cTable[i];
            sum += value * (double)count;
            sum2 += value * value * (double)count;
            int index = (int)(scale * (double)(i - hMin));
            if (index >= this.nBins) {
                index = this.nBins - 1;
            }
            int n = index;
            this.histogram[n] = this.histogram[n] + count;
            ++i;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
    }

    void getMode(float[] cTable) {
        this.maxCount = 0;
        int i = 0;
        while (i < this.nBins) {
            int count = this.histogram[i];
            if (count > this.maxCount) {
                this.maxCount = count;
                this.mode = i;
            }
            ++i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (cTable != null) {
            this.dmode = cTable[(int)this.dmode];
        }
    }

    void getCentroid(ImageProcessor ip, int minThreshold, int maxThreshold) {
        short[] pixels = (short[])ip.getPixels();
        int[] mask = ip.getMask();
        boolean limit = minThreshold > 0 || maxThreshold < 65535;
        int count = 0;
        int xsum = 0;
        int ysum = 0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                block9: {
                    block8: {
                        if (mask == null) break block8;
                        int n = mi++;
                        if (mask[n] != -16777216) break block9;
                    }
                    if (limit) {
                        int v = pixels[i] & 0xFFFF;
                        if (v >= minThreshold && v <= maxThreshold) {
                            ++count;
                            xsum += x;
                            ysum += y;
                        }
                    } else {
                        ++count;
                        xsum += x;
                        ysum += y;
                    }
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCentroid = ((double)xsum / (double)count + 0.5) * this.pw;
        this.yCentroid = ((double)ysum / (double)count + 0.5) * this.ph;
    }

    void getCenterOfMass(ImageProcessor ip, int minThreshold, int maxThreshold) {
        short[] pixels = (short[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                block7: {
                    int v;
                    block6: {
                        if (mask == null) break block6;
                        int n = mi++;
                        if (mask[n] != -16777216) break block7;
                    }
                    if ((v = pixels[i] & 0xFFFF) >= minThreshold && v <= maxThreshold) {
                        count += (double)v;
                        xsum += (double)(x * v);
                        ysum += (double)(y * v);
                    }
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }

    void getCalibratedMinAndMax(int[] hist, int minValue, int maxValue, float[] cTable) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double v = 0.0;
        int i = minValue;
        while (i <= maxValue) {
            if (hist[i] > 0) {
                v = cTable[i];
                if (v < this.min) {
                    this.min = v;
                }
                if (v > this.max) {
                    this.max = v;
                }
            }
            ++i;
        }
    }
}

