/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.BadHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FauxHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.HDU;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.SkippedHDU;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class Fits {
    private BufferedDataInputStream dataStr;
    private Vector HDUList = new Vector(10);
    private boolean atEOF;

    public static String version() {
        return "0.6";
    }

    public Fits() {
    }

    public Fits(InputStream str) throws FitsException {
        this(str, false);
    }

    public Fits(InputStream str, boolean compressed) throws FitsException {
        this.streamInit(str, compressed);
    }

    protected void streamInit(InputStream str, boolean compressed) throws FitsException {
        if (str == null) {
            throw new FitsException("Null input stream");
        }
        if (compressed) {
            try {
                str = new GZIPInputStream(str);
            }
            catch (IOException e2) {
                throw new FitsException("Cannot inflate input stream" + e2);
            }
        }
        this.dataStr = str instanceof BufferedDataInputStream ? (BufferedDataInputStream)str : new BufferedDataInputStream(str);
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, false);
    }

    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            FileInputStream str = new FileInputStream(myFile);
            this.streamInit(str, compressed);
        }
        catch (IOException e2) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile);
        }
    }

    private static boolean isCompressed(String filename) {
        int len = filename.length();
        return len > 2 && filename.substring(len - 3).equalsIgnoreCase(".gz");
    }

    public Fits(String filename) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        boolean compressed = Fits.isCompressed(filename);
        int len = filename.length();
        if (len > 4 && filename.substring(0, 5).equalsIgnoreCase("http:")) {
            URL myURL;
            try {
                myURL = new URL(filename);
            }
            catch (IOException e2) {
                throw new FitsException("Unable to convert string to URL: " + filename);
            }
            try {
                InputStream is = myURL.openStream();
                this.streamInit(is, compressed);
            }
            catch (IOException e3) {
                throw new FitsException("Unable to open stream from URL:" + filename + " Exception=" + e3);
            }
        }
        this.fileInit(new File(filename), compressed);
    }

    public Fits(URL myURL, boolean compressed) throws FitsException {
        try {
            this.streamInit(myURL.openStream(), compressed);
        }
        catch (IOException e2) {
            throw new FitsException("Unable to open input from URL:" + myURL);
        }
    }

    public Fits(URL myURL) throws FitsException {
        this(myURL, Fits.isCompressed(myURL.getFile()));
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int size = this.currentSize();
        if (size == 0) {
            return null;
        }
        Object[] hdus = new BasicHDU[size];
        this.HDUList.copyInto(hdus);
        return hdus;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        BasicHDU nextHDU;
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        try {
            nextHDU = HDU.readHDU(this.dataStr);
        }
        catch (FitsException e2) {
            nextHDU = new BadHDU(e2);
        }
        if (nextHDU == null) {
            this.atEOF = true;
        } else {
            this.HDUList.addElement(nextHDU);
        }
        if (nextHDU instanceof FauxHDU) {
            ((FauxHDU)nextHDU).throwException();
        }
        return nextHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        int i = 0;
        while (i < n) {
            this.skipHDU();
            ++i;
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (!this.atEOF && !HDU.skipHDU(this.dataStr)) {
            this.atEOF = true;
        } else {
            this.HDUList.addElement(new SkippedHDU());
        }
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int size = this.currentSize();
        if (size > n) {
            BasicHDU hdu;
            try {
                hdu = (BasicHDU)this.HDUList.elementAt(n);
            }
            catch (NoSuchElementException e2) {
                throw new FitsException("Internal Error: Vector mismatch");
            }
            if (hdu instanceof FauxHDU) {
                ((FauxHDU)hdu).throwException();
            }
            return hdu;
        }
        int i = size;
        while (i <= n) {
            BasicHDU hdu;
            try {
                hdu = this.readHDU();
            }
            catch (FitsException e3) {
                hdu = new BadHDU(e3);
            }
            if (hdu == null) {
                return null;
            }
            ++i;
        }
        try {
            return (BasicHDU)this.HDUList.elementAt(n);
        }
        catch (NoSuchElementException e4) {
            throw new FitsException("Internal Error: HDUList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException e2) {
                throw new FitsException("IO error: " + e2);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.currentSize();
    }

    public void addHDU(BasicHDU myHDU) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (this.currentSize() == 0) {
            if (myHDU instanceof ImageHDU) {
                myHDU = new PrimaryHDU((ImageHDU)myHDU);
            } else if (!(myHDU instanceof PrimaryHDU)) {
                this.HDUList.addElement(new PrimaryHDU());
            }
        } else if (myHDU instanceof PrimaryHDU) {
            myHDU = new ImageHDU((PrimaryHDU)myHDU);
        }
        this.HDUList.addElement(myHDU);
    }

    public void insertHDU(BasicHDU myHDU, int n) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (n < 0 || n >= this.currentSize()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            this.HDUList.insertElementAt(myHDU, n);
            if (n == 0) {
                PrimaryHDU old = (PrimaryHDU)this.HDUList.elementAt(1);
                this.HDUList.setElementAt(new ImageHDU(old), 1);
            }
        }
        catch (NoSuchElementException e2) {
            throw new FitsException("Internal Error: HDUList Vector Inconsistency");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.currentSize();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.HDUList.removeElementAt(n);
            if (n == 0 && size > 0 && !(this.HDUList.elementAt(0) instanceof PrimaryHDU)) {
                this.insertHDU(new PrimaryHDU(), 0);
            }
        }
        catch (NoSuchElementException e2) {
            throw new FitsException("Internal Error: HDUList Vector Inconsitency");
        }
    }

    public void write(OutputStream os) throws FitsException {
        BufferedDataOutputStream obs = os instanceof BufferedDataOutputStream ? (BufferedDataOutputStream)os : new BufferedDataOutputStream(os);
        int i = 0;
        while (i < this.currentSize()) {
            try {
                BasicHDU hh = (BasicHDU)this.HDUList.elementAt(i);
                hh.write(obs);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new FitsException("Internal Error: Vector Inconsistency");
            }
            ++i;
        }
    }

    public void read(InputStream is) throws FitsException, IOException {
        this.dataStr = is instanceof BufferedDataInputStream ? (BufferedDataInputStream)is : new BufferedDataInputStream(is);
        this.read();
    }

    public int currentSize() {
        return this.HDUList.size();
    }

    public BufferedDataInputStream getStream() {
        return this.dataStr;
    }

    public void setStream(BufferedDataInputStream stream) {
        this.dataStr = stream;
        this.atEOF = false;
    }

    public static void main(String[] args) throws FitsException {
        if (args.length != 1) {
            System.err.println("Usage: Fits file");
            System.exit(1);
            return;
        }
        Fits fits = new Fits(args[0]);
        try {
            System.out.println("Fits: " + fits);
        }
        catch (Exception e2) {
            System.err.println(args[0] + " print threw " + e2.getMessage());
            e2.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        int n = 0;
        while (true) {
            BasicHDU hdu;
            try {
                hdu = fits.getHDU(n);
                if (hdu == null) {
                    break;
                }
            }
            catch (Exception e3) {
                System.err.println(args[0] + "#" + n + " fetch threw " + e3.getMessage());
                e3.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            try {
                System.out.println("Fits: " + args[0] + "#" + n + "= " + hdu);
            }
            catch (Exception e4) {
                System.err.println(args[0] + "#" + n + " print threw " + e4.getMessage());
                e4.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            ++n;
        }
    }
}

