/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.BufferedDataInputStream;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements DataOutput {
    public BufferedDataOutputStream(OutputStream o) {
        super(o);
    }

    public BufferedDataOutputStream(OutputStream o, int bufLength) {
        super(o, bufLength);
    }

    public void writeBoolean(boolean b2) throws IOException {
        if (b2) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b2) throws IOException {
        this.write((byte)b2);
    }

    public void writeInt(int i) throws IOException {
        byte[] b2 = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        this.write(b2, 0, 4);
    }

    public void writeShort(int s) throws IOException {
        byte[] b2 = new byte[]{(byte)(s >>> 8), (byte)s};
        this.write(b2, 0, 2);
    }

    public void writeChar(int c2) throws IOException {
        byte[] b2 = new byte[]{(byte)(c2 >>> 8), (byte)c2};
        this.write(b2, 0, 2);
    }

    public void writeLong(long l) throws IOException {
        byte[] b2 = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(b2, 0, 8);
    }

    public void writeFloat(float f) throws IOException {
        int i = Float.floatToIntBits(f);
        byte[] b2 = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        this.write(b2, 0, 4);
    }

    public void writeDouble(double d2) throws IOException {
        long l = Double.doubleToLongBits(d2);
        byte[] b2 = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(b2, 0, 8);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        byte[] b2 = new byte[2 * len];
        int i = 0;
        while (i < len) {
            char c2 = s.charAt(i);
            b2[2 * i] = (byte)(c2 >> 8);
            b2[2 * i + 1] = (byte)c2;
            ++i;
        }
        this.write(b2, 0, 2 * len);
    }

    public void writeUTF(String s) throws IOException {
        DataOutputStream d2 = new DataOutputStream(this);
        d2.writeUTF(s);
        d2.flush();
    }

    public void writePrimitiveArray(Object o) throws IOException {
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray:" + className);
        }
        if (className.charAt(1) == '[') {
            int i = 0;
            while (i < ((Object[])o).length) {
                this.writePrimitiveArray(((Object[])o)[i]);
                ++i;
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.writeBooleanArray((boolean[])o);
                    break;
                }
                case 'B': {
                    this.write((byte[])o, 0, ((byte[])o).length);
                    break;
                }
                case 'C': {
                    this.writeCharArray((char[])o);
                    break;
                }
                case 'S': {
                    this.writeShortArray((short[])o);
                    break;
                }
                case 'I': {
                    this.writeIntArray((int[])o);
                    break;
                }
                case 'J': {
                    this.writeLongArray((long[])o);
                    break;
                }
                case 'F': {
                    this.writeFloatArray((float[])o);
                    break;
                }
                case 'D': {
                    this.writeDoubleArray((double[])o);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.String;")) {
                        this.writeStringArray((String[])o);
                        break;
                    }
                    if (className.equals("[Ljava.lang.Object;")) {
                        int i = 0;
                        while (i < ((Object[])o).length) {
                            this.writePrimitiveArray(((Object[])o)[i]);
                            ++i;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
            }
        }
    }

    protected void writeBooleanArray(boolean[] b2) throws IOException {
        byte[] bx = new byte[b2.length];
        int i = 0;
        while (i < b2.length) {
            bx[i] = b2[i] ? (byte)1 : 0;
            ++i;
        }
        this.write(bx, 0, bx.length);
    }

    protected void writeShortArray(short[] s) throws IOException {
        byte[] b2 = new byte[2 * s.length];
        int i = 0;
        while (i < s.length) {
            short t2 = s[i];
            b2[2 * i] = (byte)(t2 >> 8);
            b2[2 * i + 1] = (byte)t2;
            ++i;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeCharArray(char[] c2) throws IOException {
        byte[] b2 = new byte[2 * c2.length];
        int i = 0;
        while (i < c2.length) {
            char t2 = c2[i];
            b2[2 * i] = (byte)(t2 >> 8);
            b2[2 * i + 1] = (byte)t2;
            ++i;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeIntArray(int[] i) throws IOException {
        byte[] b2 = new byte[4 * i.length];
        int ii = 0;
        while (ii < i.length) {
            int t2 = i[ii];
            b2[4 * ii] = (byte)(t2 >>> 24);
            b2[4 * ii + 1] = (byte)(t2 >>> 16);
            b2[4 * ii + 2] = (byte)(t2 >>> 8);
            b2[4 * ii + 3] = (byte)t2;
            ++ii;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeLongArray(long[] l) throws IOException {
        byte[] b2 = new byte[8 * l.length];
        int i = 0;
        while (i < l.length) {
            long t2 = l[i];
            b2[8 * i] = (byte)(t2 >>> 56);
            b2[8 * i + 1] = (byte)(t2 >>> 48);
            b2[8 * i + 2] = (byte)(t2 >>> 40);
            b2[8 * i + 3] = (byte)(t2 >>> 32);
            b2[8 * i + 4] = (byte)(t2 >>> 24);
            b2[8 * i + 5] = (byte)(t2 >>> 16);
            b2[8 * i + 6] = (byte)(t2 >>> 8);
            b2[8 * i + 7] = (byte)t2;
            ++i;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeFloatArray(float[] f) throws IOException {
        byte[] b2 = new byte[4 * f.length];
        int i = 0;
        while (i < f.length) {
            int t2 = Float.floatToIntBits(f[i]);
            b2[4 * i] = (byte)(t2 >>> 24);
            b2[4 * i + 1] = (byte)(t2 >>> 16);
            b2[4 * i + 2] = (byte)(t2 >>> 8);
            b2[4 * i + 3] = (byte)t2;
            ++i;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeDoubleArray(double[] d2) throws IOException {
        byte[] b2 = new byte[8 * d2.length];
        int i = 0;
        while (i < d2.length) {
            long t2 = Double.doubleToLongBits(d2[i]);
            b2[8 * i] = (byte)(t2 >>> 56);
            b2[8 * i + 1] = (byte)(t2 >>> 48);
            b2[8 * i + 2] = (byte)(t2 >>> 40);
            b2[8 * i + 3] = (byte)(t2 >>> 32);
            b2[8 * i + 4] = (byte)(t2 >>> 24);
            b2[8 * i + 5] = (byte)(t2 >>> 16);
            b2[8 * i + 6] = (byte)(t2 >>> 8);
            b2[8 * i + 7] = (byte)t2;
            ++i;
        }
        this.write(b2, 0, b2.length);
    }

    protected void writeStringArray(String[] s) throws IOException {
        int i = 0;
        while (i < s.length) {
            this.writeBytes(s[i]);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedDataInputStream.main(args);
    }
}

