/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class SliceMap
extends ConcreteIndexMap {
    private int position_;
    private int value_;

    public SliceMap(int position, int value) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = position;
        this.value_ = value;
    }

    public SliceMap(ConcreteIndexMap prev, int position, int value) {
        this.link(prev, new IMap(), new LengthsMap());
        this.position_ = position;
        this.value_ = value;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(delegate.storage, ii, ii);
            ++ii;
        }
        SliceMap im = new SliceMap(1, 1);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + " }");
            System.out.println(ma.getInt(new int[]{1}));
        }
        catch (IOException ee) {}
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public synchronized int get(int key) {
            int adjust = key < SliceMap.this.position_ ? key : key + 1;
            return super.get(adjust);
        }

        public synchronized int size() {
            return super.size() - 1;
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int key) {
            if (key < SliceMap.this.position_) {
                return super.get(key);
            }
            if (key == SliceMap.this.position_) {
                return SliceMap.this.value_;
            }
            return super.get(key - 1);
        }

        public synchronized int size() {
            return super.size() + 1;
        }
    }
}

