/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class TransposeMap
extends ConcreteIndexMap {
    private int aa_;
    private int bb_;

    public TransposeMap(int aa2, int bb) {
        this.init(new IMap(), new LengthsMap());
        this.aa_ = aa2;
        this.bb_ = bb;
    }

    public TransposeMap(ConcreteIndexMap prev, int aa2, int bb) {
        this.link(prev, new IMap(), new LengthsMap());
        this.aa_ = aa2;
        this.bb_ = bb;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{32, 48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(delegate.storage, ii, ii);
            ++ii;
        }
        TransposeMap im = new TransposeMap(0, 2);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + ", " + lengths[2] + " }");
            System.out.println(ma.getInt(new int[]{0, 0, 1}));
            System.out.println(ma.getInt(new int[]{0, 1, 0}));
            System.out.println(ma.getInt(new int[]{1, 0, 0}));
        }
        catch (IOException ee) {}
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public int get(int key) {
            if (key == TransposeMap.this.aa_) {
                return super.get(TransposeMap.this.bb_);
            }
            if (key == TransposeMap.this.bb_) {
                return super.get(TransposeMap.this.aa_);
            }
            return super.get(key);
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int key) {
            if (key == TransposeMap.this.aa_) {
                return super.get(TransposeMap.this.bb_);
            }
            if (key == TransposeMap.this.bb_) {
                return super.get(TransposeMap.this.aa_);
            }
            return super.get(key);
        }
    }
}

