/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;

class AttributeDictionary
implements AttributeSet,
Serializable {
    protected final NamedDictionary attributes;

    AttributeDictionary() {
        this.attributes = new NamedDictionary(0);
    }

    AttributeDictionary(Attribute[] attrArray) {
        this.attributes = new NamedDictionary(attrArray);
    }

    AttributeDictionary(final AttributeSet ss) {
        this.attributes = new NamedDictionary(ss.size(), new Enumeration(){
            final AttributeIterator ee;
            {
                this.ee = ss.iterator();
            }

            public boolean hasMoreElements() {
                return this.ee.hasNext();
            }

            public Object nextElement() {
                return this.ee.next();
            }
        });
    }

    public int size() {
        return this.attributes.size();
    }

    public AttributeIterator iterator() {
        return new AttributeIterator(){
            final Enumeration ee;
            {
                this.ee = AttributeDictionary.this.attributes.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public Attribute next() {
                return (Attribute)this.ee.nextElement();
            }
        };
    }

    public Attribute[] toArray() {
        Attribute[] aa2 = new Attribute[this.size()];
        AttributeIterator ee = this.iterator();
        int ii = 0;
        while (ee.hasNext()) {
            aa2[ii] = ee.next();
            ++ii;
        }
        return aa2;
    }

    public Attribute get(String name) {
        return (Attribute)this.attributes.get(name);
    }

    public boolean contains(String name) {
        return this.attributes.contains(name);
    }

    public boolean contains(Object oo) {
        return this.attributes.contains(oo);
    }

    public Attribute put(Attribute attr) {
        return (Attribute)this.attributes.put(attr);
    }

    public boolean remove(String name) {
        Named oo = this.attributes.remove(name);
        return oo != null;
    }

    public boolean remove(Object oo) {
        if (this.contains(oo)) {
            return this.remove(((Named)oo).getName());
        }
        return false;
    }

    public void toCdl(StringBuffer buf) {
        AttributeIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append("\t\t");
            iter.next().toCdl(buf);
            buf.append("\n");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }
}

