/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.CommonUnit;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.PlotText;
import visad.ProjectionControl;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowType;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.util.HersheyFont;

public class AxisScale
implements Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    private boolean screenBased = false;
    private VisADLineArray scaleArray;
    private VisADTriangleArray labelArray;
    private ScalarMap scalarMap;
    private Color myColor = Color.white;
    private double[] dataRange = new double[2];
    private int myAxis = -1;
    private int axisOrdinal = -1;
    private String myTitle;
    private Hashtable labelTable;
    private double majorTickSpacing = 0.0;
    private double minorTickSpacing = 0.0;
    private double tickBase = 0.0;
    private boolean autoComputeTicks = true;
    private boolean baseLineVisible = true;
    private boolean snapToBox = false;
    private boolean userLabels = false;
    private boolean visibility = true;
    private boolean labelAllTicks = false;
    private Object labelFont = null;
    private int labelSize = 12;
    private int axisSide = 0;
    private int tickOrient = 0;
    private static final double TICKSIZE = 0.5;
    private NumberFormat labelFormat = null;

    public AxisScale(ScalarMap map) throws VisADException {
        DisplayRenderer displayRenderer;
        this.scalarMap = map;
        DisplayRealType displayScalar = this.scalarMap.getDisplayScalar();
        if (!(displayScalar.equals(Display.XAxis) || displayScalar.equals(Display.YAxis) || displayScalar.equals(Display.ZAxis))) {
            throw new DisplayException("AxisSale: DisplayScalar must be XAxis, YAxis or ZAxis");
        }
        this.myAxis = displayScalar.equals(Display.XAxis) ? 0 : (displayScalar.equals(Display.YAxis) ? 1 : 2);
        this.myTitle = this.scalarMap.getScalarName();
        this.visibility = this.scalarMap.getScaleEnable();
        this.labelTable = new Hashtable();
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display != null && (displayRenderer = display.getDisplayRenderer()) != null) {
            float[] rgb = displayRenderer.getRendererControl().getForegroundColor();
            this.myColor = new Color(rgb[0], rgb[1], rgb[2]);
            boolean ok = this.makeScale();
        }
    }

    public int getAxisOrdinal() {
        return this.axisOrdinal;
    }

    void setAxisOrdinal(int ordinalValue) {
        this.axisOrdinal = ordinalValue;
    }

    public void setLabel(String label) {
        this.setTitle(label);
    }

    public String getLabel() {
        return this.getTitle();
    }

    public void setTitle(String title) {
        block3: {
            String oldTitle = this.myTitle;
            this.myTitle = title;
            if (this.myTitle.equals(oldTitle)) break block3;
            try {
                if (!this.myTitle.equals(this.scalarMap.getScalarName())) {
                    this.scalarMap.setScalarName(this.myTitle);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public int getAxis() {
        return this.myAxis;
    }

    public VisADLineArray getScaleArray() {
        return this.scaleArray;
    }

    public VisADTriangleArray getLabelArray() {
        return this.labelArray;
    }

    public void setScreenBased(boolean sb) {
        this.screenBased = sb;
    }

    public boolean getScreenBased() {
        return this.screenBased;
    }

    public boolean makeScreenBasedScale(double XMIN, double YMIN, double XMAX, double YMAX, double XTMIN, double YTMIN, double XTMAX, double YTMAX) throws VisADException {
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display == null) {
            return false;
        }
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            return false;
        }
        this.dataRange = this.scalarMap.getRange();
        if (!displayRenderer.getMode2D()) {
            return false;
        }
        boolean twoD = true;
        ProjectionControl pcontrol = display.getProjectionControl();
        double[] aspect = pcontrol.getAspectCartesian();
        double oldMax = 1.0;
        double oldMin = -1.0;
        double newMax = 1.0;
        double newMin = -1.0;
        if (this.myAxis == 0) {
            oldMax = aspect[0];
            oldMin = -aspect[0];
            newMax = XTMAX;
            newMin = XTMIN;
        } else if (this.myAxis == 1) {
            oldMax = aspect[1];
            oldMin = -aspect[1];
            newMax = YTMAX;
            newMin = YTMIN;
        }
        double mult = (this.dataRange[1] - this.dataRange[0]) / (oldMax - oldMin);
        double d1 = (newMax - oldMin) * mult + this.dataRange[0];
        double d0 = (newMin - oldMin) * mult + this.dataRange[0];
        double[] dr = new double[]{d0, d1};
        double ZMIN = 0.0;
        double ZMAX = -ZMIN;
        double SCALE = (double)this.labelSize / 200.0;
        double OFFSET = 1.05;
        SCALE *= 0.6;
        int position = 0;
        int myPosition = 0;
        if (this.snapToBox) {
            OFFSET = 1.0;
        } else {
            Enumeration e2 = display.getMapVector().elements();
            while (e2.hasMoreElements()) {
                ScalarMap map = (ScalarMap)e2.nextElement();
                if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != map.getAxisScale().getSide()) continue;
                if (map.equals(this.scalarMap)) {
                    myPosition = position;
                    break;
                }
                ++position;
            }
        }
        double line = 4.0 * (double)myPosition * SCALE;
        return this.makeScale(twoD, XMIN, YMIN, ZMIN, XMAX, YMAX, ZMAX, SCALE, OFFSET, line, dr);
    }

    public boolean makeScale() throws VisADException {
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display == null) {
            return false;
        }
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            this.axisOrdinal = displayRenderer.getAxisOrdinal(this.myAxis);
        }
        this.dataRange = this.scalarMap.getRange();
        boolean twoD = displayRenderer.getMode2D();
        ProjectionControl pcontrol = display.getProjectionControl();
        double[] aspect = pcontrol.getAspectCartesian();
        double XMIN = -aspect[0];
        double YMIN = -aspect[1];
        double ZMIN = -aspect[2];
        double XMAX = -XMIN;
        double YMAX = -YMIN;
        double ZMAX = -ZMIN;
        double SCALE = (double)this.labelSize / 200.0;
        double OFFSET = 1.05;
        int position = 0;
        int myPosition = 0;
        if (this.snapToBox) {
            OFFSET = 1.0;
        } else {
            Enumeration e2 = display.getMapVector().elements();
            while (e2.hasMoreElements()) {
                ScalarMap map = (ScalarMap)e2.nextElement();
                if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != map.getAxisScale().getSide()) continue;
                if (map.equals(this.scalarMap)) {
                    myPosition = position;
                    break;
                }
                ++position;
            }
        }
        double line = 4.0 * (double)myPosition * SCALE;
        return this.makeScale(twoD, XMIN, YMIN, ZMIN, XMAX, YMAX, ZMAX, SCALE, OFFSET, line, this.dataRange);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean makeScale(boolean twoD, double XMIN, double YMIN, double ZMIN, double XMAX, double YMAX, double ZMAX, double SCALE, double OFFSET, double line, double[] dataRange) throws VisADException {
        block66: {
            base = null;
            up = null;
            startn = null;
            startp = null;
            lineArrayVector = new Vector<VisADLineArray>(4);
            labelArrayVector = new Vector<VisADGeometryArray>();
            ONE = 1.0;
            if (dataRange[0] > dataRange[1]) {
                ONE = -1.0;
            }
            if (this.myAxis == 0) {
                if (this.getSide() == 0) {
                    base = new double[]{SCALE, 0.0, 0.0};
                    up = new double[]{0.0, SCALE, SCALE};
                    startp = new double[]{ONE * XMAX, YMIN - (OFFSET - 1.0 + line), ZMIN - (OFFSET - 1.0 + line)};
                    startn = new double[]{ONE * XMIN, YMIN - (OFFSET - 1.0 + line), ZMIN - (OFFSET - 1.0 + line)};
                } else {
                    base = new double[]{-SCALE, 0.0, 0.0};
                    up = new double[]{0.0, -SCALE, SCALE};
                    startp = new double[]{ONE * XMAX, YMAX + (OFFSET - 1.0 + line), ZMIN - (OFFSET - 1.0 + line)};
                    startn = new double[]{ONE * XMIN, YMAX + (OFFSET - 1.0 + line), ZMIN - (OFFSET - 1.0 + line)};
                }
            } else if (this.myAxis == 1) {
                if (this.getSide() == 0) {
                    base = new double[]{0.0, -SCALE, 0.0};
                    up = new double[]{SCALE, 0.0, SCALE};
                    startp = new double[]{XMIN - (OFFSET - 1.0 + line), ONE * YMAX, ZMIN - (OFFSET - 1.0 + line)};
                    startn = new double[]{XMIN - (OFFSET - 1.0 + line), ONE * YMIN, ZMIN - (OFFSET - 1.0 + line)};
                } else {
                    base = new double[]{0.0, SCALE, 0.0};
                    up = new double[]{-SCALE, 0.0, SCALE};
                    startp = new double[]{XMAX + (OFFSET - 1.0 + line), ONE * YMAX, ZMIN - (OFFSET - 1.0 + line)};
                    startn = new double[]{XMAX + (OFFSET - 1.0 + line), ONE * YMIN, ZMIN - (OFFSET - 1.0 + line)};
                }
            } else if (this.myAxis == 2) {
                if (this.getSide() == 0) {
                    base = new double[]{0.0, 0.0, -SCALE};
                    up = new double[]{SCALE, SCALE, 0.0};
                    startp = new double[]{XMIN - (OFFSET - 1.0 + line), YMIN - (OFFSET - 1.0 + line), ONE * ZMAX};
                    startn = new double[]{XMIN - (OFFSET - 1.0 + line), YMIN - (OFFSET - 1.0 + line), ONE * ZMIN};
                } else {
                    base = new double[]{0.0, 0.0, SCALE};
                    up = new double[]{-SCALE, SCALE, 0.0};
                    startp = new double[]{XMAX + (OFFSET - 1.0 + line), YMIN - (OFFSET - 1.0 + line), ONE * ZMAX};
                    startn = new double[]{XMAX + (OFFSET - 1.0 + line), YMIN - (OFFSET - 1.0 + line), ONE * ZMIN};
                }
            }
            if (twoD) {
                if (this.myAxis == 2) {
                    return false;
                }
                base[2] = 0.0;
                up[2] = 0.0;
                startn[2] = 0.0;
                startp[2] = 0.0;
            }
            if (this.baseLineVisible) {
                baseLineArray = new VisADLineArray();
                lineCoordinates = new float[6];
                i = 0;
                while (i < 3) {
                    lineCoordinates[i] = (float)startn[i];
                    lineCoordinates[3 + i] = (float)startp[i];
                    ++i;
                }
                baseLineArray.vertexCount = 2;
                baseLineArray.coordinates = lineCoordinates;
                lineArrayVector.add(baseLineArray);
            }
            range = Math.abs(dataRange[1] - dataRange[0]);
            min = Math.min(dataRange[0], dataRange[1]);
            max = Math.max(dataRange[0], dataRange[1]);
            tens = 1.0;
            if (!(range < tens)) ** GOTO lbl76
            tens /= 10.0;
            while (range < tens) {
                tens /= 10.0;
            }
            break block66;
lbl-1000:
            // 1 sources

            {
                tens *= 10.0;
lbl76:
                // 2 sources

                ** while (10.0 * tens <= range)
            }
        }
        if (this.autoComputeTicks || this.majorTickSpacing <= 0.0) {
            ratio = range / tens;
            if (ratio < 2.0) {
                tens /= 5.0;
            } else if (ratio < 4.0) {
                tens /= 2.0;
            }
            this.majorTickSpacing = tens;
        }
        hilo = this.computeTicks(max, min, this.tickBase, this.majorTickSpacing);
        firstValue = hilo[0];
        botval = hilo[0];
        topval = hilo[hilo.length - 1];
        majorTickArray = new VisADLineArray();
        nticks = (int)((topval - botval) / this.majorTickSpacing) + 1;
        majorCoordinates = new float[6 * nticks];
        tickup = up;
        if (this.getTickOrientation() != 0) {
            if (this.myAxis == 0) {
                tickup = new double[]{up[0], -up[1], -up[2]};
            } else if (this.myAxis == 1) {
                tickup = new double[]{-up[0], up[1], -up[2]};
            } else if (this.myAxis == 2) {
                tickup = new double[]{-up[0], -up[1], up[2]};
            }
        }
        k = 0;
        j = 0;
        while (j < nticks) {
            value = firstValue + (double)j * this.majorTickSpacing;
            a = (value - min) / (max - min);
            i = 0;
            while (i < 3) {
                if (k + 3 + i < majorCoordinates.length) {
                    majorCoordinates[k + i] = (float)((1.0 - a) * startn[i] + a * startp[i]);
                    majorCoordinates[k + 3 + i] = (float)((double)majorCoordinates[k + i] - 0.5 * tickup[i]);
                }
                ++i;
            }
            k += 6;
            ++j;
        }
        majorTickArray.vertexCount = 2 * nticks;
        majorTickArray.coordinates = majorCoordinates;
        lineArrayVector.add(majorTickArray);
        if (this.getMinorTickSpacing() > 0.0) {
            hilo = this.computeTicks(max, min, this.tickBase, this.minorTickSpacing);
            minorTickArray = new VisADLineArray();
            nticks = (int)((hilo[hilo.length - 1] - hilo[0]) / this.minorTickSpacing) + 1;
            minorCoordinates = new float[6 * nticks];
            k = 0;
            j = 0;
            while (j < nticks) {
                val = hilo[0] + (double)j * this.minorTickSpacing;
                a = (val - min) / (max - min);
                i = 0;
                while (i < 3) {
                    if (k + 3 + i < minorCoordinates.length) {
                        minorCoordinates[k + i] = (float)((1.0 - a) * startn[i] + a * startp[i]);
                        minorCoordinates[k + 3 + i] = (float)((double)minorCoordinates[k + i] - 0.25 * tickup[i]);
                    }
                    ++i;
                }
                k += 6;
                ++j;
            }
            minorTickArray.vertexCount = 2 * nticks;
            minorTickArray.coordinates = minorCoordinates;
            lineArrayVector.add(minorTickArray);
        }
        justification = TextControl.Justification.CENTER;
        if (twoD) {
            if (this.myAxis == 0) {
                up = new double[]{0.0, SCALE, 0.0};
            } else if (this.myAxis == 1) {
                up = new double[]{-SCALE, 0.0, 0.0};
            }
        }
        if (!this.userLabels) {
            this.createStandardLabels(topval, botval, botval, this.labelAllTicks == false ? topval - botval : this.majorTickSpacing, false);
        }
        dist = 1.5;
        if (!twoD) {
            v0 = up;
        } else {
            v1 = new double[3];
            v1[0] = 0.0;
            v1[1] = SCALE;
            v0 = v1;
            v1[2] = 0.0;
        }
        updir = v0;
        if (twoD) {
            base = new double[]{SCALE, 0.0, 0.0};
            if (this.myAxis == 0) {
                dist = this.getSide() == 0 ? 1.65 : -0.65;
            } else if (this.myAxis == 1) {
                dist = this.getSide() == 0 ? -0.65 : 0.65;
                justification = this.getSide() == 0 ? TextControl.Justification.RIGHT : TextControl.Justification.LEFT;
            }
        }
        maximumYAxisTickLabelSize = 1;
        yAxisLabelLength = 0;
        e = this.labelTable.keys();
        while (e.hasMoreElements()) {
            try {
                Value = (Double)e.nextElement();
            }
            catch (ClassCastException cce) {
                throw new VisADException("Invalid keys in label hashtable");
            }
            test = Value;
            if (test > max || test < min) continue;
            if (this.myAxis == 1 && (yAxisLabelLength = ((String)this.labelTable.get(Value)).length()) > maximumYAxisTickLabelSize) {
                maximumYAxisTickLabelSize = yAxisLabelLength;
            }
            val = (test - min) / (max - min);
            if (this.myAxis == 1 && twoD) {
                val -= 0.2 * SCALE;
            }
            point = new double[3];
            j = 0;
            while (j < 3) {
                point[j] = (1.0 - val) * startn[j] + val * startp[j] - dist * up[j];
                ++j;
            }
            if (this.labelFont == null) {
                label /* !! */  = PlotText.render_label((String)this.labelTable.get(Value), point, base, updir, justification);
                lineArrayVector.add(label /* !! */ );
                continue;
            }
            if (this.labelFont instanceof Font) {
                label /* !! */  = PlotText.render_font((String)this.labelTable.get(Value), (Font)this.labelFont, point, base, updir, justification);
                labelArrayVector.add(label /* !! */ );
                continue;
            }
            if (!(this.labelFont instanceof HersheyFont)) continue;
            label /* !! */  = PlotText.render_font((String)this.labelTable.get(Value), (HersheyFont)this.labelFont, point, base, updir, justification);
            lineArrayVector.add(label /* !! */ );
        }
        startlabel = new double[3];
        dist = 2.5;
        justification = TextControl.Justification.CENTER;
        if (twoD) {
            if (this.myAxis == 0) {
                base = new double[]{SCALE, 0.0, 0.0};
                up = new double[]{0.0, SCALE, 0.0};
                dist = this.getSide() == 0 ? 3.0 : -1.95;
            } else if (this.myAxis == 1) {
                base = new double[]{0.0, SCALE, 0.0};
                up = new double[]{-SCALE, 0.0, 0.0};
                dist = this.getSide() == 0 ? -(1.0 + (double)maximumYAxisTickLabelSize) : 1.0 + (double)maximumYAxisTickLabelSize;
            }
        }
        i = 0;
        while (i < 3) {
            startlabel[i] = 0.5 * (startn[i] + startp[i]) - dist * up[i];
            ++i;
        }
        if (this.labelFont == null) {
            plotArray = PlotText.render_label(this.myTitle, startlabel, base, up, justification);
            lineArrayVector.add(plotArray);
        } else if (this.labelFont instanceof Font) {
            nameArray = PlotText.render_font(this.myTitle, (Font)this.labelFont, startlabel, base, up, justification);
            labelArrayVector.add(nameArray);
        } else if (this.labelFont instanceof HersheyFont) {
            plotArray = PlotText.render_font(this.myTitle, (HersheyFont)this.labelFont, startlabel, base, up, justification);
            lineArrayVector.add(plotArray);
        }
        arrays = lineArrayVector.toArray(new VisADLineArray[lineArrayVector.size()]);
        this.scaleArray = VisADLineArray.merge(arrays);
        if (!labelArrayVector.isEmpty()) {
            labelArrays = labelArrayVector.toArray(new VisADTriangleArray[labelArrayVector.size()]);
            this.labelArray = VisADTriangleArray.merge(labelArrays);
            rgb = this.myColor.getColorComponents(null);
            red = ShadowType.floatToByte(rgb[0]);
            green = ShadowType.floatToByte(rgb[1]);
            blue = ShadowType.floatToByte(rgb[2]);
            n = 3 * this.labelArray.vertexCount;
            colors = new byte[n];
            i = 0;
            while (i < n) {
                colors[i] = red;
                colors[i + 1] = green;
                colors[i + 2] = blue;
                i += 3;
            }
            this.labelArray.colors = colors;
        }
        return true;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        block2: {
            Color oldColor = this.myColor;
            this.myColor = color;
            if (this.myColor == null || this.myColor.equals(oldColor)) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public void setColor(float[] color) {
        this.setColor(new Color(color[0], color[1], color[2]));
    }

    AxisScale clone(ScalarMap map) throws VisADException {
        AxisScale newScale = new AxisScale(map);
        if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar())) {
            throw new VisADException("AxisScale: DisplayScalar for map is not" + this.scalarMap.getDisplayScalar());
        }
        newScale.myColor = this.myColor;
        newScale.axisOrdinal = this.axisOrdinal;
        newScale.myAxis = this.myAxis;
        newScale.myTitle = this.myTitle;
        newScale.labelTable = (Hashtable)this.labelTable.clone();
        newScale.majorTickSpacing = this.majorTickSpacing;
        newScale.minorTickSpacing = this.minorTickSpacing;
        newScale.autoComputeTicks = this.autoComputeTicks;
        newScale.baseLineVisible = this.baseLineVisible;
        newScale.snapToBox = this.snapToBox;
        newScale.labelFont = this.labelFont;
        newScale.labelSize = this.labelSize;
        newScale.axisSide = this.axisSide;
        newScale.tickOrient = this.tickOrient;
        newScale.userLabels = this.userLabels;
        newScale.labelAllTicks = this.labelAllTicks;
        return newScale;
    }

    public void setMajorTickSpacing(double spacing) {
        block2: {
            double oldValue = this.majorTickSpacing;
            this.majorTickSpacing = Math.abs(spacing);
            this.autoComputeTicks = false;
            if (this.majorTickSpacing == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMinorTickSpacing(double spacing) {
        block2: {
            double oldValue = this.minorTickSpacing;
            this.minorTickSpacing = Math.abs(spacing);
            if (this.minorTickSpacing == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setAutoComputeTicks(boolean b2) {
        block2: {
            boolean oldValue = this.autoComputeTicks;
            this.autoComputeTicks = b2;
            if (this.autoComputeTicks == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public void createStandardLabels(double max, double min, double base, double increment) {
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        if (increment > max - min) {
            throw new IllegalArgumentException("increment must be less than or equal to range (max-min)");
        }
        this.createStandardLabels(max, min, base, increment, true);
    }

    private void createStandardLabels(double max, double min, double base, double increment, boolean byuser) {
        block4: {
            this.labelTable.clear();
            double[] values = this.computeTicks(max, min, base, increment);
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    this.labelTable.put(new Double(values[i]), this.createLabelString(values[i]));
                    ++i;
                }
            }
            if (!byuser) break block4;
            try {
                this.userLabels = true;
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public void setLabelTable(Hashtable labels) throws VisADException {
        Hashtable oldTable = this.labelTable;
        this.labelTable = labels;
        if (labels != oldTable) {
            this.userLabels = true;
            this.scalarMap.makeScale();
        }
    }

    public Hashtable getLabelTable() {
        return this.labelTable;
    }

    public void setFont(Font font) {
        block3: {
            Object oldFont = this.labelFont;
            this.labelFont = font;
            if (this.labelFont == null || this.labelFont.equals(oldFont)) break block3;
            if (this.labelFont instanceof Font) {
                this.labelSize = ((Font)this.labelFont).getSize();
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public void setFont(HersheyFont font) {
        block2: {
            Object oldFont = this.labelFont;
            this.labelFont = font;
            if (this.labelFont == null || this.labelFont.equals(oldFont)) break block2;
            this.labelSize = 12;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public Font getFont() {
        return this.labelFont instanceof Font ? (Font)this.labelFont : null;
    }

    public void setBaseLineVisible(boolean visible) {
        block2: {
            boolean oldValue = this.baseLineVisible;
            this.baseLineVisible = visible;
            if (this.baseLineVisible == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public boolean getBaseLineVisible() {
        return this.baseLineVisible;
    }

    public void setSnapToBox(boolean b2) {
        block2: {
            boolean oldValue = this.snapToBox;
            this.snapToBox = b2;
            if (this.snapToBox == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public boolean getSnapToBox() {
        return this.snapToBox;
    }

    public void setLabelSize(int size) {
        block3: {
            int oldSize = this.labelSize;
            this.labelSize = size;
            if (this.labelSize == oldSize) break block3;
            if (this.labelFont != null && this.labelFont instanceof Font) {
                this.labelFont = new Font(((Font)this.labelFont).getName(), ((Font)this.labelFont).getStyle(), this.labelSize);
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setTickBase(double base) {
        block2: {
            double oldBase = this.tickBase;
            this.tickBase = base;
            if (this.tickBase == oldBase) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public void setSide(int side) {
        block2: {
            double oldSide = this.axisSide;
            int n = this.axisSide = side == 1 ? 1 : 0;
            if ((double)this.axisSide == oldSide) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public int getSide() {
        return this.axisSide;
    }

    public void setTickOrientation(int orient) {
        block2: {
            double oldOrient = this.tickOrient;
            int n = this.tickOrient = orient == 1 ? 1 : 0;
            if ((double)this.tickOrient == oldOrient) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public int getTickOrientation() {
        return this.tickOrient;
    }

    public void setNumberFormat(NumberFormat format) {
        this.labelFormat = format;
    }

    public NumberFormat getNumberFormat() {
        return this.labelFormat;
    }

    public void setVisible(boolean visible) {
        block3: {
            boolean oldVisibility = this.visibility;
            this.visibility = visible;
            if (oldVisibility == this.visibility) break block3;
            try {
                if (visible != this.scalarMap.getScaleEnable()) {
                    this.scalarMap.setScaleEnable(visible);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public boolean isVisible() {
        return this.scalarMap.getScaleEnable();
    }

    public void setLabelAllTicks(boolean labelAll) {
        block2: {
            boolean oldValue = this.labelAllTicks;
            this.labelAllTicks = labelAll;
            if (this.labelAllTicks == oldValue) break block2;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException ve) {}
        }
    }

    public boolean getLabelAllTicks() {
        return this.labelAllTicks;
    }

    private double[] computeTicks(double high, double low, double base, double interval) {
        double[] vals = null;
        long nlo = Math.round(Math.ceil((low - base) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - base) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return new double[]{low, high};
        }
        vals = new double[numc];
        int i = 0;
        while (i < numc) {
            vals[i] = base + (double)(nlo + (long)i) * interval;
            ++i;
        }
        return vals;
    }

    private String createLabelString(double value) {
        RealType rType;
        Unit unit;
        String label = null;
        ScalarType sType = this.scalarMap.getScalar();
        label = sType instanceof RealType ? (Unit.canConvert(CommonUnit.secondsSinceTheEpoch, unit = (rType = (RealType)sType).getDefaultUnit()) && !unit.getAbsoluteUnit().equals(unit) ? new Real(rType, value).toValueString() : (this.labelFormat != null ? this.labelFormat.format(value) : PlotText.shortString(value))) : (this.labelFormat != null ? this.labelFormat.format(value) : PlotText.shortString(value));
        return label;
    }
}

