/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.CoordinateSystem;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.List1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class BaseColorControl
extends Control {
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int ALPHA = 3;
    public static final int DEFAULT_NUMBER_OF_COLORS = 256;
    private float[][] table;
    private int tableLength;
    private Function function;
    private transient RealTupleType functionDomainType;
    private transient CoordinateSystem functionCoordinateSystem;
    private transient Unit[] functionUnits;
    private transient Object lock = new Object();
    private final int components;

    public BaseColorControl(DisplayImpl d2, int components) {
        super(d2);
        if (components < 3) {
            components = 3;
        } else if (components > 4) {
            components = 4;
        }
        this.components = components;
        this.tableLength = 256;
        this.table = BaseColorControl.initTableVis5D(new float[components][this.tableLength]);
    }

    public static float[][] initTableGreyWedge(float[][] table) {
        if (table == null || table[0] == null) {
            return null;
        }
        boolean hasAlpha = table.length > 3;
        int numColors = table[0].length;
        float scale = 1.0f / (float)(numColors - 1);
        int i = 0;
        while (i < numColors) {
            table[0][i] = scale * (float)i;
            table[1][i] = scale * (float)i;
            table[2][i] = scale * (float)i;
            if (hasAlpha) {
                table[3][i] = scale * (float)i;
            }
            ++i;
        }
        return table;
    }

    public void initGreyWedge() {
        BaseColorControl.initTableGreyWedge(this.table);
    }

    public static float[][] initTableVis5D(float[][] table) {
        if (table == null || table[0] == null) {
            return null;
        }
        boolean hasAlpha = table.length > 3;
        float curve = 1.4f;
        float bias = 1.0f;
        float rfact = 0.5f * bias;
        int numColors = table[0].length;
        int i = 0;
        while (i < numColors) {
            float s = (float)i / (float)(numColors - 1);
            float t2 = curve * (s - rfact);
            table[0][i] = (float)(0.5 + 0.5 * Math.atan(7.0 * (double)t2) / 1.57);
            table[1][i] = (float)(0.5 + 0.5 * (2.0 * Math.exp(-7.0f * t2 * t2) - 1.0));
            table[2][i] = (float)(0.5 + 0.5 * Math.atan(-7.0 * (double)t2) / 1.57);
            if (hasAlpha) {
                table[3][i] = 1.0f;
            }
            ++i;
        }
        return table;
    }

    public void initVis5D() {
        BaseColorControl.initTableVis5D(this.table);
    }

    public static float[][] initTableHSV(float[][] table) {
        if (table == null || table[0] == null) {
            return null;
        }
        boolean hasAlpha = table.length > 3;
        float s = 1.0f;
        float v = 1.0f;
        int numColors = table[0].length;
        int i = 0;
        while (i < numColors) {
            float h = (float)(i * 6) / (float)(numColors - 1);
            int hFloor = (int)Math.floor(h);
            float hPart = h - (float)hFloor;
            if ((hFloor & 1) == 0) {
                hPart = 1.0f - hPart;
            }
            float m = v * (1.0f - s);
            float n = v * (1.0f - s * hPart);
            switch (hFloor) {
                case 0: 
                case 6: {
                    table[0][i] = v;
                    table[1][i] = n;
                    table[2][i] = m;
                    break;
                }
                case 1: {
                    table[0][i] = n;
                    table[1][i] = v;
                    table[2][i] = m;
                    break;
                }
                case 2: {
                    table[0][i] = m;
                    table[1][i] = v;
                    table[2][i] = n;
                    break;
                }
                case 3: {
                    table[0][i] = m;
                    table[1][i] = n;
                    table[2][i] = v;
                    break;
                }
                case 4: {
                    table[0][i] = n;
                    table[1][i] = m;
                    table[2][i] = v;
                    break;
                }
                case 5: {
                    table[0][i] = v;
                    table[1][i] = m;
                    table[2][i] = n;
                }
            }
            if (hasAlpha) {
                table[3][i] = 1.0f;
            }
            ++i;
        }
        return table;
    }

    public void initHSV() {
        BaseColorControl.initTableHSV(this.table);
    }

    public int getNumberOfComponents() {
        return this.components;
    }

    public int getNumberOfColors() {
        return this.tableLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFunction(Function func) throws RemoteException, VisADException {
        FunctionType baseType = this.components == 4 ? FunctionType.REAL_1TO4_FUNCTION : FunctionType.REAL_1TO3_FUNCTION;
        if (func == null || !func.getType().equalsExceptName(baseType)) {
            throw new DisplayException("BaseColorControl.setFunction: function must be 1D-to-" + this.components + "D");
        }
        Object object = this.lock;
        synchronized (object) {
            this.function = func;
            this.functionDomainType = ((FunctionType)this.function.getType()).getDomain();
            this.functionCoordinateSystem = this.function.getDomainCoordinateSystem();
            this.functionUnits = this.function.getDomainUnits();
            this.table = null;
        }
        this.changeControl(true);
    }

    public Function getFunction() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(float[][] t2) throws RemoteException, VisADException {
        if (t2 == null || t2[0] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Null table");
        }
        if (t2.length != this.components) {
            if (t2[0].length == this.components) {
                throw new DisplayException(this.getClass().getName() + ".setTable: " + " Table may be inverted");
            }
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Unusable table [" + t2.length + "][" + t2[0].length + "], expected [" + this.components + "][]");
        }
        if (t2[0] == null || t2[1] == null || t2[2] == null || t2.length > 3 && t2[3] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "One or more component lists is null");
        }
        if (t2[0].length != t2[1].length || t2[0].length != t2[2].length || this.components > 3 && t2[0].length != t2[3].length) {
            throw new DisplayException("BaseColorControl.setTable: Inconsistent table lengths");
        }
        Object object = this.lock;
        synchronized (object) {
            this.tableLength = t2[0].length;
            this.table = new float[this.components][this.tableLength];
            int j = 0;
            while (j < this.components) {
                System.arraycopy(t2[j], 0, this.table[j], 0, this.tableLength);
                ++j;
            }
            this.function = null;
        }
        this.changeControl(true);
    }

    public float[][] getTable() {
        if (this.table == null) {
            return null;
        }
        float[][] t2 = new float[this.components][this.tableLength];
        int j = 0;
        while (j < this.components) {
            System.arraycopy(this.table[j], 0, t2[j], 0, this.tableLength);
            ++j;
        }
        return t2;
    }

    public String getSaveString() {
        if (this.table == null) {
            return null;
        }
        int len = this.table.length;
        int len0 = this.table[0].length;
        StringBuffer sb = new StringBuffer(15 * len * len0);
        sb.append(len);
        sb.append(" x ");
        sb.append(len0);
        sb.append('\n');
        int j = 0;
        while (j < len0) {
            sb.append(this.table[0][j]);
            int i = 1;
            while (i < len) {
                sb.append(' ');
                sb.append(this.table[i][j]);
                ++i;
            }
            sb.append('\n');
            ++j;
        }
        return sb.toString();
    }

    public void setSaveString(String save) throws RemoteException, VisADException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 3) {
            throw new VisADException("Invalid save string");
        }
        int len = Convert.getInt(st.nextToken());
        if (len < 1) {
            throw new VisADException("First dimension is not positive");
        }
        if (!st.nextToken().equalsIgnoreCase("x")) {
            throw new VisADException("Invalid save string");
        }
        int len0 = Convert.getInt(st.nextToken());
        if (len0 < 1) {
            throw new VisADException("Second dimension is not positive");
        }
        if (numTokens < 3 + len * len0) {
            throw new VisADException("Not enough table entries");
        }
        float[][] t2 = new float[len][len0];
        int j = 0;
        while (j < len0) {
            int i = 0;
            while (i < len) {
                t2[i][j] = Convert.getFloat(st.nextToken());
                ++i;
            }
            ++j;
        }
        this.setTable(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[][] lookupValues(float[] values) throws RemoteException, VisADException {
        if (values == null) {
            return null;
        }
        int tblEnd = this.tableLength - 1;
        int valLen = values.length;
        float[][] colors = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.table != null) {
                colors = new float[this.components][valLen];
                float scale = this.tableLength;
                try {
                    int i = 0;
                    while (i < valLen) {
                        if (values[i] != values[i]) {
                            colors[0][i] = Float.NaN;
                            colors[1][i] = Float.NaN;
                            colors[2][i] = Float.NaN;
                            if (this.components > 3) {
                                colors[3][i] = Float.NaN;
                            }
                        } else {
                            int j = (int)(scale * values[i]);
                            if (j < 0) {
                                colors[0][i] = this.table[0][0];
                                colors[1][i] = this.table[1][0];
                                colors[2][i] = this.table[2][0];
                                if (this.components > 3) {
                                    colors[3][i] = this.table[3][0];
                                }
                            } else if (this.tableLength <= j) {
                                colors[0][i] = this.table[0][tblEnd];
                                colors[1][i] = this.table[1][tblEnd];
                                colors[2][i] = this.table[2][tblEnd];
                                if (this.components > 3) {
                                    colors[3][i] = this.table[3][tblEnd];
                                }
                            } else {
                                colors[0][i] = this.table[0][j];
                                colors[1][i] = this.table[1][j];
                                colors[2][i] = this.table[2][j];
                                if (this.components > 3) {
                                    colors[3][i] = this.table[3][j];
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e2) {}
            } else if (this.function != null) {
                List1DSet set = new List1DSet(values, this.functionDomainType, this.functionCoordinateSystem, this.functionUnits);
                Field field = this.function.resample(set, 101, 202);
                colors = Set.doubleToFloat(field.getValues());
            }
        }
        return colors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[][] lookupRange(int left, int right) throws VisADException, RemoteException {
        if (left < 0 || right >= this.tableLength || left > right) {
            throw new VisADException("Bad left/right value");
        }
        int tblEnd = this.tableLength - 1;
        int valLen = right - left + 1;
        float[][] colors = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.table != null) {
                colors = new float[this.components][valLen];
                int i = 0;
                while (i < valLen) {
                    colors[0][i] = this.table[0][i + left];
                    colors[1][i] = this.table[1][i + left];
                    colors[2][i] = this.table[2][i + left];
                    if (this.components > 3) {
                        colors[3][i] = this.table[3][i + left];
                    }
                    ++i;
                }
            } else if (this.function != null) {
                double scale = this.tableLength;
                Linear1DSet set = new Linear1DSet((MathType)this.functionDomainType, (double)left / scale, (double)right / scale, valLen, this.functionCoordinateSystem, this.functionUnits, null);
                Field field = this.function.resample(set, 100, 202);
                colors = Set.doubleToFloat(field.getValues());
            }
        }
        return colors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int left, int right, float[][] colors) throws VisADException, RemoteException {
        if (left < 0 || right >= this.tableLength || left > right) {
            throw new VisADException("Bad left/right value");
        }
        if (colors == null || colors.length != this.components || colors[0] == null || colors[1] == null || colors[2] == null || colors.length > 3 && colors[3] == null) {
            throw new VisADException("Bad range table!");
        }
        if (this.table == null) {
            throw new VisADException("Cannot set values for function!");
        }
        int valLen = right - left + 1;
        if (colors[0].length != valLen || colors[1].length != valLen || colors[2].length != valLen || colors.length > 3 && colors[3].length != valLen) {
            throw new VisADException("Array does not contain " + valLen + " colors!");
        }
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < valLen) {
                this.table[0][i + left] = colors[0][i];
                this.table[1][i + left] = colors[1][i];
                this.table[2][i + left] = colors[2][i];
                if (this.components > 3) {
                    this.table[3][i + left] = colors[3][i];
                }
                ++i;
            }
        }
        this.changeControl(true);
    }

    private boolean tableEquals(float[][] newTable) {
        if (this.table == null) {
            if (newTable != null) {
                return false;
            }
        } else {
            if (newTable == null) {
                return false;
            }
            if (this.table != newTable) {
                if (this.table.length != newTable.length) {
                    return false;
                }
                int i = 0;
                while (i < this.table.length) {
                    if (this.table[i].length != newTable[i].length) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.table.length) {
                    int j = 0;
                    while (j < this.table[i].length) {
                        if (!Util.isApproximatelyEqual(this.table[i][j], newTable[i][j])) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    private boolean functionEquals(Function newFunc) {
        if (this.function == null) {
            if (newFunc != null) {
                return false;
            }
        } else {
            if (newFunc == null) {
                return false;
            }
            if (!this.function.equals(newFunc)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncControl(Control rmt) throws VisADException {
        boolean functionChanged;
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof BaseColorControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        BaseColorControl bcc = (BaseColorControl)rmt;
        boolean changed = false;
        boolean tableChanged = !this.tableEquals(bcc.table);
        boolean bl = functionChanged = !this.functionEquals(bcc.function);
        if (tableChanged) {
            if (bcc.table == null) {
                if (functionChanged ? bcc.function == null : this.function == null) {
                    throw new VisADException("BaseColorControl has null Table, but no Function");
                }
                this.table = null;
            } else {
                if (bcc.table.length != this.components) {
                    throw new VisADException("Table must be float[" + this.components + "][], not float[" + bcc.table.length + "][]");
                }
                Object object = this.lock;
                synchronized (object) {
                    this.tableLength = bcc.table[0].length;
                    int i = 0;
                    while (i < this.components) {
                        if (this.table[i].length != bcc.table[i].length) {
                            this.table[i] = new float[bcc.table[i].length];
                        }
                        System.arraycopy(bcc.table[i], 0, this.table[i], 0, bcc.table[i].length);
                        ++i;
                    }
                    this.tableLength = this.table[0].length;
                    this.function = null;
                }
                try {
                    this.changeControl(true);
                }
                catch (RemoteException re) {
                    throw new VisADException("Could not indicate that control changed: " + re.getMessage());
                }
            }
        }
        if (functionChanged) {
            if (bcc.function == null) {
                if (this.table == null) {
                    throw new VisADException("ColorControl has null Function, but no Table");
                }
                this.function = null;
            } else {
                try {
                    this.setFunction(bcc.function);
                }
                catch (RemoteException re) {
                    throw new VisADException("Could not set function: " + re.getMessage());
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BaseColorControl bcc = (BaseColorControl)o;
        if (this.tableLength != bcc.tableLength) {
            return false;
        }
        if (!this.tableEquals(bcc.table)) {
            return false;
        }
        return this.functionEquals(bcc.function);
    }

    public Object clone() {
        BaseColorControl bcc = (BaseColorControl)super.clone();
        if (this.table != null) {
            bcc.table = new float[this.table.length][];
            int i = this.table.length - 1;
            while (i >= 0) {
                bcc.table[i] = (float[])this.table[i].clone();
                --i;
            }
        }
        return bcc;
    }

    private static char dirChar(int down, int same, int up) {
        if (down == 0 || same == 0 || up == 0) {
            if (down > 0) {
                if (up > 0) {
                    if (down > up) {
                        return 'v';
                    }
                    return '^';
                }
                if (same > 0) {
                    return '~';
                }
                return '\\';
            }
            if (up > 0) {
                if (same > 0) {
                    return '~';
                }
                return '/';
            }
            return '_';
        }
        if (down > same) {
            if (down > same + up) {
                return '\\';
            }
            if (up > down + same) {
                return '/';
            }
            if (up > same) {
                return '^';
            }
        }
        if (up > same) {
            if (up > down + same) {
                return '/';
            }
            if (down > same + up) {
                return '\\';
            }
        }
        if (same > down + up) {
            return '-';
        }
        return '~';
    }

    public String toString() {
        int binLen = this.tableLength;
        int binSize = 1;
        while (binLen > 32) {
            binLen >>= 1;
            binSize <<= 1;
        }
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        StringBuffer buf = new StringBuffer(className);
        buf.append('[');
        String colorInitial = "RGBA";
        int c2 = 0;
        while (c2 < this.components) {
            if (c2 > 0) {
                buf.append(',');
            }
            buf.append(colorInitial.charAt(c2));
            buf.append('=');
            float prev = this.table[c2][0];
            int tot = 0;
            while (tot < this.tableLength) {
                int trendUp = 0;
                int trendSame = 0;
                int trendDown = 0;
                int i = 0;
                while (i < binSize) {
                    float curr = this.table[c2][tot + i];
                    if ((double)Math.abs(curr - prev) <= 1.0E-4) {
                        ++trendSame;
                    } else if (curr < prev) {
                        ++trendDown;
                    } else {
                        ++trendUp;
                    }
                    prev = curr;
                    ++i;
                }
                buf.append(BaseColorControl.dirChar(trendDown, trendSame, trendUp));
                tot += binSize;
            }
            ++c2;
        }
        buf.append(']');
        return buf.toString();
    }
}

