/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.VisADException;

class ContourStrip {
    int[] idx_array;
    int low_idx;
    int hi_idx;
    int lev_idx;
    PlotDigits plot;
    ContourStripSet css;
    float lbl_half;

    ContourStrip(int mxsize, int lev_idx, int idx0, int idx1, PlotDigits plot, ContourStripSet css) {
        this.idx_array = new int[mxsize];
        this.lev_idx = lev_idx;
        this.plot = plot;
        this.low_idx = mxsize / 2;
        this.hi_idx = this.low_idx + 1;
        this.idx_array[this.low_idx] = idx0;
        this.idx_array[this.hi_idx] = idx1;
        this.css = css;
        this.lbl_half = (css.plot_min_max[lev_idx][1] - css.plot_min_max[lev_idx][0]) / 2.0f;
        this.lbl_half = (float)((double)this.lbl_half + (double)this.lbl_half * 0.3);
    }

    ContourStrip(int[] idx_array, int lev_idx, PlotDigits plot, ContourStripSet css) {
        this.lev_idx = lev_idx;
        int mxsize = idx_array.length + 400;
        this.idx_array = new int[mxsize];
        this.plot = plot;
        this.low_idx = mxsize / 2 - idx_array.length / 2;
        this.hi_idx = this.low_idx + idx_array.length - 1;
        System.arraycopy(idx_array, 0, this.idx_array, this.low_idx, idx_array.length);
        this.css = css;
        this.lbl_half = (css.plot_min_max[lev_idx][1] - css.plot_min_max[lev_idx][0]) / 2.0f;
        this.lbl_half = (float)((double)this.lbl_half + (double)this.lbl_half * 0.3);
    }

    boolean addPair(float[] vx, float[] vy, int idx0, int idx1) {
        float vx0 = vx[idx0];
        float vy0 = vy[idx0];
        float vx1 = vx[idx1];
        float vy1 = vy[idx1];
        float vx_s = vx[this.idx_array[this.low_idx]];
        float vy_s = vy[this.idx_array[this.low_idx]];
        float dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.low_idx < 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            --this.low_idx;
            this.idx_array[this.low_idx] = idx0;
            --this.low_idx;
            this.idx_array[this.low_idx] = idx1;
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.low_idx < 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            --this.low_idx;
            this.idx_array[this.low_idx] = idx1;
            --this.low_idx;
            this.idx_array[this.low_idx] = idx0;
            return true;
        }
        vx_s = vx[this.idx_array[this.hi_idx]];
        vy_s = vy[this.idx_array[this.hi_idx]];
        dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.hi_idx > this.idx_array.length - 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx0;
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx1;
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.hi_idx > this.idx_array.length - 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx1;
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx0;
            return true;
        }
        return false;
    }

    void getLabeledLineColorArray(float[] vx, float[] vy, byte[][] colors, float[][][] out_vv, byte[][][] out_colors, float[][][][] out_vvL, byte[][][][] out_colorsL, float[][][] lbl_loc) {
        float[][] lbl_dcoords;
        byte[][] lbl_clr;
        float[] vxB_tmp;
        float[] vy_tmp;
        float[][] vv = null;
        float[][] vv_grid = this.getLineArray(vx, vy);
        try {
            vv = this.css.spatial_set.gridToValue(vv_grid);
        }
        catch (VisADException e2) {
            System.out.println(e2.getMessage());
        }
        byte[][] bb = this.getColorArray(colors);
        int clr_dim = 0;
        if (colors != null) {
            clr_dim = colors.length;
        }
        int n_lbl = 1;
        out_vvL[0] = null;
        out_colorsL[0] = null;
        out_vvL[1] = null;
        out_colorsL[1] = null;
        lbl_loc[0] = null;
        out_vvL[2] = null;
        out_colorsL[2] = null;
        out_vvL[3] = null;
        out_colorsL[3] = null;
        lbl_loc[1] = null;
        lbl_loc[2] = null;
        out_vv[0] = vv;
        out_colors[0] = bb;
        out_vv[1] = null;
        out_colors[1] = null;
        if (vv[0].length > 20 && (this.lev_idx & 1) == 1) {
            int cc;
            float ctr_dist;
            float dz;
            float dy;
            float dx;
            int loc = vv[0].length / 2;
            int start_break = 0;
            int stop_break = 0;
            int n_pairs_b = 1;
            int n_pairs_f = 1;
            boolean found = false;
            int pos = loc;
            while (!found) {
                if ((pos -= 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                dx = vv[0][pos] - vv[0][loc];
                dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)this.lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_b;
            }
            pos = loc;
            found = false;
            while (!found) {
                if ((pos += 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                dx = vv[0][pos] - vv[0][loc];
                dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)this.lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_f;
            }
            int n_skip = (n_pairs_b + n_pairs_f) * 2;
            if ((loc & 1) == 1) {
                start_break = loc - (1 + (n_pairs_b - 1) * 2);
                stop_break = loc + (2 + (n_pairs_f - 1) * 2);
            } else {
                start_break = loc - (2 + (n_pairs_b - 1) * 2);
                stop_break = loc + (1 + (n_pairs_f - 1) * 2);
            }
            float[] vx_tmp = new float[this.plot.NumVerts];
            vy_tmp = new float[this.plot.NumVerts];
            System.arraycopy(this.plot.Vx, 0, vx_tmp, 0, this.plot.NumVerts);
            System.arraycopy(this.plot.Vy, 0, vy_tmp, 0, this.plot.NumVerts);
            vxB_tmp = new float[this.plot.NumVerts];
            float[] vyB_tmp = new float[this.plot.NumVerts];
            System.arraycopy(this.plot.VxB, 0, vxB_tmp, 0, this.plot.NumVerts);
            System.arraycopy(this.plot.VyB, 0, vyB_tmp, 0, this.plot.NumVerts);
            lbl_clr = null;
            if (bb != null) {
                lbl_clr = new byte[clr_dim][this.plot.NumVerts];
            }
            boolean rotate = true;
            lbl_dcoords = null;
            if (rotate) {
                float[][] norm = null;
                Gridded3DSet cg3d = this.css.spatial_set;
                try {
                    norm = cg3d.getNormals(new float[][]{{vv_grid[0][loc]}, {vv_grid[1][loc]}});
                }
                catch (VisADException e3) {
                    System.out.println(e3.getMessage());
                }
                if (norm[2][0] < 0.0f) {
                    norm[0][0] = -norm[0][0];
                    norm[1][0] = -norm[1][0];
                    norm[2][0] = -norm[2][0];
                }
                float del_z = vv[2][stop_break] - vv[2][start_break];
                float del_y = vv[1][stop_break] - vv[1][start_break];
                float del_x = vv[0][stop_break] - vv[0][start_break];
                float mag = (float)Math.sqrt(del_y * del_y + del_x * del_x + del_z * del_z);
                float[] fArray = new float[]{del_x / mag, del_y / mag, del_z / mag};
                float[] ctr_u = fArray;
                if (ctr_u[0] < 0.0f) {
                    ctr_u[0] = -ctr_u[0];
                    ctr_u[1] = -ctr_u[1];
                    ctr_u[2] = -ctr_u[2];
                }
                float[] norm_x_ctr = new float[]{norm[1][0] * ctr_u[2] - norm[2][0] * ctr_u[1], -(norm[0][0] * ctr_u[2] - norm[2][0] * ctr_u[0]), norm[0][0] * ctr_u[1] - norm[1][0] * ctr_u[0]};
                mag = (float)Math.sqrt(norm_x_ctr[0] * norm_x_ctr[0] + norm_x_ctr[1] * norm_x_ctr[1] + norm_x_ctr[2] * norm_x_ctr[2]);
                norm_x_ctr[0] = norm_x_ctr[0] / mag;
                norm_x_ctr[1] = norm_x_ctr[1] / mag;
                norm_x_ctr[2] = norm_x_ctr[2] / mag;
                if (Math.abs((double)norm[2][0]) <= 1.0E-5) {
                    if (norm_x_ctr[2] < 0.0f) {
                        norm_x_ctr[0] = -norm_x_ctr[0];
                        norm_x_ctr[1] = -norm_x_ctr[1];
                        norm_x_ctr[2] = -norm_x_ctr[2];
                    }
                } else if (norm_x_ctr[1] < 0.0f) {
                    norm_x_ctr[0] = -norm_x_ctr[0];
                    norm_x_ctr[1] = -norm_x_ctr[1];
                    norm_x_ctr[2] = -norm_x_ctr[2];
                }
                lbl_dcoords = new float[3][this.plot.NumVerts];
                int kk = 0;
                while (kk < this.plot.NumVerts) {
                    lbl_dcoords[0][kk] = vx_tmp[kk] * ctr_u[0] + vyB_tmp[kk] * norm_x_ctr[0];
                    lbl_dcoords[1][kk] = vx_tmp[kk] * ctr_u[1] + vyB_tmp[kk] * norm_x_ctr[1];
                    lbl_dcoords[2][kk] = vx_tmp[kk] * ctr_u[2] + vyB_tmp[kk] * norm_x_ctr[2];
                    ++kk;
                }
                int kk2 = 0;
                while (kk2 < this.plot.NumVerts) {
                    float[] fArray2 = lbl_dcoords[0];
                    int n = kk2;
                    fArray2[n] = fArray2[n] + vv[0][loc];
                    float[] fArray3 = lbl_dcoords[1];
                    int n2 = kk2;
                    fArray3[n2] = fArray3[n2] + vv[1][loc];
                    float[] fArray4 = lbl_dcoords[2];
                    int n3 = kk2++;
                    fArray4[n3] = fArray4[n3] + vv[2][loc];
                }
            }
            int kk = 0;
            while (kk < this.plot.NumVerts) {
                int n = kk;
                vx_tmp[n] = vx_tmp[n] + vv[0][loc];
                int n4 = kk;
                vy_tmp[n4] = vy_tmp[n4] + vv[1][loc];
                int n5 = kk;
                vxB_tmp[n5] = vxB_tmp[n5] + vv[0][loc];
                int n6 = kk;
                vyB_tmp[n6] = vyB_tmp[n6] + vv[1][loc];
                if (bb != null) {
                    lbl_clr[0][kk] = bb[0][loc];
                    lbl_clr[1][kk] = bb[1][loc];
                    lbl_clr[2][kk] = bb[2][loc];
                }
                ++kk;
            }
            out_vvL[0] = new float[n_lbl][][];
            out_colorsL[0] = new byte[n_lbl][][];
            out_vvL[1] = new float[n_lbl][][];
            out_colorsL[1] = new byte[n_lbl][][];
            lbl_loc[0] = new float[n_lbl][7];
            lbl_loc[0][0][0] = vv[0][loc];
            lbl_loc[0][0][1] = vv[1][loc];
            lbl_loc[0][0][2] = vv[2][loc];
            out_vv[0] = new float[3][vv[0].length - n_skip];
            out_vv[1] = new float[3][n_skip];
            if (bb != null) {
                out_colors[0] = new byte[clr_dim][bb[0].length - n_skip];
                out_colors[1] = new byte[clr_dim][n_skip];
            }
            int s_pos = 0;
            int d_pos = 0;
            int cnt = start_break;
            System.arraycopy(vv[0], s_pos, out_vv[0][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[0][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[0][2], d_pos, cnt);
            if (bb != null) {
                int cc2 = 0;
                while (cc2 < clr_dim) {
                    System.arraycopy(bb[cc2], s_pos, out_colors[0][cc2], d_pos, cnt);
                    ++cc2;
                }
            }
            s_pos = start_break;
            d_pos = 0;
            cnt = n_skip;
            System.arraycopy(vv[0], s_pos, out_vv[1][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[1][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[1][2], d_pos, cnt);
            if (bb != null) {
                int cc3 = 0;
                while (cc3 < clr_dim) {
                    System.arraycopy(bb[cc3], s_pos, out_colors[1][cc3], d_pos, cnt);
                    ++cc3;
                }
            }
            s_pos = stop_break + 1;
            d_pos = start_break;
            cnt = vv[0].length - s_pos;
            System.arraycopy(vv[0], s_pos, out_vv[0][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[0][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[0][2], d_pos, cnt);
            if (bb != null) {
                int cc4 = 0;
                while (cc4 < clr_dim) {
                    System.arraycopy(bb[cc4], s_pos, out_colors[0][cc4], d_pos, cnt);
                    ++cc4;
                }
            }
            out_vvL[2] = new float[n_lbl][3][2];
            out_vvL[3] = new float[n_lbl][3][2];
            lbl_loc[1] = new float[n_lbl][3];
            lbl_loc[2] = new float[n_lbl][3];
            if (bb != null) {
                out_colorsL[2] = new byte[n_lbl][clr_dim][2];
                out_colorsL[3] = new byte[n_lbl][clr_dim][2];
            }
            s_pos = start_break;
            d_pos = 0;
            cnt = 2;
            lbl_loc[1][0][0] = vv[0][s_pos];
            lbl_loc[1][0][1] = vv[1][s_pos];
            lbl_loc[1][0][2] = vv[2][s_pos];
            float dx2 = vv[0][loc] - vv[0][s_pos];
            float dy2 = vv[1][loc] - vv[1][s_pos];
            float dz2 = vv[2][loc] - vv[2][s_pos];
            float dd = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            dx2 /= dd;
            dy2 /= dd;
            dz2 /= dd;
            float mm = dd - (float)Math.abs((double)this.lbl_half);
            dx2 *= mm;
            dy2 *= mm;
            dz2 *= mm;
            out_vvL[2][0][0][0] = vv[0][s_pos];
            out_vvL[2][0][1][0] = vv[1][s_pos];
            out_vvL[2][0][2][0] = vv[2][s_pos];
            out_vvL[2][0][0][1] = vv[0][s_pos] + dx2;
            out_vvL[2][0][1][1] = vv[1][s_pos] + dy2;
            out_vvL[2][0][2][1] = vv[2][s_pos] + dz2;
            lbl_loc[0][0][3] = this.lbl_half;
            lbl_loc[0][0][4] = dd;
            if (bb != null) {
                cc = 0;
                while (cc < clr_dim) {
                    System.arraycopy(bb[cc], s_pos, out_colorsL[2][0][cc], d_pos, cnt);
                    ++cc;
                }
            }
            s_pos = stop_break - 1;
            d_pos = 0;
            cnt = 2;
            lbl_loc[2][0][0] = vv[0][stop_break];
            lbl_loc[2][0][1] = vv[1][stop_break];
            lbl_loc[2][0][2] = vv[2][stop_break];
            dx2 = vv[0][loc] - vv[0][stop_break];
            dy2 = vv[1][loc] - vv[1][stop_break];
            dz2 = vv[2][loc] - vv[2][stop_break];
            dd = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            dx2 /= dd;
            dy2 /= dd;
            dz2 /= dd;
            mm = dd - (float)Math.abs((double)this.lbl_half);
            dx2 *= mm;
            dy2 *= mm;
            dz2 *= mm;
            out_vvL[3][0][0][0] = vv[0][stop_break];
            out_vvL[3][0][1][0] = vv[1][stop_break];
            out_vvL[3][0][2][0] = vv[2][stop_break];
            out_vvL[3][0][0][1] = vv[0][stop_break] + dx2;
            out_vvL[3][0][1][1] = vv[1][stop_break] + dy2;
            out_vvL[3][0][2][1] = vv[2][stop_break] + dz2;
            lbl_loc[0][0][5] = this.lbl_half;
            lbl_loc[0][0][6] = dd;
            if (bb != null) {
                cc = 0;
                while (cc < clr_dim) {
                    System.arraycopy(bb[cc], s_pos, out_colorsL[3][0][cc], d_pos, cnt);
                    ++cc;
                }
            }
        } else {
            out_vv[0] = vv;
            out_colors[0] = bb;
            out_vv[1] = null;
            out_colors[1] = null;
            return;
        }
        out_vvL[0][0] = new float[3][];
        out_vvL[0][0][0] = lbl_dcoords[0];
        out_vvL[0][0][1] = vy_tmp;
        out_colorsL[0][0] = lbl_clr;
        out_vvL[1][0] = new float[3][];
        out_vvL[1][0][0] = vxB_tmp;
        out_vvL[1][0][1] = lbl_dcoords[1];
        out_colorsL[1][0] = lbl_clr;
        out_vvL[0][0][2] = lbl_dcoords[2];
        out_vvL[1][0][2] = lbl_dcoords[2];
    }

    float[][] getLineArray(float[] vx, float[] vy) {
        float[] vvx = new float[this.hi_idx - this.low_idx + 1];
        float[] vvy = new float[vvx.length];
        int ii = 0;
        int kk = this.low_idx;
        while (kk <= this.hi_idx) {
            vvx[ii] = vx[this.idx_array[kk]];
            vvy[ii] = vy[this.idx_array[kk]];
            ++ii;
            ++kk;
        }
        return new float[][]{vvx, vvy};
    }

    byte[][] getColorArray(byte[][] colors) {
        if (colors == null) {
            return null;
        }
        int clr_dim = colors.length;
        int clr_len = this.hi_idx - this.low_idx + 1;
        byte[][] new_colors = new byte[clr_dim][clr_len];
        int ii = 0;
        int kk = this.low_idx;
        while (kk <= this.hi_idx) {
            int cc = 0;
            while (cc < clr_dim) {
                new_colors[cc][ii] = colors[cc][this.idx_array[kk]];
                ++cc;
            }
            ++ii;
            ++kk;
        }
        return new_colors;
    }

    ContourStrip merge(ContourStrip c_strp) {
        if (this.lev_idx != c_strp.lev_idx) {
            System.out.println("Contour2D.ContourStrip.merge: !BIG ATTENTION!");
        }
        int[] new_idx_array = null;
        int[] thisLo = new int[2];
        int[] thisHi = new int[2];
        int[] thatLo = new int[2];
        int[] thatHi = new int[2];
        thisLo[0] = this.idx_array[this.low_idx];
        thisLo[1] = this.idx_array[this.low_idx + 1];
        thisHi[0] = this.idx_array[this.hi_idx];
        thisHi[1] = this.idx_array[this.hi_idx - 1];
        thatLo[0] = c_strp.idx_array[c_strp.low_idx];
        thatLo[1] = c_strp.idx_array[c_strp.low_idx + 1];
        thatHi[0] = c_strp.idx_array[c_strp.hi_idx];
        thatHi[1] = c_strp.idx_array[c_strp.hi_idx - 1];
        if (thisLo[0] == thatLo[0] || thisLo[0] == thatLo[1] || thisLo[1] == thatLo[0] || thisLo[1] == thatLo[1]) {
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            int kk = this.hi_idx;
            while (kk >= this.low_idx) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
                --kk;
            }
            int kk2 = c_strp.low_idx + 2;
            while (kk2 <= c_strp.hi_idx) {
                new_idx_array[ii] = c_strp.idx_array[kk2];
                ++ii;
                ++kk2;
            }
        } else if (thisLo[0] == thatHi[0] || thisLo[0] == thatHi[1] || thisLo[1] == thatHi[0] || thisLo[1] == thatHi[1]) {
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            int kk = this.hi_idx;
            while (kk >= this.low_idx) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
                --kk;
            }
            int kk3 = c_strp.hi_idx - 2;
            while (kk3 >= c_strp.low_idx) {
                new_idx_array[ii] = c_strp.idx_array[kk3];
                ++ii;
                --kk3;
            }
        } else if (thisHi[0] == thatHi[0] || thisHi[0] == thatHi[1] || thisHi[1] == thatHi[0] || thisHi[1] == thatHi[1]) {
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            int kk = this.low_idx;
            while (kk <= this.hi_idx) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
                ++kk;
            }
            int kk4 = c_strp.hi_idx - 2;
            while (kk4 >= c_strp.low_idx) {
                new_idx_array[ii] = c_strp.idx_array[kk4];
                ++ii;
                --kk4;
            }
        } else if (thisHi[0] == thatLo[0] || thisHi[0] == thatLo[1] || thisHi[1] == thatLo[0] || thisHi[1] == thatLo[1]) {
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            int kk = this.low_idx;
            while (kk <= this.hi_idx) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
                ++kk;
            }
            int kk5 = c_strp.low_idx + 2;
            while (kk5 <= c_strp.hi_idx) {
                new_idx_array[ii] = c_strp.idx_array[kk5];
                ++ii;
                ++kk5;
            }
        } else {
            return null;
        }
        return new ContourStrip(new_idx_array, this.lev_idx, this.plot, this.css);
    }

    public String toString() {
        return "(" + this.idx_array[this.low_idx] + "," + this.idx_array[this.low_idx + 1] + "), (" + this.idx_array[this.hi_idx] + "," + this.idx_array[this.hi_idx - 1] + ")";
    }
}

