/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.CoordinateSystemException;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public abstract class CoordinateSystem
implements Serializable {
    private final RealTupleType Reference;
    private final int DomainDimension;
    private final Unit[] CoordinateSystemUnits;

    public CoordinateSystem(RealTupleType reference, Unit[] units) throws VisADException {
        if (reference == null) {
            throw new CoordinateSystemException("CoordinateSystem: Reference may not be null");
        }
        if (reference.getCoordinateSystem() != null) {
            throw new CoordinateSystemException("CoordinateSystem: Reference may not have a DefaultCoordinateSystem");
        }
        this.Reference = reference;
        this.DomainDimension = this.Reference.getDimension();
        if (units != null && this.DomainDimension != units.length) {
            throw new UnitException("CoordinateSystem: units dimension does not match");
        }
        this.CoordinateSystemUnits = new Unit[this.DomainDimension];
        if (units != null) {
            int i = 0;
            while (i < this.DomainDimension) {
                this.CoordinateSystemUnits[i] = units[i];
                ++i;
            }
        }
    }

    CoordinateSystem(RealTupleType reference, Unit[] units, boolean b2) {
        this.Reference = reference;
        this.DomainDimension = this.Reference.getDimension();
        this.CoordinateSystemUnits = new Unit[this.DomainDimension];
        if (units != null) {
            int i = 0;
            while (i < this.DomainDimension) {
                this.CoordinateSystemUnits[i] = units[i];
                ++i;
            }
        }
    }

    public RealTupleType getReference() {
        return this.Reference;
    }

    public int getDimension() {
        return this.DomainDimension;
    }

    public Unit[] getReferenceUnits() {
        return this.Reference.getDefaultUnits();
    }

    public Unit[] getCoordinateSystemUnits() {
        return Unit.copyUnitsArray(this.CoordinateSystemUnits);
    }

    public abstract double[][] toReference(double[][] var1) throws VisADException;

    public abstract double[][] fromReference(double[][] var1) throws VisADException;

    public float[][] toReference(float[][] value) throws VisADException {
        double[][] val = Set.floatToDouble(value);
        val = this.toReference(val);
        return Set.doubleToFloat(val);
    }

    public float[][] fromReference(float[][] value) throws VisADException {
        double[][] val = Set.floatToDouble(value);
        val = this.fromReference(val);
        return Set.doubleToFloat(val);
    }

    public static boolean canConvert(RealTupleType out, CoordinateSystem coord_out, RealTupleType in, CoordinateSystem coord_in) {
        if (out == null) {
            return in == null;
        }
        if (out.equals(in)) {
            return true;
        }
        RealTupleType ref_out = out;
        if (coord_out != null) {
            ref_out = coord_out.getReference();
        }
        RealTupleType ref_in = in;
        if (coord_in != null) {
            ref_in = coord_in.getReference();
        }
        return ref_out.equals(ref_in);
    }

    public static double[][] transformCoordinates(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, ErrorEstimate[] errors_in, double[][] value) throws VisADException {
        int n = out.getDimension();
        Unit[] units_free = new Unit[n];
        double[][] old_value = value;
        if ((value = CoordinateSystem.transformCoordinatesFreeUnits(out, coord_out, units_free, errors_out, in, coord_in, units_in, errors_in, value)) == old_value) {
            value = new double[n][];
            int i = 0;
            while (i < n) {
                value[i] = old_value[i];
                ++i;
            }
        }
        ErrorEstimate[] sub_errors_out = new ErrorEstimate[1];
        if (errors_out == null) {
            int i = 0;
            while (i < n) {
                value[i] = Unit.transformUnits(units_out[i], sub_errors_out, units_free[i], null, value[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                value[i] = Unit.transformUnits(units_out[i], sub_errors_out, units_free[i], errors_out[i], value[i]);
                errors_out[i] = sub_errors_out[0];
                ++i;
            }
        }
        return value;
    }

    public static double[][] transformCoordinatesFreeUnits(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, ErrorEstimate[] errors_in, double[][] value) throws VisADException {
        Unit[] units;
        int i;
        int n = in.getDimension();
        double[][] error_values = new double[1][1];
        boolean any_transform = false;
        boolean any_errors = false;
        if (errors_in != null && errors_out != null) {
            any_errors = true;
            i = 0;
            while (i < n) {
                if (errors_in[i] == null) {
                    any_errors = false;
                }
                ++i;
            }
        }
        if (errors_out != null) {
            if (errors_in != null) {
                i = 0;
                while (i < n) {
                    errors_out[i] = errors_in[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < n) {
                    errors_out[i] = null;
                    ++i;
                }
            }
        }
        if ((units = Unit.copyUnitsArray(units_in)) == null) {
            units = new Unit[n];
        }
        Unit[] error_units = Unit.copyUnitsArray(units);
        if (units_out != null) {
            int i2 = 0;
            while (i2 < n) {
                units_out[i2] = units[i2];
                ++i2;
            }
        }
        if (coord_out == null) {
            coord_out = out.getCoordinateSystem();
        }
        if (coord_in == null) {
            coord_in = in.getCoordinateSystem();
        }
        if (out.equals(in)) {
            if (coord_in == null && coord_out == null) {
                return value;
            }
            if (coord_in == null || coord_out == null) {
                throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: inconsistency");
            }
            if (!coord_in.equals(coord_out)) {
                if (any_errors) {
                    if (!any_transform) {
                        error_values = ErrorEstimate.init_error_values(errors_in);
                    }
                    any_transform = true;
                    error_values = coord_in.toReference(error_values, error_units);
                    error_values = coord_out.fromReference(error_values, error_units);
                }
                value = coord_in.toReference(value, units);
                value = coord_out.fromReference(value, units);
            }
        } else {
            RealTupleType ref_out = out;
            if (coord_out != null) {
                ref_out = coord_out.getReference();
                if (out.getCoordinateSystem() == null || !out.getCoordinateSystem().getReference().equals(ref_out)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: out References don't match");
                }
            }
            RealTupleType ref_in = in;
            if (coord_in != null) {
                ref_in = coord_in.getReference();
                if (in.getCoordinateSystem() == null || !in.getCoordinateSystem().getReference().equals(ref_in)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: in References don't match");
                }
            }
            if (ref_out.equals(ref_in)) {
                if (!in.equals(ref_in)) {
                    if (any_errors) {
                        if (!any_transform) {
                            error_values = ErrorEstimate.init_error_values(errors_in);
                        }
                        any_transform = true;
                        error_values = coord_in.toReference(error_values, error_units);
                    }
                    value = coord_in.toReference(value, units);
                }
                if (!out.equals(ref_out)) {
                    if (any_errors) {
                        if (!any_transform) {
                            error_values = ErrorEstimate.init_error_values(errors_in);
                        }
                        any_transform = true;
                        error_values = coord_out.fromReference(error_values, error_units);
                    }
                    value = coord_out.fromReference(value, units);
                }
            }
        }
        if (units_out != null) {
            int i3 = 0;
            while (i3 < n) {
                units_out[i3] = units[i3];
                ++i3;
            }
        }
        if (any_errors && any_transform) {
            int i4 = 0;
            while (i4 < n) {
                double error = Math.abs(error_values[i4][2 * i4 + 1] - error_values[i4][2 * i4]);
                errors_out[i4] = new ErrorEstimate(value[i4], error, units_out[i4]);
                ++i4;
            }
        }
        return value;
    }

    public static float[][] transformCoordinates(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, ErrorEstimate[] errors_in, float[][] value) throws VisADException {
        int n = out.getDimension();
        Unit[] units_free = new Unit[n];
        float[][] old_value = value;
        if ((value = CoordinateSystem.transformCoordinatesFreeUnits(out, coord_out, units_free, errors_out, in, coord_in, units_in, errors_in, value)) == old_value) {
            value = new float[n][];
            int i = 0;
            while (i < n) {
                value[i] = old_value[i];
                ++i;
            }
        }
        ErrorEstimate[] sub_errors_out = new ErrorEstimate[1];
        if (errors_out == null) {
            int i = 0;
            while (i < n) {
                value[i] = Unit.transformUnits(units_out[i], sub_errors_out, units_free[i], null, value[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                value[i] = Unit.transformUnits(units_out[i], sub_errors_out, units_free[i], errors_out[i], value[i]);
                errors_out[i] = sub_errors_out[0];
                ++i;
            }
        }
        return value;
    }

    public static float[][] transformCoordinatesFreeUnits(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, ErrorEstimate[] errors_in, float[][] value) throws VisADException {
        Unit[] units;
        int i;
        int n = in.getDimension();
        double[][] error_values = new double[1][1];
        boolean any_transform = false;
        boolean any_errors = false;
        if (errors_in != null && errors_out != null) {
            any_errors = true;
            i = 0;
            while (i < n) {
                if (errors_in[i] == null) {
                    any_errors = false;
                }
                ++i;
            }
        }
        if (errors_out != null) {
            if (errors_in != null) {
                i = 0;
                while (i < n) {
                    errors_out[i] = errors_in[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < n) {
                    errors_out[i] = null;
                    ++i;
                }
            }
        }
        if ((units = Unit.copyUnitsArray(units_in)) == null) {
            units = new Unit[n];
        }
        Unit[] error_units = Unit.copyUnitsArray(units);
        if (units_out != null) {
            int i2 = 0;
            while (i2 < n) {
                units_out[i2] = units[i2];
                ++i2;
            }
        }
        if (coord_out == null) {
            coord_out = out.getCoordinateSystem();
        }
        if (coord_in == null) {
            coord_in = in.getCoordinateSystem();
        }
        if (out.equals(in)) {
            if (coord_in == null && coord_out == null) {
                return value;
            }
            if (coord_in == null || coord_out == null) {
                throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: inconsistency");
            }
            if (!coord_in.equals(coord_out)) {
                if (any_errors) {
                    if (!any_transform) {
                        error_values = ErrorEstimate.init_error_values(errors_in);
                    }
                    any_transform = true;
                    error_values = coord_in.toReference(error_values, error_units);
                    error_values = coord_out.fromReference(error_values, error_units);
                }
                value = coord_in.toReference(value, units);
                value = coord_out.fromReference(value, units);
            }
        } else {
            RealTupleType ref_out = out;
            if (coord_out != null) {
                ref_out = coord_out.getReference();
                if (out.getCoordinateSystem() == null || !out.getCoordinateSystem().getReference().equals(ref_out)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: out References don't match");
                }
            }
            RealTupleType ref_in = in;
            if (coord_in != null) {
                ref_in = coord_in.getReference();
                if (in.getCoordinateSystem() == null || !in.getCoordinateSystem().getReference().equals(ref_in)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: in References don't match");
                }
            }
            if (ref_out.equals(ref_in)) {
                if (!in.equals(ref_in)) {
                    if (any_errors) {
                        if (!any_transform) {
                            error_values = ErrorEstimate.init_error_values(errors_in);
                        }
                        any_transform = true;
                        error_values = coord_in.toReference(error_values, error_units);
                    }
                    value = coord_in.toReference(value, units);
                }
                if (!out.equals(ref_out)) {
                    if (any_errors) {
                        if (!any_transform) {
                            error_values = ErrorEstimate.init_error_values(errors_in);
                        }
                        any_transform = true;
                        error_values = coord_out.fromReference(error_values, error_units);
                    }
                    value = coord_out.fromReference(value, units);
                }
            }
        }
        if (units_out != null) {
            int i3 = 0;
            while (i3 < n) {
                units_out[i3] = units[i3];
                ++i3;
            }
        }
        if (any_errors && any_transform) {
            int i4 = 0;
            while (i4 < n) {
                double error = Math.abs(error_values[i4][2 * i4 + 1] - error_values[i4][2 * i4]);
                errors_out[i4] = new ErrorEstimate(value[i4], error, units_out[i4]);
                ++i4;
            }
        }
        return value;
    }

    public double[][] toReference(double[][] value, Unit[] units) throws VisADException {
        Unit[] us;
        int n = value.length;
        if (this.CoordinateSystemUnits != null) {
            int i = 0;
            while (i < n) {
                if (this.CoordinateSystemUnits[i] != null) {
                    value[i] = this.CoordinateSystemUnits[i].toThis(value[i], units[i]);
                }
                ++i;
            }
        }
        if ((us = this.Reference.getDefaultUnits()) != null) {
            int i = 0;
            while (i < n) {
                units[i] = us[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                units[i] = null;
                ++i;
            }
        }
        return this.toReference(value);
    }

    public float[][] toReference(float[][] value, Unit[] units) throws VisADException {
        Unit[] us;
        int n = value.length;
        if (this.CoordinateSystemUnits != null) {
            int i = 0;
            while (i < n) {
                if (this.CoordinateSystemUnits[i] != null) {
                    value[i] = this.CoordinateSystemUnits[i].toThis(value[i], units[i]);
                }
                ++i;
            }
        }
        if ((us = this.Reference.getDefaultUnits()) != null) {
            int i = 0;
            while (i < n) {
                units[i] = us[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                units[i] = null;
                ++i;
            }
        }
        return this.toReference(value);
    }

    public double[][] fromReference(double[][] value, Unit[] units) throws VisADException {
        int i;
        int n = value.length;
        Unit[] us = this.Reference.getDefaultUnits();
        if (us != null) {
            i = 0;
            while (i < n) {
                if (us[i] != null) {
                    value[i] = us[i].toThis(value[i], units[i]);
                }
                ++i;
            }
        }
        if (this.CoordinateSystemUnits != null) {
            i = 0;
            while (i < n) {
                units[i] = this.CoordinateSystemUnits[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                units[i] = null;
                ++i;
            }
        }
        return this.fromReference(value);
    }

    public float[][] fromReference(float[][] value, Unit[] units) throws VisADException {
        int i;
        int n = value.length;
        Unit[] us = this.Reference.getDefaultUnits();
        if (us != null) {
            i = 0;
            while (i < n) {
                if (us[i] != null) {
                    value[i] = us[i].toThis(value[i], units[i]);
                }
                ++i;
            }
        }
        if (this.CoordinateSystemUnits != null) {
            i = 0;
            while (i < n) {
                units[i] = this.CoordinateSystemUnits[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                units[i] = null;
                ++i;
            }
        }
        return this.fromReference(value);
    }

    public abstract boolean equals(Object var1);
}

