/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.DelaunayClarkson;
import visad.DelaunayWatson;
import visad.UnimplementedException;
import visad.VisADException;

public class DelaunayFast
extends Delaunay {
    public static final double ROTATE = 0.17453292519943295;

    private final void qsort(int[] array, float[][] samples, int sIndex, int lo, int hi) {
        if (lo < hi) {
            int pivot = (lo + hi) / 2;
            int swap = array[lo];
            array[lo] = array[pivot];
            array[pivot] = swap;
            pivot = lo;
            int i = lo + 1;
            while (i <= hi) {
                if (samples[sIndex][array[i]] < samples[sIndex][array[lo]]) {
                    swap = array[i];
                    array[i] = array[++pivot];
                    array[pivot] = swap;
                }
                ++i;
            }
            swap = array[lo];
            array[lo] = array[pivot];
            array[pivot] = swap;
            if (lo < pivot - 1) {
                this.qsort(array, samples, sIndex, lo, pivot - 1);
            }
            if (pivot + 1 < hi) {
                this.qsort(array, samples, sIndex, pivot + 1, hi);
            }
        }
    }

    public DelaunayFast(float[][] samples) throws VisADException {
        if (samples.length < 2 || samples.length > 3) {
            throw new VisADException("DelaunayFast: dimension must be 2 or 3");
        }
        if (samples.length == 3) {
            throw new UnimplementedException("DelaunayFast: only two dimensions for now");
        }
        int numpts = Math.min(samples[0].length, samples[1].length);
        if (numpts < 3) {
            throw new VisADException("DelaunayFast: triangulation is futile with less than 3 samples");
        }
        float[][] samp = new float[2][numpts];
        System.arraycopy(samples[0], 0, samp[0], 0, numpts);
        System.arraycopy(samples[1], 0, samp[1], 0, numpts);
        float[] samp0 = samp[0];
        float[] samp1 = samp[1];
        double cosrot = Math.cos(0.17453292519943295);
        double sinrot = Math.sin(0.17453292519943295);
        int i = 0;
        while (i < numpts) {
            double x = samp0[i];
            double y = samp1[i];
            samp0[i] = (float)(x * cosrot - y * sinrot);
            samp1[i] = (float)(y * cosrot + x * sinrot);
            ++i;
        }
        int ntris = 0;
        int tsize = (int)(0.6666667f * (float)numpts) + 10;
        int[][][] tris = new int[tsize][3][];
        int tp = 0;
        int[] nverts = new int[numpts];
        int i2 = 0;
        while (i2 < numpts) {
            nverts[i2] = 0;
            ++i2;
        }
        int ssize = 20;
        int[] ss = new int[ssize + 2];
        int[] se = new int[ssize + 2];
        boolean[] vh = new boolean[ssize + 2];
        boolean[] mp = new boolean[ssize + 2];
        int sp = 0;
        int hsize = 10;
        int[][] hs = new int[hsize + 2][];
        int hsp = 0;
        int[] indices = new int[numpts];
        int i3 = 0;
        while (i3 < numpts) {
            indices[i3] = i3;
            ++i3;
        }
        ++sp;
        ss[0] = 0;
        se[0] = numpts - 1;
        vh[0] = false;
        mp[0] = false;
        while (sp != 0) {
            int h2ups;
            int noh2;
            int nih2;
            int h1ups;
            int noh1;
            int nih1;
            if (hsp > hsize) {
                hsize += hsize;
                int[][] newhs = new int[hsize + 2][];
                System.arraycopy(hs, 0, newhs, 0, hs.length);
                hs = newhs;
            }
            if (sp > ssize) {
                ssize += ssize;
                int[] newss = new int[ssize + 2];
                int[] newse = new int[ssize + 2];
                boolean[] newvh = new boolean[ssize + 2];
                boolean[] newmp = new boolean[ssize + 2];
                System.arraycopy(ss, 0, newss, 0, ss.length);
                System.arraycopy(se, 0, newse, 0, se.length);
                System.arraycopy(vh, 0, newvh, 0, vh.length);
                System.arraycopy(mp, 0, newmp, 0, mp.length);
                ss = newss;
                se = newse;
                vh = newvh;
                mp = newmp;
            }
            int css = ss[--sp];
            int cse = se[sp];
            boolean cvh = vh[sp];
            boolean cmp = mp[sp];
            if (!cmp) {
                int[] hull;
                if (cse - css >= 3) {
                    this.qsort(indices, samp, cvh ? 0 : 1, css, cse);
                    ss[sp] = css;
                    se[sp] = cse;
                    vh[sp] = cvh;
                    mp[sp] = true;
                    int mid = (css + cse) / 2;
                    ss[++sp] = css;
                    se[sp] = mid;
                    vh[sp] = !cvh;
                    mp[sp] = false;
                    ss[++sp] = mid + 1;
                    se[sp] = cse;
                    vh[sp] = !cvh;
                    mp[sp] = false;
                    ++sp;
                    continue;
                }
                if (cse - css + 1 == 3) {
                    hull = new int[]{indices[css], indices[css + 1], indices[cse]};
                    float a0x = samp0[hull[0]];
                    float a0y = samp1[hull[0]];
                    if ((samp0[hull[1]] - a0x) * (samp1[hull[2]] - a0y) - (samp1[hull[1]] - a0y) * (samp0[hull[2]] - a0x) > 0.0f) {
                        hull[1] = indices[cse];
                        hull[2] = indices[css + 1];
                    }
                    tris[tp][0] = new int[1];
                    tris[tp][1] = new int[1];
                    tris[tp][2] = new int[1];
                    tris[tp][0][0] = hull[0];
                    tris[tp][1][0] = hull[1];
                    tris[tp][2][0] = hull[2];
                    ++tp;
                    ++ntris;
                    int n = indices[css];
                    nverts[n] = nverts[n] + 1;
                    int n2 = indices[cse];
                    nverts[n2] = nverts[n2] + 1;
                    int n3 = indices[css + 1];
                    nverts[n3] = nverts[n3] + 1;
                } else {
                    hull = new int[]{indices[css], indices[cse]};
                }
                hs[hsp++] = hull;
                continue;
            }
            int coord = cvh ? 1 : 0;
            int[] hull2 = cvh ? hs[hsp + 1] : hs[hsp -= 2];
            int[] hull1 = cvh ? hs[hsp] : hs[hsp + 1];
            hs[hsp + 1] = null;
            hs[hsp] = null;
            int upp1 = 0;
            int upp2 = 0;
            int low1 = 0;
            int low2 = 0;
            int i4 = 1;
            while (i4 < hull1.length) {
                if (samp[coord][hull1[i4]] > samp[coord][hull1[upp1]]) {
                    upp1 = i4;
                }
                if (samp[coord][hull1[i4]] < samp[coord][hull1[low1]]) {
                    low1 = i4;
                }
                ++i4;
            }
            int i5 = 1;
            while (i5 < hull2.length) {
                if (samp[coord][hull2[i5]] > samp[coord][hull2[upp2]]) {
                    upp2 = i5;
                }
                if (samp[coord][hull2[i5]] < samp[coord][hull2[low2]]) {
                    low2 = i5;
                }
                ++i5;
            }
            int t2 = 0;
            while (t2 < 3) {
                boolean plus_dir;
                int bob = (upp1 + 1) % hull1.length;
                float ax = samp0[hull2[upp2]];
                float ay = samp1[hull2[upp2]];
                float bamx = samp0[hull1[bob]] - ax;
                float bamy = samp1[hull1[bob]] - ay;
                float camx = samp0[hull1[upp1]] - ax;
                float camy = samp1[hull1[upp1]] - ay;
                float u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                float v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                boolean bl = plus_dir = u < v;
                if (!plus_dir) {
                    bob = upp1;
                    u = 0.0f;
                    v = 1.0f;
                }
                while (u < v) {
                    upp1 = bob;
                    bob = plus_dir ? (upp1 + 1) % hull1.length : (upp1 + hull1.length - 1) % hull1.length;
                    bamx = samp0[hull1[bob]] - ax;
                    bamy = samp1[hull1[bob]] - ay;
                    camx = samp0[hull1[upp1]] - ax;
                    camy = samp1[hull1[upp1]] - ay;
                    u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                    float f = v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                }
                bob = (upp2 + 1) % hull2.length;
                ax = samp0[hull1[upp1]];
                ay = samp1[hull1[upp1]];
                bamx = samp0[hull2[bob]] - ax;
                bamy = samp1[hull2[bob]] - ay;
                camx = samp0[hull2[upp2]] - ax;
                camy = samp1[hull2[upp2]] - ay;
                u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                boolean bl2 = plus_dir = u < v;
                if (!plus_dir) {
                    bob = upp2;
                    u = 0.0f;
                    v = 1.0f;
                }
                while (u < v) {
                    upp2 = bob;
                    bob = plus_dir ? (upp2 + 1) % hull2.length : (upp2 + hull2.length - 1) % hull2.length;
                    bamx = samp0[hull2[bob]] - ax;
                    bamy = samp1[hull2[bob]] - ay;
                    camx = samp0[hull2[upp2]] - ax;
                    camy = samp1[hull2[upp2]] - ay;
                    u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                    float f = v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                }
                bob = (low1 + 1) % hull1.length;
                ax = samp0[hull2[low2]];
                ay = samp1[hull2[low2]];
                bamx = samp0[hull1[bob]] - ax;
                bamy = samp1[hull1[bob]] - ay;
                camx = samp0[hull1[low1]] - ax;
                camy = samp1[hull1[low1]] - ay;
                u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                boolean bl3 = plus_dir = u > v;
                if (!plus_dir) {
                    bob = low1;
                    u = 1.0f;
                    v = 0.0f;
                }
                while (u > v) {
                    low1 = bob;
                    bob = plus_dir ? (low1 + 1) % hull1.length : (low1 + hull1.length - 1) % hull1.length;
                    bamx = samp0[hull1[bob]] - ax;
                    bamy = samp1[hull1[bob]] - ay;
                    camx = samp0[hull1[low1]] - ax;
                    camy = samp1[hull1[low1]] - ay;
                    u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                    float f = v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                }
                bob = (low2 + 1) % hull2.length;
                ax = samp0[hull1[low1]];
                ay = samp1[hull1[low1]];
                bamx = samp0[hull2[bob]] - ax;
                bamy = samp1[hull2[bob]] - ay;
                camx = samp0[hull2[low2]] - ax;
                camy = samp1[hull2[low2]] - ay;
                u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                boolean bl4 = plus_dir = u > v;
                if (!plus_dir) {
                    bob = low2;
                    u = 1.0f;
                    v = 0.0f;
                }
                while (u > v) {
                    low2 = bob;
                    bob = plus_dir ? (low2 + 1) % hull2.length : (low2 + hull2.length - 1) % hull2.length;
                    bamx = samp0[hull2[bob]] - ax;
                    bamy = samp1[hull2[bob]] - ay;
                    camx = samp0[hull2[low2]] - ax;
                    camy = samp1[hull2[low2]] - ay;
                    u = cvh ? (float)((double)bamy / Math.sqrt(bamx * bamx + bamy * bamy)) : (float)((double)bamx / Math.sqrt(bamx * bamx + bamy * bamy));
                    float f = v = cvh ? (float)((double)camy / Math.sqrt(camx * camx + camy * camy)) : (float)((double)camx / Math.sqrt(camx * camx + camy * camy));
                }
                ++t2;
            }
            if (low1 == upp1) {
                nih1 = hull1.length;
                noh1 = 1;
                h1ups = 0;
            } else {
                nih1 = low1 - upp1 + 1;
                if (nih1 <= 0) {
                    nih1 += hull1.length;
                }
                noh1 = hull1.length - nih1 + 2;
                h1ups = 1;
            }
            if (low2 == upp2) {
                nih2 = hull2.length;
                noh2 = 1;
                h2ups = 0;
            } else {
                nih2 = upp2 - low2 + 1;
                if (nih2 <= 0) {
                    nih2 += hull2.length;
                }
                noh2 = hull2.length - nih2 + 2;
                h2ups = 1;
            }
            int[] hull = new int[noh1 + noh2];
            int hullnum = 0;
            int spot = low1;
            while (spot != upp1) {
                hull[hullnum] = hull1[spot];
                ++hullnum;
                spot = (spot + 1) % hull1.length;
            }
            hull[hullnum++] = hull1[upp1];
            spot = upp2;
            while (spot != low2) {
                hull[hullnum] = hull2[spot];
                ++hullnum;
                spot = (spot + 1) % hull2.length;
            }
            hull[hullnum++] = hull2[low2];
            hs[hsp++] = hull;
            int base1 = low1;
            int base2 = low2;
            int oneUp1 = (base1 + hull1.length - 1) % hull1.length;
            int oneUp2 = (base2 + 1) % hull2.length;
            int ntd = noh1 == 1 || noh2 == 1 ? nih1 + nih2 - 1 : nih1 + nih2 - 2;
            tris[tp][0] = new int[ntd];
            tris[tp][1] = new int[ntd];
            tris[tp][2] = new int[ntd];
            int t3 = 0;
            while (t3 < ntd) {
                if (h1ups == nih1) {
                    oneUp2 = (base2 + 1) % hull2.length;
                    tris[tp][0][t3] = hull2[base2];
                    tris[tp][1][t3] = hull1[base1];
                    tris[tp][2][t3] = hull2[oneUp2];
                    ++ntris;
                    int n = hull1[base1];
                    nverts[n] = nverts[n] + 1;
                    int n4 = hull2[base2];
                    nverts[n4] = nverts[n4] + 1;
                    int n5 = hull2[oneUp2];
                    nverts[n5] = nverts[n5] + 1;
                    base2 = oneUp2;
                    ++h2ups;
                } else if (h2ups == nih2) {
                    oneUp1 = (base1 + hull1.length - 1) % hull1.length;
                    tris[tp][0][t3] = hull2[base2];
                    tris[tp][1][t3] = hull1[base1];
                    tris[tp][2][t3] = hull1[oneUp1];
                    ++ntris;
                    int n = hull1[base1];
                    nverts[n] = nverts[n] + 1;
                    int n6 = hull2[base2];
                    nverts[n6] = nverts[n6] + 1;
                    int n7 = hull1[oneUp1];
                    nverts[n7] = nverts[n7] + 1;
                    base1 = oneUp1;
                    ++h1ups;
                } else {
                    boolean sig;
                    int hb1 = hull1[base1];
                    int ho1 = hull1[oneUp1];
                    int hb2 = hull2[base2];
                    int ho2 = hull2[oneUp2];
                    float ax = samp0[ho2];
                    float ay = samp1[ho2];
                    float bx = samp0[hb2];
                    float by = samp1[hb2];
                    float cx = samp0[ho1];
                    float cy = samp1[ho1];
                    float dx = samp0[hb1];
                    float dy = samp1[hb1];
                    float abx = ax - bx;
                    float aby = ay - by;
                    float acx = ax - cx;
                    float acy = ay - cy;
                    float dbx = dx - bx;
                    float dby = dy - by;
                    float dcx = dx - cx;
                    float dcy = dy - cy;
                    float Q = abx * acx + aby * acy;
                    float R = dbx * abx + dby * aby;
                    float S = acx * dcx + acy * dcy;
                    float T = dbx * dcx + dby * dcy;
                    boolean QD = abx * acy - aby * acx >= 0.0f;
                    boolean RD = dbx * aby - dby * abx >= 0.0f;
                    boolean SD = acx * dcy - acy * dcx >= 0.0f;
                    boolean TD = dcx * dby - dcy * dbx >= 0.0f;
                    boolean bl = sig = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                    boolean d2 = QD == sig ? true : (RD == sig ? false : (SD == sig ? false : (TD == sig ? true : (Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S))))));
                    if (d2) {
                        tris[tp][0][t3] = hull2[base2];
                        tris[tp][1][t3] = hull1[base1];
                        tris[tp][2][t3] = hull2[oneUp2];
                        ++ntris;
                        int n = hull1[base1];
                        nverts[n] = nverts[n] + 1;
                        int n8 = hull2[base2];
                        nverts[n8] = nverts[n8] + 1;
                        int n9 = hull2[oneUp2];
                        nverts[n9] = nverts[n9] + 1;
                        base2 = oneUp2;
                        ++h2ups;
                        oneUp2 = (base2 + 1) % hull2.length;
                    } else {
                        tris[tp][0][t3] = hull2[base2];
                        tris[tp][1][t3] = hull1[base1];
                        tris[tp][2][t3] = hull1[oneUp1];
                        ++ntris;
                        int n = hull1[base1];
                        nverts[n] = nverts[n] + 1;
                        int n10 = hull2[base2];
                        nverts[n10] = nverts[n10] + 1;
                        int n11 = hull1[oneUp1];
                        nverts[n11] = nverts[n11] + 1;
                        base1 = oneUp1;
                        ++h1ups;
                        oneUp1 = (base1 + hull1.length - 1) % hull1.length;
                    }
                }
                ++t3;
            }
            ++tp;
        }
        this.Tri = new int[ntris][3];
        int tr = 0;
        int i6 = 0;
        while (i6 < tp) {
            int j = 0;
            while (j < tris[i6][0].length) {
                this.Tri[tr][0] = tris[i6][0][j];
                this.Tri[tr][1] = tris[i6][1][j];
                this.Tri[tr][2] = tris[i6][2][j];
                ++tr;
                ++j;
            }
            ++i6;
        }
        this.Vertices = new int[numpts][];
        int i7 = 0;
        while (i7 < numpts) {
            this.Vertices[i7] = new int[nverts[i7]];
            nverts[i7] = 0;
            ++i7;
        }
        int i8 = 0;
        while (i8 < ntris) {
            int a2 = this.Tri[i8][0];
            int b2 = this.Tri[i8][1];
            int c2 = this.Tri[i8][2];
            int n = a2;
            int n12 = nverts[n];
            nverts[n] = n12 + 1;
            this.Vertices[a2][n12] = i8;
            int n13 = b2;
            int n14 = nverts[n13];
            nverts[n13] = n14 + 1;
            this.Vertices[b2][n14] = i8;
            int n15 = c2;
            int n16 = nverts[n15];
            nverts[n15] = n16 + 1;
            this.Vertices[c2][n16] = i8++;
        }
        this.finish_triang(samples);
    }

    public static void main(String[] argv) throws VisADException {
        boolean problem = false;
        int points = 0;
        if (argv.length < 1) {
            problem = true;
        } else {
            try {
                points = Integer.parseInt(argv[0]);
                if (points < 3) {
                    problem = true;
                }
            }
            catch (NumberFormatException exc) {
                problem = true;
            }
        }
        if (problem) {
            System.out.println("Usage:\n   java visad.DelaunayFast points\npoints = the number of points to triangulate.\n");
            System.exit(1);
        }
        System.out.println("Generating " + points + " random points...");
        float[][] samples = new float[2][points];
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        int i = 0;
        while (i < points) {
            samp0[i] = (float)(500.0 * Math.random());
            samp1[i] = (float)(500.0 * Math.random());
            ++i;
        }
        System.out.println("\nTriangulating points with Clarkson algorithm...");
        long start1 = System.currentTimeMillis();
        DelaunayClarkson dc = new DelaunayClarkson(samples);
        long end1 = System.currentTimeMillis();
        float time1 = (float)(end1 - start1) / 1000.0f;
        System.out.println("Triangulation took " + time1 + " seconds.");
        System.out.println("\nTriangulating points with Watson algorithm...");
        long start2 = System.currentTimeMillis();
        DelaunayWatson dw = new DelaunayWatson(samples);
        long end2 = System.currentTimeMillis();
        float time2 = (float)(end2 - start2) / 1000.0f;
        System.out.println("Triangulation took " + time2 + " seconds.");
        System.out.println("\nTriangulating points with Fast algorithm...");
        long start3 = System.currentTimeMillis();
        DelaunayFast df = new DelaunayFast(samples);
        long end3 = System.currentTimeMillis();
        float time3 = (float)(end3 - start3) / 1000.0f;
        System.out.println("Triangulation took " + time3 + " seconds.");
        float ratio1 = time1 / time3;
        System.out.println("\nAt " + points + " points:");
        System.out.println("  Fast is " + ratio1 + " times faster than Clarkson.");
        float ratio2 = time2 / time3;
        System.out.println("  Fast is " + ratio2 + " times faster than Watson.");
    }
}

