/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Display;
import visad.DisplayRealType;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class DisplayTupleType
extends RealTupleType {
    public DisplayTupleType(DisplayRealType[] types) throws VisADException {
        this(types, null);
    }

    public DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super((RealType[])types, coord_sys, null);
        if (coord_sys != null) {
            RealTupleType ref = coord_sys.getReference();
            if (!(ref instanceof DisplayTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference must be a DisplayTupleType");
            }
            if (Display.DisplaySpatialOffsetTuple.equals(ref)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplaySpatialOffsetTuple");
            }
            Unit[] default_units = this.getDefaultUnits();
            Unit[] coord_sys_units = coord_sys.getCoordinateSystemUnits();
            int n = default_units.length;
            boolean match = true;
            int i = 0;
            while (i < n) {
                if (default_units[i] == null) {
                    if (coord_sys_units[i] != null) {
                        match = false;
                    }
                } else if (!default_units[i].equals(coord_sys_units[i])) {
                    match = false;
                }
                ++i;
            }
            if (!match) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must equal default Units");
            }
        }
        this.setTuples(types, coord_sys);
    }

    DisplayTupleType(DisplayRealType[] types, boolean b2) {
        this(types, (CoordinateSystem)null, b2);
    }

    DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys, boolean b2) {
        super((RealType[])types, coord_sys, b2);
        try {
            this.setTuples(types, coord_sys);
        }
        catch (VisADException e2) {
            System.out.println(e2);
        }
    }

    private void setTuples(DisplayRealType[] types, CoordinateSystem coord_sys) throws VisADException {
        int n = types.length;
        boolean[] circulars = new boolean[n];
        int i = 0;
        while (i < n) {
            circulars[i] = false;
            ++i;
        }
        if (coord_sys != null && coord_sys.getReference().equals(Display.DisplaySpatialCartesianTuple)) {
            double[] defaults = new double[n];
            int i2 = 0;
            while (i2 < n) {
                defaults[i2] = types[i2].getDefaultValue();
                ++i2;
            }
            int i3 = 0;
            while (i3 < n) {
                Unit u = types[i3].getDefaultUnit();
                if (u != null && Unit.canConvert(CommonUnit.degree, u)) {
                    double[][] test = new double[n][37];
                    int j = 0;
                    while (j < n) {
                        int k;
                        if (j == i3) {
                            k = 0;
                            while (k < 37) {
                                test[j][k] = u.toThis(10.0 * (double)k, CommonUnit.degree);
                                ++k;
                            }
                        } else {
                            k = 0;
                            while (k < 37) {
                                test[j][k] = defaults[j];
                                ++k;
                            }
                        }
                        ++j;
                    }
                    double[][] tt = coord_sys.toReference(test);
                    double diff180 = Math.sqrt((tt[0][18] - tt[0][0]) * (tt[0][18] - tt[0][0]) + (tt[1][18] - tt[1][0]) * (tt[1][18] - tt[1][0]) + (tt[2][18] - tt[2][0]) * (tt[2][18] - tt[2][0]));
                    double diff360 = Math.sqrt((tt[0][36] - tt[0][0]) * (tt[0][36] - tt[0][0]) + (tt[1][36] - tt[1][0]) * (tt[1][36] - tt[1][0]) + (tt[2][36] - tt[2][0]) * (tt[2][36] - tt[2][0]));
                    if (diff360 < 0.01 * diff180) {
                        circulars[i3] = true;
                        double diff0 = 0.0;
                        double difflast = 0.0;
                        int k = 0;
                        while (k < 37) {
                            if (k == 36) {
                                if (difflast < 0.1 * diff0 || diff0 < 0.1 * difflast) {
                                    circulars[i3] = false;
                                    break;
                                }
                            } else {
                                double diff = Math.sqrt((tt[0][k + 1] - tt[0][k]) * (tt[0][k + 1] - tt[0][k]) + (tt[1][k + 1] - tt[1][k]) * (tt[1][k + 1] - tt[1][k]) + (tt[2][k + 1] - tt[2][k]) * (tt[2][k + 1] - tt[2][k]));
                                if (k == 0) {
                                    diff0 = diff;
                                } else if (difflast < 0.1 * diff || diff < 0.1 * difflast) {
                                    circulars[i3] = false;
                                    break;
                                }
                                difflast = diff;
                            }
                            ++k;
                        }
                    }
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < n) {
            types[i4].setTuple(this, i4, circulars[i4]);
            ++i4;
        }
    }
}

