/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class EarthVectorType
extends RealVectorType {
    public EarthVectorType(RealType[] types) throws VisADException {
        this(types, null);
    }

    public EarthVectorType(RealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super(types, coord_sys);
        if (types.length != 2 && types.length != 3) {
            throw new TypeException("EarthVectorType must be 2-D or 3-D: " + types.length);
        }
        int i = 0;
        while (i < types.length) {
            if (!Unit.canConvert(CommonUnit.meterPerSecond, types[i].getDefaultUnit())) {
                throw new TypeException("EarthVectorType components must be convertable with meter / second: " + types[i].getDefaultUnit());
            }
            ++i;
        }
    }

    public EarthVectorType(RealType a2) throws VisADException {
        super(a2);
    }

    public EarthVectorType(RealType a2, RealType b2) throws VisADException {
        super(a2, b2);
    }

    public EarthVectorType(RealType a2, RealType b2, RealType c2) throws VisADException {
        super(a2, b2, c2);
    }

    public EarthVectorType(RealType a2, RealType b2, RealType c2, RealType d2) throws VisADException {
        super(a2, b2, c2, d2);
    }

    public double[][] transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, ErrorEstimate[] errors_in, ErrorEstimate[] errors_out, double[][] inloc, double[][] outloc, double[][] value) throws VisADException, RemoteException {
        return value;
    }
}

