/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded2DSet
extends GriddedSet {
    int LengthX;
    int LengthY;
    float LowX;
    float HiX;
    float LowY;
    float HiY;
    private int gx = -1;
    private int gy = -1;

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        super(type, samples, Gridded2DSet.make_lengths(lengthX, lengthY), coord_sys, units, errors, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1) {
            boolean bl = this.Pos = (this.Samples[0][1] - this.Samples[0][0]) * (this.Samples[1][this.LengthX + 1] - this.Samples[1][1]) - (this.Samples[1][1] - this.Samples[1][0]) * (this.Samples[0][this.LengthX + 1] - this.Samples[0][1]) > 0.0f;
            if (test) {
                int i = 0;
                while (i < this.Length) {
                    if (this.Samples[0][i] != this.Samples[0][i]) {
                        throw new SetException("Gridded2DSet: samples value #" + i + " may not be missing");
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.LengthY - 1) {
                    int i2 = 0;
                    while (i2 < this.LengthX - 1) {
                        float[] v00 = new float[2];
                        float[] v10 = new float[2];
                        float[] v01 = new float[2];
                        float[] v11 = new float[2];
                        int v = 0;
                        while (v < 2) {
                            v00[v] = this.Samples[v][j * this.LengthX + i2];
                            v10[v] = this.Samples[v][j * this.LengthX + i2 + 1];
                            v01[v] = this.Samples[v][(j + 1) * this.LengthX + i2];
                            v11[v] = this.Samples[v][(j + 1) * this.LengthX + i2 + 1];
                            ++v;
                        }
                        if ((v10[0] - v00[0]) * (v11[1] - v10[1]) - (v10[1] - v00[1]) * (v11[0] - v10[0]) > 0.0f != this.Pos || (v11[0] - v10[0]) * (v01[1] - v11[1]) - (v11[1] - v10[1]) * (v01[0] - v11[0]) > 0.0f != this.Pos || (v01[0] - v11[0]) * (v00[1] - v01[1]) - (v01[1] - v11[1]) * (v00[0] - v01[0]) > 0.0f != this.Pos || (v00[0] - v01[0]) * (v10[1] - v00[1]) - (v00[1] - v01[1]) * (v10[0] - v00[0]) > 0.0f != this.Pos) {
                            throw new SetException("Gridded2DSet: samples do not form a valid grid (" + i2 + "," + j + ")");
                        }
                        ++i2;
                    }
                    ++j;
                }
            }
        }
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, Gridded1DSet.make_lengths(lengthX), coord_sys, units, errors, copy);
        if (this.DomainDimension != 2) {
            throw new SetException("Gridded2DSet Domain dimension should be 2, not " + this.DomainDimension);
        }
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }

    static int[] make_lengths(int lengthX, int lengthY) {
        int[] lens = new int[]{lengthX, lengthY};
        return lens;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            float[][] grid = new float[this.ManifoldDimension][length];
            int i = 0;
            while (i < length) {
                int indexY;
                int indexX;
                if (0 <= index[i] && index[i] < this.Length) {
                    indexX = index[i] % this.LengthX;
                    indexY = index[i] / this.LengthX;
                } else {
                    indexX = -1;
                    indexY = -1;
                }
                grid[0][i] = indexX;
                grid[1][i] = indexY;
                ++i;
            }
            return this.gridToValue(grid);
        }
        float[][] values = new float[2][length];
        int i = 0;
        while (i < length) {
            if (0 <= index[i] && index[i] < this.Length) {
                values[0][i] = this.Samples[0][index[i]];
                values[1][i] = this.Samples[1][index[i]];
            } else {
                values[0][i] = Float.NaN;
                values[1][i] = Float.NaN;
            }
            ++i;
        }
        return values;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        float[] grid0 = grid[0];
        float[] grid1 = grid[1];
        int i = 0;
        while (i < length) {
            float g0 = grid0[i];
            float g1 = grid1[i];
            index[i] = g0 != g0 || g1 != g1 ? -1 : (int)((double)g0 + 0.5) + this.LengthX * (int)((double)g1 + 0.5);
            ++i;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DSet.gridToValue: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        float[][] value = new float[2][length];
        int i = 0;
        while (i < length) {
            float gx = grid[0][i];
            float gy = grid[1][i];
            if ((double)gx < -0.5 || (double)gy < -0.5 || (double)gx > (double)this.LengthX - 0.5 || (double)gy > (double)this.LengthY - 0.5) {
                value[1][i] = Float.NaN;
                value[0][i] = Float.NaN;
            } else {
                int j;
                int igx = (int)gx;
                int igy = (int)gy;
                if (igx < 0) {
                    igx = 0;
                }
                if (igx > this.LengthX - 2) {
                    igx = this.LengthX - 2;
                }
                if (igy < 0) {
                    igy = 0;
                }
                if (igy > this.LengthY - 2) {
                    igy = this.LengthY - 2;
                }
                int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
                if (gx + gy - (float)igx - (float)igy - 1.0f <= 0.0f) {
                    j = 0;
                    while (j < 2) {
                        value[j][i] = this.Samples[j][s[0][0]] + (gx - (float)igx) * (this.Samples[j][s[1][0]] - this.Samples[j][s[0][0]]) + (gy - (float)igy) * (this.Samples[j][s[0][1]] - this.Samples[j][s[0][0]]);
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < 2) {
                        value[j][i] = this.Samples[j][s[1][1]] + ((float)(1 + igx) - gx) * (this.Samples[j][s[0][1]] - this.Samples[j][s[1][1]]) + ((float)(1 + igy) - gy) * (this.Samples[j][s[1][0]] - this.Samples[j][s[1][1]]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int length = Math.min(value[0].length, value[1].length);
        float[][] grid = new float[this.ManifoldDimension][length];
        if (this.gx < 0 || this.gx >= this.LengthX || this.gy < 0 || this.gy >= this.LengthY) {
            this.gx = (this.LengthX - 1) / 2;
            this.gy = (this.LengthY - 1) / 2;
        }
        boolean lowertri = true;
        int i = 0;
        while (i < length) {
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1]) {
                this.gx = (this.LengthX - 1) / 2;
                this.gy = (this.LengthY - 1) / 2;
            }
            grid[1][i] = Float.NaN;
            grid[0][i] = Float.NaN;
            int itnum = 0;
            while (itnum < 2 * (this.LengthX + this.LengthY)) {
                int ogy;
                int ogx;
                boolean test3;
                boolean test2;
                boolean test1;
                float tval3;
                float tval2;
                float tval1;
                float[] v0 = new float[]{this.Samples[0][this.gy * this.LengthX + this.gx], this.Samples[1][this.gy * this.LengthX + this.gx]};
                float[] v1 = new float[]{this.Samples[0][this.gy * this.LengthX + this.gx + 1], this.Samples[1][this.gy * this.LengthX + this.gx + 1]};
                float[] v2 = new float[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx]};
                float[] v3 = new float[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx + 1], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx + 1]};
                float[] bd = new float[]{v2[0] - v1[0], v2[1] - v1[1]};
                float[] bp = new float[]{value[0][i] - v1[0], value[1][i] - v1[1]};
                float[] dp = new float[]{value[0][i] - v2[0], value[1][i] - v2[1]};
                if (lowertri) {
                    float[] ab = new float[]{v1[0] - v0[0], v1[1] - v0[1]};
                    float[] da = new float[]{v0[0] - v2[0], v0[1] - v2[1]};
                    float[] ap = new float[]{value[0][i] - v0[0], value[1][i] - v0[1]};
                    tval1 = ab[0] * ap[1] - ab[1] * ap[0];
                    tval2 = bd[0] * bp[1] - bd[1] * bp[0];
                    tval3 = da[0] * dp[1] - da[1] * dp[0];
                    boolean bl = tval1 == 0.0f || tval1 > 0.0f == this.Pos ? true : (test1 = false);
                    boolean bl2 = tval2 == 0.0f || tval2 > 0.0f == this.Pos ? true : (test2 = false);
                    test3 = tval3 == 0.0f || tval3 > 0.0f == this.Pos;
                    ogx = this.gx++;
                    ogy = this.gy--;
                    if (test1 || test2) {
                        if (!test2 && !test3) {
                            --this.gx;
                            ++this.gy;
                        } else if (!test1 && !test3) {
                            --this.gx;
                            --this.gy;
                        } else if (!test1) {
                            --this.gy;
                        } else if (!test3) {
                            --this.gx;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == ogx && this.gy == ogy && test2) {
                        grid[0][i] = ((value[0][i] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - value[1][i]) * (v2[0] - v0[0])) / ((v1[0] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - v1[1]) * (v2[0] - v0[0])) + (float)this.gx;
                        grid[1][i] = ((value[0][i] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - value[1][i]) * (v1[0] - v0[0])) / ((v2[0] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - v2[1]) * (v1[0] - v0[0])) + (float)this.gy;
                        break;
                    }
                    lowertri = false;
                } else {
                    float[] bc = new float[]{v3[0] - v1[0], v3[1] - v1[1]};
                    float[] cd = new float[]{v2[0] - v3[0], v2[1] - v3[1]};
                    float[] cp = new float[]{value[0][i] - v3[0], value[1][i] - v3[1]};
                    tval1 = bc[0] * bp[1] - bc[1] * bp[0];
                    tval2 = cd[0] * cp[1] - cd[1] * cp[0];
                    tval3 = bd[0] * dp[1] - bd[1] * dp[0];
                    boolean bl = tval1 == 0.0f || tval1 > 0.0f == this.Pos ? true : (test1 = false);
                    boolean bl3 = tval2 == 0.0f || tval2 > 0.0f == this.Pos ? true : (test2 = false);
                    test3 = tval3 == 0.0f || tval3 < 0.0f == this.Pos;
                    ogx = this.gx++;
                    ogy = this.gy--;
                    if (test1 || test3) {
                        if (!test2 && !test3) {
                            --this.gx;
                            ++this.gy;
                        } else if (!test1 && !test2) {
                            ++this.gx;
                            ++this.gy;
                        } else if (!test1) {
                            ++this.gx;
                        } else if (!test2) {
                            ++this.gy;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == ogx && this.gy == ogy && test3) {
                        grid[0][i] = ((v3[0] - value[0][i]) * (v1[1] - v3[1]) + (value[1][i] - v3[1]) * (v1[0] - v3[0])) / ((v2[0] - v3[0]) * (v1[1] - v3[1]) - (v2[1] - v3[1]) * (v1[0] - v3[0])) + (float)this.gx + 1.0f;
                        grid[1][i] = ((v2[1] - v3[1]) * (v3[0] - value[0][i]) + (v2[0] - v3[0]) * (value[1][i] - v3[1])) / ((v1[0] - v3[0]) * (v2[1] - v3[1]) - (v2[0] - v3[0]) * (v1[1] - v3[1])) + (float)this.gy + 1.0f;
                        break;
                    }
                    lowertri = true;
                }
                if ((double)grid[0][i] >= (double)this.LengthX - 0.5 || (double)grid[1][i] >= (double)this.LengthY - 0.5 || (double)grid[0][i] <= -0.5 || (double)grid[1][i] <= -0.5) {
                    grid[1][i] = Float.NaN;
                    grid[0][i] = Float.NaN;
                }
                ++itnum;
            }
            ++i;
        }
        return grid;
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 2) {
            return new Gridded2DSet(type, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded2DSet(type, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] argv) throws VisADException {
        InputStreamReader inStr = new InputStreamReader(System.in);
        int[] ints = new int[80];
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e2) {
            System.out.println("Gridded2DSet: " + e2);
        }
        int l = 0;
        while (ints[l] != 10) {
            try {
                ints[++l] = inStr.read();
            }
            catch (Exception e3) {
                System.out.println("Gridded2DSet: " + e3);
            }
        }
        char[] chars = new char[l];
        int i = 0;
        while (i < l) {
            chars[i] = (char)ints[i];
            ++i;
        }
        int num_coords = Integer.parseInt(new String(chars));
        if (num_coords % 4 != 0) {
            System.out.println("Gridded2DSet: input coordinates must be divisible by 4 for main function testing routines.");
        }
        float[][] samp = new float[2][num_coords];
        System.out.println("num_dimensions = 2, num_coords = " + num_coords + "\n");
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e4) {
            System.out.println("Gridded2DSet: " + e4);
        }
        int c2 = 0;
        while (c2 < num_coords) {
            int d2 = 0;
            while (d2 < 2) {
                l = 0;
                try {
                    ints[0] = inStr.read();
                }
                catch (Exception e5) {
                    System.out.println("Gridded2DSet: " + e5);
                }
                while (ints[l] != 32 && ints[l] != 10) {
                    try {
                        ints[++l] = inStr.read();
                    }
                    catch (Exception e6) {
                        System.out.println("Gridded2DSet: " + e6);
                    }
                }
                chars = new char[l];
                int i2 = 0;
                while (i2 < l) {
                    chars[i2] = (char)ints[i2];
                    ++i2;
                }
                samp[d2][c2] = Float.valueOf(new String(chars)).floatValue();
                ++d2;
            }
            ++c2;
        }
        try {
            inStr.close();
        }
        catch (Exception e7) {
            System.out.println("Gridded2DSet: " + e7);
        }
        RealType vis_xcoord = RealType.getRealType("xcoord");
        RealType vis_ycoord = RealType.getRealType("ycoord");
        RealType[] vis_array = new RealType[]{vis_xcoord, vis_ycoord};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        Gridded2DSet gSet2D = new Gridded2DSet((MathType)vis_tuple, samp, num_coords / 4, 4);
        System.out.println("Lengths = " + num_coords / 4 + " 4 " + " wedge = ");
        int[] wedge = gSet2D.getWedge();
        int i3 = 0;
        while (i3 < wedge.length) {
            System.out.println(" " + wedge[i3]);
            ++i3;
        }
        System.out.println("Samples (" + gSet2D.LengthX + " x " + gSet2D.LengthY + "):");
        int i4 = 0;
        while (i4 < gSet2D.LengthX * gSet2D.LengthY) {
            System.out.println("#" + i4 + ":\t" + gSet2D.Samples[0][i4] + ", " + gSet2D.Samples[1][i4]);
            ++i4;
        }
        System.out.println("\ngridToValue test:");
        int myLengthX = gSet2D.LengthX + 1;
        int myLengthY = gSet2D.LengthY + 1;
        float[][] myGrid = new float[2][myLengthX * myLengthY];
        int j = 0;
        while (j < myLengthY) {
            int i5 = 0;
            while (i5 < myLengthX) {
                myGrid[0][j * myLengthX + i5] = (float)i5 - 0.5f;
                myGrid[1][j * myLengthX + i5] = (float)j - 0.5f;
                if (myGrid[0][j * myLengthX + i5] < 0.0f) {
                    float[] fArray = myGrid[0];
                    int n = j * myLengthX + i5;
                    fArray[n] = (float)((double)fArray[n] + 0.1);
                }
                if (myGrid[0][j * myLengthX + i5] > (float)(gSet2D.LengthX - 1)) {
                    float[] fArray = myGrid[0];
                    int n = j * myLengthX + i5;
                    fArray[n] = (float)((double)fArray[n] - 0.1);
                }
                if (myGrid[1][j * myLengthX + i5] < 0.0f) {
                    float[] fArray = myGrid[1];
                    int n = j * myLengthX + i5;
                    fArray[n] = (float)((double)fArray[n] + 0.1);
                }
                if (myGrid[1][j * myLengthX + i5] > (float)(gSet2D.LengthY - 1)) {
                    float[] fArray = myGrid[1];
                    int n = j * myLengthX + i5;
                    fArray[n] = (float)((double)fArray[n] - 0.1);
                }
                ++i5;
            }
            ++j;
        }
        float[][] myValue = gSet2D.gridToValue(myGrid);
        int i6 = 0;
        while (i6 < myLengthX * myLengthY) {
            System.out.println("(" + (float)Math.round(1000000.0f * myGrid[0][i6]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myGrid[1][i6]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * myValue[0][i6]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myValue[1][i6]) / 1000000.0f);
            ++i6;
        }
        System.out.println("\nvalueToGrid test:");
        float[][] gridTwo = gSet2D.valueToGrid(myValue);
        int i7 = 0;
        while (i7 < gridTwo[0].length) {
            System.out.println((float)Math.round(1000000.0f * myValue[0][i7]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myValue[1][i7]) / 1000000.0f + "\t-->  (" + (float)Math.round(1000000.0f * gridTwo[0][i7]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * gridTwo[1][i7]) / 1000000.0f + ")");
            ++i7;
        }
        System.out.println();
    }
}

