/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class HSVCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, null, null};

    public HSVCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    HSVCoordinateSystem(RealTupleType reference, boolean b2) {
        super(reference, coordinate_system_units, b2);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        int j = 0;
        double f = 0.0;
        double p = 0.0;
        double q = 0.0;
        double t2 = 0.0;
        int i = 0;
        while (i < len) {
            double h = tuples[0][i] % 360.0;
            if (h < 0.0) {
                h += 360.0;
            }
            double s = Math.max(0.0, Math.min(1.0, tuples[1][i]));
            double v = Math.max(0.0, Math.min(1.0, tuples[2][i]));
            if (s == 0.0) {
                value[0][i] = v;
                value[1][i] = v;
                value[2][i] = v;
            } else {
                j = (int)Math.floor(h /= 60.0);
                f = h - (double)j;
                p = v * (1.0 - s);
                q = v * (1.0 - s * f);
                t2 = v * (1.0 - s * (1.0 - f));
                switch (j) {
                    case 0: {
                        value[0][i] = v;
                        value[1][i] = t2;
                        value[2][i] = p;
                        break;
                    }
                    case 1: {
                        value[0][i] = q;
                        value[1][i] = v;
                        value[2][i] = p;
                        break;
                    }
                    case 2: {
                        value[0][i] = p;
                        value[1][i] = v;
                        value[2][i] = t2;
                        break;
                    }
                    case 3: {
                        value[0][i] = p;
                        value[1][i] = q;
                        value[2][i] = v;
                        break;
                    }
                    case 4: {
                        value[0][i] = t2;
                        value[1][i] = p;
                        value[2][i] = v;
                        break;
                    }
                    default: {
                        value[0][i] = v;
                        value[1][i] = p;
                        value[2][i] = q;
                    }
                }
            }
            ++i;
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        int i = 0;
        while (i < len) {
            double r = Math.max(0.0, Math.min(1.0, tuples[0][i]));
            double g = Math.max(0.0, Math.min(1.0, tuples[1][i]));
            double b2 = Math.max(0.0, Math.min(1.0, tuples[2][i]));
            double max = Math.max(r, Math.max(g, b2));
            double min = Math.min(r, Math.min(g, b2));
            value[2][i] = max;
            double d2 = value[1][i] = max != 0.0 ? (max - min) / max : 0.0;
            if (value[1][i] == 0.0) {
                value[2][i] = 0.0;
            } else {
                double h;
                double rc = (max - r) / (max - min);
                double gc = (max - g) / (max - min);
                double bc = (max - b2) / (max - min);
                if (r == max) {
                    h = bc - gc;
                } else if (g == max) {
                    h = 2.0 + rc - bc;
                } else if (b2 == max) {
                    h = 4.0 + gc - rc;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                h = 60.0 * h;
                if (h < 0.0) {
                    h += 360.0;
                }
                value[2][i] = h;
            }
            ++i;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        int j = 0;
        float f = 0.0f;
        float p = 0.0f;
        float q = 0.0f;
        float t2 = 0.0f;
        int i = 0;
        while (i < len) {
            float h = tuples[0][i] % 360.0f;
            if (h < 0.0f) {
                h += 360.0f;
            }
            float s = Math.max(0.0f, Math.min(1.0f, tuples[1][i]));
            float v = Math.max(0.0f, Math.min(1.0f, tuples[2][i]));
            if (s == 0.0f) {
                value[0][i] = v;
                value[1][i] = v;
                value[2][i] = v;
            } else {
                j = (int)Math.floor(h /= 60.0f);
                f = h - (float)j;
                p = v * (1.0f - s);
                q = v * (1.0f - s * f);
                t2 = v * (1.0f - s * (1.0f - f));
                switch (j) {
                    case 0: {
                        value[0][i] = v;
                        value[1][i] = t2;
                        value[2][i] = p;
                        break;
                    }
                    case 1: {
                        value[0][i] = q;
                        value[1][i] = v;
                        value[2][i] = p;
                        break;
                    }
                    case 2: {
                        value[0][i] = p;
                        value[1][i] = v;
                        value[2][i] = t2;
                        break;
                    }
                    case 3: {
                        value[0][i] = p;
                        value[1][i] = q;
                        value[2][i] = v;
                        break;
                    }
                    case 4: {
                        value[0][i] = t2;
                        value[1][i] = p;
                        value[2][i] = v;
                        break;
                    }
                    default: {
                        value[0][i] = v;
                        value[1][i] = p;
                        value[2][i] = q;
                    }
                }
            }
            ++i;
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        int i = 0;
        while (i < len) {
            float r = Math.max(0.0f, Math.min(1.0f, tuples[0][i]));
            float g = Math.max(0.0f, Math.min(1.0f, tuples[1][i]));
            float b2 = Math.max(0.0f, Math.min(1.0f, tuples[2][i]));
            float max = Math.max(r, Math.max(g, b2));
            float min = Math.min(r, Math.min(g, b2));
            value[2][i] = max;
            float f = value[1][i] = max != 0.0f ? (max - min) / max : 0.0f;
            if (value[1][i] == 0.0f) {
                value[2][i] = 0.0f;
            } else {
                float h;
                float rc = (max - r) / (max - min);
                float gc = (max - g) / (max - min);
                float bc = (max - b2) / (max - min);
                if (r == max) {
                    h = bc - gc;
                } else if (g == max) {
                    h = 2.0f + rc - bc;
                } else if (b2 == max) {
                    h = 4.0f + gc - rc;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                h = 60.0f * h;
                if (h < 0.0f) {
                    h += 360.0f;
                }
                value[2][i] = h;
            }
            ++i;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof HSVCoordinateSystem;
    }
}

