/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class Irregular2DSet
extends IrregularSet {
    private float LowX;
    private float HiX;
    private float LowY;
    private float HiY;

    public Irregular2DSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, null, null, null, null, true);
    }

    public Irregular2DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, coord_sys, units, errors, delan, true);
    }

    public Irregular2DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan, boolean copy) throws VisADException {
        super(type, samples, samples.length, coord_sys, units, errors, delan, copy);
        if (samples.length != 2) {
            throw new SetException("Irregular2DSet: ManifoldDimension must be 2 for this constructor");
        }
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.oldToNew = null;
        this.newToOld = null;
    }

    public Irregular2DSet(MathType type, float[][] samples, int[] new2old, int[] old2new) throws VisADException {
        this(type, samples, new2old, old2new, null, null, null, true);
    }

    public Irregular2DSet(MathType type, float[][] samples, int[] new2old, int[] old2new, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, new2old, old2new, coord_sys, units, errors, true);
    }

    public Irregular2DSet(MathType type, float[][] samples, int[] new2old, int[] old2new, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, 1, coord_sys, units, errors, null, copy);
        if (this.Length != new2old.length || this.Length != old2new.length) {
            throw new SetException("Irregular2DSet: sort lengths do not match");
        }
        this.newToOld = new int[this.Length];
        this.oldToNew = new int[this.Length];
        System.arraycopy(new2old, 0, this.newToOld, 0, this.Length);
        System.arraycopy(old2new, 0, this.oldToNew, 0, this.Length);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.Delan = null;
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        if (samples.length == 3) {
            if (this.ManifoldDimension == 1) {
                return new Irregular3DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan == null || this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)type, samples, null, null, null, this.Delan, false);
        }
        if (samples.length == 2) {
            if (this.ManifoldDimension == 1) {
                return new Irregular2DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan == null || this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular2DSet((MathType)type, samples, null, null, null, this.Delan, false);
        }
        throw new SetException("Irregular2DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        float[][] value = new float[2][index.length];
        int i = 0;
        while (i < index.length) {
            if (index[i] >= 0 && index[i] < this.Length) {
                value[0][i] = this.Samples[0][index[i]];
                value[1][i] = this.Samples[1][index[i]];
            } else {
                value[1][i] = Float.NaN;
                value[0][i] = Float.NaN;
            }
            ++i;
        }
        return value;
    }

    public int[] valueToTri(float[][] value) throws VisADException {
        if (this.ManifoldDimension != 2) {
            throw new SetException("Irregular2DSet.valueToTri: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int length = value[0].length;
        if (length != value[1].length) {
            throw new SetException("Irregular2DSet.valueToTri: lengths don't match");
        }
        if (this.Delan == null) {
            throw new SetException("Irregular2DSet.valueToTri: triangulation undefined");
        }
        int[] tri = new int[length];
        int curtri = 0;
        int i = 0;
        while (i < length) {
            tri[i] = -1;
            boolean foundit = false;
            if (curtri < 0) {
                curtri = 0;
            }
            int itnum = 0;
            while (itnum < this.Delan.Tri.length && !foundit) {
                int nextri;
                boolean flip;
                boolean test1;
                boolean test0;
                int t0 = this.Delan.Tri[curtri][0];
                int t1 = this.Delan.Tri[curtri][1];
                int t2 = this.Delan.Tri[curtri][2];
                float Ax = this.Samples[0][t0];
                float Ay = this.Samples[1][t0];
                float Bx = this.Samples[0][t1];
                float By = this.Samples[1][t1];
                float Cx = this.Samples[0][t2];
                float Cy = this.Samples[1][t2];
                float Px = value[0][i];
                float Py = value[1][i];
                float tval0 = (Bx - Ax) * (Py - Ay) - (By - Ay) * (Px - Ax);
                float tval1 = (Cx - Bx) * (Py - By) - (Cy - By) * (Px - Bx);
                float tval2 = (Ax - Cx) * (Py - Cy) - (Ay - Cy) * (Px - Cx);
                boolean bl = tval0 == 0.0f || tval0 > 0.0f == (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) > 0.0f ? true : (test0 = false);
                boolean bl2 = tval1 == 0.0f || tval1 > 0.0f == (Cx - Bx) * (Ay - By) - (Cy - By) * (Ax - Bx) > 0.0f ? true : (test1 = false);
                boolean test2 = tval2 == 0.0f || tval2 > 0.0f == (Ax - Cx) * (By - Cy) - (Ay - Cy) * (Bx - Cx) > 0.0f;
                int it2 = itnum / 2;
                boolean bl3 = flip = it2 % 2 == 0;
                if (!(test0 || test1 || test2)) {
                    curtri = -1;
                } else if (!test0 && !test1) {
                    curtri = flip ? ((nextri = this.Delan.Walk[curtri][1]) >= 0 ? nextri : this.Delan.Walk[curtri][0]) : ((nextri = this.Delan.Walk[curtri][0]) >= 0 ? nextri : this.Delan.Walk[curtri][1]);
                } else if (!test1 && !test2) {
                    curtri = flip ? ((nextri = this.Delan.Walk[curtri][2]) >= 0 ? nextri : this.Delan.Walk[curtri][1]) : ((nextri = this.Delan.Walk[curtri][1]) >= 0 ? nextri : this.Delan.Walk[curtri][2]);
                } else if (!test2 && !test0) {
                    curtri = flip ? ((nextri = this.Delan.Walk[curtri][0]) >= 0 ? nextri : this.Delan.Walk[curtri][2]) : ((nextri = this.Delan.Walk[curtri][2]) >= 0 ? nextri : this.Delan.Walk[curtri][0]);
                } else if (!test0) {
                    curtri = this.Delan.Walk[curtri][0];
                } else if (!test1) {
                    curtri = this.Delan.Walk[curtri][1];
                } else if (!test2) {
                    curtri = this.Delan.Walk[curtri][2];
                } else {
                    foundit = true;
                }
                if (curtri < 0) {
                    foundit = true;
                }
                if (foundit) {
                    tri[i] = curtri;
                }
                ++itnum;
            }
            ++i;
        }
        return tri;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Irregular2DDSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int[] tri = this.valueToTri(value);
        int[] index = new int[tri.length];
        int i = 0;
        while (i < tri.length) {
            if (tri[i] < 0) {
                index[i] = -1;
            } else {
                float x = value[0][i];
                float y = value[1][i];
                int t2 = tri[i];
                int t0 = this.Delan.Tri[t2][0];
                int t1 = this.Delan.Tri[t2][1];
                int t22 = this.Delan.Tri[t2][2];
                float D00 = this.Samples[0][t0] - x;
                float D01 = this.Samples[1][t0] - y;
                float D10 = this.Samples[0][t1] - x;
                float D11 = this.Samples[1][t1] - y;
                float D20 = this.Samples[0][t22] - x;
                float D21 = this.Samples[1][t22] - y;
                float Dsq0 = D00 * D00 + D01 * D01;
                float Dsq1 = D10 * D10 + D11 * D11;
                float Dsq2 = D20 * D20 + D21 * D21;
                float min = Math.min(Dsq0, Dsq1);
                index[i] = (min = Math.min(min, Dsq2)) == Dsq0 ? t0 : (min == Dsq1 ? t1 : t22);
            }
            ++i;
        }
        return index;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Irregular2DDSet.valueToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length < length || weights.length < length) {
            throw new SetException("Irregular2DSet.valueToInterp: lengths don't match");
        }
        int[] tri = this.valueToTri(value);
        int i = 0;
        while (i < tri.length) {
            if (tri[i] < 0) {
                indices[i] = null;
                weights[i] = null;
            } else {
                int[] ival = new int[3];
                float[] wval = new float[3];
                float x = value[0][i];
                float y = value[1][i];
                int t2 = tri[i];
                int t0 = this.Delan.Tri[t2][0];
                int t1 = this.Delan.Tri[t2][1];
                int t22 = this.Delan.Tri[t2][2];
                ival[0] = t0;
                ival[1] = t1;
                ival[2] = t22;
                float x0 = this.Samples[0][t0];
                float y0 = this.Samples[1][t0];
                float x1 = this.Samples[0][t1];
                float y1 = this.Samples[1][t1];
                float x2 = this.Samples[0][t22];
                float y2 = this.Samples[1][t22];
                float C0x = y2 - y1;
                float C0y = x1 - x2;
                float C1x = y2 - y0;
                float C1y = x0 - x2;
                float C2x = y1 - y0;
                float C2y = x0 - x1;
                wval[0] = ((x - x1) * C0x + (y - y1) * C0y) / ((x0 - x1) * C0x + (y0 - y1) * C0y);
                wval[1] = ((x - x0) * C1x + (y - y0) * C1y) / ((x1 - x0) * C1x + (y1 - y0) * C1y);
                wval[2] = ((x - x0) * C2x + (y - y0) * C2y) / ((x2 - x0) * C2x + (y2 - y0) * C2y);
                indices[i] = ival;
                weights[i] = wval;
            }
            ++i;
        }
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 1) {
            return new Irregular2DSet(type, this.Samples, this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Irregular2DSet(type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    public static void main(String[] argv) throws VisADException {
        float[][] samp = new float[][]{{139.0f, 357.0f, 416.0f, 276.0f, 495.0f, 395.0f, 578.0f, 199.0f}, {102.0f, 44.0f, 306.0f, 174.0f, 108.0f, 460.0f, 333.0f, 351.0f}};
        RealType test1 = RealType.getRealType("x");
        RealType test2 = RealType.getRealType("y");
        RealType[] t_array = new RealType[]{test1, test2};
        RealTupleType t_tuple = new RealTupleType(t_array);
        Irregular2DSet iSet2D = new Irregular2DSet((MathType)t_tuple, samp);
        System.out.println("Samples:");
        int i = 0;
        while (i < iSet2D.Samples[0].length) {
            System.out.println("#" + i + ":\t" + iSet2D.Samples[0][i] + ", " + iSet2D.Samples[1][i]);
            ++i;
        }
        System.out.println();
        System.out.println("valueToIndex test:");
        float[][] value = new float[][]{{164.0f, 287.0f, 311.0f, 417.0f, 522.0f, 366.0f, 445.0f}, {131.0f, 323.0f, 90.0f, 264.0f, 294.0f, 421.0f, 91.0f}};
        int[] index = iSet2D.valueToIndex(value);
        int i2 = 0;
        while (i2 < index.length) {
            System.out.println(value[0][i2] + ", " + value[1][i2] + "\t--> #" + index[i2]);
            ++i2;
        }
        System.out.println();
        System.out.println("valueToInterp test:");
        int[][] indices = new int[value[0].length][];
        float[][] weights = new float[value[0].length][];
        iSet2D.valueToInterp(value, indices, weights);
        int i3 = 0;
        while (i3 < value[0].length) {
            System.out.println(value[0][i3] + ", " + value[1][i3] + "\t--> [" + indices[i3][0] + ", " + indices[i3][1] + ", " + indices[i3][2] + "]\tweight total: " + (weights[i3][0] + weights[i3][1] + weights[i3][2]));
            ++i3;
        }
        System.out.println();
    }
}

