/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.OffsetUnit;
import visad.RealIface;
import visad.RealType;
import visad.SI;
import visad.Scalar;
import visad.ScaledUnit;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class Real
extends Scalar
implements RealIface {
    private final double Value;
    private final Unit unit;
    private final ErrorEstimate Error;

    public Real(RealType type, double value, Unit u, ErrorEstimate error) throws VisADException {
        super(type);
        if (!Unit.canConvert(u, type.getDefaultUnit())) {
            throw new UnitException("Real: Unit \"" + u + "\" must be convertable" + " with Type default Unit \"" + type.getDefaultUnit() + "\"");
        }
        this.unit = u != null && type.isInterval() ? u.getAbsoluteUnit() : u;
        this.Value = value;
        this.Error = Double.isNaN(value) ? null : error;
    }

    public Real(RealType type, double value, Unit u, double error) throws VisADException {
        this(type, value, u, new ErrorEstimate(value, Math.abs(error), u != null && type.isInterval() ? u.getAbsoluteUnit() : u));
    }

    public Real(RealType type, double value, Unit u) throws VisADException {
        this(type, value, u, null);
    }

    public Real(RealType type, double value) {
        this(type, value, type.getDefaultUnit(), null, true);
    }

    public Real(RealType type) {
        this(type, Double.NaN, type.getDefaultUnit(), null, true);
    }

    public Real(double value, double error) {
        this(RealType.Generic, value, RealType.Generic.getDefaultUnit(), new ErrorEstimate(value, Math.abs(error), RealType.Generic.getDefaultUnit()), true);
    }

    public Real(double value) {
        this(RealType.Generic, value, RealType.Generic.getDefaultUnit(), new ErrorEstimate(value, 0.0, RealType.Generic.getDefaultUnit()), true);
    }

    private Real(RealType type, double value, Unit u, ErrorEstimate error, boolean b2) {
        super(type);
        this.unit = u != null && type.isInterval() ? u.getAbsoluteUnit() : u;
        this.Value = value;
        this.Error = Double.isNaN(value) ? null : error;
    }

    public final double getValue() {
        return this.Value;
    }

    public int __gt__(double other) {
        if (this.Value > other) {
            return 1;
        }
        return 0;
    }

    public int __lt__(double other) {
        if (this.Value < other) {
            return 1;
        }
        return 0;
    }

    public int __ge__(double other) {
        if (this.Value >= other) {
            return 1;
        }
        return 0;
    }

    public int __le__(double other) {
        if (this.Value <= other) {
            return 1;
        }
        return 0;
    }

    public int __ne__(double other) {
        if (this.Value != other) {
            return 1;
        }
        return 0;
    }

    public int __eq__(double other) {
        if (this.Value == other) {
            return 1;
        }
        return 0;
    }

    public int __gt__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public int __lt__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 < 0.0) {
            return 1;
        }
        return 0;
    }

    public int __ge__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 >= 0.0) {
            return 1;
        }
        return 0;
    }

    public int __le__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 <= 0.0) {
            return 1;
        }
        return 0;
    }

    public int __eq__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 == 0.0) {
            return 1;
        }
        return 0;
    }

    public int __ne__(Real other) throws VisADException, RemoteException {
        double d2 = ((Real)this.subtract(other)).getValue();
        if (d2 != 0.0) {
            return 1;
        }
        return 0;
    }

    public double __float__() {
        return this.Value;
    }

    public long __long__() {
        return (long)this.Value;
    }

    public int __int__() {
        return (int)this.Value;
    }

    public final double getValue(Unit unit_out) throws VisADException {
        if (unit_out == null) {
            if (this.unit != null) {
                throw new UnitException("Real.getValue: illegal Unit conversion");
            }
            return this.Value;
        }
        if (this.unit == null) {
            throw new UnitException("Real.getValue: illegal Unit conversion");
        }
        if (((RealType)this.getType()).isInterval()) {
            unit_out = unit_out.getAbsoluteUnit();
        }
        return unit_out.toThis(this.Value, this.unit);
    }

    public boolean isMissing() {
        return Double.isNaN(this.Value);
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Real) {
            Real that = (Real)data;
            if (!(new_type instanceof RealType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            Unit thisUnit = this.getUnit();
            Unit thatUnit = that.getUnit();
            double thisValue = this.getValue();
            double thatValue = that.getValue();
            ErrorEstimate thisErr = this.getError();
            ErrorEstimate thatErr = that.getError();
            Unit outUnit = null;
            double outValue = Double.NaN;
            switch (op) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    if (thisUnit == null || thatUnit == null) {
                        outUnit = null;
                    } else if (thisUnit == CommonUnit.promiscuous) {
                        outUnit = thatUnit.getAbsoluteUnit();
                    } else if (thatUnit == CommonUnit.promiscuous) {
                        outUnit = thisUnit.getAbsoluteUnit();
                    } else {
                        try {
                            outUnit = thisUnit.getAbsoluteUnit();
                            thisValue = outUnit.toThis(thisValue, thisUnit);
                            thatValue = outUnit.toThis(thatValue, thatUnit);
                            if (error_mode != 202 && thisErr != null && thatErr != null) {
                                double newErr;
                                Unit errUnit;
                                if (!outUnit.equals(thisUnit)) {
                                    errUnit = thisErr.getUnit();
                                    if (errUnit == null) {
                                        errUnit = thisUnit;
                                    }
                                    newErr = outUnit.toThis(thisErr.getErrorValue(), errUnit);
                                    thisErr = new ErrorEstimate(thisValue, newErr, outUnit);
                                }
                                if (!outUnit.equals(thatUnit)) {
                                    errUnit = thatErr.getUnit();
                                    if (errUnit == null) {
                                        errUnit = thatUnit;
                                    }
                                    newErr = outUnit.toThis(thatErr.getErrorValue(), errUnit);
                                    thatErr = new ErrorEstimate(thatValue, newErr, outUnit);
                                }
                            }
                        }
                        catch (UnitException e2) {
                            outUnit = null;
                        }
                    }
                    switch (op) {
                        case 1: {
                            outValue = thisValue + thatValue;
                            break;
                        }
                        case 2: {
                            outValue = thisValue - thatValue;
                            break;
                        }
                        case 3: {
                            outValue = thatValue - thisValue;
                            break;
                        }
                        case 9: {
                            outValue = Math.max(thisValue, thatValue);
                            break;
                        }
                        case 10: {
                            outValue = Math.min(thisValue, thatValue);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    Unit absUnit;
                    if (thisUnit != null) {
                        absUnit = thisUnit.getAbsoluteUnit();
                        thisValue = absUnit.toThis(thisValue, thisUnit);
                        thisUnit = absUnit;
                    }
                    if (thatUnit != null) {
                        absUnit = thatUnit.getAbsoluteUnit();
                        thatValue = absUnit.toThis(thatValue, thatUnit);
                        thatUnit = absUnit;
                    }
                    if (thisUnit == null || thatUnit == null) {
                        outUnit = null;
                    } else {
                        switch (op) {
                            case 4: {
                                outUnit = thisUnit.equals(CommonUnit.promiscuous) ? thatUnit : (thatUnit.equals(CommonUnit.promiscuous) ? thisUnit : thisUnit.multiply(thatUnit));
                                break;
                            }
                            case 5: {
                                outUnit = thatUnit.equals(CommonUnit.promiscuous) ? thisUnit : thisUnit.divide(thatUnit);
                                break;
                            }
                            case 6: {
                                outUnit = thisUnit.equals(CommonUnit.promiscuous) ? thatUnit : thatUnit.divide(thisUnit);
                            }
                        }
                    }
                    switch (op) {
                        case 4: {
                            outValue = thisValue * thatValue;
                            break;
                        }
                        case 5: {
                            outValue = thisValue / thatValue;
                            break;
                        }
                        case 6: {
                            outValue = thatValue / thisValue;
                        }
                    }
                    break;
                }
                case 7: {
                    Unit absUnit;
                    if (thisUnit != null) {
                        absUnit = thisUnit.getAbsoluteUnit();
                        thisValue = absUnit.toThis(thisValue, thisUnit);
                        thisUnit = absUnit;
                    }
                    if (thatUnit != null && !CommonUnit.promiscuous.equals(this.unit)) {
                        absUnit = thatUnit.getAbsoluteUnit();
                        thatValue = absUnit.toThis(thatValue, thatUnit);
                        thatUnit = absUnit;
                    }
                    outUnit = thisUnit != null && (thisUnit.equals(CommonUnit.promiscuous) || thisUnit.equals(CommonUnit.dimensionless)) ? thisUnit : null;
                    outValue = Math.pow(thisValue, thatValue);
                    break;
                }
                case 8: {
                    Unit absUnit;
                    if (thatUnit != null) {
                        absUnit = thatUnit.getAbsoluteUnit();
                        thatValue = absUnit.toThis(thatValue, thatUnit);
                        thatUnit = absUnit;
                    }
                    if (thisUnit != null && !CommonUnit.promiscuous.equals(this.unit)) {
                        absUnit = thisUnit.getAbsoluteUnit();
                        thisValue = absUnit.toThis(thisValue, thisUnit);
                        thisUnit = absUnit;
                    }
                    outUnit = thatUnit != null && (thatUnit.equals(CommonUnit.promiscuous) || thatUnit.equals(CommonUnit.dimensionless)) ? thatUnit : null;
                    outValue = Math.pow(thatValue, thisValue);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    if (thisUnit != null && thatUnit != null) {
                        Unit absUnit = thisUnit.getAbsoluteUnit();
                        thisValue = absUnit.toThis(thisValue, thisUnit);
                        thatValue = absUnit.toThis(thatValue, thatUnit);
                        thisUnit = absUnit;
                        thatUnit = absUnit;
                    }
                    switch (op) {
                        case 11: {
                            outValue = Math.atan2(thisValue, thatValue);
                            outUnit = CommonUnit.radian;
                            break;
                        }
                        case 12: {
                            outValue = 57.29577951308232 * Math.atan2(thisValue, thatValue);
                            outUnit = CommonUnit.degree;
                            break;
                        }
                        case 13: {
                            outValue = Math.atan2(thatValue, thisValue);
                            outUnit = CommonUnit.radian;
                            break;
                        }
                        case 14: {
                            outValue = 57.29577951308232 * Math.atan2(thatValue, thisValue);
                            outUnit = CommonUnit.degree;
                            break;
                        }
                        case 15: {
                            outValue = thisValue % thatValue;
                            outUnit = thisUnit;
                            break;
                        }
                        case 16: {
                            outValue = thatValue % thisValue;
                            outUnit = thatUnit;
                        }
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("Real.binary: illegal operation");
                }
            }
            if (error_mode == 202 || thisErr == null || thatErr == null) {
                return new Real((RealType)new_type, outValue, outUnit, null);
            }
            return new Real((RealType)new_type, outValue, outUnit, new ErrorEstimate(outValue, outUnit, op, thisErr, thatErr, error_mode));
        }
        if (data instanceof Text) {
            throw new TypeException("Real.binary: types don't match");
        }
        if (data instanceof TupleIface) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(op), new_type, sampling_mode, error_mode);
        }
        throw new TypeException("Real.binary");
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        Unit u;
        double value;
        double thisValue;
        Unit thisUnit;
        if (this.unit == null) {
            thisUnit = null;
            thisValue = this.Value;
        } else {
            thisUnit = Unit.canConvert(CommonUnit.dimensionless, this.unit) ? CommonUnit.dimensionless : this.unit.getAbsoluteUnit();
            thisValue = thisUnit.toThis(this.Value, this.unit);
        }
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        switch (op) {
            case 21: {
                value = Math.abs(thisValue);
                u = thisUnit;
                break;
            }
            case 22: {
                value = Math.acos(thisValue);
                u = CommonUnit.radian;
                break;
            }
            case 23: {
                value = 57.29577951308232 * Math.acos(thisValue);
                u = CommonUnit.degree;
                break;
            }
            case 24: {
                value = Math.asin(thisValue);
                u = CommonUnit.radian;
                break;
            }
            case 25: {
                value = 57.29577951308232 * Math.asin(thisValue);
                u = CommonUnit.degree;
                break;
            }
            case 26: {
                value = Math.atan(thisValue);
                u = CommonUnit.radian;
                break;
            }
            case 27: {
                value = 57.29577951308232 * Math.atan(thisValue);
                u = CommonUnit.degree;
                break;
            }
            case 28: {
                value = Math.ceil(thisValue);
                u = thisUnit;
                break;
            }
            case 29: {
                value = CommonUnit.degree.equals(thisUnit) ? Math.cos(Math.PI / 180 * thisValue) : Math.cos(thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 30: {
                value = CommonUnit.radian.equals(thisUnit) ? Math.cos(thisValue) : Math.cos(Math.PI / 180 * thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 31: {
                value = Math.exp(thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 32: {
                value = Math.floor(thisValue);
                u = thisUnit;
                break;
            }
            case 33: {
                value = Math.log(thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 34: {
                value = Math.rint(thisValue);
                u = thisUnit;
                break;
            }
            case 35: {
                value = Math.round(thisValue);
                u = thisUnit;
                break;
            }
            case 36: {
                value = CommonUnit.degree.equals(thisUnit) ? Math.sin(Math.PI / 180 * thisValue) : Math.sin(thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 37: {
                value = CommonUnit.radian.equals(thisUnit) ? Math.sin(thisValue) : Math.sin(Math.PI / 180 * thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 38: {
                value = Math.sqrt(thisValue);
                if (thisUnit == null) {
                    u = null;
                    break;
                }
                try {
                    u = thisUnit.sqrt();
                }
                catch (IllegalArgumentException e2) {
                    u = null;
                }
                catch (UnitException e3) {
                    u = null;
                }
                break;
            }
            case 39: {
                value = CommonUnit.degree.equals(thisUnit) ? Math.tan(Math.PI / 180 * thisValue) : Math.tan(thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 40: {
                value = CommonUnit.radian.equals(thisUnit) ? Math.tan(thisValue) : Math.tan(Math.PI / 180 * thisValue);
                u = CommonUnit.dimensionless.equals(thisUnit) ? thisUnit : null;
                break;
            }
            case 41: {
                value = -thisValue;
                u = thisUnit;
                break;
            }
            case 42: {
                value = thisValue;
                u = thisUnit;
                break;
            }
            default: {
                throw new ArithmeticException("Real.unary: illegal operation");
            }
        }
        if (error_mode == 202 || this.Error == null) {
            return new Real((RealType)new_type, value, u, null);
        }
        return new Real((RealType)new_type, value, u, new ErrorEstimate(value, u, op, this.Error, error_mode));
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        Unit dunit;
        double value;
        if (Double.isNaN(this.Value)) {
            return shadow;
        }
        int i = ((ShadowRealType)type).getIndex();
        if (i >= 0 && (value = (dunit = ((RealType)this.Type).getDefaultUnit()) != null && !dunit.equals(this.unit) ? dunit.toThis(this.Value, this.unit) : this.Value) == value) {
            shadow.ranges[0][i] = Math.min(shadow.ranges[0][i], value);
            shadow.ranges[1][i] = Math.max(shadow.ranges[1][i], value);
        }
        return shadow;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public ErrorEstimate getError() {
        return this.Error;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || this.Error == null || error == null || error.isMissing()) {
            return this;
        }
        double a2 = ((Real)error).getValue();
        double b2 = this.Error.getErrorValue();
        double e2 = error_mode == 200 ? Math.sqrt(a2 * a2 + b2 * b2) : Math.abs(a2) + Math.abs(b2);
        return new Real((RealType)this.Type, this.Value, this.unit, new ErrorEstimate(this.Value, e2, this.unit));
    }

    public Real cloneButValue(double value) throws VisADException {
        return new Real((RealType)this.Type, value, this.unit, this.Error);
    }

    public Real cloneButUnit(Unit u) throws VisADException {
        return new Real((RealType)this.Type, this.Value, u, this.Error);
    }

    public String toString() {
        try {
            if (Double.isNaN(this.Value)) {
                return "missing";
            }
            return Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit()) ? new DateTime(this).toString() : Double.toString(this.Value);
        }
        catch (VisADException e2) {
            return e2.toString();
        }
    }

    public String toValueString() {
        String result;
        block4: {
            try {
                if (Double.isNaN(this.Value)) {
                    result = "missing";
                    break block4;
                }
                if (Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit())) {
                    result = new DateTime(this).toValueString();
                    break block4;
                }
                Unit u = this.unit != null ? this.unit : ((RealType)this.getType()).getDefaultUnit();
                result = Float.toString((float)this.Value) + (u == null ? "" : " " + u);
            }
            catch (VisADException e2) {
                result = e2.toString();
            }
        }
        return result;
    }

    public String longString(String pre) throws VisADException {
        if (Double.isNaN(this.Value)) {
            return pre + "missing\n";
        }
        if (Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit())) {
            return pre + "Real.Time: Value = " + new DateTime(this).toString() + "\n";
        }
        return pre + "Real: Value = " + this.Value + "  (TypeName: " + ((RealType)this.Type).getName() + ")\n";
    }

    public int compareTo(Object object) {
        int comp;
        block4: {
            Real that = (Real)object;
            try {
                Unit defaultUnit = ((RealType)this.getType()).getDefaultUnit();
                comp = new Double(this.getValue(defaultUnit)).compareTo(new Double(that.getValue(defaultUnit)));
                if (comp != 0) break block4;
                if (this.Error == null) {
                    comp = that.Error == null ? 0 : -1;
                    break block4;
                }
                if (that.Error == null) {
                    comp = 1;
                    break block4;
                }
                comp = this.Error.compareTo(that.Error);
            }
            catch (VisADException e2) {
                comp = 1;
            }
        }
        return comp;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Real && this.getType().equals(((Real)obj).getType()) && this.compareTo(obj) == 0;
    }

    public int hashCode() {
        RealType realType = (RealType)this.getType();
        int hashCode = realType.hashCode();
        try {
            hashCode ^= new Double(this.getValue(realType.getDefaultUnit())).hashCode();
        }
        catch (VisADException e2) {
            // empty catch block
        }
        if (this.Error != null) {
            hashCode ^= this.Error.hashCode();
        }
        return hashCode;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b2 = 10;
        Real w = new Real(b2);
        int ii = 14;
        int s = 12;
        Real t2 = new Real(1.0);
        Real x = new Real(12.0);
        Real y = new Real(12.0);
        Real u = new Real(ii);
        Real v = new Real(s);
        System.out.println("x = " + x + "\nw = " + w);
        System.out.println("x + w = " + x.add(w));
        System.out.println("x - w = " + x.subtract(w));
        System.out.println("x * w = " + x.multiply(w));
        System.out.println("x / w = " + x.divide(w));
        System.out.println("sqrt(x) = " + x.sqrt());
        System.out.println("");
        Real fahrenheit = new Real(RealType.getRealType("FahrenheitTemperature", (Unit)new OffsetUnit(459.67, new ScaledUnit(0.5555555555555556, SI.kelvin, "degR"), "degF"), null), 32.0);
        Real kelvin = new Real(RealType.getRealType("Temperature", (Unit)SI.kelvin, null), 300.0);
        System.out.println("300 kelvin + 32 fahrenheit = " + ((Real)kelvin.add(fahrenheit)).toValueString());
        System.out.println("300 kelvin - 32 fahrenheit = " + ((Real)kelvin.subtract(fahrenheit)).toValueString());
        System.out.println("max(300 kelvin, 32 fahrenheit) = " + ((Real)kelvin.max(fahrenheit)).toValueString());
        System.out.println("min(300 kelvin, 32 fahrenheit) = " + ((Real)kelvin.min(fahrenheit)).toValueString());
        System.out.println("");
        System.out.println("32 fahrenheit + 300 kelvin = " + ((Real)fahrenheit.add(kelvin)).toValueString());
        System.out.println("32 fahrenheit - 300 kelvin = " + ((Real)fahrenheit.subtract(kelvin)).toValueString());
        System.out.println("max(32 fahrenheit, 300 kelvin) = " + ((Real)fahrenheit.max(kelvin)).toValueString());
        System.out.println("min(32 fahrenheit, 300 kelvin) = " + ((Real)fahrenheit.min(kelvin)).toValueString());
        System.out.println("");
        Real deltaF = new Real(RealType.getRealType("DeltaFahrenheitTemperature", new OffsetUnit(459.67, new ScaledUnit(0.5555555555555556, SI.kelvin, "degR"), "degF"), null, 1), 32.0);
        System.out.println("300 kelvin + 32 deltaF = " + ((Real)kelvin.add(deltaF)).toValueString());
        System.out.println("300 kelvin - 32 deltaF = " + ((Real)kelvin.subtract(deltaF)).toValueString());
        System.out.println("max(300 kelvin, 32 deltaF) = " + ((Real)kelvin.max(deltaF)).toValueString());
        System.out.println("min(300 kelvin, 32 deltaF) = " + ((Real)kelvin.min(deltaF)).toValueString());
        System.out.println("");
        System.out.println("32 deltaF + 300 kelvin = " + ((Real)deltaF.add(kelvin)).toValueString());
        System.out.println("32 deltaF - 300 kelvin = " + ((Real)deltaF.subtract(kelvin)).toValueString());
        System.out.println("max(32 deltaF, 300 kelvin) = " + ((Real)deltaF.max(kelvin)).toValueString());
        System.out.println("min(32 deltaF, 300 kelvin) = " + ((Real)deltaF.min(kelvin)).toValueString());
        System.out.println("");
        Real deltaK = new Real(RealType.getRealType("DeltaTemperature", SI.kelvin, null, 1), 100.0);
        System.out.println("300 kelvin + 100 deltaK = " + ((Real)kelvin.add(deltaK)).toValueString());
        System.out.println("300 kelvin - 100 deltaK = " + ((Real)kelvin.subtract(deltaK)).toValueString());
        System.out.println("max(300 kelvin, 100 deltaK) = " + ((Real)kelvin.max(deltaK)).toValueString());
        System.out.println("min(300 kelvin, 100 deltaK) = " + ((Real)kelvin.min(deltaK)).toValueString());
        System.out.println("");
        System.out.println("100 deltaK + 300 kelvin = " + ((Real)deltaK.add(kelvin)).toValueString());
        System.out.println("100 deltaK - 300 kelvin = " + ((Real)deltaK.subtract(kelvin)).toValueString());
        System.out.println("max(100 deltaK, 300 kelvin) = " + ((Real)deltaK.max(kelvin)).toValueString());
        System.out.println("min(100 deltaK, 300 kelvin) = " + ((Real)deltaK.min(kelvin)).toValueString());
        System.out.println("");
        System.out.println("100 deltaK + 32 deltaF = " + ((Real)deltaK.add(deltaF)).toValueString());
        System.out.println("100 deltaK - 32 deltaF = " + ((Real)deltaK.subtract(deltaF)).toValueString());
        System.out.println("max(100 deltaK, 32 deltaF) = " + ((Real)deltaK.max(deltaF)).toValueString());
        System.out.println("min(100 deltaK, 32 deltaF) = " + ((Real)deltaK.min(deltaF)).toValueString());
        System.out.println("");
        System.out.println("32 deltaF + 100 deltaK = " + ((Real)deltaF.add(deltaK)).toValueString());
        System.out.println("32 deltaF - 100 deltaK = " + ((Real)deltaF.subtract(deltaK)).toValueString());
        System.out.println("max(32 deltaF, 100 deltaK) = " + ((Real)deltaF.max(deltaK)).toValueString());
        System.out.println("min(32 deltaF, 100 deltaK) = " + ((Real)deltaF.min(deltaK)).toValueString());
        System.out.println("");
        System.out.println("300 kelvin + -(32 fahrenheit) = " + ((Real)kelvin.add(fahrenheit.negate())).toValueString());
        System.out.println("32 fahrenheit + -(300 kelvin) = " + ((Real)fahrenheit.add(kelvin.negate())).toValueString());
        System.out.println("");
        ScaledUnit foot = new ScaledUnit(3.048, SI.meter);
        ScaledUnit yard = new ScaledUnit(3.0, foot);
        System.out.println("log(1 yard / 3 feet) = " + ((Real)new Real(RealType.getRealType("OneYard", (Unit)SI.meter, null), 1.0, yard).divide(new Real(RealType.getRealType("ThreeFeet", (Unit)SI.meter, null), 3.0, foot)).log()).toValueString());
    }
}

