/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.ShadowType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class RealTupleType
extends TupleType {
    private CoordinateSystem DefaultCoordinateSystem;
    private Unit[] DefaultUnits;
    private Set DefaultSet;
    private boolean DefaultSetEverAccessed;
    private static RealType[] components2c = new RealType[]{RealType.XAxis, RealType.YAxis};
    public static final RealTupleType SpatialCartesian2DTuple = new RealTupleType(components2c, true);
    private static RealType[] components3c = new RealType[]{RealType.XAxis, RealType.YAxis, RealType.ZAxis};
    public static final RealTupleType SpatialCartesian3DTuple = new RealTupleType(components3c, true);
    private static RealType[] components2e = new RealType[]{RealType.Longitude, RealType.Latitude};
    public static final RealTupleType SpatialEarth2DTuple = new RealTupleType(components2e, true);
    private static RealType[] componentsll = new RealType[]{RealType.Latitude, RealType.Longitude};
    public static final RealTupleType LatitudeLongitudeTuple = new RealTupleType(componentsll, true);
    private static RealType[] components3e = new RealType[]{RealType.Longitude, RealType.Latitude, RealType.Altitude};
    public static final RealTupleType SpatialEarth3DTuple = new RealTupleType(components3e, true);
    private static RealType[] componentslla = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
    public static final RealTupleType LatitudeLongitudeAltitude = new RealTupleType(componentslla, true);
    private static RealType[] components1t = new RealType[]{RealType.Time};
    public static final RealTupleType Time1DTuple = new RealTupleType(components1t, true);
    private static RealType[] components2g = new RealType[]{RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic2D = new RealTupleType(components2g, true);
    private static RealType[] components3g = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic3D = new RealTupleType(components3g, true);

    public RealTupleType(RealType[] types) throws VisADException {
        this(types, null, null);
    }

    public RealTupleType(RealType a2) throws VisADException {
        this(RealTupleType.makeArray(a2), null, null);
    }

    public RealTupleType(RealType a2, RealType b2) throws VisADException {
        this(RealTupleType.makeArray(a2, b2), null, null);
    }

    public RealTupleType(RealType a2, RealType b2, RealType c2) throws VisADException {
        this(RealTupleType.makeArray(a2, b2, c2), null, null);
    }

    public RealTupleType(RealType a2, RealType b2, RealType c2, RealType d2) throws VisADException {
        this(RealTupleType.makeArray(a2, b2, c2, d2), null, null);
    }

    public RealTupleType(RealType[] types, CoordinateSystem coord_sys, Set set) throws VisADException {
        super(types);
        if (coord_sys != null && types.length != coord_sys.getDimension()) {
            throw new CoordinateSystemException("RealTupleType: bad CoordinateSystem dimension");
        }
        this.DefaultCoordinateSystem = coord_sys;
        this.DefaultSet = set;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(types);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Units");
        }
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem cs = this.DefaultSet.getCoordinateSystem();
            if (cs != null && !cs.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + (coord_sys == null ? null : coord_sys.getReference()) + " must match" + " default set CoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public RealTupleType(RealType a2, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a2), coord_sys, set);
    }

    public RealTupleType(RealType a2, RealType b2, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a2, b2), coord_sys, set);
    }

    public RealTupleType(RealType a2, RealType b2, RealType c2, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a2, b2, c2), coord_sys, set);
    }

    public RealTupleType(RealType a2, RealType b2, RealType c2, RealType d2, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a2, b2, c2, d2), coord_sys, set);
    }

    RealTupleType(RealType[] types, boolean b2) {
        this(types, null, b2);
    }

    RealTupleType(RealType[] types, CoordinateSystem coord_sys, boolean b2) {
        super(types, b2);
        this.DefaultCoordinateSystem = coord_sys;
        this.DefaultSet = null;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(types);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new VisADError("RealTupleType (trusted): CoordinateSystem Units must be convertable with default Units");
        }
    }

    public MathType binary(MathType type, int op, Vector names) throws TypeException, VisADException {
        if (type == null) {
            throw new TypeException("RealTupleType.binary: type may not be null");
        }
        if (type instanceof RealTupleType) {
            int n_comps = this.getDimension();
            RealType[] new_types = new RealType[n_comps];
            int ii = 0;
            while (ii < n_comps) {
                RealType type_component = (RealType)((RealTupleType)type).getComponent(ii);
                new_types[ii] = (RealType)this.getComponent(ii).binary(type_component, op, names);
                ++ii;
            }
            return new RealTupleType(new_types);
        }
        if (type instanceof RealType) {
            int n_comps = this.getDimension();
            RealType[] new_types = new RealType[n_comps];
            int ii = 0;
            while (ii < n_comps) {
                new_types[ii] = (RealType)this.getComponent(ii).binary(type, op, names);
                ++ii;
            }
            return new RealTupleType(new_types);
        }
        if (type instanceof FunctionType && ((FunctionType)type).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)type).getDomain(), ((FunctionType)type).getRange().binary(this, DataImpl.invertOp(op), names));
        }
        throw new TypeException("RealTupleType.binary: types don't match");
    }

    public MathType unary(int op, Vector names) throws VisADException {
        int n_comps = this.getDimension();
        RealType[] R_types = new RealType[n_comps];
        int ii = 0;
        while (ii < n_comps) {
            R_types[ii] = (RealType)this.getComponent(ii).unary(op, names);
            ++ii;
        }
        return new RealTupleType(R_types, this.DefaultCoordinateSystem, null);
    }

    public static RealType[] makeArray(RealType a2) {
        RealType[] types = new RealType[]{a2};
        return types;
    }

    public static RealType[] makeArray(RealType a2, RealType b2) {
        RealType[] types = new RealType[]{a2, b2};
        return types;
    }

    public static RealType[] makeArray(RealType a2, RealType b2, RealType c2) {
        RealType[] types = new RealType[]{a2, b2, c2};
        return types;
    }

    public static RealType[] makeArray(RealType a2, RealType b2, RealType c2, RealType d2) {
        RealType[] types = new RealType[]{a2, b2, c2, d2};
        return types;
    }

    private void setDefaultUnits(RealType[] types) {
        int n = types.length;
        this.DefaultUnits = new Unit[n];
        int i = 0;
        while (i < n) {
            this.DefaultUnits[i] = types[i].getDefaultUnit();
            ++i;
        }
    }

    public Unit[] getDefaultUnits() {
        return Unit.copyUnitsArray(this.DefaultUnits);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.DefaultCoordinateSystem;
    }

    public synchronized void setDefaultSet(Set sampling) throws VisADException {
        if (sampling.getDimension() != this.getDimension()) {
            throw new SetException("RealTupleType.setDefaultSet: dimensions don't match");
        }
        if (this.DefaultSetEverAccessed) {
            throw new TypeException("RealTupleType: DefaultSet already accessed so cannot change");
        }
        this.DefaultSet = sampling;
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem cs = this.DefaultSet.getCoordinateSystem();
            if (cs != null && !cs.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + this.DefaultCoordinateSystem.getReference() + " must match" + " default set CoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public synchronized Set getDefaultSet() {
        this.DefaultSetEverAccessed = true;
        return this.DefaultSet;
    }

    public boolean equalsExceptName(MathType type) {
        int n = this.getDimension();
        try {
            if (type instanceof RealType) {
                return n == 1 && this.getComponent(0) instanceof RealType;
            }
            if (!(type instanceof RealTupleType)) {
                return false;
            }
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            int i = 0;
            while (i < n) {
                flag = flag && this.getComponent(i).equalsExceptName(((TupleType)type).getComponent(i));
                ++i;
            }
            return flag;
        }
        catch (VisADException e2) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType type) {
        int n = this.getDimension();
        try {
            if (type instanceof RealType) {
                return type.equalsExceptNameButUnits(this);
            }
            if (!(type instanceof RealTupleType)) {
                return false;
            }
            if (n != ((RealTupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            int i = 0;
            while (i < n) {
                flag = flag && this.getComponent(i).equalsExceptNameButUnits(((RealTupleType)type).getComponent(i));
                ++i;
            }
            return flag;
        }
        catch (VisADException e2) {
            return false;
        }
    }

    public String prettyString(int indent) {
        try {
            if (this.getDimension() == 1) {
                return ((RealType)this.getComponent(0)).toString();
            }
        }
        catch (VisADException e2) {
            return super.prettyString(0);
        }
        return super.prettyString(0);
    }

    public Data missingData() {
        return new RealTuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowRealTupleType(this, link, parent);
    }
}

