/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ContourControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayInterruptException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowScalarType;
import visad.ShadowSetType;
import visad.ShadowTextType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.TextControl;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;

public abstract class ShadowFunctionOrSetType
extends ShadowType {
    ShadowRealTupleType Domain;
    ShadowType Range;
    ShadowRealType[] RangeComponents;
    ShadowRealType[] DomainComponents;
    ShadowRealType[] DomainReferenceComponents;
    boolean Flat;
    int[] inherited_values;

    public ShadowFunctionOrSetType(MathType t2, DataDisplayLink link, ShadowType parent, ShadowRealTupleType domain, ShadowType range) throws VisADException, RemoteException {
        super(t2, link, parent);
        this.Domain = domain;
        this.Range = range;
        if (this instanceof ShadowFunctionType) {
            this.Flat = this.Range instanceof ShadowRealType || this.Range instanceof ShadowTextType || this.Range instanceof ShadowTupleType && ((ShadowTupleType)this.Range).isFlat();
            this.MultipleSpatialDisplayScalar = this.Domain.getMultipleSpatialDisplayScalar() || this.Range.getMultipleSpatialDisplayScalar();
            this.MultipleDisplayScalar = this.Domain.getMultipleDisplayScalar() || this.Range.getMultipleDisplayScalar();
            this.MappedDisplayScalar = this.Domain.getMappedDisplayScalar() || this.Range.getMappedDisplayScalar();
            this.RangeComponents = this.getComponents(this.Range, true);
        } else if (this instanceof ShadowSetType) {
            this.Flat = true;
            this.MultipleDisplayScalar = this.Domain.getMultipleDisplayScalar();
            this.MappedDisplayScalar = this.Domain.getMappedDisplayScalar();
            this.RangeComponents = null;
        } else {
            throw new DisplayException("ShadowFunctionOrSetType: must be ShadowFunctionType or ShadowSetType");
        }
        this.DomainComponents = this.getComponents(this.Domain, false);
        this.DomainReferenceComponents = this.getComponents(this.Domain.getReference(), false);
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public ShadowRealType[] getRangeComponents() {
        return this.RangeComponents;
    }

    public ShadowRealType[] getDomainComponents() {
        return this.DomainComponents;
    }

    public ShadowRealType[] getDomainReferenceComponents() {
        return this.DomainReferenceComponents;
    }

    int[] getRangeDisplayIndices() throws VisADException {
        if (!(this instanceof ShadowFunctionType)) {
            throw new DisplayException("ShadowFunctionOrSetType.getRangeDisplayIndices: must be ShadowFunctionType");
        }
        int n = this.RangeComponents.length;
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = this.RangeComponents[i].getIndex();
            ++i;
        }
        return indices;
    }

    public int[] getInheritedValues() {
        return this.inherited_values;
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        int[] local_indices = this.Domain.sumIndices(indices);
        int[] local_display_indices = this.Domain.sumDisplayIndices(display_indices);
        int[] local_value_indices = this.Domain.sumValueIndices(value_indices);
        if (this.Domain.testTransform()) {
            this.Domain.markTransform(isTransform);
        }
        if (this instanceof ShadowFunctionType) {
            this.Range.markTransform(isTransform);
        }
        this.inherited_values = ShadowType.copyIndices(value_indices);
        if (levelOfDifficulty == 6 && this.checkAny(local_display_indices)) {
            levelOfDifficulty = 2;
        }
        int avCount = this.checkAnimationOrValue(this.Domain.getDisplayIndices());
        if (this.Domain.getDimension() != 1) {
            if (avCount > 0) {
                throw new BadMappingException("Animation and SelectValue may only occur in 1-D Function domain: ShadowFunctionOrSetType.checkIndices");
            }
            if (avCount > 1) {
                throw new BadMappingException("only one Animation and SelectValue may occur Set domain: ShadowFunctionOrSetType.checkIndices");
            }
        }
        if (this.Flat || this instanceof ShadowSetType) {
            if (this instanceof ShadowFunctionType) {
                if (this.Range instanceof ShadowTupleType) {
                    local_indices = ((ShadowTupleType)this.Range).sumIndices(local_indices);
                    local_display_indices = ((ShadowTupleType)this.Range).sumDisplayIndices(local_display_indices);
                    local_value_indices = ((ShadowTupleType)this.Range).sumValueIndices(local_value_indices);
                } else if (this.Range instanceof ShadowScalarType) {
                    ((ShadowScalarType)this.Range).incrementIndices(local_indices);
                    local_display_indices = ShadowType.addIndices(local_display_indices, ((ShadowScalarType)this.Range).getDisplayIndices());
                    local_value_indices = ShadowType.addIndices(local_value_indices, ((ShadowScalarType)this.Range).getValueIndices());
                }
                if (this.checkAnimationOrValue(this.Range.getDisplayIndices()) > 0) {
                    throw new BadMappingException("Animation and SelectValue may not occur in Function range: ShadowFunctionOrSetType.checkIndices");
                }
            }
            this.anyContour = this.checkContour(local_display_indices);
            this.anyFlow = this.checkFlow(local_display_indices);
            this.anyShape = this.checkShape(local_display_indices);
            this.anyText = this.checkText(local_display_indices);
            this.LevelOfDifficulty = this.testIndices(local_indices, local_display_indices, levelOfDifficulty);
            this.Dtype = !this.Domain.getMappedDisplayScalar() ? 0 : (this.Domain.getAllSpatial() && this.checkR4(this.Domain.getDisplayIndices()) ? 1 : (this.checkR1D3(this.Domain.getDisplayIndices()) ? 3 : (this.checkR2D2(this.Domain.getDisplayIndices()) ? 2 : (this.checkAnimationOrValue(this.Domain.getDisplayIndices()) > 0 ? 4 : 5))));
            this.Rtype = this instanceof ShadowFunctionType ? (!this.Range.getMappedDisplayScalar() ? 0 : (this.checkR1D3(this.Range.getDisplayIndices()) ? 1 : (this.checkR2D2(this.Range.getDisplayIndices()) ? 2 : (this.checkR3(this.Range.getDisplayIndices()) ? 3 : (this.checkR4(this.Range.getDisplayIndices()) ? 4 : 5))))) : 0;
            if (this.LevelOfDifficulty == 2) {
                this.LevelOfDifficulty = this.Dtype != 5 && this.Rtype != 5 ? (this.Dtype == 4 ? 4 : 3) : 1;
            }
            if (this instanceof ShadowFunctionType) {
                this.isTextureMap = !this.getMultipleDisplayScalar() && this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 2 && this.Domain.getAllSpatial() && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && this.display.getGraphicsModeControl().getTextureEnable() && !this.display.getGraphicsModeControl().getPointMode();
                this.curvedTexture = this.getLevelOfDifficulty() == 3 && this.Domain.getAllSpatial() && this.checkSpatialOffsetColorAlphaRange(this.Domain.getDisplayIndices()) && this.checkSpatialOffsetColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && !this.display.getGraphicsModeControl().getPointMode();
                this.isTexture3D = this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 3 && this.Domain.getAllSpatial() && this.checkSpatialRange(this.Domain.getDisplayIndices()) && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkColorAlphaRange(this.Range.getDisplayIndices()) && this.checkAny(this.Range.getDisplayIndices()) && this.display.getGraphicsModeControl().getTextureEnable() && !this.display.getGraphicsModeControl().getPointMode();
                this.isLinearContour3D = this.getLevelOfDifficulty() == 3 && ((FunctionType)this.getType()).getReal() && this.Domain.getDimension() == 3 && this.Domain.getAllSpatial() && !this.Domain.getMultipleDisplayScalar() && !this.Domain.getSpatialReference() && Display.DisplaySpatialCartesianTuple.equals(this.Domain.getDisplaySpatialTuple()) && this.checkContourColorAlphaRange(this.Range.getDisplayIndices()) && this.checkContour(this.Range.getDisplayIndices());
            }
        } else {
            if (levelOfDifficulty == 2 && !this.checkNested(this.Domain.getDisplayIndices())) {
                levelOfDifficulty = 1;
            }
            this.LevelOfDifficulty = this.Range.checkIndices(local_indices, local_display_indices, local_value_indices, isTransform, levelOfDifficulty);
        }
        return this.LevelOfDifficulty;
    }

    public ShadowRealTupleType getDomain() {
        return this.Domain;
    }

    public ShadowType getRange() {
        return this.Range;
    }

    void markTransform(boolean[] isTransform) {
        if (this.Range != null) {
            this.Range.markTransform(isTransform);
        }
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        boolean[][] range_select;
        int i;
        int i2;
        Linear1DSet Y;
        Linear1DSet X;
        int domain_dimension;
        int domain_length;
        if (data.isMissing()) {
            return false;
        }
        if (this.LevelOfDifficulty == 6) {
            return false;
        }
        DataDisplayLink link = renderer.getLink();
        if (link != null) {
            boolean time_flag = false;
            if (link.time_flag) {
                time_flag = true;
            } else if (500L < System.currentTimeMillis() - link.start_time) {
                link.time_flag = true;
                time_flag = true;
            }
            if (time_flag) {
                if (link.peekTicks()) {
                    throw new DisplayInterruptException("please wait . . .");
                }
                Enumeration maps = link.getSelectedMapVector().elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!map.peekTicks(renderer, link)) continue;
                    throw new DisplayInterruptException("please wait . . .");
                }
            }
        }
        boolean anyContour = this.getAnyContour();
        boolean anyFlow = this.getAnyFlow();
        boolean anyShape = this.getAnyShape();
        boolean anyText = this.getAnyText();
        boolean indexed = shadow_api.wantIndexed();
        int valueArrayLength = this.display.getValueArrayLength();
        int[] valueToScalar = this.display.getValueToScalar();
        int[] valueToMap = this.display.getValueToMap();
        Vector MapVector = this.display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int i3 = 0;
        while (i3 < valueArrayLength) {
            if (this.inherited_values[i3] > 0) {
                display_values[i3] = new float[1];
                display_values[i3][0] = value_array[i3];
            }
            ++i3;
        }
        if (this.getIsTerminal() && anyContour && !anyFlow && !anyShape && !anyText) {
            boolean any_enabled = false;
            int i4 = 0;
            while (i4 < valueArrayLength) {
                int displayScalarIndex = valueToScalar[i4];
                DisplayRealType real = this.display.getDisplayScalar(displayScalarIndex);
                if (real.equals(Display.IsoContour) && this.inherited_values[i4] == 0) {
                    ContourControl control = (ContourControl)((ScalarMap)MapVector.elementAt(valueToMap[i4])).getControl();
                    boolean[] bvalues = new boolean[2];
                    float[] fvalues = new float[5];
                    control.getMainContours(bvalues, fvalues);
                    if (bvalues[0]) {
                        any_enabled = true;
                    }
                }
                ++i4;
            }
            if (!any_enabled) {
                return false;
            }
        }
        Set domain_set = null;
        Unit[] dataUnits = null;
        CoordinateSystem dataCoordinateSystem = null;
        if (this instanceof ShadowFunctionType) {
            if (!(data instanceof Field)) {
                throw new UnimplementedException("data must be Field: ShadowFunctionOrSetType.doTransform: ");
            }
            domain_set = ((Field)data).getDomainSet();
            dataUnits = ((Function)data).getDomainUnits();
            dataCoordinateSystem = ((Function)data).getDomainCoordinateSystem();
        } else if (this instanceof ShadowSetType) {
            domain_set = (Set)data;
            dataUnits = ((Set)data).getSetUnits();
            dataCoordinateSystem = ((Set)data).getCoordinateSystem();
        } else {
            throw new DisplayException("must be ShadowFunctionType or ShadowSetType: ShadowFunctionOrSetType.doTransform");
        }
        float[][] domain_values = null;
        double[][] domain_doubles = null;
        Unit[] domain_units = ((RealTupleType)this.Domain.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            domain_dimension = domain_set.getDimension();
        }
        catch (SetException e2) {
            return false;
        }
        ShadowRealType[] DomainComponents = this.getDomainComponents();
        int alpha_index = this.display.getDisplayScalarIndex(Display.Alpha);
        String[] text_values = null;
        TextControl text_control = shadow_api.getParentTextControl();
        String inherited_text = shadow_api.getParentText();
        if (inherited_text != null) {
            text_values = new String[domain_length];
            int i5 = 0;
            while (i5 < domain_length) {
                text_values[i5] = inherited_text;
                ++i5;
            }
        }
        boolean isTextureMap = this.getIsTextureMap() && renderer.isLegalTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2);
        int cMapCurveSize = (int)default_values[this.display.getDisplayScalarIndex(Display.CurvedSize)];
        int curved_size = cMapCurveSize > 0 ? cMapCurveSize : this.display.getGraphicsModeControl().getCurvedSize();
        float textureEnable = default_values[this.display.getDisplayScalarIndex(Display.TextureEnable)];
        boolean texture = this.display.getGraphicsModeControl().getTextureEnable();
        if (textureEnable > -0.5f) {
            texture = textureEnable > 0.5f;
        }
        boolean curvedTexture = this.getCurvedTexture() && !isTextureMap && texture && curved_size > 0 && this.getIsTerminal() && shadow_api.allowCurvedTexture() && (double)default_values[alpha_index] > 0.99 && renderer.isLegalTextureMap() && domain_set.getManifoldDimension() == 2 && domain_set instanceof GriddedSet;
        boolean domainOnlySpatial = this.Domain.getAllSpatial() && !this.Domain.getMultipleDisplayScalar();
        boolean isTexture3D = this.getIsTexture3D() && renderer.isLegalTextureMap() && (domain_set instanceof Linear3DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 3);
        boolean range3D = isTexture3D && this.anyRange(this.Domain.getDisplayIndices());
        boolean isLinearContour3D = this.getIsLinearContour3D() && domain_set instanceof Linear3DSet && shadow_api.allowLinearContour();
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int data_depth = 0;
        int texture_width = 1;
        int texture_height = 1;
        int texture_depth = 1;
        float[] coordinatesX = null;
        float[] texCoordsX = null;
        float[] normalsX = null;
        byte[] colorsX = null;
        float[] coordinatesY = null;
        float[] texCoordsY = null;
        float[] normalsY = null;
        byte[] colorsY = null;
        float[] coordinatesZ = null;
        float[] texCoordsZ = null;
        float[] normalsZ = null;
        byte[] colorsZ = null;
        int[] volume_tuple_index = null;
        if (isTextureMap) {
            X = null;
            Y = null;
            if (domain_set instanceof Linear2DSet) {
                X = ((Linear2DSet)domain_set).getX();
                Y = ((Linear2DSet)domain_set).getY();
            } else {
                X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
                Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
            }
            float[][] limits = new float[2][2];
            limits[0][0] = (float)X.getFirst();
            limits[0][1] = (float)X.getLast();
            limits[1][0] = (float)Y.getFirst();
            limits[1][1] = (float)Y.getLast();
            data_width = X.getLength();
            data_height = Y.getLength();
            texture_width = shadow_api.textureWidth(data_width);
            texture_height = shadow_api.textureHeight(data_height);
            float half_width = 0.5f / (float)(data_width - 1);
            float half_height = 0.5f / (float)(data_height - 1);
            half_width = (limits[0][1] - limits[0][0]) * half_width;
            half_height = (limits[1][1] - limits[1][0]) * half_height;
            float[] fArray = limits[0];
            fArray[0] = fArray[0] - half_width;
            float[] fArray2 = limits[0];
            fArray2[1] = fArray2[1] + half_width;
            float[] fArray3 = limits[1];
            fArray3[0] = fArray3[0] - half_height;
            float[] fArray4 = limits[1];
            fArray4[1] = fArray4[1] + half_height;
            limits = Unit.convertTuple(limits, dataUnits, domain_units);
            int[] tuple_index = new int[3];
            if (DomainComponents.length != 2) {
                throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
            }
            i2 = 0;
            while (i2 < DomainComponents.length) {
                Enumeration maps = DomainComponents[i2].getSelectedMapVector().elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    DisplayRealType real = map.getDisplayScalar();
                    DisplayTupleType tuple = real.getTuple();
                    if (!Display.DisplaySpatialCartesianTuple.equals(tuple)) continue;
                    limits[i2] = map.scaleValues(limits[i2]);
                    tuple_index[i2] = real.getTupleIndex();
                    break;
                }
                ++i2;
            }
            tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
            DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
            int value2_index = this.display.getDisplayScalarIndex(real);
            float value2 = default_values[value2_index];
            int i6 = 0;
            while (i6 < valueArrayLength) {
                if (this.inherited_values[i6] > 0 && real.equals(this.display.getDisplayScalar(valueToScalar[i6]))) {
                    value2 = value_array[i6];
                    break;
                }
                ++i6;
            }
            coordinates = new float[12];
            coordinates[tuple_index[0]] = limits[0][0];
            coordinates[tuple_index[1]] = limits[1][0];
            coordinates[tuple_index[2]] = value2;
            coordinates[3 + tuple_index[0]] = limits[0][1];
            coordinates[3 + tuple_index[1]] = limits[1][0];
            coordinates[3 + tuple_index[2]] = value2;
            coordinates[6 + tuple_index[0]] = limits[0][1];
            coordinates[6 + tuple_index[1]] = limits[1][1];
            coordinates[6 + tuple_index[2]] = value2;
            coordinates[9 + tuple_index[0]] = limits[0][0];
            coordinates[9 + tuple_index[1]] = limits[1][1];
            coordinates[9 + tuple_index[2]] = value2;
            shadow_api.adjustZ(coordinates);
            texCoords = new float[8];
            float ratiow = (float)data_width / (float)texture_width;
            float ratioh = (float)data_height / (float)texture_height;
            shadow_api.setTexCoords(texCoords, ratiow, ratioh);
            normals = new float[12];
            float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
            float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
            float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
            float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            normals[0] = n0 /= nlen;
            normals[1] = n1 /= nlen;
            normals[2] = n2 /= nlen;
            normals[3] = n0;
            normals[4] = n1;
            normals[5] = n2;
            normals[6] = n0;
            normals[7] = n1;
            normals[8] = n2;
            normals[9] = n0;
            normals[10] = n1;
            normals[11] = n2;
            colors = new byte[12];
            i = 0;
            while (i < 12) {
                colors[i] = 127;
                ++i;
            }
        } else if (isTexture3D) {
            X = null;
            Y = null;
            Linear1DSet Z = null;
            if (domain_set instanceof Linear3DSet) {
                X = ((Linear3DSet)domain_set).getX();
                Y = ((Linear3DSet)domain_set).getY();
                Z = ((Linear3DSet)domain_set).getZ();
            } else {
                X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
                Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
                Z = ((LinearNDSet)domain_set).getLinear1DComponent(2);
            }
            float[][] limits = new float[3][2];
            limits[0][0] = (float)X.getFirst();
            limits[0][1] = (float)X.getLast();
            limits[1][0] = (float)Y.getFirst();
            limits[1][1] = (float)Y.getLast();
            limits[2][0] = (float)Z.getFirst();
            limits[2][1] = (float)Z.getLast();
            limits = Unit.convertTuple(limits, dataUnits, domain_units);
            data_width = X.getLength();
            data_height = Y.getLength();
            data_depth = Z.getLength();
            texture_width = shadow_api.textureWidth(data_width);
            texture_height = shadow_api.textureHeight(data_height);
            texture_depth = shadow_api.textureDepth(data_depth);
            int[] tuple_index = new int[3];
            if (DomainComponents.length != 3) {
                throw new DisplayException("texture3D domain dimension != 3:ShadowFunctionOrSetType.doTransform");
            }
            int i7 = 0;
            while (i7 < DomainComponents.length) {
                Enumeration maps = DomainComponents[i7].getSelectedMapVector().elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    DisplayRealType real = map.getDisplayScalar();
                    DisplayTupleType tuple = real.getTuple();
                    if (!Display.DisplaySpatialCartesianTuple.equals(tuple)) continue;
                    limits[i7] = map.scaleValues(limits[i7]);
                    tuple_index[i7] = real.getTupleIndex();
                    break;
                }
                ++i7;
            }
            volume_tuple_index = tuple_index;
            coordinatesX = new float[12 * data_width];
            coordinatesY = new float[12 * data_height];
            coordinatesZ = new float[12 * data_depth];
            i2 = 0;
            while (i2 < data_depth) {
                int i12 = i2 * 12;
                float depth = limits[2][0] + (limits[2][1] - limits[2][0]) * (float)i2 / ((float)data_depth - 1.0f);
                coordinatesZ[i12 + tuple_index[0]] = limits[0][0];
                coordinatesZ[i12 + tuple_index[1]] = limits[1][0];
                coordinatesZ[i12 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 3 + tuple_index[0]] = limits[0][1];
                coordinatesZ[i12 + 3 + tuple_index[1]] = limits[1][0];
                coordinatesZ[i12 + 3 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 6 + tuple_index[0]] = limits[0][1];
                coordinatesZ[i12 + 6 + tuple_index[1]] = limits[1][1];
                coordinatesZ[i12 + 6 + tuple_index[2]] = depth;
                coordinatesZ[i12 + 9 + tuple_index[0]] = limits[0][0];
                coordinatesZ[i12 + 9 + tuple_index[1]] = limits[1][1];
                coordinatesZ[i12 + 9 + tuple_index[2]] = depth;
                ++i2;
            }
            int i8 = 0;
            while (i8 < data_height) {
                int i12 = i8 * 12;
                float height = limits[1][0] + (limits[1][1] - limits[1][0]) * (float)i8 / ((float)data_height - 1.0f);
                coordinatesY[i12 + tuple_index[0]] = limits[0][0];
                coordinatesY[i12 + tuple_index[1]] = height;
                coordinatesY[i12 + tuple_index[2]] = limits[2][0];
                coordinatesY[i12 + 3 + tuple_index[0]] = limits[0][1];
                coordinatesY[i12 + 3 + tuple_index[1]] = height;
                coordinatesY[i12 + 3 + tuple_index[2]] = limits[2][0];
                coordinatesY[i12 + 6 + tuple_index[0]] = limits[0][1];
                coordinatesY[i12 + 6 + tuple_index[1]] = height;
                coordinatesY[i12 + 6 + tuple_index[2]] = limits[2][1];
                coordinatesY[i12 + 9 + tuple_index[0]] = limits[0][0];
                coordinatesY[i12 + 9 + tuple_index[1]] = height;
                coordinatesY[i12 + 9 + tuple_index[2]] = limits[2][1];
                ++i8;
            }
            int i9 = 0;
            while (i9 < data_width) {
                float width;
                int i12 = i9 * 12;
                coordinatesX[i12 + tuple_index[0]] = width = limits[0][0] + (limits[0][1] - limits[0][0]) * (float)i9 / ((float)data_width - 1.0f);
                coordinatesX[i12 + tuple_index[1]] = limits[1][0];
                coordinatesX[i12 + tuple_index[2]] = limits[2][0];
                coordinatesX[i12 + 3 + tuple_index[0]] = width;
                coordinatesX[i12 + 3 + tuple_index[1]] = limits[1][1];
                coordinatesX[i12 + 3 + tuple_index[2]] = limits[2][0];
                coordinatesX[i12 + 6 + tuple_index[0]] = width;
                coordinatesX[i12 + 6 + tuple_index[1]] = limits[1][1];
                coordinatesX[i12 + 6 + tuple_index[2]] = limits[2][1];
                coordinatesX[i12 + 9 + tuple_index[0]] = width;
                coordinatesX[i12 + 9 + tuple_index[1]] = limits[1][0];
                coordinatesX[i12 + 9 + tuple_index[2]] = limits[2][1];
                ++i9;
            }
            float ratiow = (float)data_width / (float)texture_width;
            float ratioh = (float)data_height / (float)texture_height;
            float ratiod = (float)data_depth / (float)texture_depth;
            texCoordsX = shadow_api.setTexStackCoords(data_width, 0, ratiow, ratioh, ratiod);
            texCoordsY = shadow_api.setTexStackCoords(data_height, 1, ratiow, ratioh, ratiod);
            texCoordsZ = shadow_api.setTexStackCoords(data_depth, 2, ratiow, ratioh, ratiod);
            normalsX = new float[12 * data_width];
            normalsY = new float[12 * data_height];
            normalsZ = new float[12 * data_depth];
            float n0 = (coordinatesX[5] - coordinatesX[2]) * (coordinatesX[7] - coordinatesX[1]) - (coordinatesX[4] - coordinatesX[1]) * (coordinatesX[8] - coordinatesX[2]);
            float n1 = (coordinatesX[3] - coordinatesX[0]) * (coordinatesX[8] - coordinatesX[2]) - (coordinatesX[5] - coordinatesX[2]) * (coordinatesX[6] - coordinatesX[0]);
            float n2 = (coordinatesX[4] - coordinatesX[1]) * (coordinatesX[6] - coordinatesX[0]) - (coordinatesX[3] - coordinatesX[0]) * (coordinatesX[7] - coordinatesX[1]);
            float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            int i10 = 0;
            while (i10 < normalsX.length) {
                normalsX[i10] = n0;
                normalsX[i10 + 1] = n1;
                normalsX[i10 + 2] = n2;
                i10 += 3;
            }
            n0 = (coordinatesY[5] - coordinatesY[2]) * (coordinatesY[7] - coordinatesY[1]) - (coordinatesY[4] - coordinatesY[1]) * (coordinatesY[8] - coordinatesY[2]);
            n1 = (coordinatesY[3] - coordinatesY[0]) * (coordinatesY[8] - coordinatesY[2]) - (coordinatesY[5] - coordinatesY[2]) * (coordinatesY[6] - coordinatesY[0]);
            n2 = (coordinatesY[4] - coordinatesY[1]) * (coordinatesY[6] - coordinatesY[0]) - (coordinatesY[3] - coordinatesY[0]) * (coordinatesY[7] - coordinatesY[1]);
            nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            i = 0;
            while (i < normalsY.length) {
                normalsY[i] = n0;
                normalsY[i + 1] = n1;
                normalsY[i + 2] = n2;
                i += 3;
            }
            n0 = (coordinatesZ[5] - coordinatesZ[2]) * (coordinatesZ[7] - coordinatesZ[1]) - (coordinatesZ[4] - coordinatesZ[1]) * (coordinatesZ[8] - coordinatesZ[2]);
            n1 = (coordinatesZ[3] - coordinatesZ[0]) * (coordinatesZ[8] - coordinatesZ[2]) - (coordinatesZ[5] - coordinatesZ[2]) * (coordinatesZ[6] - coordinatesZ[0]);
            n2 = (coordinatesZ[4] - coordinatesZ[1]) * (coordinatesZ[6] - coordinatesZ[0]) - (coordinatesZ[3] - coordinatesZ[0]) * (coordinatesZ[7] - coordinatesZ[1]);
            nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
            n0 /= nlen;
            n1 /= nlen;
            n2 /= nlen;
            int i11 = 0;
            while (i11 < normalsZ.length) {
                normalsZ[i11] = n0;
                normalsZ[i11 + 1] = n1;
                normalsZ[i11 + 2] = n2;
                i11 += 3;
            }
            colorsX = new byte[12 * data_width];
            colorsY = new byte[12 * data_height];
            colorsZ = new byte[12 * data_depth];
            int i12 = 0;
            while (i12 < 12 * data_width) {
                colorsX[i12] = 127;
                ++i12;
            }
            int i13 = 0;
            while (i13 < 12 * data_height) {
                colorsY[i13] = 127;
                ++i13;
            }
            int i14 = 0;
            while (i14 < 12 * data_depth) {
                colorsZ[i14] = 127;
                ++i14;
            }
        }
        if (!(isTextureMap || isTexture3D && !range3D || isLinearContour3D)) {
            RealTupleType ref;
            if (domain_dimension == 1) {
                domain_doubles = domain_set.getDoubles(false);
                domain_doubles = Unit.convertTuple(domain_doubles, dataUnits, domain_units);
                ShadowType.mapValues((float[][])display_values, domain_doubles, DomainComponents);
            } else {
                domain_values = (float[][])domain_set.getSamples(false).clone();
                domain_values = Unit.convertTuple(domain_values, dataUnits, domain_units, false);
                ShadowType.mapValues((float[][])display_values, domain_values, DomainComponents);
            }
            ShadowRealTupleType domain_reference = this.Domain.getReference();
            if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
                ref = (RealTupleType)domain_reference.getType();
                float[][] reference_values = null;
                double[][] reference_doubles = null;
                if (domain_dimension == 1) {
                    reference_doubles = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)this.Domain.getType(), dataCoordinateSystem, domain_units, null, domain_doubles);
                } else {
                    reference_values = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)this.Domain.getType(), dataCoordinateSystem, domain_units, null, domain_values);
                }
                renderer.setEarthSpatialData(this.Domain, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)this.Domain.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
                ShadowRealType[] DomainReferenceComponents = this.getDomainReferenceComponents();
                if (domain_dimension == 1) {
                    ShadowType.mapValues((float[][])display_values, reference_doubles, DomainReferenceComponents);
                } else {
                    ShadowType.mapValues((float[][])display_values, reference_values, DomainReferenceComponents);
                }
                reference_values = null;
                reference_doubles = null;
            } else {
                ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
                Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                renderer.setEarthSpatialData(this.Domain, domain_reference, ref, ref_units, (RealTupleType)this.Domain.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            }
            domain_values = null;
            domain_doubles = null;
        }
        if (this instanceof ShadowFunctionType) {
            float[][] range_values = ((Field)data).getFloats(false);
            if (range_values != null) {
                ShadowRealType[] RangeComponents = this.getRangeComponents();
                ShadowType.mapValues((float[][])display_values, range_values, RangeComponents);
                int[] refToComponent = this.getRefToComponent();
                ShadowRealTupleType[] componentWithRef = this.getComponentWithRef();
                int[] componentIndex = this.getComponentIndex();
                if (refToComponent != null) {
                    int i15 = 0;
                    while (i15 < refToComponent.length) {
                        CoordinateSystem[] range_coord_sys;
                        Unit[] range_units;
                        int n = componentWithRef[i15].getDimension();
                        int start = refToComponent[i15];
                        float[][] values = new float[n][];
                        int j = 0;
                        while (j < n) {
                            values[j] = range_values[j + start];
                            ++j;
                        }
                        ShadowRealTupleType component_reference = componentWithRef[i15].getReference();
                        RealTupleType ref = (RealTupleType)component_reference.getType();
                        if (i15 == 0 && componentWithRef[i15].equals(this.Range)) {
                            range_units = ((Field)data).getDefaultRangeUnits();
                            range_coord_sys = ((Field)data).getRangeCoordinateSystem();
                        } else {
                            Unit[] dummy_units = ((Field)data).getDefaultRangeUnits();
                            range_units = new Unit[n];
                            int j2 = 0;
                            while (j2 < n) {
                                range_units[j2] = dummy_units[j2 + start];
                                ++j2;
                            }
                            range_coord_sys = ((Field)data).getRangeCoordinateSystem(componentIndex[i15]);
                        }
                        float[][] reference_values = null;
                        if (range_coord_sys.length == 1) {
                            reference_values = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)componentWithRef[i15].getType(), range_coord_sys[0], range_units, null, values);
                            renderer.setEarthSpatialData(componentWithRef[i15], component_reference, ref, ref.getDefaultUnits(), (RealTupleType)componentWithRef[i15].getType(), range_coord_sys, range_units);
                        } else {
                            reference_values = new float[n][domain_length];
                            float[][] temp = new float[n][1];
                            int j3 = 0;
                            while (j3 < domain_length) {
                                int k = 0;
                                while (k < n) {
                                    temp[k][0] = values[k][j3];
                                    ++k;
                                }
                                temp = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)componentWithRef[i15].getType(), range_coord_sys[j3], range_units, null, temp);
                                int k2 = 0;
                                while (k2 < n) {
                                    reference_values[k2][j3] = temp[k2][0];
                                    ++k2;
                                }
                                ++j3;
                            }
                            renderer.setEarthSpatialData(componentWithRef[i15], component_reference, ref, ref.getDefaultUnits(), (RealTupleType)componentWithRef[i15].getType(), range_coord_sys, range_units);
                        }
                        ShadowType.mapValues((float[][])display_values, reference_values, this.getComponents(component_reference, false));
                        reference_values = null;
                        values = null;
                        ++i15;
                    }
                }
                if (this.Range instanceof ShadowTupleType) {
                    if (this.Range instanceof ShadowRealTupleType) {
                        Unit[] range_units = ((Field)data).getDefaultRangeUnits();
                        CoordinateSystem[] range_coord_sys = ((Field)data).getRangeCoordinateSystem();
                        ShadowRealTupleType component_reference = ((ShadowRealTupleType)this.Range).getReference();
                        RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                        Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                        renderer.setEarthSpatialData((ShadowRealTupleType)this.Range, component_reference, ref, ref_units, (RealTupleType)this.Range.getType(), range_coord_sys, range_units);
                    } else {
                        Unit[] dummy_units = ((Field)data).getDefaultRangeUnits();
                        int start = 0;
                        int n = ((ShadowTupleType)this.Range).getDimension();
                        int i16 = 0;
                        while (i16 < n) {
                            ShadowType range_component = ((ShadowTupleType)this.Range).getComponent(i16);
                            if (range_component instanceof ShadowRealTupleType) {
                                int m = ((ShadowRealTupleType)range_component).getDimension();
                                Unit[] range_units = new Unit[m];
                                int j = 0;
                                while (j < m) {
                                    range_units[j] = dummy_units[j + start];
                                    ++j;
                                }
                                CoordinateSystem[] range_coord_sys = ((Field)data).getRangeCoordinateSystem(i16);
                                ShadowRealTupleType component_reference = ((ShadowRealTupleType)range_component).getReference();
                                RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                                Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                                renderer.setEarthSpatialData((ShadowRealTupleType)range_component, component_reference, ref, ref_units, (RealTupleType)range_component.getType(), range_coord_sys, range_units);
                                start += ((ShadowRealTupleType)range_component).getDimension();
                            } else if (range_component instanceof ShadowRealType) {
                                ++start;
                            }
                            ++i16;
                        }
                    }
                }
                range_values = null;
            }
            if (anyText && text_values == null) {
                String[][] string_values;
                int i17 = 0;
                while (i17 < valueArrayLength) {
                    if (display_values[i17] != null) {
                        int displayScalarIndex = valueToScalar[i17];
                        ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i17]);
                        ScalarType real = map.getScalar();
                        DisplayRealType dreal = this.display.getDisplayScalar(displayScalarIndex);
                        if (dreal.equals(Display.Text) && real instanceof RealType) {
                            text_control = (TextControl)map.getControl();
                            text_values = new String[domain_length];
                            NumberFormat format = text_control.getNumberFormat();
                            if (display_values[i17].length == 1) {
                                String text = null;
                                text = display_values[i17][0] != display_values[i17][0] ? "" : (format == null ? PlotText.shortString(display_values[i17][0]) : format.format(display_values[i17][0]));
                                int j = 0;
                                while (j < domain_length) {
                                    text_values[j] = text;
                                    ++j;
                                }
                            } else if (format == null) {
                                int j = 0;
                                while (j < domain_length) {
                                    text_values[j] = display_values[i17][j] != display_values[i17][j] ? "" : PlotText.shortString(display_values[i17][j]);
                                    ++j;
                                }
                            } else {
                                int j = 0;
                                while (j < domain_length) {
                                    text_values[j] = display_values[i17][j] != display_values[i17][j] ? "" : format.format(display_values[i17][j]);
                                    ++j;
                                }
                            }
                            break;
                        }
                    }
                    ++i17;
                }
                if (text_values == null && (string_values = ((Field)data).getStringValues()) != null) {
                    int[] textIndices = ((FunctionType)this.getType()).getTextIndices();
                    int n = string_values.length;
                    if (this.Range instanceof ShadowTextType) {
                        Vector maps = shadow_api.getTextMaps(-1, textIndices);
                        if (!maps.isEmpty()) {
                            text_values = string_values[0];
                            ScalarMap map = (ScalarMap)maps.firstElement();
                            text_control = (TextControl)map.getControl();
                        }
                    } else if (this.Range instanceof ShadowTupleType) {
                        int i18 = 0;
                        while (i18 < n) {
                            Vector maps = shadow_api.getTextMaps(i18, textIndices);
                            if (!maps.isEmpty()) {
                                text_values = string_values[i18];
                                ScalarMap map = (ScalarMap)maps.firstElement();
                                text_control = (TextControl)map.getControl();
                            }
                            ++i18;
                        }
                    }
                }
            }
        }
        if ((range_select = shadow_api.assembleSelect(display_values, domain_length, valueArrayLength, valueToScalar, this.display, shadow_api))[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
            return false;
        }
        if (this.getIsTerminal()) {
            int i19;
            Object c2;
            if (!this.getFlat()) {
                throw new DisplayException("terminal but not Flat");
            }
            GraphicsModeControl mode = (GraphicsModeControl)this.display.getGraphicsModeControl().clone();
            float pointSize = default_values[this.display.getDisplayScalarIndex(Display.PointSize)];
            mode.setPointSize(pointSize, true);
            float lineWidth = default_values[this.display.getDisplayScalarIndex(Display.LineWidth)];
            mode.setLineWidth(lineWidth, true);
            int lineStyle = (int)default_values[this.display.getDisplayScalarIndex(Display.LineStyle)];
            mode.setLineStyle(lineStyle, true);
            int polygonMode = (int)default_values[this.display.getDisplayScalarIndex(Display.PolygonMode)];
            mode.setPolygonMode(polygonMode, true);
            boolean pointMode = mode.getPointMode();
            float missingTransparent = default_values[this.display.getDisplayScalarIndex(Display.MissingTransparent)];
            boolean isMissingTransparent = mode.getMissingTransparent();
            if (missingTransparent > -0.5f) {
                isMissingTransparent = missingTransparent > 0.5f;
            }
            boolean[] single_missing = new boolean[]{false, false, false, false};
            Object color_values = shadow_api.assembleColor(display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, single_missing, shadow_api);
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            float[][] flow1_values = new float[3][];
            float[][] flow2_values = new float[3][];
            float[] flowScale = new float[2];
            shadow_api.assembleFlow(flow1_values, flow2_values, flowScale, display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, renderer, shadow_api);
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            float[][] spatial_values = new float[3][];
            int[] spatialDimensions = new int[2];
            boolean[] swap = new boolean[]{false, false, false};
            boolean[][] spatial_range_select = new boolean[1][];
            Set spatial_set = shadow_api.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, this.display, default_values, this.inherited_values, domain_set, this.Domain.getAllSpatial(), anyContour && !isLinearContour3D, spatialDimensions, spatial_range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
            if (isLinearContour3D) {
                spatial_set = domain_set;
                spatialDimensions[0] = 3;
                spatialDimensions[1] = 3;
            }
            boolean spatial_all_select = true;
            if (spatial_range_select[0] != null) {
                int j;
                spatial_all_select = false;
                if (range_select[0] == null) {
                    range_select[0] = spatial_range_select[0];
                } else if (spatial_range_select[0].length == 1) {
                    j = 0;
                    while (j < range_select[0].length) {
                        range_select[0][j] = range_select[0][j] && spatial_range_select[0][0];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < range_select[0].length) {
                        range_select[0][j] = range_select[0][j] && spatial_range_select[0][j];
                        ++j;
                    }
                }
            }
            spatial_range_select = null;
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            int spatialDomainDimension = spatialDimensions[0];
            int spatialManifoldDimension = spatialDimensions[1];
            int spatial_length = Math.min(domain_length, spatial_values[0].length);
            int color_length = Math.min(domain_length, color_values[0].length);
            int alpha_length = color_values[3].length;
            float constant_alpha = Float.NaN;
            float[] constant_color = null;
            if (alpha_length == 1) {
                if (single_missing[3]) {
                    return false;
                }
                if (color_values[3][0] == -1) {
                    constant_alpha = 0.0f;
                    c2 = new byte[3][];
                    c2[0] = color_values[0];
                    c2[1] = color_values[1];
                    c2[2] = color_values[2];
                    color_values = c2;
                } else {
                    byte v = color_values[3][0];
                    color_values[3] = new byte[color_values[0].length];
                    i19 = 0;
                    while (i19 < color_values[0].length) {
                        color_values[3][i19] = v;
                        ++i19;
                    }
                }
            }
            if (color_length == 1) {
                if (spatialManifoldDimension == 1 || shadow_api.allowConstantColorSurfaces()) {
                    if (single_missing[0] || single_missing[1] || single_missing[2]) {
                        return false;
                    }
                    constant_color = new float[]{ShadowType.byteToFloat(color_values[0][0]), ShadowType.byteToFloat(color_values[1][0]), ShadowType.byteToFloat(color_values[2][0])};
                    color_values = null;
                } else {
                    c2 = new byte[((byte[][])color_values).length][domain_length];
                    i19 = 0;
                    while (i19 < ((byte[][])color_values).length) {
                        int j = 0;
                        while (j < domain_length) {
                            c2[i19][j] = color_values[i19][0];
                            ++j;
                        }
                        ++i19;
                    }
                    color_values = c2;
                }
            }
            if (range_select[0] != null && range_select[0].length == 1 && !range_select[0][0]) {
                return false;
            }
            if (this.LevelOfDifficulty == 3) {
                VisADGeometryArray array;
                boolean anyShapeCreated = false;
                VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, this.display, default_values, this.inherited_values, spatial_values, (byte[][])color_values, range_select, -1, shadow_api);
                if (arrays != null) {
                    int i20 = 0;
                    while (i20 < arrays.length) {
                        array = arrays[i20];
                        shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                        array = null;
                        ++i20;
                    }
                    anyShapeCreated = true;
                    arrays = null;
                }
                boolean anyTextCreated = false;
                if (anyText && text_values != null && text_control != null) {
                    array = shadow_api.makeText(text_values, text_control, spatial_values, (byte[][])color_values, range_select);
                    shadow_api.addTextToGroup(group, array, mode, constant_alpha, constant_color);
                    array = null;
                    anyTextCreated = true;
                }
                boolean anyFlowCreated = false;
                if (anyFlow) {
                    int i21;
                    arrays = shadow_api.makeStreamline(0, flow1_values, flowScale[0], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select);
                    if (arrays != null) {
                        i21 = 0;
                        while (i21 < arrays.length) {
                            if (arrays[i21] != null) {
                                shadow_api.addToGroup(group, arrays[i21], mode, constant_alpha, constant_color);
                                arrays[i21] = null;
                            }
                            ++i21;
                        }
                    } else {
                        arrays = shadow_api.makeFlow(0, flow1_values, flowScale[0], spatial_values, (byte[][])color_values, range_select);
                        if (arrays != null) {
                            i21 = 0;
                            while (i21 < arrays.length) {
                                if (arrays[i21] != null) {
                                    shadow_api.addToGroup(group, arrays[i21], mode, constant_alpha, constant_color);
                                    arrays[i21] = null;
                                }
                                ++i21;
                            }
                        }
                    }
                    anyFlowCreated = true;
                    arrays = shadow_api.makeStreamline(1, flow2_values, flowScale[1], spatial_values, spatial_set, spatialManifoldDimension, (byte[][])color_values, range_select);
                    if (arrays != null) {
                        i21 = 0;
                        while (i21 < arrays.length) {
                            if (arrays[i21] != null) {
                                shadow_api.addToGroup(group, arrays[i21], mode, constant_alpha, constant_color);
                                arrays[i21] = null;
                            }
                            ++i21;
                        }
                    } else {
                        arrays = shadow_api.makeFlow(1, flow2_values, flowScale[1], spatial_values, (byte[][])color_values, range_select);
                        if (arrays != null) {
                            i21 = 0;
                            while (i21 < arrays.length) {
                                if (arrays[i21] != null) {
                                    shadow_api.addToGroup(group, arrays[i21], mode, constant_alpha, constant_color);
                                    arrays[i21] = null;
                                }
                                ++i21;
                            }
                        }
                    }
                    anyFlowCreated = true;
                }
                boolean anyContourCreated = false;
                if (anyContour) {
                    anyContourCreated = shadow_api.makeContour(valueArrayLength, valueToScalar, display_values, this.inherited_values, MapVector, valueToMap, domain_length, range_select, spatialManifoldDimension, spatial_set, (byte[][])color_values, indexed, group, mode, swap, constant_alpha, constant_color, shadow_api);
                }
                if (!(anyContourCreated || anyFlowCreated || anyTextCreated || anyShapeCreated)) {
                    if (isTextureMap) {
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            int i22 = 0;
                            while (i22 < domain_length) {
                                color_values[0][i22] = ShadowType.floatToByte(constant_color[0]);
                                color_values[1][i22] = ShadowType.floatToByte(constant_color[1]);
                                color_values[2][i22] = ShadowType.floatToByte(constant_color[2]);
                                ++i22;
                            }
                        }
                        if (range_select[0] != null && range_select[0].length > 1) {
                            int len = range_select[0].length;
                            float alpha = default_values[this.display.getDisplayScalarIndex(Display.Alpha)];
                            if (constant_alpha == constant_alpha) {
                                alpha = 1.0f - constant_alpha;
                            }
                            if (((byte[][])color_values).length < 4) {
                                byte[][] c3 = new byte[][]{color_values[0], color_values[1], color_values[2], new byte[len]};
                                int i23 = 0;
                                while (i23 < len) {
                                    c3[3][i23] = ShadowType.floatToByte(alpha);
                                    ++i23;
                                }
                                constant_alpha = Float.NaN;
                                color_values = c3;
                            }
                            if (isMissingTransparent) {
                                int i24 = 0;
                                while (i24 < len) {
                                    if (!range_select[0][i24]) {
                                        color_values[3][i24] = 0;
                                    }
                                    ++i24;
                                }
                            } else {
                                int i25 = 0;
                                while (i25 < len) {
                                    if (!range_select[0][i25]) {
                                        color_values[0][i25] = 0;
                                        color_values[1][i25] = 0;
                                        color_values[2][i25] = 0;
                                    }
                                    ++i25;
                                }
                            }
                        }
                        VisADQuadArray qarray = new VisADQuadArray();
                        qarray.vertexCount = 4;
                        qarray.coordinates = coordinates;
                        qarray.texCoords = texCoords;
                        qarray.colors = colors;
                        qarray.normals = normals;
                        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, (byte[][])color_values);
                        shadow_api.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
                        return false;
                    }
                    if (curvedTexture) {
                        int len;
                        int i26;
                        int i27;
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            i27 = 0;
                            while (i27 < domain_length) {
                                color_values[0][i27] = ShadowType.floatToByte(constant_color[0]);
                                color_values[1][i27] = ShadowType.floatToByte(constant_color[1]);
                                color_values[2][i27] = ShadowType.floatToByte(constant_color[2]);
                                ++i27;
                            }
                        }
                        if (range_select[0] != null) {
                            if (isMissingTransparent && ((byte[][])color_values).length > 3) {
                                i27 = 0;
                                while (i27 < domain_length) {
                                    if (!range_select[0][i27]) {
                                        color_values[3][i27] = 0;
                                    }
                                    ++i27;
                                }
                            } else {
                                i27 = 0;
                                while (i27 < domain_length) {
                                    if (!range_select[0][i27]) {
                                        color_values[0][i27] = 0;
                                        color_values[1][i27] = 0;
                                        color_values[2][i27] = 0;
                                    }
                                    ++i27;
                                }
                            }
                        }
                        int[] lengths = ((GriddedSet)domain_set).getLengths();
                        data_width = lengths[0];
                        data_height = lengths[1];
                        texture_width = shadow_api.textureWidth(data_width);
                        texture_height = shadow_api.textureHeight(data_height);
                        int size = (data_width + data_height) / 2;
                        curved_size = Math.max(2, Math.min(curved_size, size / 32));
                        int nwidth = 2 + (data_width - 1) / curved_size;
                        int nheight = 2 + (data_height - 1) / curved_size;
                        if (range_select[0] != null && !domainOnlySpatial) {
                            curved_size = 1;
                            nwidth = data_width;
                            nheight = data_height;
                        }
                        int nn = nwidth * nheight;
                        coordinates = new float[3 * nn];
                        int k = 0;
                        int[] is = new int[nwidth];
                        int[] js = new int[nheight];
                        int i28 = 0;
                        while (i28 < nwidth) {
                            is[i28] = Math.min(i28 * curved_size, data_width - 1);
                            ++i28;
                        }
                        int j = 0;
                        while (j < nheight) {
                            js[j] = Math.min(j * curved_size, data_height - 1);
                            ++j;
                        }
                        int j4 = 0;
                        while (j4 < nheight) {
                            i26 = 0;
                            while (i26 < nwidth) {
                                int ij = is[i26] + data_width * js[j4];
                                coordinates[k++] = spatial_values[0][ij];
                                coordinates[k++] = spatial_values[1][ij];
                                coordinates[k++] = spatial_values[2][ij];
                                ++i26;
                            }
                            ++j4;
                        }
                        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
                        colors = new byte[3 * nn];
                        i26 = 0;
                        while (i26 < 3 * nn) {
                            colors[i26] = 127;
                            ++i26;
                        }
                        float ratiow = (float)data_width / (float)texture_width;
                        float ratioh = (float)data_height / (float)texture_height;
                        float half_width = 0.5f / (float)texture_width;
                        float half_height = 0.5f / (float)texture_height;
                        float width = 1.0f / (float)texture_width;
                        float height = 1.0f / (float)texture_height;
                        int mt = 0;
                        texCoords = new float[2 * nn];
                        int j5 = 0;
                        while (j5 < nheight) {
                            int i29 = 0;
                            while (i29 < nwidth) {
                                float isfactor = (float)is[i29] / ((float)data_width - 1.0f);
                                float jsfactor = (float)js[j5] / ((float)data_height - 1.0f);
                                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                                texCoords[mt++] = 1.0f - (ratioh - height) * jsfactor - half_height;
                                ++i29;
                            }
                            ++j5;
                        }
                        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
                        tarray.stripVertexCounts = new int[nheight - 1];
                        int i30 = 0;
                        while (i30 < nheight - 1) {
                            tarray.stripVertexCounts[i30] = 2 * nwidth;
                            ++i30;
                        }
                        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
                        tarray.normals = new float[3 * len];
                        tarray.coordinates = new float[3 * len];
                        tarray.colors = new byte[3 * len];
                        tarray.texCoords = new float[2 * len];
                        k = 0;
                        int kt = 0;
                        int nwidth3 = 3 * nwidth;
                        int nwidth2 = 2 * nwidth;
                        int i31 = 0;
                        while (i31 < nheight - 1) {
                            int m = i31 * nwidth3;
                            mt = i31 * nwidth2;
                            int j6 = 0;
                            while (j6 < nwidth) {
                                tarray.coordinates[k] = coordinates[m];
                                tarray.coordinates[k + 1] = coordinates[m + 1];
                                tarray.coordinates[k + 2] = coordinates[m + 2];
                                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                                tarray.normals[k] = normals[m];
                                tarray.normals[k + 1] = normals[m + 1];
                                tarray.normals[k + 2] = normals[m + 2];
                                tarray.normals[k + 3] = normals[m + nwidth3];
                                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                                tarray.colors[k] = colors[m];
                                tarray.colors[k + 1] = colors[m + 1];
                                tarray.colors[k + 2] = colors[m + 2];
                                tarray.colors[k + 3] = colors[m + nwidth3];
                                tarray.colors[k + 4] = colors[m + nwidth3 + 1];
                                tarray.colors[k + 5] = colors[m + nwidth3 + 2];
                                tarray.texCoords[kt] = texCoords[mt];
                                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                                k += 6;
                                m += 3;
                                kt += 4;
                                mt += 2;
                                ++j6;
                            }
                            ++i31;
                        }
                        if (!spatial_all_select) {
                            tarray = (VisADTriangleStripArray)tarray.removeMissing();
                        }
                        tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
                        tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
                        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, (byte[][])color_values);
                        shadow_api.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
                        return false;
                    }
                    if (isTexture3D) {
                        int i32;
                        if (color_values == null) {
                            color_values = new byte[3][domain_length];
                            int i33 = 0;
                            while (i33 < domain_length) {
                                color_values[0][i33] = ShadowType.floatToByte(constant_color[0]);
                                color_values[1][i33] = ShadowType.floatToByte(constant_color[1]);
                                color_values[2][i33] = ShadowType.floatToByte(constant_color[2]);
                                ++i33;
                            }
                        }
                        if (range_select[0] != null && range_select[0].length > 1) {
                            int len = range_select[0].length;
                            float alpha = default_values[this.display.getDisplayScalarIndex(Display.Alpha)];
                            if (constant_alpha == constant_alpha) {
                                alpha = 1.0f - constant_alpha;
                            }
                            if (((byte[][])color_values).length < 4) {
                                byte[][] c4 = new byte[][]{color_values[0], color_values[1], color_values[2], new byte[len]};
                                int i34 = 0;
                                while (i34 < len) {
                                    c4[3][i34] = ShadowType.floatToByte(alpha);
                                    ++i34;
                                }
                                constant_alpha = Float.NaN;
                                color_values = c4;
                            }
                            i32 = 0;
                            while (i32 < len) {
                                if (!range_select[0][i32]) {
                                    color_values[3][i32] = 0;
                                    color_values[0][i32] = 0;
                                    color_values[1][i32] = 0;
                                    color_values[2][i32] = 0;
                                }
                                ++i32;
                            }
                        }
                        VisADQuadArray[] qarray = new VisADQuadArray[]{new VisADQuadArray(), new VisADQuadArray(), new VisADQuadArray()};
                        qarray[0].vertexCount = coordinatesX.length / 3;
                        qarray[0].coordinates = coordinatesX;
                        qarray[0].texCoords = texCoordsX;
                        qarray[0].colors = colorsX;
                        qarray[0].normals = normalsX;
                        qarray[1].vertexCount = coordinatesY.length / 3;
                        qarray[1].coordinates = coordinatesY;
                        qarray[1].texCoords = texCoordsY;
                        qarray[1].colors = colorsY;
                        qarray[1].normals = normalsY;
                        qarray[2].vertexCount = coordinatesZ.length / 3;
                        qarray[2].coordinates = coordinatesZ;
                        qarray[2].texCoords = texCoordsZ;
                        qarray[2].colors = colorsZ;
                        qarray[2].normals = normalsZ;
                        BufferedImage[][] images = new BufferedImage[3][];
                        i32 = 0;
                        while (i32 < 3) {
                            images[i32] = this.createImages(i32, data_width, data_height, data_depth, texture_width, texture_height, texture_depth, (byte[][])color_values);
                            ++i32;
                        }
                        BufferedImage[] imagesX = null;
                        BufferedImage[] imagesY = null;
                        BufferedImage[] imagesZ = null;
                        VisADQuadArray qarrayX = null;
                        VisADQuadArray qarrayY = null;
                        VisADQuadArray qarrayZ = null;
                        int i35 = 0;
                        while (i35 < 3) {
                            if (volume_tuple_index[i35] == 0) {
                                qarrayX = qarray[i35];
                                imagesX = images[i35];
                            } else if (volume_tuple_index[i35] == 1) {
                                qarrayY = qarray[i35];
                                imagesY = images[i35];
                            } else if (volume_tuple_index[i35] == 2) {
                                qarrayZ = qarray[i35];
                                imagesZ = images[i35];
                            }
                            ++i35;
                        }
                        VisADQuadArray qarrayXrev = this.reverse(qarrayX);
                        VisADQuadArray qarrayYrev = this.reverse(qarrayY);
                        VisADQuadArray qarrayZrev = this.reverse(qarrayZ);
                        shadow_api.textureStackToGroup(group, qarrayX, qarrayY, qarrayZ, qarrayXrev, qarrayYrev, qarrayZrev, imagesX, imagesY, imagesZ, mode, constant_alpha, constant_color, texture_width, texture_height, texture_depth, renderer);
                        return false;
                    }
                    if (pointMode || spatial_set == null || spatialManifoldDimension == 0 || spatialManifoldDimension == 3) {
                        if (range_select[0] != null) {
                            int len = range_select[0].length;
                            if (len == 1 || spatial_values[0].length == 1) {
                                return false;
                            }
                            int j = 0;
                            while (j < len) {
                                if (!range_select[0][j]) {
                                    spatial_values[0][j] = Float.NaN;
                                }
                                ++j;
                            }
                            array = ShadowType.makePointGeometry(spatial_values, color_values, true);
                        } else {
                            array = ShadowType.makePointGeometry(spatial_values, color_values);
                        }
                    } else if (spatialManifoldDimension == 1) {
                        if (range_select[0] != null) {
                            if (isMissingTransparent) {
                                spatial_set.cram_missing(range_select[0]);
                                spatial_all_select = false;
                            } else {
                                int i36;
                                if (color_values == null) {
                                    color_values = new byte[4][domain_length];
                                    i36 = 0;
                                    while (i36 < domain_length) {
                                        color_values[0][i36] = ShadowType.floatToByte(constant_color[0]);
                                        color_values[1][i36] = ShadowType.floatToByte(constant_color[1]);
                                        color_values[2][i36] = ShadowType.floatToByte(constant_color[2]);
                                        ++i36;
                                    }
                                }
                                i36 = 0;
                                while (i36 < domain_length) {
                                    if (!range_select[0][i36]) {
                                        color_values[0][i36] = 0;
                                        color_values[1][i36] = 0;
                                        color_values[2][i36] = 0;
                                    }
                                    ++i36;
                                }
                            }
                        }
                        if ((array = spatial_set.make1DGeometry((byte[][])color_values)) != null) {
                            if (!spatial_all_select) {
                                array = array.removeMissing();
                            }
                            array = array.adjustLongitude(renderer);
                            array = array.adjustSeam(renderer);
                        }
                    } else if (spatialManifoldDimension == 2) {
                        if (range_select[0] != null) {
                            if (isMissingTransparent) {
                                spatial_set.cram_missing(range_select[0]);
                                spatial_all_select = false;
                            } else {
                                int i37;
                                if (color_values == null) {
                                    color_values = new byte[4][domain_length];
                                    i37 = 0;
                                    while (i37 < domain_length) {
                                        color_values[0][i37] = ShadowType.floatToByte(constant_color[0]);
                                        color_values[1][i37] = ShadowType.floatToByte(constant_color[1]);
                                        color_values[2][i37] = ShadowType.floatToByte(constant_color[2]);
                                        ++i37;
                                    }
                                }
                                i37 = 0;
                                while (i37 < domain_length) {
                                    if (!range_select[0][i37]) {
                                        color_values[0][i37] = 0;
                                        color_values[1][i37] = 0;
                                        color_values[2][i37] = 0;
                                    }
                                    ++i37;
                                }
                            }
                        }
                        if ((array = spatial_set.make2DGeometry((byte[][])color_values, indexed)) != null) {
                            if (!spatial_all_select) {
                                array = array.removeMissing();
                            }
                            array = array.adjustLongitude(renderer);
                            array = array.adjustSeam(renderer);
                        }
                    } else {
                        throw new DisplayException("bad spatialManifoldDimension: ShadowFunctionOrSetType.doTransform");
                    }
                    if (array != null && array.vertexCount > 0) {
                        shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                        array = null;
                    }
                }
                if (renderer.getIsDirectManipulation()) {
                    renderer.setSpatialValues(spatial_values);
                }
                return false;
            }
            if (this.LevelOfDifficulty == 4) {
                Control control = null;
                Object swit = null;
                int index = -1;
                if (DomainComponents.length == 1) {
                    RealType real = (RealType)DomainComponents[0].getType();
                    int i38 = 0;
                    while (i38 < valueArrayLength) {
                        int displayScalarIndex;
                        DisplayRealType dreal;
                        ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i38]);
                        float[] values = display_values[i38];
                        if (values != null && real.equals(map.getScalar()) && ((dreal = this.display.getDisplayScalar(displayScalarIndex = valueToScalar[i38])).equals(Display.Animation) || dreal.equals(Display.SelectValue))) {
                            swit = shadow_api.makeSwitch();
                            index = i38;
                            control = map.getControl();
                            break;
                        }
                        ++i38;
                    }
                }
                if (control == null) {
                    throw new DisplayException("bad SIMPLE_ANIMATE_FIELD: ShadowFunctionOrSetType.doTransform");
                }
                int i39 = 0;
                while (i39 < domain_length) {
                    Object branch = shadow_api.makeBranch();
                    if (range_select[0] == null || range_select[0].length == 1 || range_select[0][i39]) {
                        String[] te;
                        VisADGeometryArray array = null;
                        float[][] sp = new float[3][1];
                        if (spatial_values[0].length > 1) {
                            sp[0][0] = spatial_values[0][i39];
                            sp[1][0] = spatial_values[1][i39];
                            sp[2][0] = spatial_values[2][i39];
                        } else {
                            sp[0][0] = spatial_values[0][0];
                            sp[1][0] = spatial_values[1][0];
                            sp[2][0] = spatial_values[2][0];
                        }
                        byte[][] co = new byte[3][1];
                        if (color_values == null) {
                            co[0][0] = ShadowType.floatToByte(constant_color[0]);
                            co[1][0] = ShadowType.floatToByte(constant_color[1]);
                            co[2][0] = ShadowType.floatToByte(constant_color[2]);
                        } else if (color_values[0].length > 1) {
                            co[0][0] = color_values[0][i39];
                            co[1][0] = color_values[1][i39];
                            co[2][0] = color_values[2][i39];
                        } else {
                            co[0][0] = color_values[0][0];
                            co[1][0] = color_values[1][0];
                            co[2][0] = color_values[2][0];
                        }
                        boolean[][] ra = new boolean[][]{{true}};
                        boolean anyShapeCreated = false;
                        VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector, valueToScalar, this.display, default_values, this.inherited_values, sp, co, ra, i39, shadow_api);
                        if (arrays != null) {
                            int j = 0;
                            while (j < arrays.length) {
                                array = arrays[j];
                                shadow_api.addToGroup(branch, array, mode, constant_alpha, constant_color);
                                array = null;
                                ++j;
                            }
                            anyShapeCreated = true;
                            arrays = null;
                        }
                        boolean anyTextCreated = false;
                        if (anyText && text_values != null && text_control != null && (array = shadow_api.makeText(te = new String[]{text_values.length > 1 ? text_values[i39] : text_values[0]}, text_control, sp, co, ra)) != null) {
                            shadow_api.addTextToGroup(branch, array, mode, constant_alpha, constant_color);
                            array = null;
                            anyTextCreated = true;
                        }
                        boolean anyFlowCreated = false;
                        if (anyFlow) {
                            int j;
                            if (flow1_values != null && flow1_values[0] != null) {
                                float[][] f1 = new float[3][1];
                                if (flow1_values[0].length > 1) {
                                    f1[0][0] = flow1_values[0][i39];
                                    f1[1][0] = flow1_values[1][i39];
                                    f1[2][0] = flow1_values[2][i39];
                                } else {
                                    f1[0][0] = flow1_values[0][0];
                                    f1[1][0] = flow1_values[1][0];
                                    f1[2][0] = flow1_values[2][0];
                                }
                                arrays = shadow_api.makeFlow(0, f1, flowScale[0], sp, co, ra);
                                if (arrays != null) {
                                    j = 0;
                                    while (j < arrays.length) {
                                        if (arrays[j] != null) {
                                            shadow_api.addToGroup(branch, arrays[j], mode, constant_alpha, constant_color);
                                            arrays[j] = null;
                                        }
                                        ++j;
                                    }
                                }
                                anyFlowCreated = true;
                            }
                            if (flow2_values != null && flow2_values[0] != null) {
                                float[][] f2 = new float[3][1];
                                if (flow2_values[0].length > 1) {
                                    f2[0][0] = flow2_values[0][i39];
                                    f2[1][0] = flow2_values[1][i39];
                                    f2[2][0] = flow2_values[2][i39];
                                } else {
                                    f2[0][0] = flow2_values[0][0];
                                    f2[1][0] = flow2_values[1][0];
                                    f2[2][0] = flow2_values[2][0];
                                }
                                arrays = shadow_api.makeFlow(1, f2, flowScale[1], sp, co, ra);
                                if (arrays != null) {
                                    j = 0;
                                    while (j < arrays.length) {
                                        if (arrays[j] != null) {
                                            shadow_api.addToGroup(branch, arrays[j], mode, constant_alpha, constant_color);
                                            arrays[j] = null;
                                        }
                                        ++j;
                                    }
                                }
                                anyFlowCreated = true;
                            }
                        }
                        if (!(anyShapeCreated || anyTextCreated || anyFlowCreated)) {
                            array = new VisADPointArray();
                            array.vertexCount = 1;
                            coordinates = new float[]{sp[0][0], sp[1][0], sp[2][0]};
                            array.coordinates = coordinates;
                            if (color_values != null) {
                                colors = new byte[]{co[0][0], co[1][0], co[2][0]};
                                array.colors = colors;
                            }
                            shadow_api.addToGroup(branch, array, mode, constant_alpha, constant_color);
                            array = null;
                        }
                    }
                    shadow_api.addToSwitch(swit, branch);
                    ++i39;
                }
                shadow_api.addSwitch(group, swit, control, domain_set, renderer);
                return false;
            }
            throw new UnimplementedException("terminal LEGAL unimplemented: ShadowFunctionOrSetType.doTransform");
        }
        boolean post = false;
        Control control = null;
        Object swit = null;
        int index = -1;
        if (DomainComponents.length == 1) {
            RealType real = (RealType)DomainComponents[0].getType();
            int i40 = 0;
            while (i40 < valueArrayLength) {
                int displayScalarIndex;
                DisplayRealType dreal;
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i40]);
                float[] values = display_values[i40];
                if (values != null && real.equals(map.getScalar()) && ((dreal = this.display.getDisplayScalar(displayScalarIndex = valueToScalar[i40])).equals(Display.Animation) || dreal.equals(Display.SelectValue))) {
                    swit = shadow_api.makeSwitch();
                    index = i40;
                    control = map.getControl();
                    break;
                }
                ++i40;
            }
        }
        if (control != null) {
            shadow_api.addSwitch(group, swit, control, domain_set, renderer);
        }
        float[] range_value_array = new float[valueArrayLength];
        int j = 0;
        while (j < this.display.getValueArrayLength()) {
            range_value_array[j] = Float.NaN;
            ++j;
        }
        int i41 = 0;
        while (i41 < domain_length) {
            if (range_select[0] == null || range_select[0].length == 1 || range_select[0][i41]) {
                Object branch;
                if (text_values != null && text_control != null) {
                    shadow_api.setText(text_values[i41], text_control);
                } else {
                    shadow_api.setText(null, null);
                }
                int j7 = 0;
                while (j7 < valueArrayLength) {
                    if (display_values[j7] != null) {
                        range_value_array[j7] = display_values[j7].length == 1 ? display_values[j7][0] : display_values[j7][i41];
                    }
                    ++j7;
                }
                int[] lat_lon_indices = renderer.getLatLonIndices();
                if (control != null) {
                    branch = shadow_api.makeBranch();
                    post |= shadow_api.recurseRange(branch, ((Field)data).getSample(i41), range_value_array, default_values, renderer);
                    shadow_api.addToSwitch(swit, branch);
                } else {
                    branch = shadow_api.makeBranch();
                    post |= shadow_api.recurseRange(branch, ((Field)data).getSample(i41), range_value_array, default_values, renderer);
                    shadow_api.addToGroup(group, branch);
                }
                renderer.setLatLonIndices(lat_lon_indices);
            } else if (control != null) {
                Object branch = shadow_api.makeBranch();
                shadow_api.addToSwitch(swit, branch);
            }
            ++i41;
        }
        return post;
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, byte[][] color_values) throws VisADException {
        BufferedImage image = null;
        if (color_values.length > 3) {
            int i;
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            DataBuffer db = raster.getDataBuffer();
            if (!(db instanceof DataBufferInt)) {
                throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
            }
            image = new BufferedImage(colorModel, raster, false, null);
            int[] intData = ((DataBufferInt)db).getData();
            int k = 0;
            int m = 0;
            int j = 0;
            while (j < data_height) {
                int i2 = 0;
                while (i2 < data_width) {
                    int r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                    int g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                    int b2 = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                    int a2 = color_values[3][k] < 0 ? color_values[3][k] + 256 : color_values[3][k];
                    intData[m++] = a2 << 24 | r << 16 | g << 8 | b2;
                    ++k;
                    ++i2;
                }
                i = data_width;
                while (i < texture_width) {
                    intData[m++] = 0;
                    ++i;
                }
                ++j;
            }
            int j2 = data_height;
            while (j2 < texture_height) {
                i = 0;
                while (i < texture_width) {
                    intData[m++] = 0;
                    ++i;
                }
                ++j2;
            }
        } else {
            int i;
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            DataBuffer db = raster.getDataBuffer();
            int[] intData = null;
            if (db instanceof DataBufferInt) {
                intData = ((DataBufferInt)db).getData();
                image = new BufferedImage(colorModel, raster, false, null);
            } else {
                image = new BufferedImage(texture_width, texture_height, 1);
                intData = new int[texture_width * texture_height];
            }
            int k = 0;
            int m = 0;
            int j = 0;
            while (j < data_height) {
                int i3 = 0;
                while (i3 < data_width) {
                    int r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                    int g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                    int b3 = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                    int a3 = 255;
                    intData[m++] = a3 << 24 | r << 16 | g << 8 | b3;
                    ++k;
                    ++i3;
                }
                i = data_width;
                while (i < texture_width) {
                    intData[m++] = 0;
                    ++i;
                }
                ++j;
            }
            int j3 = data_height;
            while (j3 < texture_height) {
                i = 0;
                while (i < texture_width) {
                    intData[m++] = 0;
                    ++i;
                }
                ++j3;
            }
            if (!(db instanceof DataBufferInt)) {
                image.setRGB(0, 0, texture_width, texture_height, intData, 0, texture_width);
            }
        }
        return image;
    }

    public BufferedImage[] createImages(int axis, int data_width_in, int data_height_in, int data_depth_in, int texture_width_in, int texture_height_in, int texture_depth_in, byte[][] color_values) throws VisADException {
        int texture_depth;
        int texture_height;
        int texture_width;
        int data_depth;
        int data_height;
        int data_width;
        int kdepth;
        int kheight;
        int kwidth;
        if (axis == 2) {
            kwidth = 1;
            kheight = data_width_in;
            kdepth = data_width_in * data_height_in;
            data_width = data_width_in;
            data_height = data_height_in;
            data_depth = data_depth_in;
            texture_width = texture_width_in;
            texture_height = texture_height_in;
            texture_depth = texture_depth_in;
        } else if (axis == 1) {
            kwidth = 1;
            kdepth = data_width_in;
            kheight = data_width_in * data_height_in;
            data_width = data_width_in;
            data_depth = data_height_in;
            data_height = data_depth_in;
            texture_width = texture_width_in;
            texture_depth = texture_height_in;
            texture_height = texture_depth_in;
        } else if (axis == 0) {
            kdepth = 1;
            kwidth = data_width_in;
            kheight = data_width_in * data_height_in;
            data_depth = data_width_in;
            data_width = data_height_in;
            data_height = data_depth_in;
            texture_depth = texture_width_in;
            texture_width = texture_height_in;
            texture_height = texture_depth_in;
        } else {
            return null;
        }
        BufferedImage[] images = new BufferedImage[texture_depth];
        int d2 = 0;
        while (d2 < data_depth) {
            int j;
            int i;
            int a2;
            int b2;
            int g;
            int r;
            int i2;
            int k;
            int j2;
            int m;
            int kk;
            int[] intData;
            DataBuffer db;
            WritableRaster raster;
            ColorModel colorModel;
            if (color_values.length > 3) {
                colorModel = ColorModel.getRGBdefault();
                raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
                images[d2] = new BufferedImage(colorModel, raster, false, null);
                db = raster.getDataBuffer();
                if (!(db instanceof DataBufferInt)) {
                    throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
                }
                intData = ((DataBufferInt)db).getData();
                kk = d2 * kdepth;
                m = 0;
                j2 = 0;
                while (j2 < data_height) {
                    k = kk + j2 * kheight;
                    i2 = 0;
                    while (i2 < data_width) {
                        r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                        g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                        b2 = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                        a2 = color_values[3][k] < 0 ? color_values[3][k] + 256 : color_values[3][k];
                        intData[m++] = a2 << 24 | r << 16 | g << 8 | b2;
                        k += kwidth;
                        ++i2;
                    }
                    i = data_width;
                    while (i < texture_width) {
                        intData[m++] = 0;
                        ++i;
                    }
                    ++j2;
                }
                j = data_height;
                while (j < texture_height) {
                    i2 = 0;
                    while (i2 < texture_width) {
                        intData[m++] = 0;
                        ++i2;
                    }
                    ++j;
                }
            } else {
                colorModel = ColorModel.getRGBdefault();
                raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
                images[d2] = new BufferedImage(colorModel, raster, false, null);
                db = raster.getDataBuffer();
                if (!(db instanceof DataBufferInt)) {
                    throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
                }
                intData = ((DataBufferInt)db).getData();
                kk = d2 * kdepth;
                m = 0;
                j2 = 0;
                while (j2 < data_height) {
                    k = kk + j2 * kheight;
                    i2 = 0;
                    while (i2 < data_width) {
                        r = color_values[0][k] < 0 ? color_values[0][k] + 256 : color_values[0][k];
                        g = color_values[1][k] < 0 ? color_values[1][k] + 256 : color_values[1][k];
                        b2 = color_values[2][k] < 0 ? color_values[2][k] + 256 : color_values[2][k];
                        a2 = 255;
                        intData[m++] = a2 << 24 | r << 16 | g << 8 | b2;
                        k += kwidth;
                        ++i2;
                    }
                    i = data_width;
                    while (i < texture_width) {
                        intData[m++] = 0;
                        ++i;
                    }
                    ++j2;
                }
                j = data_height;
                while (j < texture_height) {
                    i2 = 0;
                    while (i2 < texture_width) {
                        intData[m++] = 0;
                        ++i2;
                    }
                    ++j;
                }
            }
            ++d2;
        }
        int d3 = data_depth;
        while (d3 < texture_depth) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
            images[d3] = new BufferedImage(colorModel, raster, false, null);
            DataBuffer db = raster.getDataBuffer();
            if (!(db instanceof DataBufferInt)) {
                throw new UnimplementedException("getRGBdefault isn't DataBufferInt");
            }
            int[] intData = ((DataBufferInt)db).getData();
            int i = 0;
            while (i < texture_width * texture_height) {
                intData[i] = 0;
                ++i;
            }
            ++d3;
        }
        return images;
    }

    public VisADQuadArray reverse(VisADQuadArray array) {
        int count;
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.coordinates = new float[array.coordinates.length];
        qarray.texCoords = new float[array.texCoords.length];
        qarray.colors = new byte[array.colors.length];
        qarray.normals = new float[array.normals.length];
        qarray.vertexCount = count = array.vertexCount;
        int color_length = array.colors.length / count;
        int tex_length = array.texCoords.length / count;
        int i3 = 0;
        int k3 = 3 * (count - 1);
        int ic = 0;
        int kc = color_length * (count - 1);
        int it = 0;
        int kt = tex_length * (count - 1);
        int i = 0;
        while (i < count) {
            qarray.coordinates[i3] = array.coordinates[k3];
            qarray.coordinates[i3 + 1] = array.coordinates[k3 + 1];
            qarray.coordinates[i3 + 2] = array.coordinates[k3 + 2];
            qarray.texCoords[it] = array.texCoords[kt];
            qarray.texCoords[it + 1] = array.texCoords[kt + 1];
            if (tex_length == 3) {
                qarray.texCoords[it + 2] = array.texCoords[kt + 2];
            }
            qarray.normals[i3] = array.normals[k3];
            qarray.normals[i3 + 1] = array.normals[k3 + 1];
            qarray.normals[i3 + 2] = array.normals[k3 + 2];
            qarray.colors[ic] = array.colors[kc];
            qarray.colors[ic + 1] = array.colors[kc + 1];
            qarray.colors[ic + 2] = array.colors[kc + 2];
            if (color_length == 4) {
                qarray.colors[ic + 3] = array.colors[kc + 3];
            }
            i3 += 3;
            k3 -= 3;
            ic += color_length;
            kc -= color_length;
            it += tex_length;
            kt -= tex_length;
            ++i;
        }
        return qarray;
    }
}

