/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Action;
import visad.ActionImpl;
import visad.ReferenceException;
import visad.RemoteAction;
import visad.RemoteThing;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.Thing;
import visad.ThingChangedEvent;
import visad.ThingChangedLink;
import visad.ThingChangedListener;
import visad.ThingReference;
import visad.VisADException;

public class ThingReferenceImpl
implements ThingReference {
    String Name;
    private transient Thing thing;
    private transient ThingReference ref;
    private long Tick;
    transient Vector ListenerVector = new Vector();

    public ThingReferenceImpl(String name) throws VisADException {
        if (name == null) {
            throw new VisADException("ThingReference: name cannot be null");
        }
        this.Name = name;
        this.Tick = -9223372036854775807L;
    }

    public Thing getThing() {
        return this.thing;
    }

    public synchronized void setThing(Thing t2) throws VisADException, RemoteException {
        if (t2 instanceof RemoteThing) {
            throw new RemoteVisADException("ThingReferenceImpl.setThing: cannot use RemoteThing");
        }
        if (this.thing != null) {
            this.thing.removeReference(this.ref);
        }
        this.ref = this;
        this.thing = t2;
        if (t2 != null) {
            t2.addReference(this.ref);
        }
        this.incTick();
    }

    synchronized void adaptedSetThing(RemoteThing t2, RemoteThingReference r) throws VisADException, RemoteException {
        if (this.thing != null) {
            this.thing.removeReference(this.ref);
        }
        this.ref = r;
        this.thing = t2;
        t2.addReference(this.ref);
        this.incTick();
    }

    public long getTick() {
        return this.Tick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long incTick() throws VisADException, RemoteException {
        ++this.Tick;
        if (this.Tick == Long.MAX_VALUE) {
            this.Tick = -9223372036854775807L;
        }
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                int i = 0;
                while (i < this.ListenerVector.size()) {
                    ThingChangedLink listener = (ThingChangedLink)this.ListenerVector.elementAt(i);
                    ThingChangedEvent e2 = new ThingChangedEvent(listener.getId(), this.Tick);
                    try {
                        listener.queueThingChangedEvent(e2);
                        ++i;
                    }
                    catch (ConnectException exc) {
                        this.ListenerVector.remove(i);
                    }
                }
            }
        }
        return this.Tick;
    }

    public ThingChangedEvent peekThingChanged(Action a2) throws VisADException {
        if (!(a2 instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.peekThingChanged: Action must be local");
        }
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink listener = this.findThingChangedLink(a2);
        if (listener == null) {
            return null;
        }
        return listener.peekThingChangedEvent();
    }

    public ThingChangedEvent acknowledgeThingChanged(Action a2) throws VisADException {
        if (!(a2 instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.acknowledgeThingChanged: Action must be local");
        }
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink listener = this.findThingChangedLink(a2);
        if (listener == null) {
            return null;
        }
        return listener.acknowledgeThingChangedEvent();
    }

    public ThingChangedEvent adaptedPeekThingChanged(RemoteAction a2) throws VisADException {
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink listener = this.findThingChangedLink(a2);
        if (listener == null) {
            return null;
        }
        return listener.peekThingChangedEvent();
    }

    public ThingChangedEvent adaptedAcknowledgeThingChanged(RemoteAction a2) throws VisADException {
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink listener = this.findThingChangedLink(a2);
        if (listener == null) {
            return null;
        }
        return listener.acknowledgeThingChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThingChangedLink findThingChangedLink(Action a2) throws VisADException {
        if (a2 == null) {
            throw new ReferenceException("ThingReferenceImpl.findThingChangedLink: Action cannot be null");
        }
        if (this.ListenerVector == null) {
            return null;
        }
        Vector vector = this.ListenerVector;
        synchronized (vector) {
            Enumeration listeners = this.ListenerVector.elements();
            while (listeners.hasMoreElements()) {
                ThingChangedLink listener = (ThingChangedLink)listeners.nextElement();
                if (!a2.equals(listener.getAction())) continue;
                return listener;
            }
        }
        return null;
    }

    public String getName() {
        return this.Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThingChangedListener(ThingChangedListener listener, long id) throws RemoteVisADException, ReferenceException, VisADException {
        if (!(listener instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.addThingChangedListener: Action must be local");
        }
        ThingReferenceImpl thingReferenceImpl = this;
        synchronized (thingReferenceImpl) {
            if (this.ListenerVector == null) {
                this.ListenerVector = new Vector();
            }
        }
        Vector vector = this.ListenerVector;
        synchronized (vector) {
            if (this.findThingChangedLink((ActionImpl)listener) != null) {
                throw new ReferenceException("ThingReferenceImpl.addThingChangedListener: link to Action already exists");
            }
            this.ListenerVector.addElement(new ThingChangedLink((ActionImpl)listener, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adaptedAddThingChangedListener(RemoteAction a2, long id) throws VisADException {
        ThingReferenceImpl thingReferenceImpl = this;
        synchronized (thingReferenceImpl) {
            if (this.ListenerVector == null) {
                this.ListenerVector = new Vector();
            }
        }
        Vector vector = this.ListenerVector;
        synchronized (vector) {
            if (this.findThingChangedLink(a2) != null) {
                throw new ReferenceException("ThingReferenceImpl.addThingChangedListener: link to Action already exists");
            }
            this.ListenerVector.addElement(new ThingChangedLink(a2, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThingChangedListener(ThingChangedListener a2) throws VisADException {
        if (!(a2 instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.removeThingChangedListener: Action must be local");
        }
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                ThingChangedLink listener = this.findThingChangedLink((ActionImpl)a2);
                if (listener != null) {
                    this.ListenerVector.removeElement(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adaptedRemoveThingChangedListener(RemoteAction a2) throws VisADException {
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                ThingChangedLink listener = this.findThingChangedLink(a2);
                if (listener != null) {
                    this.ListenerVector.removeElement(listener);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ThingReference)) {
            return false;
        }
        return obj == this;
    }

    public String toString() {
        return "ThingReference " + this.Name;
    }
}

