/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;

public class ToggleControl
extends Control {
    private boolean on;
    private Control parent;

    public ToggleControl(DisplayImpl d2, Control p) {
        super(d2);
        this.parent = p;
        this.on = true;
    }

    public Control getParent() {
        return this.parent;
    }

    public boolean getOn() {
        return this.on;
    }

    public void setOn(boolean o) throws VisADException, RemoteException {
        this.on = o;
        this.changeControl(true);
    }

    private boolean parentEquals(Control newParent) {
        if (this.parent == null) {
            if (newParent != null) {
                return false;
            }
        } else {
            if (newParent == null) {
                return false;
            }
            if (!this.parent.equals(newParent)) {
                return false;
            }
        }
        return true;
    }

    public String getSaveString() {
        return "" + this.on;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        this.setOn(Convert.getBoolean(save));
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ToggleControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ToggleControl tc = (ToggleControl)rmt;
        boolean changed = false;
        if (this.on != tc.on) {
            changed = true;
            this.on = tc.on;
        }
        if (!this.parentEquals(tc.parent)) {
            changed = true;
            this.parent = tc.parent;
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ToggleControl tc = (ToggleControl)o;
        if (this.on != tc.on) {
            return false;
        }
        return this.parentEquals(tc.parent);
    }
}

