/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.lang.reflect.InvocationTargetException;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.VisADException;
import visad.data.hdfeos.PolarStereographic;
import visad.matrix.JamaMatrix;

public class LinearVectorPointMethod {
    JamaMatrix jm_A;
    double scale_1;
    double scale_2;
    double scale_3;
    double[][] centroid_ll;

    public LinearVectorPointMethod(double[][] lonlat_s) throws VisADException {
        if (lonlat_s[0].length != 3) {
            throw new VisADException("number of points must equal 3");
        }
        this.scale_1 = 1.0;
        this.scale_2 = (1.0 + Math.sin(lonlat_s[1][0])) / (1.0 + Math.sin(lonlat_s[1][1]));
        this.scale_3 = (1.0 + Math.sin(lonlat_s[1][0])) / (1.0 + Math.sin(lonlat_s[1][2]));
        PolarStereographic cs = new PolarStereographic(lonlat_s[0][0], lonlat_s[1][0]);
        double[][] verts_xy = ((CoordinateSystem)cs).fromReference(lonlat_s);
        double[][] del_xy = new double[2][lonlat_s[0].length];
        double[] centroid_xy = LinearVectorPointMethod.triangleCentroid(verts_xy);
        this.centroid_ll = ((CoordinateSystem)cs).toReference(new double[][]{{centroid_xy[0]}, {centroid_xy[1]}});
        System.out.println("centroid lon: " + this.centroid_ll[0][0] * 57.29577951308232);
        System.out.println("centroid lat: " + this.centroid_ll[1][0] * 57.29577951308232);
        double scale_c = (1.0 + Math.sin(lonlat_s[1][0])) / (1.0 + Math.sin(this.centroid_ll[1][0]));
        double scale_c_squared = scale_c * scale_c;
        del_xy[0][0] = verts_xy[0][0] - centroid_xy[0];
        del_xy[1][0] = verts_xy[1][0] - centroid_xy[1];
        del_xy[0][1] = verts_xy[0][1] - centroid_xy[0];
        del_xy[1][1] = verts_xy[1][1] - centroid_xy[1];
        del_xy[0][2] = verts_xy[0][2] - centroid_xy[0];
        del_xy[1][2] = verts_xy[1][2] - centroid_xy[1];
        double[][] X_values = new double[6][6];
        X_values[0][0] = 1.0;
        X_values[0][1] = 0.0;
        X_values[0][2] = 1.0;
        X_values[0][3] = 0.0;
        X_values[0][4] = 1.0;
        X_values[0][5] = 0.0;
        X_values[1][0] = 0.0;
        X_values[1][1] = 1.0;
        X_values[1][2] = 0.0;
        X_values[1][3] = 1.0;
        X_values[1][4] = 0.0;
        X_values[1][5] = 1.0;
        X_values[2][0] = del_xy[0][0] / scale_c_squared;
        X_values[2][1] = -del_xy[1][0] / scale_c_squared;
        X_values[2][2] = del_xy[0][1] / scale_c_squared;
        X_values[2][3] = -del_xy[1][1] / scale_c_squared;
        X_values[2][4] = del_xy[0][2] / scale_c_squared;
        X_values[2][5] = -del_xy[1][2] / scale_c_squared;
        X_values[3][0] = del_xy[1][0] / scale_c_squared;
        X_values[3][1] = del_xy[0][0] / scale_c_squared;
        X_values[3][2] = del_xy[1][1] / scale_c_squared;
        X_values[3][3] = del_xy[0][1] / scale_c_squared;
        X_values[3][4] = del_xy[1][2] / scale_c_squared;
        X_values[3][5] = del_xy[0][2] / scale_c_squared;
        X_values[4][0] = del_xy[0][0] / scale_c_squared;
        X_values[4][1] = del_xy[1][0] / scale_c_squared;
        X_values[4][2] = del_xy[0][1] / scale_c_squared;
        X_values[4][3] = del_xy[1][1] / scale_c_squared;
        X_values[4][4] = del_xy[0][2] / scale_c_squared;
        X_values[4][5] = del_xy[1][2] / scale_c_squared;
        X_values[5][0] = -del_xy[1][0] / scale_c_squared;
        X_values[5][1] = del_xy[0][0] / scale_c_squared;
        X_values[5][2] = -del_xy[1][1] / scale_c_squared;
        X_values[5][3] = del_xy[0][1] / scale_c_squared;
        X_values[5][4] = -del_xy[1][2] / scale_c_squared;
        X_values[5][5] = del_xy[0][2] / scale_c_squared;
        try {
            this.jm_A = new JamaMatrix(X_values);
            this.jm_A = this.jm_A.transpose();
        }
        catch (IllegalAccessException e2) {
        }
        catch (InstantiationException e3) {
        }
        catch (InvocationTargetException e4) {}
    }

    public double[][] getCentroid() {
        return this.centroid_ll;
    }

    public double[] getKinematics(double[][] uv_wind) throws VisADException {
        double[][] values = new double[1][6];
        values[0][0] = uv_wind[0][0] / this.scale_1;
        values[0][1] = uv_wind[1][0] / this.scale_1;
        values[0][2] = uv_wind[0][1] / this.scale_2;
        values[0][3] = uv_wind[1][1] / this.scale_2;
        values[0][4] = uv_wind[0][2] / this.scale_3;
        values[0][5] = uv_wind[1][2] / this.scale_3;
        FlatField x = null;
        try {
            JamaMatrix jm_b = new JamaMatrix(values);
            x = this.jm_A.solve(jm_b.transpose());
        }
        catch (IllegalAccessException e2) {
        }
        catch (InstantiationException e3) {
        }
        catch (InvocationTargetException e4) {}
        return x.getValues()[0];
    }

    public static void main(String[] args) throws VisADException {
        double[][] lonlat_s = new double[2][3];
        lonlat_s[0][0] = -1.7014342213066722;
        lonlat_s[1][0] = 0.6388777726925243;
        lonlat_s[0][1] = -1.7314364311484545;
        lonlat_s[1][1] = 0.6295751677793946;
        lonlat_s[0][2] = -1.7020799931299102;
        lonlat_s[1][2] = 0.6105859855176963;
        LinearVectorPointMethod lvpm = new LinearVectorPointMethod(lonlat_s);
        double[][] uv_wind = new double[2][3];
        uv_wind[0][0] = 6.5;
        uv_wind[1][0] = 19.8;
        uv_wind[0][1] = 11.0;
        uv_wind[1][1] = 9.2;
        uv_wind[0][2] = 8.2;
        uv_wind[1][2] = 11.7;
        double[] div_vort = lvpm.getKinematics(uv_wind);
        int ii = 0;
        while (ii < div_vort.length) {
            System.out.println(div_vort[ii]);
            ++ii;
        }
        System.out.println(Double.NaN);
    }

    private static double[] triangleCentroid(double[][] verts) {
        double[] centroid_xy = new double[2];
        double[][] midpoint_12 = new double[2][1];
        double[][] midpoint_13 = new double[2][1];
        double[][] verts_xy = new double[2][3];
        verts_xy[0][0] = verts[0][0];
        verts_xy[0][1] = verts[0][1];
        verts_xy[0][2] = verts[0][2];
        verts_xy[1][0] = verts[1][0];
        verts_xy[1][1] = verts[1][1];
        verts_xy[1][2] = verts[1][2];
        boolean rotate = false;
        midpoint_12[0][0] = (verts_xy[0][1] - verts_xy[0][0]) / 2.0 + verts_xy[0][0];
        midpoint_12[1][0] = (verts_xy[1][1] - verts_xy[1][0]) / 2.0 + verts_xy[1][0];
        midpoint_13[0][0] = (verts_xy[0][2] - verts_xy[0][0]) / 2.0 + verts_xy[0][0];
        midpoint_13[1][0] = (verts_xy[1][2] - verts_xy[1][0]) / 2.0 + verts_xy[1][0];
        double slope_12_3 = (verts_xy[1][2] - midpoint_12[1][0]) / (verts_xy[0][2] - midpoint_12[0][0]);
        double slope_13_2 = (verts_xy[1][1] - midpoint_13[1][0]) / (verts_xy[0][1] - midpoint_13[0][0]);
        if (Double.isInfinite(slope_12_3) || Double.isInfinite(slope_13_2)) {
            System.out.println("infinite slope");
            LinearVectorPointMethod.rotate_clockwise(verts_xy, 1.5707963267948966);
            LinearVectorPointMethod.rotate_clockwise(midpoint_12, 1.5707963267948966);
            LinearVectorPointMethod.rotate_clockwise(midpoint_13, 1.5707963267948966);
            rotate = true;
        }
        double yintercept_12_3 = verts_xy[1][2] - slope_12_3 * verts_xy[0][2];
        double yintercept_13_2 = verts_xy[1][1] - slope_13_2 * verts_xy[0][1];
        centroid_xy[0] = (yintercept_12_3 - yintercept_13_2) / (slope_13_2 - slope_12_3);
        centroid_xy[1] = slope_12_3 * centroid_xy[0] + yintercept_12_3;
        if (rotate) {
            double[][] xy = new double[2][1];
            xy[0][0] = centroid_xy[0];
            xy[1][0] = centroid_xy[1];
            LinearVectorPointMethod.rotate_clockwise(xy, -1.5707963267948966);
            centroid_xy[0] = xy[0][0];
            centroid_xy[1] = xy[1][0];
        }
        return centroid_xy;
    }

    private static void rotate_clockwise(double[][] points, double rot_angle) {
        int ii = 0;
        while (ii < points[0].length) {
            double x = points[0][ii];
            double y = points[1][ii];
            double angle = Math.atan2(y, x);
            double r = Math.sqrt(x * x + y * y);
            points[0][ii] = r * Math.cos(angle - rot_angle);
            points[1][ii] = r * Math.sin(angle - rot_angle);
            ++ii;
        }
    }
}

