/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.ShapeControl;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADTriangleStripArray;
import visad.aeri.Aeri;
import visad.aeri.LinearVectorPointMethod;
import visad.aeri.Qdiv;
import visad.bom.WindPolarCoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADSerialForm;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.util.AnimationWidget;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class Qdiv
implements ScalarMapListener {
    RealType latitude;
    RealType longitude;
    RealType altitude;
    RealTupleType spatial_domain;
    RealType time;
    RealType stn_idx;
    RealType temp;
    RealType dwpt;
    RealType wvmr;
    RealType RH;
    RealType theta;
    RealType thetaE;
    RealType u_wind;
    RealType v_wind;
    RealType wvmr_u;
    RealType wvmr_v;
    RealType band1;
    RealType div_qV;
    RealType q_divV;
    RealType qAdvct;
    RealType shape;
    RealTupleType wind_aeri;
    RealTupleType div_qV_comps;
    FunctionType alt_to_wind_aeri;
    FunctionType time_to_alt_to_wind_aeri;
    FunctionType alt_to_divqV;
    FunctionType time_to_alt_to_divqV;
    FieldImpl advect_field;
    FieldImpl stations_field;
    FieldImpl divqV_field;
    ImageSequence image_seq;
    Set timeDomain;
    int n_stations = 3;
    double[] station_lat;
    double[] station_lon;
    double[] station_alt;
    double[] station_id;
    double[] stat_xoffset = new double[this.n_stations];
    double[] stat_yoffset = new double[this.n_stations];
    double[][] centroid_ll;
    BaseMapAdapter baseMap;
    DataReference map_ref;
    ScalarMap xmap;
    ScalarMap ymap;
    ScalarMap zmap;
    ScalarMap img_map;
    boolean xmapEvent = false;
    boolean ymapEvent = false;
    boolean imgEvent = false;
    boolean firstEvent = false;
    boolean first_img_Event = false;
    float latmin;
    float latmax;
    float lonmin;
    float lonmax;
    float del_lat;
    float del_lon;
    double[] x_range;
    double[] y_range;
    int height_limit = 4000;
    int time_intrvl = 900;
    boolean rh = false;
    boolean tm = false;
    boolean pt = false;
    boolean ept = false;
    int start_date = 0;
    double start_time = 0.0;
    double[] scale_offset_x = new double[2];
    double[] scale_offset_y = new double[2];
    AnimationControl ani_cntrl;
    int alt_factor = 8;
    int n_hres_alt_samples;
    float alt_min;
    float alt_max;
    double hgt_max = -1.7976931348623157E308;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        Qdiv qdiv = new Qdiv(args);
    }

    public Qdiv(String[] args) throws VisADException, RemoteException, IOException {
        String vadfile = null;
        String baseDate = "19991226";
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (args[i].endsWith(".vad")) {
                    vadfile = args[i];
                } else if (args[i].equals("-limit") && i + 1 < args.length) {
                    try {
                        this.height_limit = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException e2) {
                        System.out.println("bad height limit: " + args[i + 1]);
                    }
                    ++i;
                } else if (args[i].equals("-date") && i + 1 < args.length) {
                    baseDate = args[i + 1];
                    ++i;
                } else if (args[i].equals("-rh")) {
                    this.rh = true;
                    this.tm = false;
                } else if (args[i].equals("-temp")) {
                    this.tm = true;
                    this.rh = false;
                } else if (args[i].equals("-theta")) {
                    this.pt = true;
                } else if (args[i].equals("-thetaE")) {
                    this.ept = true;
                }
            }
            ++i;
        }
        if (vadfile != null) {
            this.init_from_vad(vadfile);
        } else {
            this.init_from_cdf(baseDate);
        }
        this.wvmr.alias("MR");
        this.temp.alias("T");
        try {
            String fs = System.getProperty("file.separator");
            this.image_seq = Qdiv.init_images("." + fs + "data" + fs + "image" + fs + baseDate);
            this.band1 = (RealType)((RealTupleType)((FunctionType)((FunctionType)this.image_seq.getType()).getRange()).getRange()).getComponent(0);
        }
        catch (Exception e3) {
            System.out.println("no AREA image data");
            this.image_seq = null;
        }
        JFrame frame = new JFrame("VisAD AERI/QDIV Viewer");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        frame.getContentPane().add(panel);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 0));
        DisplayImpl display = this.makeDisplay(panel, panel2);
        int WIDTH = 1200;
        int HEIGHT = 800;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setVisible(true);
        JFrame frame2 = new JFrame("image color");
        frame2.setSize(400, 200);
        frame2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        frame2.getContentPane().add(panel2);
    }

    void init_from_cdf(String baseDate) throws VisADException, RemoteException, IOException {
        this.station_lat = new double[this.n_stations];
        this.station_lon = new double[this.n_stations];
        this.station_alt = new double[this.n_stations];
        this.station_id = new double[this.n_stations];
        this.longitude = RealType.Longitude;
        this.latitude = RealType.Latitude;
        this.RH = RealType.getRealType("RH", SI.second);
        this.stn_idx = RealType.getRealType("stn_idx");
        this.theta = RealType.getRealType("theta");
        this.thetaE = RealType.getRealType("thetaE");
        this.u_wind = RealType.getRealType("u_wind");
        this.v_wind = RealType.getRealType("v_wind");
        this.wvmr_u = RealType.getRealType("wvmr_u");
        this.wvmr_v = RealType.getRealType("wvmr_v");
        this.div_qV = RealType.getRealType("div_qV");
        this.q_divV = RealType.getRealType("q_divV");
        this.qAdvct = RealType.getRealType("qAdvct");
        this.shape = RealType.getRealType("shape");
        String[] wind_files = new String[this.n_stations];
        String[] rtvl_files = new String[this.n_stations];
        String truncatedDate = baseDate;
        wind_files[0] = "./data/" + baseDate + "_lamont_windprof.cdf";
        wind_files[1] = "./data/" + baseDate + "_vici_windprof.cdf";
        wind_files[2] = "./data/" + baseDate + "_purcell_windprof.cdf";
        rtvl_files[0] = "./data/lamont_" + truncatedDate + "AG.cdf";
        rtvl_files[1] = "./data/vici_" + truncatedDate + "AG.cdf";
        rtvl_files[2] = "./data/purcell_" + truncatedDate + "AG.cdf";
        File file = new File("./data/lamont_" + truncatedDate + "AP.cdf");
        rtvl_files[0] = file.exists() ? "./data/lamont_" + truncatedDate + "AP.cdf" : "./data/lamont_" + truncatedDate + "AG.cdf";
        file = new File("./data/vici_" + truncatedDate + "AP.cdf");
        rtvl_files[1] = file.exists() ? "./data/vici_" + truncatedDate + "AP.cdf" : "./data/vici_" + truncatedDate + "AG.cdf";
        file = new File("./data/purcell_" + truncatedDate + "AP.cdf");
        rtvl_files[2] = file.exists() ? "./data/purcell_" + truncatedDate + "AP.cdf" : "./data/purcell_" + truncatedDate + "AG.cdf";
        FieldImpl[] winds = this.makeWinds(wind_files);
        System.out.println(winds[0].getType().prettyString());
        FieldImpl[] rtvls = this.makeAeri(rtvl_files);
        System.out.println(rtvls[0].getType().prettyString());
        RealType[] r_types = new RealType[]{this.u_wind, this.v_wind, this.temp, this.dwpt, this.wvmr, this.wvmr_u, this.wvmr_v, this.thetaE};
        this.wind_aeri = new RealTupleType(r_types);
        this.alt_to_wind_aeri = new FunctionType(this.altitude, this.wind_aeri);
        this.time_to_alt_to_wind_aeri = new FunctionType(RealType.Time, this.alt_to_wind_aeri);
        this.div_qV_comps = new RealTupleType(new RealType[]{this.div_qV, this.thetaE, this.shape});
        this.alt_to_divqV = new FunctionType(this.altitude, this.div_qV_comps);
        this.time_to_alt_to_divqV = new FunctionType(RealType.Time, this.alt_to_divqV);
        this.spatial_domain = new RealTupleType(this.longitude, this.latitude, this.altitude);
        this.stations_field = this.make_wind_aeri(winds, rtvls);
        System.out.println(this.stations_field.getType().prettyString());
        this.divqV_field = this.makeDivqV(this.stations_field);
        System.out.println("makeDivqV:  Done");
    }

    void init_from_vad(String vad_file) throws VisADException, RemoteException, IOException {
        VisADSerialForm vad_form = new VisADSerialForm();
        this.stations_field = (FieldImpl)vad_form.open(vad_file);
        MathType file_type = this.stations_field.getType();
        this.stn_idx = (RealType)((FunctionType)file_type).getDomain().getComponent(0);
        FunctionType f_type0 = (FunctionType)((FunctionType)file_type).getRange();
        this.time = (RealType)f_type0.getDomain().getComponent(0);
        FunctionType f_type1 = (FunctionType)f_type0.getRange();
        this.spatial_domain = f_type1.getDomain();
        this.longitude = (RealType)this.spatial_domain.getComponent(0);
        this.latitude = (RealType)this.spatial_domain.getComponent(1);
        this.altitude = (RealType)this.spatial_domain.getComponent(2);
        RealTupleType rtt = (RealTupleType)f_type1.getRange();
        this.temp = (RealType)rtt.getComponent(0);
        this.dwpt = (RealType)rtt.getComponent(1);
        this.wvmr = (RealType)rtt.getComponent(2);
        this.RH = (RealType)rtt.getComponent(3);
        this.theta = (RealType)rtt.getComponent(4);
        this.thetaE = (RealType)rtt.getComponent(5);
    }

    public static ImageSequence init_images(String image_directory) throws VisADException, RemoteException, IOException {
        String fs = System.getProperty("file.separator");
        if (image_directory == null) {
            image_directory = "." + fs + "data" + fs + "image" + fs + "ir_display";
        }
        File file = new File(image_directory);
        String[] image_files = file.list();
        int n_images = image_files.length;
        SingleBandedImage[] nav_images = new NavigatedImage[n_images];
        int ii = 0;
        while (ii < n_images) {
            AreaAdapter area = new AreaAdapter(image_directory + fs + image_files[ii]);
            FlatField image = area.getData();
            DateTime img_start = area.getImageStartTime();
            nav_images[ii] = new NavigatedImage(image, img_start, "AREA");
            ++ii;
        }
        ImageSequenceManager img_manager = new ImageSequenceManager(nav_images);
        return img_manager.getImageSequence();
    }

    DisplayImpl makeDisplay(JPanel panel, JPanel panel2) throws VisADException, RemoteException, IOException {
        double display_y;
        double display_x;
        this.del_lon = 8.0f;
        this.del_lat = 8.0f;
        this.baseMap = new BaseMapAdapter("OUTLUSAM");
        this.map_ref = new DataReferenceImpl("map");
        if (!this.baseMap.isEastPositive()) {
            this.baseMap.setEastPositive(true);
        }
        DataImpl poles = this.makePoles();
        DataReferenceImpl poles_ref = new DataReferenceImpl("poles");
        poles_ref.setData(poles);
        DisplayImplJ3D display = new DisplayImplJ3D("aeri");
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        mode.setLineWidth(1.5f);
        DisplayRenderer dr = display.getDisplayRenderer();
        dr.setBoxOn(false);
        this.xmap = new ScalarMap(this.longitude, Display.XAxis);
        this.xmap.setScaleEnable(false);
        this.xmap.addScalarMapListener(this);
        this.ymap = new ScalarMap(this.latitude, Display.YAxis);
        this.ymap.setScaleEnable(false);
        this.ymap.addScalarMapListener(this);
        double[] lon_mm = Qdiv.getArrayMinMax(this.station_lon);
        double[] lat_mm = Qdiv.getArrayMinMax(this.station_lat);
        this.baseMap.setLatLonLimits((float)(lat_mm[0] - (double)this.del_lat), (float)(lat_mm[1] + (double)this.del_lat), (float)(lon_mm[0] - (double)this.del_lon), (float)(lon_mm[1] + (double)this.del_lon));
        UnionSet map = this.baseMap.getData();
        this.map_ref.setData(map);
        this.zmap = new ScalarMap(this.altitude, Display.ZAxis);
        display.addMap(this.xmap);
        display.addMap(this.ymap);
        display.addMap(this.zmap);
        float rad = 0.06f;
        float len = 0.0078375f;
        ScalarMap shape_map = new ScalarMap(this.shape, Display.Shape);
        display.addMap(shape_map);
        VisADTriangleStripArray cyl = Qdiv.makeCylinder(14, rad, len);
        System.out.println("makeCylinder done");
        VisADGeometryArray[] shapes = new VisADGeometryArray[]{cyl};
        ShapeControl shape_control = (ShapeControl)shape_map.getControl();
        shape_control.setShapeSet(new Integer1DSet(1));
        shape_control.setShapes(shapes);
        ScalarMap flowx = new ScalarMap(this.wvmr_u, Display.Flow1X);
        ScalarMap flowy = new ScalarMap(this.wvmr_v, Display.Flow1Y);
        display.addMap(flowx);
        display.addMap(flowy);
        FlowControl flow_cntrl = (FlowControl)flowx.getControl();
        flow_cntrl.setFlowScale(0.5f);
        flow_cntrl = (FlowControl)flowy.getControl();
        flow_cntrl.setFlowScale(0.5f);
        ScalarMap cmap = null;
        cmap = this.rh ? new ScalarMap(this.RH, Display.RGB) : (this.tm ? new ScalarMap(this.temp, Display.RGB) : (this.pt ? new ScalarMap(this.theta, Display.RGB) : (this.ept ? new ScalarMap(this.thetaE, Display.RGB) : new ScalarMap(this.wvmr, Display.RGB))));
        display.addMap(cmap);
        ScalarMap cmap2 = new ScalarMap(this.thetaE, Display.RGB);
        display.addMap(cmap2);
        ColorMapWidget cmw = new ColorMapWidget(cmap, null, true, false);
        LabeledColorWidget cwidget = new LabeledColorWidget(cmw);
        ScalarMap tmap = new ScalarMap(RealType.Time, Display.Animation);
        display.addMap(tmap);
        this.ani_cntrl = (AnimationControl)((Object)tmap.getControl());
        this.ani_cntrl.setStep(200);
        AnimationWidget awidget = new AnimationWidget(tmap);
        this.zmap.setRange(0.0, this.hgt_max);
        this.img_map = new ScalarMap(this.band1, Display.RGB);
        this.img_map.addScalarMapListener(this);
        display.addMap(this.img_map);
        ColorControl cc = (ColorControl)this.img_map.getControl();
        cc.initGreyWedge();
        ConstantMap[] map_constMap = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(-0.98, Display.ZAxis)};
        display.addReference(poles_ref);
        display.addReference(this.map_ref, map_constMap);
        ConstantMap[] c_maps = new ConstantMap[2];
        int kk = 0;
        while (kk < this.n_stations) {
            display_x = this.station_lon[kk] * this.scale_offset_x[0] + this.scale_offset_x[1];
            c_maps[0] = new ConstantMap(display_x, Display.XAxis);
            display_y = this.station_lat[kk] * this.scale_offset_y[0] + this.scale_offset_y[1];
            c_maps[1] = new ConstantMap(display_y, Display.YAxis);
            DataReferenceImpl station_ref = new DataReferenceImpl("station: " + kk);
            station_ref.setData(this.stations_field.getSample(kk));
            display.addReference(station_ref, c_maps);
            ++kk;
        }
        display_x = this.centroid_ll[0][0] * 57.29577951308232 * this.scale_offset_x[0] + this.scale_offset_x[1];
        display_y = this.centroid_ll[1][0] * 57.29577951308232 * this.scale_offset_y[0] + this.scale_offset_y[1];
        ConstantMap[] c_maps2 = new ConstantMap[]{new ConstantMap(display_x, Display.XAxis), new ConstantMap(display_y, Display.YAxis)};
        DataReferenceImpl centroid_ref = new DataReferenceImpl("centroid");
        centroid_ref.setData(this.divqV_field);
        display.addReference(centroid_ref, c_maps2);
        ConstantMap[] img_constMap = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
        if (this.image_seq != null) {
            DataReferenceImpl img_ref = new DataReferenceImpl("image");
            img_ref.setData(this.image_seq);
            display.addReference(img_ref, img_constMap);
        }
        JPanel dpanel = new JPanel();
        dpanel.setLayout(new BoxLayout(dpanel, 1));
        dpanel.add(display.getComponent());
        JPanel wpanel = new JPanel();
        wpanel.setLayout(new BoxLayout(wpanel, 1));
        cwidget.setMaximumSize(new Dimension(400, 100));
        awidget.setMaximumSize(new Dimension(400, 200));
        wpanel.add(cwidget);
        wpanel.add(awidget);
        JPanel hpanel = new JPanel();
        hpanel.setLayout(new BoxLayout(hpanel, 0));
        this.makeDisplay2(hpanel);
        wpanel.add(hpanel);
        Dimension d2 = new Dimension(400, 800);
        wpanel.setMaximumSize(d2);
        panel.add(dpanel);
        panel.add(wpanel);
        return display;
    }

    void makeDisplay2(JPanel panel) throws VisADException, RemoteException, IOException {
        DisplayImplJ3D display = new DisplayImplJ3D("components", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        DisplayRenderer dr = display.getDisplayRenderer();
        dr.setBoxOn(false);
        ScalarMap xmap = new ScalarMap(RealType.Time, Display.XAxis);
        ScalarMap ymap = new ScalarMap(this.altitude, Display.YAxis);
        ScalarMap cmap = new ScalarMap(this.div_qV, Display.RGB);
        display.addMap(xmap);
        display.addMap(ymap);
        display.addMap(cmap);
        class Listener
        implements ControlListener {
            double[][] value;
            private final /* synthetic */ ScalarMap val$xmap;
            private final /* synthetic */ Qdiv this$0;

            Listener(Qdiv this$0, ScalarMap val$xmap) {
                this.this$0 = this$0;
                this.val$xmap = val$xmap;
            }

            public void controlChanged(ControlEvent ce) {
                int step = this.this$0.ani_cntrl.getCurrent();
                try {
                    this.value = this.this$0.timeDomain.indexToDouble(new int[]{step});
                    this.val$xmap.setRange(this.value[0][0] - 14400.0, this.value[0][0]);
                }
                catch (VisADException e2) {
                }
                catch (RemoteException e3) {}
            }
        }
        this.ani_cntrl.addControlListener(new Listener(this, xmap));
        DataReferenceImpl time_height_ref = new DataReferenceImpl("time_height_ref");
        time_height_ref.setData(this.divqV_field.domainMultiply());
        display.addReference(time_height_ref);
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        panel.add(display.getComponent());
    }

    public static double[] getArrayMinMax(double[] array) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[] min_max = new double[2];
        int ii = 0;
        while (ii < array.length) {
            if (array[ii] > max) {
                max = array[ii];
            }
            if (array[ii] < min) {
                min = array[ii];
            }
            ++ii;
        }
        min_max[0] = min;
        min_max[1] = max;
        return min_max;
    }

    DataImpl makePoles() throws VisADException, RemoteException {
        SampledSet[] set_s = new SampledSet[this.n_stations];
        int ii = 0;
        float[][] locs = new float[3][2];
        int kk = 0;
        while (kk < this.n_stations) {
            boolean any = false;
            float hgt = -3.4028235E38f;
            FieldImpl station = (FieldImpl)this.stations_field.getSample(kk);
            if (station != null) {
                int len = station.getLength();
                int i = 0;
                while (i < len) {
                    FieldImpl pole = (FieldImpl)station.getSample(i);
                    if (pole != null && pole.getLength() >= 2) {
                        Set set = pole.getDomainSet();
                        float[][] samples = set.getSamples(false);
                        float[] hi = ((SampledSet)set).getHi();
                        if (hi[0] > hgt) {
                            hgt = hi[0];
                        }
                        if (!any && samples[0][0] == samples[0][0]) {
                            any = true;
                            locs[0][0] = (float)this.station_lon[kk];
                            locs[1][0] = (float)this.station_lat[kk];
                            locs[0][1] = locs[0][0];
                            locs[1][1] = locs[1][0];
                        }
                    }
                    ++i;
                }
                if (any) {
                    locs[2][0] = 0.0f;
                    locs[2][1] = hgt;
                    set_s[ii++] = new Gridded3DSet((MathType)this.spatial_domain, locs, 2, null, null, null);
                    if ((double)hgt > this.hgt_max) {
                        this.hgt_max = hgt;
                    }
                }
            }
            ++kk;
        }
        SampledSet[] set_ss = new SampledSet[ii];
        System.arraycopy(set_s, 0, set_ss, 0, ii);
        return new UnionSet((MathType)this.spatial_domain, set_ss);
    }

    public void mapChanged(ScalarMapEvent e2) throws VisADException, RemoteException {
        if (this.xmap.equals(e2.getScalarMap())) {
            this.xmapEvent = true;
        } else if (this.ymap.equals(e2.getScalarMap())) {
            this.ymapEvent = true;
        } else if (this.img_map.equals(e2.getScalarMap())) {
            this.imgEvent = true;
        }
        if (this.xmapEvent && this.ymapEvent && !this.firstEvent) {
            double[] minmax = Qdiv.getArrayMinMax(this.station_lat);
            this.latmin = (float)minmax[0];
            this.latmax = (float)minmax[1];
            minmax = Qdiv.getArrayMinMax(this.station_lon);
            this.lonmin = (float)minmax[0];
            this.lonmax = (float)minmax[1];
            this.firstEvent = true;
            this.xmap.setRange(this.lonmin, this.lonmax);
            this.ymap.setRange(this.latmin, this.latmax);
            double[] so = new double[2];
            double[] data = new double[2];
            double[] display = new double[2];
            this.xmap.getScale(so, data, display);
            this.scale_offset_x[0] = so[0];
            this.scale_offset_x[1] = so[1];
            this.ymap.getScale(so, data, display);
            this.scale_offset_y[0] = so[0];
            this.scale_offset_y[1] = so[1];
        }
        if (this.imgEvent && !this.first_img_Event) {
            double[] i_range = this.img_map.getRange();
            System.out.println(i_range[0] + " " + i_range[1]);
            this.first_img_Event = true;
            this.img_map.setRange(i_range[1], i_range[0]);
        }
    }

    public void controlChanged(ScalarMapControlEvent e2) {
    }

    FieldImpl[] makeWinds(String[] files) throws VisADException, RemoteException, IOException {
        DataImpl[] file_data = new DataImpl[this.n_stations];
        FieldImpl[] time_field = new FieldImpl[this.n_stations];
        double[][] time_offset = null;
        double[] base_date = new double[this.n_stations];
        double[] base_time = new double[this.n_stations];
        Gridded1DSet d_set = null;
        FlatField new_ff = null;
        Plain plain = new Plain();
        int kk = 0;
        while (kk < this.n_stations) {
            file_data[kk] = plain.open(files[kk]);
            ++kk;
        }
        MathType file_type = file_data[0].getType();
        System.out.println(file_type.prettyString());
        System.out.println();
        FunctionType f_type0 = (FunctionType)((TupleType)file_type).getComponent(2);
        int n_comps = ((TupleType)f_type0.getRange()).getDimension();
        FunctionType f_type1 = (FunctionType)((TupleType)f_type0.getRange()).getComponent(n_comps - 1);
        RealTupleType rt_type = (RealTupleType)f_type1.getRange();
        int alt_idx = rt_type.getIndex("Altitude");
        this.altitude = (RealType)rt_type.getComponent(alt_idx);
        int ws_idx = rt_type.getIndex("windSpeed");
        RealType spd = (RealType)rt_type.getComponent(ws_idx);
        int wd_idx = rt_type.getIndex("windDir");
        RealType dir = (RealType)rt_type.getComponent(wd_idx);
        RealType[] r_types = new RealType[]{dir, spd};
        RealType[] uv_types = new RealType[]{this.u_wind, this.v_wind};
        RealTupleType uv = new RealTupleType(uv_types);
        WindPolarCoordinateSystem cs = new WindPolarCoordinateSystem(uv);
        RealTupleType ds = new RealTupleType(r_types, (CoordinateSystem)cs, null);
        FunctionType alt_to_ds = new FunctionType(this.altitude, ds);
        FunctionType alt_to_uv = new FunctionType(this.altitude, uv);
        RealType domain_type = (RealType)((TupleType)f_type0.getRange()).getComponent(0);
        this.time = RealType.Time;
        FunctionType new_type = new FunctionType(RealType.Time, alt_to_uv);
        FieldImpl[] winds = new FieldImpl[this.n_stations];
        int ii = 0;
        while (ii < this.n_stations) {
            base_date[ii] = ((Real)((Tuple)file_data[ii]).getComponent(0)).getValue();
            base_time[ii] = ((Real)((Tuple)file_data[ii]).getComponent(1)).getValue();
            time_field[ii] = (FieldImpl)((Tuple)file_data[ii]).getComponent(2);
            this.station_lat[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(6)).getValue();
            this.station_lon[ii] = -((Real)((Tuple)time_field[ii].getSample(0)).getComponent(7)).getValue();
            this.station_alt[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(8)).getValue();
            this.station_id[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(9)).getValue();
            if (ii == 0) {
                this.start_time = base_time[0];
                this.start_date = (int)base_date[0];
            }
            int length = time_field[ii].getLength();
            double[][] times = new double[1][length];
            time_offset = new double[1][length];
            FlatField[] range_data = new FlatField[length];
            double[][] samples = null;
            int n_not_all_miss = 0;
            int jj = 0;
            while (jj < length) {
                Tuple range = (Tuple)time_field[ii].getSample(jj);
                time_offset[0][jj] = ((Real)range.getComponent(0)).getValue();
                FlatField p_field = (FlatField)range.getComponent(n_comps - 1);
                double[][] values = p_field.getValues();
                double[][] new_values = new double[2][values[0].length];
                if (jj == 0) {
                    samples = new double[1][values[0].length];
                    System.arraycopy(values[alt_idx], 0, samples[0], 0, samples[0].length);
                    d_set = new Gridded1DSet((MathType)this.altitude, Set.doubleToFloat(samples), samples[0].length);
                }
                new_ff = new FlatField(alt_to_uv, d_set);
                int n_not_miss = 0;
                int n_levels = values[0].length;
                int[] not_miss = new int[n_levels];
                int mm = 0;
                while (mm < n_levels) {
                    new_values[0][mm] = values[wd_idx][mm] <= -9999.0 ? Double.NaN : values[wd_idx][mm];
                    new_values[1][mm] = values[ws_idx][mm] <= -9999.0 ? Double.NaN : values[ws_idx][mm];
                    if (new_values[0][mm] == new_values[0][mm] && new_values[1][mm] == new_values[1][mm]) {
                        not_miss[n_not_miss] = mm;
                        ++n_not_miss;
                    }
                    ++mm;
                }
                if (n_levels - 7 < n_not_miss && n_not_miss <= n_levels) {
                    int endlen;
                    int nn = n_not_miss;
                    if (not_miss[0] > 0) {
                        nn += not_miss[0];
                    }
                    if ((endlen = values[0].length - (not_miss[n_not_miss - 1] + 1)) > 0) {
                        nn += endlen;
                    }
                    float[][] newer_values = new float[2][nn];
                    float[][] newer_samples = new float[1][nn];
                    int i = 0;
                    while (i < n_not_miss) {
                        newer_values[0][not_miss[0] + i] = (float)new_values[0][not_miss[i]];
                        newer_values[1][not_miss[0] + i] = (float)new_values[1][not_miss[i]];
                        newer_samples[0][not_miss[0] + i] = (float)samples[0][not_miss[i]];
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < not_miss[0]) {
                        newer_values[0][i2] = (float)new_values[0][not_miss[0]];
                        newer_values[1][i2] = (float)new_values[1][not_miss[0]];
                        newer_samples[0][i2] = (float)samples[0][not_miss[0]];
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < endlen) {
                        newer_values[0][not_miss[0] + n_not_miss + i3] = (float)new_values[0][not_miss[n_not_miss - 1]];
                        newer_values[1][not_miss[0] + n_not_miss + i3] = (float)new_values[1][not_miss[n_not_miss - 1]];
                        newer_samples[0][not_miss[0] + n_not_miss + i3] = (float)samples[0][not_miss[n_not_miss - 1]];
                        ++i3;
                    }
                    Gridded1DSet newer_d_set = new Gridded1DSet((MathType)this.altitude, newer_samples, nn);
                    FlatField newer_ff = new FlatField(alt_to_uv, newer_d_set);
                    newer_ff.setSamples(((CoordinateSystem)cs).toReference(newer_values));
                    range_data[n_not_all_miss] = new_ff = (FlatField)newer_ff.resample(d_set, 101, 202);
                    times[0][n_not_all_miss] = base_time[0] + time_offset[0][jj];
                    ++n_not_all_miss;
                }
                ++jj;
            }
            double[][] new_times = new double[1][n_not_all_miss];
            Data[] new_range_data = new Data[n_not_all_miss];
            System.arraycopy(times[0], 0, new_times[0], 0, n_not_all_miss);
            System.arraycopy(range_data, 0, new_range_data, 0, n_not_all_miss);
            System.out.println("n_not_all_miss: " + n_not_all_miss);
            Gridded1DSet domain_set = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(new_times), n_not_all_miss);
            winds[ii] = new FieldImpl(new_type, domain_set);
            winds[ii].setSamples(new_range_data, false);
            ++ii;
        }
        return winds;
    }

    FieldImpl[] makeAeri(String[] files) throws VisADException, RemoteException, IOException {
        DataImpl[] file_data = new DataImpl[this.n_stations];
        FieldImpl[] time_field = new FieldImpl[this.n_stations];
        double[][] time_offset = null;
        double[] base_date = new double[this.n_stations];
        double[] base_time = new double[this.n_stations];
        Plain plain = new Plain();
        int kk = 0;
        while (kk < this.n_stations) {
            file_data[kk] = plain.open(files[kk]);
            ++kk;
        }
        System.out.println(file_data[0].getType().prettyString());
        MathType file_type = file_data[0].getType();
        FunctionType f_type0 = (FunctionType)((TupleType)file_type).getComponent(1);
        FunctionType f_type1 = (FunctionType)((TupleType)f_type0.getRange()).getComponent(1);
        RealTupleType rtt = (RealTupleType)f_type1.getRange();
        RealType pres = RealType.getRealType("press");
        this.temp = RealType.getRealType("temp");
        this.dwpt = RealType.getRealType("dwpt");
        this.wvmr = RealType.getRealType("wvmr");
        RealType[] r_types = new RealType[]{pres, this.temp, this.dwpt, this.wvmr};
        f_type1 = new FunctionType(f_type1.getDomain(), new RealTupleType(r_types));
        RealType domain_type = (RealType)((TupleType)f_type0.getRange()).getComponent(0);
        FunctionType new_type = new FunctionType(RealType.Time, f_type1);
        FieldImpl[] rtvls = new FieldImpl[this.n_stations];
        int ii = 0;
        while (ii < this.n_stations) {
            base_time[ii] = ((Real)((Tuple)file_data[ii]).getComponent(0)).getValue();
            time_field[ii] = (FieldImpl)((Tuple)file_data[ii]).getComponent(1);
            base_date[ii] = ((Real)((Tuple)file_data[ii]).getComponent(2)).getValue();
            int length = time_field[ii].getLength();
            time_offset = new double[1][length];
            Data[] range_data = new Data[length];
            double[][] times = new double[1][length];
            int not_all_missing = 0;
            int jj = 0;
            while (jj < length) {
                Tuple range = (Tuple)time_field[ii].getSample(jj);
                time_offset[0][jj] = ((Real)range.getComponent(0)).getValue();
                FlatField p_field = (FlatField)range.getComponent(1);
                double[][] values = p_field.getValues();
                double[][] new_values = new double[4][values[0].length];
                int num_missing = 0;
                int n_levels = values[0].length;
                int mm = 0;
                while (mm < n_levels) {
                    new_values[0][mm] = values[0][mm] == -9999.0 ? Double.NaN : values[0][mm];
                    new_values[1][mm] = values[1][mm] == -9999.0 ? Double.NaN : values[1][mm];
                    new_values[2][mm] = values[2][mm] == -9999.0 ? Double.NaN : values[2][mm];
                    if (values[3][mm] == -9999.0) {
                        new_values[3][mm] = Double.NaN;
                        ++num_missing;
                    } else {
                        new_values[3][mm] = values[3][mm];
                    }
                    ++mm;
                }
                if (num_missing < 3) {
                    FlatField new_ff = new FlatField(f_type1, p_field.getDomainSet());
                    new_ff.setSamples(new_values);
                    range_data[not_all_missing] = new_ff;
                    times[0][not_all_missing] = base_time[0] + time_offset[0][jj];
                    ++not_all_missing;
                }
                ++jj;
            }
            System.out.println("not_all_missing: " + not_all_missing);
            double[][] new_times = new double[1][not_all_missing];
            Data[] new_range_data = new Data[not_all_missing];
            System.arraycopy(times[0], 0, new_times[0], 0, not_all_missing);
            System.arraycopy(range_data, 0, new_range_data, 0, not_all_missing);
            Gridded1DSet domain_set = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(new_times), not_all_missing);
            rtvls[ii] = new FieldImpl(new_type, domain_set);
            rtvls[ii].setSamples(new_range_data, false);
            ++ii;
        }
        return rtvls;
    }

    FieldImpl make_wind_aeri(FieldImpl[] winds, FieldImpl[] rtvls) throws VisADException, RemoteException, IOException {
        float[][] value_s = new float[1][1];
        int[] index_s = new int[1];
        boolean idx = false;
        double[][] new_values = null;
        FieldImpl stations_field = new FieldImpl(new FunctionType(this.stn_idx, this.time_to_alt_to_wind_aeri), new Integer1DSet(this.stn_idx, this.n_stations, null, null, null));
        double[] lows = new double[this.n_stations * 2];
        double[] his = new double[this.n_stations * 2];
        int kk = 0;
        while (kk < this.n_stations) {
            Set d_set = winds[kk].getDomainSet();
            lows[kk] = ((SampledSet)d_set).getLow()[0];
            his[kk] = ((SampledSet)d_set).getHi()[0];
            d_set = rtvls[kk].getDomainSet();
            lows[this.n_stations + kk] = ((SampledSet)d_set).getLow()[0];
            his[this.n_stations + kk] = ((SampledSet)d_set).getHi()[0];
            ++kk;
        }
        double[] minmax = Qdiv.getArrayMinMax(lows);
        double hi_low = minmax[1];
        minmax = Qdiv.getArrayMinMax(his);
        double low_hi = minmax[0];
        System.out.println("hi_low: " + hi_low);
        System.out.println("low_hi: " + low_hi);
        this.timeDomain = new Linear1DSet((MathType)this.time, hi_low, low_hi, (int)(low_hi - hi_low) / this.time_intrvl);
        int kk2 = 0;
        while (kk2 < this.n_stations) {
            FieldImpl time_wind_aeri = new FieldImpl(this.time_to_alt_to_wind_aeri, this.timeDomain);
            FieldImpl wind_to_timeDomain = (FieldImpl)winds[kk2].resample(this.timeDomain, 101, 202);
            FieldImpl rtvl_to_timeDomain = (FieldImpl)rtvls[kk2].resample(this.timeDomain, 101, 202);
            int dim = ((RealTupleType)((FunctionType)this.time_to_alt_to_wind_aeri.getRange()).getRange()).getDimension();
            int n_times = this.timeDomain.getLength();
            Set ds = null;
            int nn = 0;
            int tt = 0;
            while (tt < n_times) {
                FieldImpl alt_to_rtvl = (FieldImpl)rtvl_to_timeDomain.getSample(tt);
                FieldImpl alt_to_wind = (FieldImpl)wind_to_timeDomain.getSample(tt);
                if (tt == 0) {
                    ds = alt_to_wind.getDomainSet();
                    float[][] samples = ds.getSamples();
                    float[] ns = new float[samples[0].length];
                    int i = 0;
                    while (i < samples[0].length) {
                        if ((double)samples[0][i] - this.station_alt[kk2] < (double)this.height_limit) {
                            ns[nn] = samples[0][i] - (float)this.station_alt[kk2];
                            ++nn;
                        }
                        ++i;
                    }
                    float[][] new_samples = new float[1][nn];
                    System.arraycopy(ns, 0, new_samples[0], 0, nn);
                    ds = new Gridded1DSet(ds.getType(), new_samples, nn);
                    new_values = new double[dim][nn];
                }
                FieldImpl rtvl_on_wind = (FieldImpl)alt_to_rtvl.resample(ds, 101, 202);
                double[][] uv_values = alt_to_wind.getValues();
                double[][] rtvl_values = rtvl_on_wind.getValues();
                int ii = 0;
                while (ii < nn) {
                    new_values[0][ii] = uv_values[0][ii];
                    new_values[1][ii] = uv_values[1][ii];
                    new_values[2][ii] = rtvl_values[1][ii];
                    new_values[3][ii] = rtvl_values[2][ii];
                    new_values[4][ii] = rtvl_values[3][ii];
                    new_values[5][ii] = uv_values[0][ii] * rtvl_values[3][ii];
                    new_values[6][ii] = uv_values[1][ii] * rtvl_values[3][ii];
                    new_values[7][ii] = Aeri.equivPotentialTemperatureStar(Aeri.potentialTemperature(rtvl_values[1][ii], rtvl_values[0][ii]), rtvl_values[3][ii], rtvl_values[1][ii]);
                    ++ii;
                }
                FlatField ff = new FlatField(this.alt_to_wind_aeri, ds);
                ff.setSamples(new_values);
                time_wind_aeri.setSample(tt, (Data)ff);
                ++tt;
            }
            stations_field.setSample(kk2, (Data)time_wind_aeri, false);
            ++kk2;
        }
        return stations_field;
    }

    FieldImpl makeDivqV(FieldImpl stations) throws VisADException, RemoteException {
        double[][] uv_comps = new double[2][3];
        double[][] lonlat = new double[2][3];
        lonlat[0][0] = this.station_lon[0] * (Math.PI / 180);
        lonlat[0][1] = this.station_lon[1] * (Math.PI / 180);
        lonlat[0][2] = this.station_lon[2] * (Math.PI / 180);
        lonlat[1][0] = this.station_lat[0] * (Math.PI / 180);
        lonlat[1][1] = this.station_lat[1] * (Math.PI / 180);
        lonlat[1][2] = this.station_lat[2] * (Math.PI / 180);
        LinearVectorPointMethod lvpm = new LinearVectorPointMethod(lonlat);
        this.centroid_ll = lvpm.getCentroid();
        FieldImpl station0 = (FieldImpl)stations.getSample(0);
        FieldImpl station1 = (FieldImpl)stations.getSample(1);
        FieldImpl station2 = (FieldImpl)stations.getSample(2);
        FlatField ff = (FlatField)station0.getSample(0);
        Set alt_set = ff.getDomainSet();
        int alt_len = alt_set.getLength();
        this.alt_min = ((SampledSet)alt_set).getLow()[0];
        this.alt_max = ((SampledSet)alt_set).getHi()[0];
        this.n_hres_alt_samples = alt_len * this.alt_factor;
        Linear1DSet hres_alt_set = new Linear1DSet(alt_set.getType(), this.alt_min, this.alt_max, this.n_hres_alt_samples);
        FieldImpl new_field = new FieldImpl(this.time_to_alt_to_divqV, station0.getDomainSet());
        int tt = 0;
        while (tt < station0.getLength()) {
            FlatField field0 = (FlatField)station0.getSample(tt);
            FlatField field1 = (FlatField)station1.getSample(tt);
            FlatField field2 = (FlatField)station2.getSample(tt);
            double[][] values0 = field0.getValues(false);
            double[][] values1 = field1.getValues(false);
            double[][] values2 = field2.getValues(false);
            FlatField new_ff = new FlatField(this.alt_to_divqV, alt_set);
            double[][] new_values = new double[3][alt_len];
            int kk = 0;
            while (kk < alt_len) {
                boolean any_missing = false;
                uv_comps[0][0] = values0[0][kk];
                uv_comps[1][0] = values0[1][kk];
                uv_comps[0][1] = values1[0][kk];
                uv_comps[1][1] = values1[1][kk];
                uv_comps[0][2] = values2[0][kk];
                uv_comps[1][2] = values2[1][kk];
                if (Double.isNaN(uv_comps[0][0]) || Double.isNaN(uv_comps[1][0])) {
                    any_missing = true;
                } else if (Double.isNaN(uv_comps[0][1]) || Double.isNaN(uv_comps[1][1])) {
                    any_missing = true;
                } else if (Double.isNaN(uv_comps[0][2]) || Double.isNaN(uv_comps[1][2])) {
                    any_missing = true;
                }
                if (!any_missing) {
                    double[] kinematics = lvpm.getKinematics(uv_comps);
                    new_values[0][kk] = kinematics[4];
                    new_values[1][kk] = (values0[7][kk] + values1[7][kk] + values2[7][kk]) / 3.0;
                } else {
                    new_values[0][kk] = Double.NaN;
                    new_values[1][kk] = Double.NaN;
                }
                ++kk;
            }
            new_ff.setSamples(new_values);
            new_field.setSample(tt, (Data)new_ff.resample(hres_alt_set, 101, 202), false);
            ++tt;
        }
        return new_field;
    }

    public static VisADTriangleStripArray makeCylinder(int n_faces, float rad, float len) {
        float[][] xy_points = new float[2][n_faces];
        double del_theta = Math.PI * 2 / (double)n_faces;
        double theta = del_theta / 2.0;
        int[] index = new int[n_faces + 1];
        int kk = 0;
        while (kk < n_faces) {
            xy_points[0][kk] = (float)Math.cos(theta);
            xy_points[1][kk] = (float)Math.sin(theta);
            theta += del_theta;
            index[kk] = kk;
            ++kk;
        }
        index[n_faces] = 0;
        VisADTriangleStripArray cyl = new VisADTriangleStripArray();
        cyl.vertexCount = 2 * (n_faces + 1);
        cyl.coordinates = new float[cyl.vertexCount * 3];
        cyl.normals = new float[cyl.vertexCount * 3];
        cyl.stripVertexCounts = new int[1];
        cyl.stripVertexCounts[0] = cyl.vertexCount;
        int kk2 = 0;
        while (kk2 < n_faces + 1) {
            int ii = kk2 * 6;
            cyl.coordinates[ii] = rad * xy_points[0][index[kk2]];
            cyl.coordinates[ii + 1] = rad * xy_points[1][index[kk2]];
            cyl.coordinates[ii + 2] = len;
            cyl.coordinates[ii += 3] = rad * xy_points[0][index[kk2]];
            cyl.coordinates[ii + 1] = rad * xy_points[1][index[kk2]];
            cyl.coordinates[ii + 2] = -len;
            ++kk2;
        }
        int kk3 = 0;
        while (kk3 < n_faces + 1) {
            int ii = kk3 * 6;
            cyl.normals[ii] = xy_points[0][index[kk3]];
            cyl.normals[ii + 1] = xy_points[1][index[kk3]];
            cyl.normals[ii + 2] = 0.0f;
            cyl.normals[ii += 3] = xy_points[0][index[kk3]];
            cyl.normals[ii + 1] = xy_points[1][index[kk3]];
            cyl.normals[ii + 2] = 0.0f;
            ++kk3;
        }
        return cyl;
    }
}

