/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.BadMappingException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ShadowType;
import visad.VisADError;
import visad.VisADException;
import visad.bom.ShadowImageFunctionTypeJ3D;
import visad.collab.CollabUtil;
import visad.data.netcdf.Plain;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.VisADBranchGroup;
import visad.util.Delay;

public class ImageRendererJ3D
extends DefaultRendererJ3D {
    private static MathType image_sequence_type;
    private static MathType image_type;
    private static MathType image_sequence_type2;
    private static MathType image_type2;
    private static MathType image_sequence_type3;
    private static MathType image_type3;
    private boolean reUseFrames = false;
    private boolean setSetOnReUseFrames = true;
    private VisADBranchGroup vbranch = null;

    public static boolean isImageType(MathType type) {
        return image_sequence_type.equalsExceptName(type) || image_sequence_type2.equalsExceptName(type) || image_sequence_type3.equalsExceptName(type) || image_type.equalsExceptName(type) || image_type2.equalsExceptName(type) || image_type3.equalsExceptName(type);
    }

    public static void verifyImageRendererUsable(MathType type, ScalarMap[] maps) throws VisADException {
        ImageRendererJ3D.isRendererUsable(type, maps);
    }

    public static boolean isRendererUsable(MathType type, ScalarMap[] maps) throws VisADException {
        int dim;
        RealType time = null;
        RealTupleType domain = null;
        RealTupleType range = null;
        RealType x = null;
        RealType y = null;
        RealType rx = null;
        RealType ry = null;
        RealType r = null;
        RealType g = null;
        RealType b2 = null;
        RealType rgb = null;
        if (!(type instanceof FunctionType)) {
            throw new VisADException("Not a FunctionType");
        }
        FunctionType function = (FunctionType)type;
        RealTupleType functionD = function.getDomain();
        MathType functionR = function.getRange();
        if (function.equalsExceptName(image_sequence_type) || function.equalsExceptName(image_sequence_type2) || function.equalsExceptName(image_sequence_type3)) {
            time = (RealType)functionD.getComponent(0);
            function = (FunctionType)functionR;
            functionD = function.getDomain();
            functionR = function.getRange();
        }
        if (function.equalsExceptName(image_type) || function.equalsExceptName(image_type2) || function.equalsExceptName(image_type3)) {
            domain = function.getDomain();
            MathType rt = function.getRange();
            range = rt instanceof RealType ? new RealTupleType((RealType)rt) : (RealTupleType)rt;
        } else {
            throw new VisADException("Illegal MathType");
        }
        x = (RealType)domain.getComponent(0);
        y = (RealType)domain.getComponent(1);
        CoordinateSystem cs = domain.getCoordinateSystem();
        if (cs != null) {
            RealTupleType rxy = cs.getReference();
            rx = (RealType)rxy.getComponent(0);
            ry = (RealType)rxy.getComponent(1);
        }
        if ((dim = range.getDimension()) == 1) {
            rgb = (RealType)range.getComponent(0);
        } else {
            r = (RealType)range.getComponent(0);
            g = (RealType)range.getComponent(1);
            b2 = (RealType)range.getComponent(2);
        }
        boolean btime = time == null;
        boolean bx = false;
        boolean by = false;
        boolean brx = false;
        boolean bry = false;
        boolean br = false;
        boolean bg = false;
        boolean bb = false;
        boolean dbr = false;
        boolean dbg = false;
        boolean dbb = false;
        Boolean latlon = null;
        DisplayRealType spatial = null;
        int i = 0;
        while (i < maps.length) {
            RealType q;
            ScalarMap m = maps[i];
            ScalarType md = m.getScalar();
            DisplayRealType mr = m.getDisplayScalar();
            boolean ddt = md.equals(time);
            boolean ddx = md.equals(x);
            boolean ddy = md.equals(y);
            boolean ddrx = md.equals(rx);
            boolean ddry = md.equals(ry);
            boolean ddr = md.equals(r);
            boolean ddg = md.equals(g);
            boolean ddb = md.equals(b2);
            boolean ddrgb = md.equals(rgb);
            if (ddt) {
                if (btime) {
                    throw new VisADException("Multiple Time mappings");
                }
                if (!mr.equals(Display.Animation)) {
                    throw new VisADException("Time mapped to something other than Animation");
                }
                btime = true;
            } else if (ddx || ddy || ddrx || ddry) {
                boolean ll;
                if (ddx && bx || ddy && by || ddrx && brx || ddry && bry) {
                    throw new VisADException("Duplicate spatial mappings");
                }
                if ((ddx || ddy) && (brx || bry) || (ddrx || ddry) && (bx || by)) {
                    throw new VisADException("reference and non-reference spatial mappings");
                }
                RealType realType = q = ddx ? x : null;
                if (ddy) {
                    q = y;
                }
                if (ddrx) {
                    q = rx;
                }
                if (ddry) {
                    q = ry;
                }
                if (mr.equals(Display.XAxis) || mr.equals(Display.YAxis) || mr.equals(Display.ZAxis)) {
                    ll = false;
                } else if (mr.equals(Display.Latitude) || mr.equals(Display.Longitude) || mr.equals(Display.Radius)) {
                    ll = true;
                } else {
                    throw new VisADException("Illegal domain mapping");
                }
                if (latlon == null) {
                    latlon = new Boolean(ll);
                    spatial = mr;
                } else {
                    if (latlon != ll) {
                        throw new VisADException("Multiple spatial coordinate systems");
                    }
                    if (spatial == mr) {
                        throw new VisADException("Multiple mappings to the same spatial DisplayRealType");
                    }
                }
                if (ddx) {
                    bx = true;
                } else if (ddy) {
                    by = true;
                } else if (ddrx) {
                    brx = true;
                } else if (ddry) {
                    bry = true;
                }
            } else if (ddrgb) {
                if (br || bg || bb) {
                    throw new VisADException("Duplicate color mappings");
                }
                if (rgb == null || !mr.equals(Display.RGB) && !mr.equals(Display.RGBA)) {
                    throw new VisADException("Illegal RGB/RGBA mapping");
                }
                dbb = true;
                dbg = true;
                dbr = true;
                bb = true;
                bg = true;
                br = true;
            } else if (ddr || ddg || ddb) {
                if (rgb != null) {
                    throw new VisADException("Illegal RGB mapping");
                }
                RealType realType = ddr ? r : (q = ddg ? g : b2);
                if (mr.equals(Display.Red)) {
                    dbr = true;
                } else if (mr.equals(Display.Green)) {
                    dbg = true;
                } else if (mr.equals(Display.Blue)) {
                    dbb = true;
                } else {
                    throw new VisADException("Illegal color mapping");
                }
                if (ddr) {
                    br = true;
                } else if (ddg) {
                    bg = true;
                } else {
                    bb = true;
                }
            } else if (ddt || ddx || ddy || ddrx || ddry || ddr || ddg || ddb || ddrgb) {
                throw new VisADException("Illegal mapping: " + m);
            }
            ++i;
        }
        if (!(btime && (bx && by || brx && bry) && br && bg && bb && dbr && dbg && dbb)) {
            throw new VisADException("Insufficient mappings");
        }
        return true;
    }

    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowImageFunctionTypeJ3D(type, link, parent);
    }

    public void setReUseFrames(boolean reuse) {
        this.reUseFrames = reuse;
    }

    public void setReUseFrames() {
        this.setReUseFrames(true);
    }

    public boolean getReUseFrames() {
        return this.reUseFrames;
    }

    public void setSetSetOnReUseFrames(boolean ss) {
        this.setSetOnReUseFrames = ss;
    }

    public boolean getSetSetOnReUseFrames() {
        return this.setSetOnReUseFrames;
    }

    public void clearScene() {
        this.vbranch = null;
        super.clearScene();
    }

    void setVisADBranch(VisADBranchGroup branch) {
        this.vbranch = branch;
    }

    void markMissingVisADBranch() {
        if (this.vbranch != null) {
            this.vbranch.scratchTime();
        }
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] Links;
        BranchGroup branch = this.getBranch();
        if (branch == null) {
            branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(14);
            branch.setCapability(12);
            branch.setCapability(13);
        }
        if ((Links = this.getLinks()) == null || Links.length == 0) {
            return null;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ3D type = (ShadowTypeJ3D)link.getShadow();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            MathType mtype = link.getType();
            if (!ImageRendererJ3D.isImageType(mtype)) {
                throw new BadMappingException("must be image or image sequence");
            }
            link.start_time = System.currentTimeMillis();
            link.time_flag = false;
            this.vbranch = null;
            try {
                type.doTransform(branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return null;
                }
                throw re;
            }
        }
        link.clearData();
        return branch;
    }

    public Object clone() {
        return new ImageRendererJ3D();
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        int step = 1000;
        int len = 3;
        if (args.length > 0) {
            try {
                len = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e2) {
                len = 3;
            }
        }
        if (len < 1) {
            len = 1;
        }
        if (args.length > 1) {
            try {
                step = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e3) {
                step = 1000;
            }
        }
        if (step < 1) {
            step = 1;
        }
        Plain plain = new Plain();
        Field raw_image_sequence = null;
        try {
            raw_image_sequence = (Field)((Object)plain.open("images.nc"));
        }
        catch (IOException exc) {
            String s = "To run this example, the images.nc file must be present in\nthe current directory.You can obtain this file from:\n  ftp://www.ssec.wisc.edu/pub/visad-2.0/images.nc.Z";
            System.out.println(s);
            System.exit(0);
        }
        FunctionType image_sequence_type = (FunctionType)raw_image_sequence.getType();
        Set raw_set = raw_image_sequence.getDomainSet();
        float[][] raw_times = raw_set.getSamples();
        int raw_len = raw_times[0].length;
        if (raw_len != 4) {
            throw new VisADException("wrong number of images in sequence");
        }
        float raw_span = 1.3333334f * (raw_times[0][3] - raw_times[0][0]);
        double[][] times = new double[1][len];
        int i = 0;
        while (i < len) {
            times[0][i] = raw_times[0][i % raw_len] + raw_span * (float)(i / raw_len);
            ++i;
        }
        Gridded1DDoubleSet set = new Gridded1DDoubleSet(raw_set.getType(), times, len);
        FieldImpl image_sequence = new FieldImpl(image_sequence_type, set);
        int i2 = 0;
        while (i2 < len) {
            image_sequence.setSample(i2, raw_image_sequence.getSample(i2 % raw_len));
            ++i2;
        }
        DataReferenceImpl image_ref = new DataReferenceImpl("image");
        image_ref.setData(image_sequence);
        DisplayImplJ3D display = new DisplayImplJ3D("image display");
        FunctionType image_type = (FunctionType)image_sequence_type.getRange();
        RealTupleType domain_type = image_type.getDomain();
        display.addMap(new ScalarMap((RealType)domain_type.getComponent(0), Display.XAxis));
        display.addMap(new ScalarMap((RealType)domain_type.getComponent(1), Display.YAxis));
        display.addMap(new ScalarMap((RealType)image_type.getRange(), Display.RGB));
        RealType hour_type = (RealType)image_sequence_type.getDomain().getComponent(0);
        ScalarMap animation_map = new ScalarMap(hour_type, Display.Animation);
        display.addMap(animation_map);
        AnimationControl animation_control = (AnimationControl)((Object)animation_map.getControl());
        animation_control.setStep(step);
        animation_control.setOn(true);
        JFrame frame = new JFrame("ImageRendererJ3D test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
        System.out.println("first animation sequence");
        ImageRendererJ3D renderer = new ImageRendererJ3D();
        display.addReferences((DataRenderer)renderer, image_ref);
        new Delay(len * 4000);
        int i3 = 0;
        while (i3 < len) {
            times[0][i3] = raw_times[0][(i3 + 1) % raw_len] + raw_span * (float)((i3 + 1) / raw_len);
            ++i3;
        }
        set = new Gridded1DDoubleSet(raw_set.getType(), times, len);
        FieldImpl new_image_sequence = new FieldImpl(image_sequence_type, set);
        int i4 = 0;
        while (i4 < len) {
            new_image_sequence.setSample(i4, raw_image_sequence.getSample((i4 + 1) % raw_len));
            ++i4;
        }
        System.out.println("second animation sequence");
        renderer.setReUseFrames(true);
        image_ref.setData(new_image_sequence);
    }

    static {
        try {
            image_type = MathType.stringToType("((ImageElement, ImageLine) -> ImageValue)");
            image_sequence_type = new FunctionType(RealType.Time, image_type);
            image_type2 = MathType.stringToType("((ImageElement, ImageLine) -> (ImageValue))");
            image_sequence_type2 = new FunctionType(RealType.Time, image_type2);
            image_type3 = MathType.stringToType("((ImageElement, ImageLine) -> (Red, Green, Blue))");
            image_sequence_type3 = new FunctionType(RealType.Time, image_type3);
        }
        catch (VisADException e2) {
            throw new VisADError(e2.getMessage());
        }
    }
}

