/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import visad.browser.Convert;
import visad.browser.RangeSlider;
import visad.browser.Slider;
import visad.browser.Widget;
import visad.browser.WidgetEvent;

public class ContourWidget
extends Widget
implements ActionListener,
ItemListener {
    Checkbox contours;
    Checkbox labels;
    Checkbox dashed;
    TextField interval;
    TextField base;
    Label surfaceLabel;
    Slider surface;
    ContourRangeSlider contourRange;
    private String cwName;
    private double cwMinValue;
    private double cwMaxValue;
    private boolean cwMainContours;
    private boolean cwLabels;
    private float cwSurfaceValue;
    private float cwContourInterval;
    private float cwLowLimit;
    private float cwHiLimit;
    private float cwBase;

    public ContourWidget() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.contours = new Checkbox("contours", this.cwMainContours);
        this.labels = new Checkbox("labels", this.cwLabels);
        this.dashed = new Checkbox("dashed lines below base", this.cwContourInterval < 0.0f);
        this.interval = new TextField(Convert.shortString(Math.abs(this.cwContourInterval)));
        this.base = new TextField(Convert.shortString(this.cwBase));
        this.surfaceLabel = new Label("value = 0");
        this.surface = new Slider(0.0f, 0.0f, 1.0f);
        this.contourRange = new ContourRangeSlider(0.0f, 1.0f, this);
        this.contours.addItemListener(this);
        this.labels.addItemListener(this);
        this.dashed.addItemListener(this);
        this.interval.addActionListener(this);
        this.base.addActionListener(this);
        this.surface.addActionListener(this);
        this.addComponent(this.contours, gridbag, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.labels, gridbag, 2, 0, 2, 1, 0.0, 0.0);
        this.addComponent(this.dashed, gridbag, 1, 1, 3, 1, 0.0, 0.0);
        this.addComponent(new Label("interval:"), gridbag, 0, 2, 1, 1, 0.0, 0.0);
        this.addComponent(this.interval, gridbag, 1, 2, 1, 1, 1.0, 0.0);
        this.addComponent(new Label("base:"), gridbag, 2, 2, 1, 1, 0.0, 0.0);
        this.addComponent(this.base, gridbag, 3, 2, 1, 1, 1.0, 0.0);
        this.addComponent(this.surfaceLabel, gridbag, 0, 3, 4, 1, 1.0, 0.0);
        this.addComponent(this.surface, gridbag, 0, 4, 4, 1, 1.0, 0.0);
        this.addComponent(this.contourRange, gridbag, 0, 5, 4, 1, 1.0, 1.0);
    }

    public String getName() {
        return this.cwName;
    }

    public void setName(String name) {
        this.cwName = name;
        this.contourRange.setName(name);
        this.refreshSurfaceLabel();
    }

    public double getMinValue() {
        return this.cwMinValue;
    }

    public double getMaxValue() {
        return this.cwMaxValue;
    }

    public void setRange(float min, float max) {
        this.cwMinValue = min;
        this.cwMaxValue = max;
        this.surface.setBounds(min, max);
        this.contourRange.setBounds(min, max);
    }

    public boolean getMainContours() {
        return this.cwMainContours;
    }

    public void setMainContours(boolean mc) {
        this.cwMainContours = mc;
        this.contours.setState(mc);
    }

    public boolean getLabels() {
        return this.cwLabels;
    }

    public void setLabels(boolean lb) {
        this.cwLabels = lb;
        this.labels.setState(lb);
    }

    public float getSurfaceValue() {
        return this.cwSurfaceValue;
    }

    public void setSurfaceValue(float sv) {
        this.cwSurfaceValue = sv;
        this.surface.setValue(sv);
        this.refreshSurfaceLabel();
    }

    public float getContourInterval() {
        return this.cwContourInterval;
    }

    public void setContourInterval(float ci) {
        this.cwContourInterval = ci;
        this.interval.setText(Convert.shortString(Math.abs(ci)));
        this.dashed.setState(ci < 0.0f);
    }

    public float getLowLimit() {
        return this.cwLowLimit;
    }

    public float getHiLimit() {
        return this.cwHiLimit;
    }

    public void setLimits(float lo, float hi) {
        this.cwLowLimit = lo;
        this.cwHiLimit = hi;
        this.contourRange.setValues(lo, hi);
    }

    public float getBase() {
        return this.cwBase;
    }

    public void setBase(float bs) {
        this.cwBase = bs;
        this.base.setText(Convert.shortString(bs));
    }

    public String getSaveString() {
        return this.cwMainContours + " " + this.cwLabels + " " + this.cwSurfaceValue + " " + this.cwContourInterval + " " + this.cwLowLimit + " " + this.cwHiLimit + " " + this.cwBase;
    }

    public void setSaveString(String save) {
        if (save == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(save);
        if (st.countTokens() < 7) {
            return;
        }
        boolean mc = Convert.getBoolean(st.nextToken());
        boolean lb = Convert.getBoolean(st.nextToken());
        float sv = Convert.getFloat(st.nextToken());
        float ci = Convert.getFloat(st.nextToken());
        float lo = Convert.getFloat(st.nextToken());
        float hi = Convert.getFloat(st.nextToken());
        float bs = Convert.getFloat(st.nextToken());
        this.setMainContours(mc);
        this.setLabels(lb);
        this.setSurfaceValue(sv);
        this.setContourInterval(ci);
        this.setLimits(lo, hi);
        this.setBase(bs);
    }

    private void refreshSurfaceLabel() {
        this.surfaceLabel.setText((this.cwName == null ? "value" : this.cwName) + " = " + (Float.isNaN(this.cwSurfaceValue) ? "---" : Convert.shortString(this.cwSurfaceValue)));
    }

    public void actionPerformed(ActionEvent e2) {
        Object source = e2.getSource();
        if (source == this.interval) {
            float iv = Float.NaN;
            try {
                iv = Float.valueOf(this.interval.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.interval.setText(Convert.shortString(Math.abs(this.cwContourInterval)));
            }
            if (iv > 0.0f) {
                if (this.dashed.getState()) {
                    iv = -iv;
                }
                this.setContourInterval(iv);
                this.contours.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (source == this.base) {
            float bs = Float.NaN;
            try {
                bs = Float.valueOf(this.base.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.base.setText(Convert.shortString(this.cwBase));
            }
            if (bs == bs) {
                this.setBase(bs);
                this.contours.requestFocus();
                this.notifyListeners(new WidgetEvent(this));
            }
        } else if (source == this.surface) {
            float sv = this.surface.getValue();
            this.setSurfaceValue(sv);
            this.notifyListeners(new WidgetEvent(this));
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        boolean on;
        ItemSelectable source = e2.getItemSelectable();
        boolean bl = on = e2.getStateChange() == 1;
        if (source == this.contours) {
            this.setMainContours(on);
        } else if (source == this.labels) {
            this.setLabels(on);
        } else if (source == this.dashed) {
            this.setContourInterval(-this.cwContourInterval);
        }
        this.notifyListeners(new WidgetEvent(this));
    }

    public static void main(String[] args) {
        new ContourWidget().testWidget();
    }

    class ContourRangeSlider
    extends RangeSlider {
        private ContourWidget widget;

        ContourRangeSlider(float min, float max, ContourWidget parent) {
            super("value", min, max);
            this.widget = parent;
        }

        public void valuesUpdated() {
            this.widget.setLimits(this.minValue, this.maxValue);
            this.widget.notifyListeners(new WidgetEvent(this.widget));
        }
    }
}

