/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import visad.browser.WidgetEvent;
import visad.browser.WidgetListener;

public abstract class Widget
extends Panel {
    protected static final boolean DEBUG = false;
    protected static final String TRUE = "T";
    protected static final String FALSE = "F";
    protected static final Color PALE_GRAY = new Color(0.8f, 0.8f, 0.8f);
    private Vector listeners = new Vector();

    public static boolean containedIn(int px, int py, int x, int y, int w, int h) {
        return new Rectangle(x, y, w, h).contains(px, py);
    }

    public Widget() {
        this.setBackground(PALE_GRAY);
    }

    protected void addComponent(Component c2, GridBagLayout layout, int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.fill = 1;
        gbc.weightx = wx;
        gbc.weighty = wy;
        layout.setConstraints(c2, gbc);
        this.add(c2);
    }

    protected void testWidget() {
        String title = this.getClass().getName();
        title = title.substring(title.lastIndexOf(46) + 1);
        Frame f = new Frame(title);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        f.add(this);
        f.pack();
        f.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWidgetListener(WidgetListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWidgetListener(WidgetListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(WidgetEvent e2) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                WidgetListener l = (WidgetListener)this.listeners.elementAt(i);
                l.widgetChanged(e2);
                ++i;
            }
        }
    }

    public abstract String getSaveString();

    public abstract void setSaveString(String var1);
}

