/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RemoteDataImpl;
import visad.RemoteThingImpl;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ThingImpl;
import visad.ThingReference;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientTupleImpl;
import visad.cluster.RemoteClusterData;

public abstract class RemoteClusterDataImpl
extends RemoteDataImpl
implements RemoteClusterData {
    private Set partitionSet = null;
    private int dimension = -1;
    private RemoteClusterData[] jvmTable = null;
    private RemoteClusterData me = null;
    private RemoteClusterDataImpl parent = null;
    private ThingImpl adaptedThingImpl = new ThingImpl();
    private RemoteThingImpl adaptedRemoteThingImpl = new RemoteThingImpl(this.adaptedThingImpl);

    public RemoteClusterDataImpl() throws RemoteException {
        super((DataImpl)null);
        this.me = this;
    }

    RemoteClusterData[] getTable() {
        return this.jvmTable;
    }

    public RemoteClusterData getClusterData(RealTuple domain) throws RemoteException, VisADException {
        CoordinateSystem coord_in;
        RealTupleType in;
        CoordinateSystem coord_out;
        if (domain == null || this.partitionSet == null || this.jvmTable == null) {
            throw new ClusterException("null domain or setup not done");
        }
        if (this.dimension != domain.getDimension()) {
            return this.jvmTable[this.jvmTable.length - 1];
        }
        double[][] vals = new double[this.dimension][1];
        int i = 0;
        while (i < this.dimension) {
            vals[i][0] = ((Real)domain.getComponent(i)).getValue();
            ++i;
        }
        RealTupleType out = ((SetType)this.partitionSet.getType()).getDomain();
        if (!CoordinateSystem.canConvert(out, coord_out = this.partitionSet.getCoordinateSystem(), in = (RealTupleType)domain.getType(), coord_in = domain.getCoordinateSystem())) {
            return this.jvmTable[this.jvmTable.length - 1];
        }
        if (this.partitionSet.getLength() == 1) {
            return this.jvmTable[0];
        }
        vals = CoordinateSystem.transformCoordinates(((SetType)this.partitionSet.getType()).getDomain(), this.partitionSet.getCoordinateSystem(), this.partitionSet.getSetUnits(), null, (RealTupleType)domain.getType(), domain.getCoordinateSystem(), domain.getTupleUnits(), null, vals);
        try {
            int[] indices = this.partitionSet.doubleToIndex(vals);
            return indices[0] < 0 ? null : this.jvmTable[indices[0]];
        }
        catch (SetException e2) {
            return null;
        }
    }

    public void setupClusterData(Set ps, RemoteClusterData[] table) throws RemoteException, VisADException {
        if (table == null) {
            throw new ClusterException("table must be non-null");
        }
        if (ps != null) {
            if (ps.getLength() + 1 > table.length) {
                throw new ClusterException("table.length (" + table.length + ") must " + " >= ps.length + 1 (" + (ps.getLength() + 1) + ")");
            }
            this.partitionSet = ps;
            this.dimension = ps.getDimension();
        } else {
            this.partitionSet = null;
            this.dimension = -1;
        }
        this.jvmTable = table;
    }

    public Set getPartitionSet() {
        return this.partitionSet;
    }

    public boolean clusterDataEquals(RemoteClusterData cd) throws RemoteException {
        return cd == this.me;
    }

    public void setParent(RemoteClusterDataImpl p) {
        this.parent = p;
    }

    public void notifyReferences() throws VisADException, RemoteException {
        this.adaptedThingImpl.notifyReferences();
        if (this.parent != null) {
            this.parent.notifyReferences();
        }
    }

    public void addReference(ThingReference r) throws VisADException {
        this.adaptedRemoteThingImpl.addReference(r);
    }

    public void removeReference(ThingReference r) throws VisADException {
        this.adaptedRemoteThingImpl.removeReference(r);
    }

    public DataImpl local() throws VisADException, RemoteException {
        throw new ClusterException("no local() method for cluster data");
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        Real r = new Real(0.0);
        RemoteClientTupleImpl cd = new RemoteClientTupleImpl(new Data[]{r});
        RemoteClientTupleImpl cd2 = new RemoteClientTupleImpl(new Data[]{r});
        System.out.println(cd.equals(cd));
        System.out.println(cd.equals(cd2));
        System.out.println(cd.clusterDataEquals(cd));
        System.out.println(cd.clusterDataEquals(cd2));
        System.exit(0);
    }
}

